/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.agent.observability.observation;

import com.embabel.agent.api.common.ranking.Ranking;
import com.embabel.agent.api.event.AbstractAgentProcessEvent;
import com.embabel.agent.api.event.ActionExecutionResultEvent;
import com.embabel.agent.api.event.ActionExecutionStartEvent;
import com.embabel.agent.api.event.AgentPlatformEvent;
import com.embabel.agent.api.event.AgentProcessCompletedEvent;
import com.embabel.agent.api.event.AgentProcessCreationEvent;
import com.embabel.agent.api.event.AgentProcessEvent;
import com.embabel.agent.api.event.AgentProcessFailedEvent;
import com.embabel.agent.api.event.AgentProcessPausedEvent;
import com.embabel.agent.api.event.AgentProcessPlanFormulatedEvent;
import com.embabel.agent.api.event.AgentProcessReadyToPlanEvent;
import com.embabel.agent.api.event.AgentProcessStuckEvent;
import com.embabel.agent.api.event.AgentProcessWaitingEvent;
import com.embabel.agent.api.event.AgenticEventListener;
import com.embabel.agent.api.event.DynamicAgentCreationEvent;
import com.embabel.agent.api.event.GoalAchievedEvent;
import com.embabel.agent.api.event.LlmRequestEvent;
import com.embabel.agent.api.event.LlmResponseEvent;
import com.embabel.agent.api.event.ProcessKilledEvent;
import com.embabel.agent.api.event.RankingChoiceCouldNotBeMadeEvent;
import com.embabel.agent.api.event.RankingChoiceMadeEvent;
import com.embabel.agent.api.event.RankingChoiceRequestEvent;
import com.embabel.agent.api.event.ReplanRequestedEvent;
import com.embabel.agent.api.event.StateTransitionEvent;
import com.embabel.agent.api.event.ToolCallRequestEvent;
import com.embabel.agent.api.event.ToolCallResponseEvent;
import com.embabel.agent.api.event.ToolLoopCompletedEvent;
import com.embabel.agent.api.event.ToolLoopStartEvent;
import com.embabel.agent.core.Action;
import com.embabel.agent.core.AgentProcess;
import com.embabel.agent.core.ToolGroupMetadata;
import com.embabel.agent.event.AgentProcessRagEvent;
import com.embabel.agent.event.RagEvent;
import com.embabel.agent.event.RagRequestReceivedEvent;
import com.embabel.agent.event.RagResponseEvent;
import com.embabel.agent.observability.ObservabilityProperties;
import com.embabel.agent.observability.observation.EmbabelObservationContext;
import com.embabel.agent.observability.observation.ObservationKeys;
import com.embabel.agent.observability.observation.ObservationUtils;
import com.embabel.agent.rag.pipeline.event.EnhancementCompletedRagPipelineEvent;
import com.embabel.agent.rag.pipeline.event.EnhancementStartingRagPipelineEvent;
import com.embabel.agent.rag.pipeline.event.InitialRequestRagPipelineEvent;
import com.embabel.agent.rag.pipeline.event.InitialResponseRagPipelineEvent;
import com.embabel.agent.rag.pipeline.event.RagPipelineEvent;
import com.embabel.chat.Message;
import com.embabel.common.ai.model.LlmOptions;
import com.embabel.plan.Plan;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmbabelFullObservationEventListener
implements AgenticEventListener {
    private static final Logger log = LoggerFactory.getLogger(EmbabelFullObservationEventListener.class);
    private final ObservationRegistry observationRegistry;
    private final ObservabilityProperties properties;
    private final Map<String, ObservationContext> activeObservations = new ConcurrentHashMap<String, ObservationContext>();
    private final Map<String, String> inputSnapshots = new ConcurrentHashMap<String, String>();
    private final Map<String, Integer> planIterations = new ConcurrentHashMap<String, Integer>();

    public EmbabelFullObservationEventListener(ObservationRegistry observationRegistry, ObservabilityProperties properties) {
        this.observationRegistry = observationRegistry;
        this.properties = properties;
        log.info("EmbabelFullObservationEventListener initialized with Spring Observation API");
    }

    public void onProcessEvent(@NotNull AgentProcessEvent event) {
        AgentProcessEvent agentProcessEvent = event;
        Objects.requireNonNull(agentProcessEvent);
        AgentProcessEvent agentProcessEvent2 = agentProcessEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AgentProcessCreationEvent.class, AgentProcessCompletedEvent.class, AgentProcessFailedEvent.class, ActionExecutionStartEvent.class, ActionExecutionResultEvent.class, GoalAchievedEvent.class, ToolCallRequestEvent.class, ToolCallResponseEvent.class, AgentProcessReadyToPlanEvent.class, AgentProcessPlanFormulatedEvent.class, StateTransitionEvent.class, AgentProcessWaitingEvent.class, AgentProcessPausedEvent.class, AgentProcessStuckEvent.class, ToolLoopStartEvent.class, ToolLoopCompletedEvent.class, LlmRequestEvent.class, LlmResponseEvent.class, AgentProcessRagEvent.class, ReplanRequestedEvent.class, ProcessKilledEvent.class}, (Object)agentProcessEvent2, n)) {
            case 0: {
                AgentProcessCreationEvent e = (AgentProcessCreationEvent)agentProcessEvent2;
                this.onAgentProcessCreation(e);
                break;
            }
            case 1: {
                AgentProcessCompletedEvent e = (AgentProcessCompletedEvent)agentProcessEvent2;
                this.onAgentProcessCompleted(e);
                break;
            }
            case 2: {
                AgentProcessFailedEvent e = (AgentProcessFailedEvent)agentProcessEvent2;
                this.onAgentProcessFailed(e);
                break;
            }
            case 3: {
                ActionExecutionStartEvent e = (ActionExecutionStartEvent)agentProcessEvent2;
                this.onActionStart(e);
                break;
            }
            case 4: {
                ActionExecutionResultEvent e = (ActionExecutionResultEvent)agentProcessEvent2;
                this.onActionResult(e);
                break;
            }
            case 5: {
                GoalAchievedEvent e = (GoalAchievedEvent)agentProcessEvent2;
                this.onGoalAchieved(e);
                break;
            }
            case 6: {
                ToolCallRequestEvent e = (ToolCallRequestEvent)agentProcessEvent2;
                if (!this.properties.isTraceToolCalls()) break;
                this.onToolCallRequest(e);
                break;
            }
            case 7: {
                ToolCallResponseEvent e = (ToolCallResponseEvent)agentProcessEvent2;
                if (!this.properties.isTraceToolCalls()) break;
                this.onToolCallResponse(e);
                break;
            }
            case 8: {
                AgentProcessReadyToPlanEvent e = (AgentProcessReadyToPlanEvent)agentProcessEvent2;
                if (!this.properties.isTracePlanning()) break;
                this.onReadyToPlan(e);
                break;
            }
            case 9: {
                AgentProcessPlanFormulatedEvent e = (AgentProcessPlanFormulatedEvent)agentProcessEvent2;
                if (!this.properties.isTracePlanning()) break;
                this.onPlanFormulated(e);
                break;
            }
            case 10: {
                StateTransitionEvent e = (StateTransitionEvent)agentProcessEvent2;
                if (!this.properties.isTraceStateTransitions()) break;
                this.onStateTransition(e);
                break;
            }
            case 11: {
                AgentProcessWaitingEvent e = (AgentProcessWaitingEvent)agentProcessEvent2;
                if (!this.properties.isTraceLifecycleStates()) break;
                this.onLifecycleState((AbstractAgentProcessEvent)e, "WAITING");
                break;
            }
            case 12: {
                AgentProcessPausedEvent e = (AgentProcessPausedEvent)agentProcessEvent2;
                if (!this.properties.isTraceLifecycleStates()) break;
                this.onLifecycleState((AbstractAgentProcessEvent)e, "PAUSED");
                break;
            }
            case 13: {
                AgentProcessStuckEvent e = (AgentProcessStuckEvent)agentProcessEvent2;
                if (!this.properties.isTraceLifecycleStates()) break;
                this.onStuck(e);
                break;
            }
            case 14: {
                ToolLoopStartEvent e = (ToolLoopStartEvent)agentProcessEvent2;
                if (!this.properties.isTraceToolLoop()) break;
                this.onToolLoopStart(e);
                break;
            }
            case 15: {
                ToolLoopCompletedEvent e = (ToolLoopCompletedEvent)agentProcessEvent2;
                if (!this.properties.isTraceToolLoop()) break;
                this.onToolLoopCompleted(e);
                break;
            }
            case 16: {
                LlmRequestEvent e = (LlmRequestEvent)agentProcessEvent2;
                if (!this.properties.isTraceLlmCalls()) break;
                this.onLlmRequest(e);
                break;
            }
            case 17: {
                LlmResponseEvent e = (LlmResponseEvent)agentProcessEvent2;
                if (!this.properties.isTraceLlmCalls()) break;
                this.onLlmResponse(e);
                break;
            }
            case 18: {
                AgentProcessRagEvent e = (AgentProcessRagEvent)agentProcessEvent2;
                if (!this.properties.isTraceRag()) break;
                this.onRagEvent(e);
                break;
            }
            case 19: {
                ReplanRequestedEvent e = (ReplanRequestedEvent)agentProcessEvent2;
                if (!this.properties.isTracePlanning()) break;
                this.onReplanRequested(e);
                break;
            }
            case 20: {
                ProcessKilledEvent e = (ProcessKilledEvent)agentProcessEvent2;
                this.onProcessKilled(e);
                break;
            }
        }
    }

    public void onPlatformEvent(@NotNull AgentPlatformEvent event) {
        AgentPlatformEvent agentPlatformEvent = event;
        Objects.requireNonNull(agentPlatformEvent);
        AgentPlatformEvent agentPlatformEvent2 = agentPlatformEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{RankingChoiceMadeEvent.class, RankingChoiceCouldNotBeMadeEvent.class, RankingChoiceRequestEvent.class, DynamicAgentCreationEvent.class}, (Object)agentPlatformEvent2, n)) {
            case 0: {
                RankingChoiceMadeEvent e = (RankingChoiceMadeEvent)agentPlatformEvent2;
                if (!this.properties.isTraceRanking()) break;
                this.onRankingChoiceMade(e);
                break;
            }
            case 1: {
                RankingChoiceCouldNotBeMadeEvent e = (RankingChoiceCouldNotBeMadeEvent)agentPlatformEvent2;
                if (!this.properties.isTraceRanking()) break;
                this.onRankingChoiceCouldNotBeMade(e);
                break;
            }
            case 2: {
                RankingChoiceRequestEvent e = (RankingChoiceRequestEvent)agentPlatformEvent2;
                if (!this.properties.isTraceRanking()) break;
                this.onRankingRequest(e);
                break;
            }
            case 3: {
                DynamicAgentCreationEvent e = (DynamicAgentCreationEvent)agentPlatformEvent2;
                if (!this.properties.isTraceDynamicAgentCreation()) break;
                this.onDynamicAgentCreation(e);
                break;
            }
        }
    }

    private void onAgentProcessCreation(AgentProcessCreationEvent event) {
        ObservationContext parentCtx;
        AgentProcess process = event.getAgentProcess();
        String runId = process.getId();
        String agentName = process.getAgent().getName();
        String parentId = process.getParentId();
        boolean isSubagent = parentId != null && !parentId.isEmpty();
        String goalName = ObservationUtils.extractGoalName(process);
        String plannerType = process.getProcessOptions().getPlannerType().name();
        String input = ObservationUtils.getBlackboardSnapshot(process);
        EmbabelObservationContext context = isSubagent ? EmbabelObservationContext.subAgent(runId, agentName, parentId) : EmbabelObservationContext.rootAgent(runId, agentName);
        Observation observation = Observation.createNotStarted((String)agentName, () -> context, (ObservationRegistry)this.observationRegistry);
        if (isSubagent && (parentCtx = this.findParentObservation(parentId)) != null) {
            observation.parentObservation(parentCtx.observation);
        }
        observation.lowCardinalityKeyValue("gen_ai.operation.name", "agent");
        observation.highCardinalityKeyValue("gen_ai.conversation.id", runId);
        observation.lowCardinalityKeyValue("embabel.agent.name", agentName);
        observation.lowCardinalityKeyValue("embabel.agent.is_subagent", String.valueOf(isSubagent));
        observation.lowCardinalityKeyValue("embabel.agent.planner_type", plannerType);
        observation.lowCardinalityKeyValue("embabel.event.type", "agent_process");
        observation.highCardinalityKeyValue("embabel.agent.run_id", runId);
        observation.highCardinalityKeyValue("embabel.agent.goal", goalName);
        observation.highCardinalityKeyValue("embabel.agent.parent_id", parentId != null ? parentId : "");
        if (!input.isEmpty()) {
            observation.highCardinalityKeyValue("input.value", this.truncate(input));
            this.inputSnapshots.put(ObservationKeys.agentKey(runId), input);
        }
        this.planIterations.put(runId, 0);
        observation.start();
        Observation.Scope scope = observation.openScope();
        this.activeObservations.put(ObservationKeys.agentKey(runId), new ObservationContext(observation, scope));
        log.debug("Started observation for agent: {} (runId: {})", (Object)agentName, (Object)runId);
    }

    private void onAgentProcessCompleted(AgentProcessCompletedEvent event) {
        AgentProcess process = event.getAgentProcess();
        String runId = process.getId();
        String key = ObservationKeys.agentKey(runId);
        ObservationContext ctx = this.activeObservations.remove(key);
        this.inputSnapshots.remove(key);
        this.planIterations.remove(runId);
        if (ctx != null) {
            Object lastResult;
            ctx.observation.lowCardinalityKeyValue("embabel.agent.status", "completed");
            String output = ObservationUtils.getBlackboardSnapshot(process);
            if (!output.isEmpty()) {
                ctx.observation.highCardinalityKeyValue("output.value", this.truncate(output));
            }
            if ((lastResult = process.getBlackboard().lastResult()) != null) {
                ctx.observation.highCardinalityKeyValue("embabel.agent.result", this.truncate(lastResult.toString()));
            }
            ctx.scope.close();
            ctx.observation.stop();
            log.debug("Completed observation for agent runId: {}", (Object)runId);
        }
    }

    private void onAgentProcessFailed(AgentProcessFailedEvent event) {
        AgentProcess process = event.getAgentProcess();
        String runId = process.getId();
        String key = ObservationKeys.agentKey(runId);
        ObservationContext ctx = this.activeObservations.remove(key);
        this.inputSnapshots.remove(key);
        this.planIterations.remove(runId);
        if (ctx != null) {
            ctx.observation.lowCardinalityKeyValue("embabel.agent.status", "failed");
            Object failureInfo = process.getFailureInfo();
            if (failureInfo != null) {
                ctx.observation.highCardinalityKeyValue("embabel.agent.error", this.truncate(failureInfo.toString()));
                ctx.observation.error((Throwable)new RuntimeException(this.truncate(failureInfo.toString())));
            }
            ctx.scope.close();
            ctx.observation.stop();
            log.debug("Failed observation for agent runId: {}", (Object)runId);
        }
    }

    private void onActionStart(ActionExecutionStartEvent event) {
        AgentProcess process = event.getAgentProcess();
        String runId = process.getId();
        Action action = event.getAction();
        String actionName = action.getName();
        String shortName = action.shortName();
        String input = ObservationUtils.getActionInputs(action, process);
        EmbabelObservationContext context = EmbabelObservationContext.action(runId, shortName);
        Observation observation = Observation.createNotStarted((String)shortName, () -> context, (ObservationRegistry)this.observationRegistry);
        observation.lowCardinalityKeyValue("gen_ai.operation.name", "execute_action");
        observation.lowCardinalityKeyValue("embabel.event.type", "action");
        observation.lowCardinalityKeyValue("embabel.action.short_name", shortName);
        observation.highCardinalityKeyValue("embabel.action.name", actionName);
        observation.highCardinalityKeyValue("embabel.action.run_id", runId);
        observation.highCardinalityKeyValue("embabel.action.description", event.getAction().getDescription());
        String key = ObservationKeys.actionKey(runId, actionName);
        if (!input.isEmpty()) {
            observation.highCardinalityKeyValue("input.value", this.truncate(input));
            this.inputSnapshots.put(key, input);
        }
        observation.start();
        Observation.Scope scope = observation.openScope();
        this.activeObservations.put(key, new ObservationContext(observation, scope));
        log.debug("Started observation for action: {} (runId: {})", (Object)shortName, (Object)runId);
    }

    private void onActionResult(ActionExecutionResultEvent event) {
        AgentProcess process = event.getAgentProcess();
        String runId = process.getId();
        String actionName = event.getAction().getName();
        String key = ObservationKeys.actionKey(runId, actionName);
        ObservationContext ctx = this.activeObservations.remove(key);
        this.inputSnapshots.remove(key);
        if (ctx != null) {
            Object lastResult;
            String statusName = event.getActionStatus().getStatus().name();
            ctx.observation.lowCardinalityKeyValue("embabel.action.status", statusName);
            ctx.observation.highCardinalityKeyValue("embabel.action.duration_ms", String.valueOf(event.getRunningTime().toMillis()));
            String output = ObservationUtils.getBlackboardSnapshot(process);
            if (!output.isEmpty()) {
                ctx.observation.highCardinalityKeyValue("output.value", this.truncate(output));
            }
            if ((lastResult = process.getBlackboard().lastResult()) != null) {
                ctx.observation.highCardinalityKeyValue("embabel.action.result", this.truncate(lastResult.toString()));
            }
            if ("FAILED".equals(statusName)) {
                ctx.observation.error((Throwable)new RuntimeException("Action failed: " + actionName));
            }
            ctx.scope.close();
            ctx.observation.stop();
            log.debug("Completed observation for action: {} (runId: {})", (Object)actionName, (Object)runId);
        }
    }

    private void onGoalAchieved(GoalAchievedEvent event) {
        Object lastResult;
        AgentProcess process = event.getAgentProcess();
        String runId = process.getId();
        String goalName = event.getGoal().getName();
        String shortGoalName = goalName.contains(".") ? goalName.substring(goalName.lastIndexOf(46) + 1) : goalName;
        EmbabelObservationContext context = EmbabelObservationContext.goal(runId, "goal:" + shortGoalName);
        Observation observation = Observation.createNotStarted((String)("goal:" + shortGoalName), () -> context, (ObservationRegistry)this.observationRegistry);
        observation.lowCardinalityKeyValue("embabel.goal.short_name", shortGoalName);
        observation.highCardinalityKeyValue("embabel.goal.name", goalName);
        observation.highCardinalityKeyValue("embabel.event.type", "goal_achieved");
        String snapshot = ObservationUtils.getBlackboardSnapshot(process);
        if (!snapshot.isEmpty()) {
            observation.highCardinalityKeyValue("input.value", this.truncate(snapshot));
        }
        if ((lastResult = process.getBlackboard().lastResult()) != null) {
            observation.highCardinalityKeyValue("output.value", this.truncate(lastResult.toString()));
        }
        observation.start();
        observation.stop();
        log.debug("Recorded goal achieved: {} (runId: {})", (Object)shortGoalName, (Object)runId);
    }

    private void onToolCallRequest(ToolCallRequestEvent event) {
        ToolGroupMetadata metadata;
        AgentProcess process = event.getAgentProcess();
        String runId = process.getId();
        String toolName = event.getTool();
        Observation parentObservation = this.observationRegistry.getCurrentObservation();
        String toolSpan = ObservationKeys.toolSpanName(toolName);
        EmbabelObservationContext context = EmbabelObservationContext.toolCall(runId, toolSpan);
        Observation observation = Observation.createNotStarted((String)toolSpan, () -> context, (ObservationRegistry)this.observationRegistry);
        if (parentObservation != null) {
            observation.parentObservation(parentObservation);
        }
        observation.lowCardinalityKeyValue("gen_ai.operation.name", "execute_tool");
        observation.lowCardinalityKeyValue("gen_ai.tool.name", toolName);
        observation.lowCardinalityKeyValue("gen_ai.tool.type", "function");
        observation.lowCardinalityKeyValue("embabel.tool.name", toolName);
        observation.lowCardinalityKeyValue("embabel.event.type", "tool_call");
        String correlationId = event.getCorrelationId();
        if (correlationId != null && !"-".equals(correlationId)) {
            observation.highCardinalityKeyValue("embabel.tool.correlation_id", correlationId);
        }
        if ((metadata = event.getToolGroupMetadata()) != null) {
            String role;
            String groupName;
            String description = metadata.getDescription();
            if (description != null && !description.isEmpty()) {
                observation.highCardinalityKeyValue("gen_ai.tool.description", this.truncate(description));
            }
            if ((groupName = metadata.getName()) != null) {
                observation.lowCardinalityKeyValue("embabel.tool.group.name", groupName);
            }
            if ((role = metadata.getRole()) != null) {
                observation.lowCardinalityKeyValue("embabel.tool.group.role", role);
            }
        }
        if (event.getToolInput() != null) {
            String truncatedInput = this.truncate(event.getToolInput());
            observation.highCardinalityKeyValue("input.value", truncatedInput);
            observation.highCardinalityKeyValue("gen_ai.tool.call.arguments", truncatedInput);
        }
        observation.start();
        Observation.Scope scope = observation.openScope();
        this.activeObservations.put(ObservationKeys.toolKey(runId, toolName), new ObservationContext(observation, scope));
        log.debug("Started observation for tool: {} (runId: {}, correlationId: {}, parentObservation: {})", new Object[]{toolName, runId, correlationId, parentObservation != null ? parentObservation.getContext().getName() : "none"});
    }

    private void onToolCallResponse(ToolCallResponseEvent event) {
        String toolName;
        AgentProcess process = event.getAgentProcess();
        String runId = process.getId();
        String key = ObservationKeys.toolKey(runId, toolName = event.getRequest().getTool());
        ObservationContext ctx = this.activeObservations.remove(key);
        if (ctx != null) {
            ctx.observation.highCardinalityKeyValue("embabel.tool.duration_ms", String.valueOf(event.getRunningTime().toMillis()));
            Object toolResult = ObservationUtils.extractToolResult(event);
            if (toolResult != null) {
                String truncatedResult = this.truncate(toolResult.toString());
                ctx.observation.highCardinalityKeyValue("output.value", truncatedResult);
                ctx.observation.highCardinalityKeyValue("gen_ai.tool.call.result", truncatedResult);
                ctx.observation.lowCardinalityKeyValue("embabel.tool.status", "success");
            } else {
                Throwable error = ObservationUtils.extractToolError(event);
                if (error != null) {
                    ctx.observation.lowCardinalityKeyValue("embabel.tool.status", "error");
                    ctx.observation.highCardinalityKeyValue("embabel.tool.error.type", error.getClass().getSimpleName());
                    ctx.observation.highCardinalityKeyValue("embabel.tool.error.message", this.truncate(error.getMessage()));
                    ctx.observation.error(error);
                } else {
                    ctx.observation.lowCardinalityKeyValue("embabel.tool.status", "success");
                }
            }
            ctx.scope.close();
            ctx.observation.stop();
            log.debug("Completed observation for tool: {} (runId: {})", (Object)toolName, (Object)runId);
        }
    }

    private void onReadyToPlan(AgentProcessReadyToPlanEvent event) {
        AgentProcess process = event.getAgentProcess();
        String runId = process.getId();
        String plannerType = process.getProcessOptions().getPlannerType().name();
        EmbabelObservationContext context = EmbabelObservationContext.planning(runId, "planning:ready");
        Observation observation = Observation.createNotStarted((String)"planning:ready", () -> context, (ObservationRegistry)this.observationRegistry);
        observation.lowCardinalityKeyValue("gen_ai.operation.name", "planning");
        observation.lowCardinalityKeyValue("embabel.event.type", "planning_ready");
        observation.lowCardinalityKeyValue("embabel.plan.planner_type", plannerType);
        observation.highCardinalityKeyValue("embabel.agent.run_id", runId);
        if (event.getWorldState() != null) {
            observation.highCardinalityKeyValue("input.value", this.truncate(event.getWorldState().infoString(Boolean.valueOf(true), 0)));
        }
        observation.start();
        observation.stop();
        log.debug("Recorded planning ready event (runId: {})", (Object)runId);
    }

    private void onPlanFormulated(AgentProcessPlanFormulatedEvent event) {
        AgentProcess process = event.getAgentProcess();
        String runId = process.getId();
        Plan plan = event.getPlan();
        int iteration = this.planIterations.compute(runId, (k, v) -> v == null ? 1 : v + 1);
        boolean isReplanning = iteration > 1;
        String spanName = isReplanning ? "planning:replanning" : "planning:formulated";
        EmbabelObservationContext context = EmbabelObservationContext.planning(runId, spanName);
        Observation observation = Observation.createNotStarted((String)spanName, () -> context, (ObservationRegistry)this.observationRegistry);
        observation.lowCardinalityKeyValue("gen_ai.operation.name", isReplanning ? "replanning" : "planning");
        observation.lowCardinalityKeyValue("embabel.event.type", isReplanning ? "replanning" : "plan_formulated");
        observation.lowCardinalityKeyValue("embabel.plan.is_replanning", String.valueOf(isReplanning));
        observation.lowCardinalityKeyValue("embabel.plan.planner_type", process.getProcessOptions().getPlannerType().name());
        observation.highCardinalityKeyValue("embabel.agent.run_id", runId);
        observation.highCardinalityKeyValue("embabel.plan.iteration", String.valueOf(iteration));
        if (plan != null) {
            observation.highCardinalityKeyValue("embabel.plan.actions_count", String.valueOf(plan.getActions().size()));
            observation.highCardinalityKeyValue("output.value", this.truncate(ObservationUtils.formatPlanSteps(plan)));
            if (plan.getGoal() != null) {
                observation.highCardinalityKeyValue("embabel.plan.goal", plan.getGoal().getName());
            }
        }
        if (event.getWorldState() != null) {
            observation.highCardinalityKeyValue("input.value", this.truncate(event.getWorldState().infoString(Boolean.valueOf(true), 0)));
        }
        observation.start();
        observation.stop();
        log.debug("Recorded plan formulated event (iteration: {}, runId: {})", (Object)iteration, (Object)runId);
    }

    private void onReplanRequested(ReplanRequestedEvent event) {
        AgentProcess process = event.getAgentProcess();
        String runId = process.getId();
        EmbabelObservationContext context = EmbabelObservationContext.planning(runId, "planning:replan_requested");
        Observation observation = Observation.createNotStarted((String)"planning:replan_requested", () -> context, (ObservationRegistry)this.observationRegistry);
        observation.lowCardinalityKeyValue("embabel.event.type", "replan_requested");
        observation.highCardinalityKeyValue("embabel.agent.run_id", runId);
        observation.highCardinalityKeyValue("embabel.replan.reason", this.truncate(event.getReason()));
        observation.start();
        observation.stop();
        log.debug("Recorded replan requested event (runId: {}, reason: {})", (Object)runId, (Object)event.getReason());
    }

    private void onStateTransition(StateTransitionEvent event) {
        AgentProcess process = event.getAgentProcess();
        String runId = process.getId();
        Object newState = event.getNewState();
        String stateName = newState != null ? newState.getClass().getSimpleName() : "Unknown";
        EmbabelObservationContext context = EmbabelObservationContext.stateTransition(runId, "state:" + stateName);
        Observation observation = Observation.createNotStarted((String)("state:" + stateName), () -> context, (ObservationRegistry)this.observationRegistry);
        observation.lowCardinalityKeyValue("embabel.state.to", stateName);
        observation.lowCardinalityKeyValue("embabel.event.type", "state_transition");
        observation.highCardinalityKeyValue("embabel.agent.run_id", runId);
        if (newState != null) {
            observation.highCardinalityKeyValue("input.value", this.truncate(newState.toString()));
        }
        observation.start();
        observation.stop();
        log.debug("Recorded state transition to: {} (runId: {})", (Object)stateName, (Object)runId);
    }

    private void onLifecycleState(AbstractAgentProcessEvent event, String state) {
        AgentProcess process = event.getAgentProcess();
        String runId = process.getId();
        EmbabelObservationContext context = EmbabelObservationContext.lifecycle(runId, "lifecycle:" + state.toLowerCase());
        Observation observation = Observation.createNotStarted((String)("lifecycle:" + state.toLowerCase()), () -> context, (ObservationRegistry)this.observationRegistry);
        observation.lowCardinalityKeyValue("embabel.lifecycle.state", state);
        observation.highCardinalityKeyValue("embabel.agent.run_id", runId);
        observation.highCardinalityKeyValue("embabel.event.type", "lifecycle_" + state.toLowerCase());
        String snapshot = ObservationUtils.getBlackboardSnapshot(process);
        if (!snapshot.isEmpty()) {
            observation.highCardinalityKeyValue("input.value", this.truncate(snapshot));
        }
        observation.start();
        observation.stop();
        log.debug("Recorded lifecycle state: {} (runId: {})", (Object)state, (Object)runId);
    }

    private void onStuck(AgentProcessStuckEvent event) {
        AgentProcess process = event.getAgentProcess();
        String runId = process.getId();
        EmbabelObservationContext context = EmbabelObservationContext.lifecycle(runId, "lifecycle:stuck");
        Observation observation = Observation.createNotStarted((String)"lifecycle:stuck", () -> context, (ObservationRegistry)this.observationRegistry);
        observation.lowCardinalityKeyValue("embabel.lifecycle.state", "STUCK");
        observation.highCardinalityKeyValue("embabel.agent.run_id", runId);
        observation.highCardinalityKeyValue("embabel.event.type", "lifecycle_stuck");
        String snapshot = ObservationUtils.getBlackboardSnapshot(process);
        if (!snapshot.isEmpty()) {
            observation.highCardinalityKeyValue("input.value", this.truncate(snapshot));
        }
        observation.start();
        observation.error((Throwable)new RuntimeException("Agent process is stuck"));
        observation.stop();
        log.debug("Recorded lifecycle state: STUCK (runId: {})", (Object)runId);
    }

    private void onToolLoopStart(ToolLoopStartEvent event) {
        Object resolvedParent;
        Observation parentObs;
        AgentProcess process = event.getAgentProcess();
        String runId = process.getId();
        String actionName = event.getAction() != null ? event.getAction().getName() : "__no_action__";
        String interactionId = event.getInteractionId();
        String llmKey = ObservationKeys.llmKey(runId, interactionId);
        ObservationContext llmCtx = this.activeObservations.get(llmKey);
        if (llmCtx != null) {
            parentObs = llmCtx.observation;
            resolvedParent = "llm (key=" + llmKey + ")";
        } else {
            String actionKey = ObservationKeys.actionKey(runId, actionName);
            ObservationContext parentCtx = this.activeObservations.get(actionKey);
            if (parentCtx != null) {
                parentObs = parentCtx.observation;
                resolvedParent = "action (key=" + actionKey + ")";
            } else {
                String agentKey = ObservationKeys.agentKey(runId);
                ObservationContext agentCtx = this.activeObservations.get(agentKey);
                parentObs = agentCtx != null ? agentCtx.observation : null;
                resolvedParent = agentCtx != null ? "agent (key=" + agentKey + ")" : "NONE";
            }
        }
        log.debug("Tool loop parent resolution: {} (runId: {}, action: {}, interactionId: {}, activeKeys: {})", new Object[]{resolvedParent, runId, actionName, interactionId, this.activeObservations.keySet()});
        String toolLoopName = ObservationKeys.toolLoopSpanName(interactionId);
        EmbabelObservationContext context = EmbabelObservationContext.toolLoop(runId, toolLoopName);
        Observation observation = Observation.createNotStarted((String)toolLoopName, () -> context, (ObservationRegistry)this.observationRegistry);
        if (parentObs != null) {
            observation.parentObservation(parentObs);
        } else {
            log.warn("No parent found for tool loop {} (runId: {}). Tool loop will be an independent trace.", (Object)interactionId, (Object)runId);
        }
        observation.lowCardinalityKeyValue("gen_ai.operation.name", "tool_loop");
        observation.lowCardinalityKeyValue("embabel.event.type", "tool_loop");
        observation.highCardinalityKeyValue("embabel.tool_loop.interaction_id", interactionId);
        observation.highCardinalityKeyValue("embabel.tool_loop.max_iterations", String.valueOf(event.getMaxIterations()));
        observation.highCardinalityKeyValue("embabel.tool_loop.output_class", event.getOutputClass().getSimpleName());
        observation.highCardinalityKeyValue("embabel.tool_loop.tools", String.join((CharSequence)", ", event.getToolNames()));
        observation.start();
        Observation.Scope scope = observation.openScope();
        this.activeObservations.put(ObservationKeys.toolLoopKey(runId, interactionId), new ObservationContext(observation, scope));
        log.debug("Started observation for tool loop: {} (runId: {})", (Object)interactionId, (Object)runId);
    }

    private void onToolLoopCompleted(ToolLoopCompletedEvent event) {
        String interactionId;
        AgentProcess process = event.getAgentProcess();
        String runId = process.getId();
        String key = ObservationKeys.toolLoopKey(runId, interactionId = event.getInteractionId());
        ObservationContext ctx = this.activeObservations.remove(key);
        if (ctx != null) {
            ctx.observation.highCardinalityKeyValue("embabel.tool_loop.total_iterations", String.valueOf(event.getTotalIterations()));
            ctx.observation.highCardinalityKeyValue("embabel.tool_loop.replan_requested", String.valueOf(event.getReplanRequested()));
            ctx.observation.highCardinalityKeyValue("embabel.tool_loop.duration_ms", String.valueOf(event.getRunningTime().toMillis()));
            ctx.scope.close();
            ctx.observation.stop();
            log.debug("Completed observation for tool loop: {} (runId: {})", (Object)interactionId, (Object)runId);
        }
    }

    private void onLlmRequest(LlmRequestEvent<?> event) {
        List messages;
        String provider;
        AgentProcess process = event.getAgentProcess();
        String runId = process.getId();
        String actionName = event.getAction() != null ? event.getAction().getName() : "__no_action__";
        String modelName = event.getLlmMetadata().getName();
        ObservationContext parentCtx = this.activeObservations.get(ObservationKeys.actionKey(runId, actionName));
        if (parentCtx == null) {
            parentCtx = this.activeObservations.get(ObservationKeys.agentKey(runId));
        }
        String llmSpanName = "llm:" + modelName;
        EmbabelObservationContext context = EmbabelObservationContext.llmCall(runId, llmSpanName);
        Observation observation = Observation.createNotStarted((String)llmSpanName, () -> context, (ObservationRegistry)this.observationRegistry);
        if (parentCtx != null) {
            observation.parentObservation(parentCtx.observation);
        }
        observation.lowCardinalityKeyValue("gen_ai.operation.name", "chat");
        observation.lowCardinalityKeyValue("gen_ai.request.model", modelName);
        observation.lowCardinalityKeyValue("embabel.event.type", "llm_call");
        observation.highCardinalityKeyValue("embabel.llm.output_class", event.getOutputClass().getSimpleName());
        observation.highCardinalityKeyValue("embabel.llm.interaction_id", event.getInteraction().getId());
        LlmOptions llmOptions = event.getInteraction().getLlm();
        if (llmOptions.getTemperature() != null) {
            observation.highCardinalityKeyValue("gen_ai.request.temperature", String.valueOf(llmOptions.getTemperature()));
        }
        if (llmOptions.getMaxTokens() != null) {
            observation.highCardinalityKeyValue("gen_ai.request.max_tokens", String.valueOf(llmOptions.getMaxTokens()));
        }
        if (llmOptions.getTopP() != null) {
            observation.highCardinalityKeyValue("gen_ai.request.top_p", String.valueOf(llmOptions.getTopP()));
        }
        if ((provider = event.getLlmMetadata().getProvider()) != null && !provider.isEmpty()) {
            observation.lowCardinalityKeyValue("gen_ai.provider.name", provider);
        }
        if ((messages = event.getMessages()) != null && !messages.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (Object msg : messages) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                if (!(msg instanceof Message)) continue;
                Message m = (Message)msg;
                sb.append("[").append(m.getRole().name()).append("]: ").append(m.getContent());
            }
            if (sb.length() > 0) {
                observation.highCardinalityKeyValue("input.value", this.truncate(sb.toString()));
            }
        }
        observation.start();
        Observation.Scope scope = observation.openScope();
        this.activeObservations.put(ObservationKeys.llmKey(runId, event.getInteraction().getId()), new ObservationContext(observation, scope));
        log.debug("Started LLM observation: llm:{} (runId: {}, action: {})", new Object[]{modelName, runId, actionName});
    }

    private void onLlmResponse(LlmResponseEvent<?> event) {
        AgentProcess process = event.getAgentProcess();
        String runId = process.getId();
        String key = ObservationKeys.llmKey(runId, event.getRequest().getInteraction().getId());
        ObservationContext ctx = this.activeObservations.remove(key);
        if (ctx != null) {
            ctx.observation.highCardinalityKeyValue("embabel.llm.duration_ms", String.valueOf(event.getRunningTime().toMillis()));
            Object response = event.getResponse();
            if (response != null) {
                ctx.observation.highCardinalityKeyValue("embabel.llm.output_type", response.getClass().getSimpleName());
            }
            if (response instanceof Throwable) {
                Throwable error = (Throwable)response;
                ctx.observation.error(error);
            } else if (response != null) {
                ctx.observation.highCardinalityKeyValue("output.value", this.truncate(response.toString()));
            }
            ctx.scope.close();
            ctx.observation.stop();
            log.debug("Completed LLM observation (runId: {}, key: {})", (Object)runId, (Object)key);
        }
    }

    private void onRagEvent(AgentProcessRagEvent event) {
        Object spanName;
        AgentProcess process = event.getAgentProcess();
        String runId = process.getId();
        RagEvent ragEvent = event.getRagEvent();
        if (ragEvent instanceof RagRequestReceivedEvent) {
            spanName = "rag:request";
        } else if (ragEvent instanceof RagResponseEvent) {
            spanName = "rag:response";
        } else if (ragEvent instanceof EnhancementStartingRagPipelineEvent) {
            EnhancementStartingRagPipelineEvent e = (EnhancementStartingRagPipelineEvent)ragEvent;
            spanName = "rag:enhancement:" + e.getEnhancerName();
        } else if (ragEvent instanceof EnhancementCompletedRagPipelineEvent) {
            EnhancementCompletedRagPipelineEvent e = (EnhancementCompletedRagPipelineEvent)ragEvent;
            spanName = "rag:enhancement:" + e.getEnhancerName() + ":done";
        } else {
            spanName = ragEvent instanceof InitialRequestRagPipelineEvent ? "rag:pipeline:request" : (ragEvent instanceof InitialResponseRagPipelineEvent ? "rag:pipeline:response" : "rag:event");
        }
        EmbabelObservationContext context = EmbabelObservationContext.rag(runId, (String)spanName);
        Observation observation = Observation.createNotStarted((String)spanName, () -> context, (ObservationRegistry)this.observationRegistry);
        observation.lowCardinalityKeyValue("embabel.event.type", "rag");
        observation.lowCardinalityKeyValue("gen_ai.operation.name", "rag");
        observation.highCardinalityKeyValue("embabel.rag.query", ragEvent.getRequest().getQuery());
        if (ragEvent instanceof RagRequestReceivedEvent) {
            observation.highCardinalityKeyValue("input.value", this.truncate(ragEvent.getRequest().getQuery()));
        } else if (ragEvent instanceof RagResponseEvent) {
            RagResponseEvent re = (RagResponseEvent)ragEvent;
            observation.highCardinalityKeyValue("embabel.rag.result_count", String.valueOf(re.getRagResponse().getResults().size()));
            observation.highCardinalityKeyValue("output.value", this.truncate(re.getRagResponse().getResults().toString()));
        } else if (ragEvent instanceof EnhancementStartingRagPipelineEvent) {
            EnhancementStartingRagPipelineEvent e = (EnhancementStartingRagPipelineEvent)ragEvent;
            observation.highCardinalityKeyValue("embabel.rag.enhancer", e.getEnhancerName());
        } else if (ragEvent instanceof EnhancementCompletedRagPipelineEvent) {
            EnhancementCompletedRagPipelineEvent e = (EnhancementCompletedRagPipelineEvent)ragEvent;
            observation.highCardinalityKeyValue("embabel.rag.enhancer", e.getEnhancerName());
        } else if (ragEvent instanceof RagPipelineEvent) {
            RagPipelineEvent pe = (RagPipelineEvent)ragEvent;
            observation.highCardinalityKeyValue("embabel.rag.description", pe.getDescription());
        }
        observation.start();
        observation.stop();
        log.debug("Recorded RAG event: {} (runId: {})", spanName, (Object)runId);
    }

    private void onRankingRequest(RankingChoiceRequestEvent<?> event) {
        EmbabelObservationContext context = EmbabelObservationContext.ranking("ranking:request");
        Observation observation = Observation.createNotStarted((String)"ranking:request", () -> context, (ObservationRegistry)this.observationRegistry);
        observation.lowCardinalityKeyValue("embabel.event.type", "ranking");
        observation.lowCardinalityKeyValue("gen_ai.operation.name", "ranking");
        observation.highCardinalityKeyValue("embabel.ranking.type", event.getType().getSimpleName());
        observation.highCardinalityKeyValue("embabel.ranking.choices_count", String.valueOf(event.getChoices().size()));
        observation.highCardinalityKeyValue("input.value", this.truncate(event.getBasis().toString()));
        observation.start();
        observation.stop();
        log.debug("Recorded ranking request event");
    }

    private void onRankingChoiceMade(RankingChoiceMadeEvent<?> event) {
        Ranking choice = event.getChoice();
        String chosenName = choice.getMatch().getName();
        EmbabelObservationContext context = EmbabelObservationContext.ranking("ranking:choice_made");
        Observation observation = Observation.createNotStarted((String)"ranking:choice_made", () -> context, (ObservationRegistry)this.observationRegistry);
        observation.lowCardinalityKeyValue("embabel.event.type", "ranking");
        observation.lowCardinalityKeyValue("gen_ai.operation.name", "ranking");
        observation.highCardinalityKeyValue("embabel.ranking.chosen", chosenName);
        observation.highCardinalityKeyValue("embabel.ranking.score", String.valueOf(choice.getScore()));
        observation.highCardinalityKeyValue("embabel.ranking.type", event.getType().getSimpleName());
        observation.highCardinalityKeyValue("embabel.ranking.choices_count", String.valueOf(event.getChoices().size()));
        observation.highCardinalityKeyValue("input.value", this.truncate(event.getBasis().toString()));
        observation.highCardinalityKeyValue("output.value", this.truncate(event.getRankings().infoString(Boolean.valueOf(true), 0)));
        observation.start();
        observation.stop();
        log.debug("Recorded ranking choice made: {}", (Object)chosenName);
    }

    private void onRankingChoiceCouldNotBeMade(RankingChoiceCouldNotBeMadeEvent<?> event) {
        EmbabelObservationContext context = EmbabelObservationContext.ranking("ranking:no_choice");
        Observation observation = Observation.createNotStarted((String)"ranking:no_choice", () -> context, (ObservationRegistry)this.observationRegistry);
        observation.lowCardinalityKeyValue("embabel.event.type", "ranking");
        observation.lowCardinalityKeyValue("gen_ai.operation.name", "ranking");
        observation.highCardinalityKeyValue("embabel.ranking.type", event.getType().getSimpleName());
        observation.highCardinalityKeyValue("embabel.ranking.confidence_cutoff", String.valueOf(event.getConfidenceCutOff()));
        observation.highCardinalityKeyValue("embabel.ranking.choices_count", String.valueOf(event.getChoices().size()));
        observation.highCardinalityKeyValue("input.value", this.truncate(event.getBasis().toString()));
        observation.highCardinalityKeyValue("output.value", this.truncate(event.getRankings().infoString(Boolean.valueOf(true), 0)));
        observation.start();
        observation.error((Throwable)new RuntimeException("No ranking choice could be made"));
        observation.stop();
        log.debug("Recorded ranking choice could not be made");
    }

    private void onDynamicAgentCreation(DynamicAgentCreationEvent event) {
        String agentName = event.getAgent().getName();
        EmbabelObservationContext context = EmbabelObservationContext.dynamicAgentCreation("dynamic_agent:" + agentName);
        Observation observation = Observation.createNotStarted((String)("dynamic_agent:" + agentName), () -> context, (ObservationRegistry)this.observationRegistry);
        observation.lowCardinalityKeyValue("embabel.event.type", "dynamic_agent_creation");
        observation.lowCardinalityKeyValue("gen_ai.operation.name", "create_agent");
        observation.highCardinalityKeyValue("embabel.agent.name", agentName);
        observation.highCardinalityKeyValue("input.value", this.truncate(event.getBasis().toString()));
        observation.start();
        observation.stop();
        log.debug("Recorded dynamic agent creation: {}", (Object)agentName);
    }

    private void onProcessKilled(ProcessKilledEvent event) {
        AgentProcess process = event.getAgentProcess();
        String runId = process.getId();
        String key = ObservationKeys.agentKey(runId);
        ObservationContext ctx = this.activeObservations.remove(key);
        this.inputSnapshots.remove(key);
        this.planIterations.remove(runId);
        if (ctx != null) {
            ctx.observation.lowCardinalityKeyValue("embabel.agent.status", "killed");
            ctx.observation.error((Throwable)new RuntimeException("Agent process was killed"));
            ctx.scope.close();
            ctx.observation.stop();
            log.debug("Recorded process killed for agent runId: {}", (Object)runId);
        }
    }

    private ObservationContext findParentObservation(String runId) {
        String actionPrefix = "action:" + runId;
        for (String key : this.activeObservations.keySet()) {
            if (!key.startsWith(actionPrefix)) continue;
            return this.activeObservations.get(key);
        }
        return this.activeObservations.get(ObservationKeys.agentKey(runId));
    }

    private String truncate(String value) {
        return ObservationUtils.truncate(value, this.properties.getMaxAttributeLength());
    }

    private record ObservationContext(Observation observation, Observation.Scope scope) {
    }
}

