/*
 * Decompiled with CFR 0.152.
 */
package com.embabel.common.ai.prompt;

import com.embabel.common.ai.prompt.PromptContributor;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u000f\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u000bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/embabel/common/ai/prompt/KnowledgeCutoffDate;", "Lcom/embabel/common/ai/prompt/PromptContributor;", "date", "Ljava/time/LocalDate;", "formatter", "Ljava/time/format/DateTimeFormatter;", "<init>", "(Ljava/time/LocalDate;Ljava/time/format/DateTimeFormatter;)V", "getDate", "()Ljava/time/LocalDate;", "contribution", "", "role", "getRole", "()Ljava/lang/String;", "toString", "embabel-agent-common"})
public final class KnowledgeCutoffDate
implements PromptContributor {
    @NotNull
    private final LocalDate date;
    @NotNull
    private final DateTimeFormatter formatter;
    @NotNull
    private final String role;

    public KnowledgeCutoffDate(@NotNull LocalDate date, @NotNull DateTimeFormatter formatter) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)formatter, (String)"formatter");
        this.date = date;
        this.formatter = formatter;
        this.role = "knowledge_cutoff";
    }

    public /* synthetic */ KnowledgeCutoffDate(LocalDate localDate, DateTimeFormatter dateTimeFormatter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM");
        }
        this(localDate, dateTimeFormatter);
    }

    @NotNull
    public final LocalDate getDate() {
        return this.date;
    }

    @Override
    @NotNull
    public String contribution() {
        return "Knowledge cutoff: " + this.date.format(this.formatter) + "\n";
    }

    @Override
    @NotNull
    public String getRole() {
        return this.role;
    }

    @NotNull
    public String toString() {
        return "KnowledgeCutoffDate: [" + this.contribution() + "]";
    }
}

