/*
 * Decompiled with CFR 0.152.
 */
package com.emailage.javawrapper.utilities;

import com.emailage.javawrapper.model.OAuth2Token;
import com.emailage.javawrapper.utilities.AutoCloseableHttpsUrlConnection;
import com.emailage.javawrapper.utilities.HttpHelper;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.net.ssl.HttpsURLConnection;

public class OAuth2Wrapper {
    private static final Object lock = new Object();
    protected final String accountToken;
    protected final String accountSecret;
    protected LocalDateTime expiration;
    protected OAuth2Token token;
    protected final URL tokenUrl;
    protected final HttpHelper httpHelper;
    private static final String tokenForm = "grant_type=client_credentials&client_id=%s&client_secret=%s";
    private static final String refreshForm = "grant_type=refresh_token&client_id=%s&refresh_token=%s";

    public static OAuth2Wrapper getInstance(String accountToken, String accountSecret, URL tokenUrl, HttpHelper httpHelper) {
        if (!InstanceHolder.InstanceCollection.containsKey(accountToken)) {
            InstanceHolder.InstanceCollection.put(accountToken, new OAuth2Wrapper(accountToken, accountSecret, tokenUrl, httpHelper));
        }
        return (OAuth2Wrapper)InstanceHolder.InstanceCollection.get(accountToken);
    }

    public static OAuth2Wrapper getInstance(String accountToken, String accountSecret, URL tokenUrl) {
        if (!InstanceHolder.InstanceCollection.containsKey(accountToken)) {
            InstanceHolder.InstanceCollection.put(accountToken, new OAuth2Wrapper(accountToken, accountSecret, tokenUrl, new HttpHelper()));
        }
        return (OAuth2Wrapper)InstanceHolder.InstanceCollection.get(accountToken);
    }

    protected OAuth2Wrapper(String accountToken, String accountSecret, URL tokenUrl, HttpHelper httpHelper) {
        this.accountSecret = accountSecret;
        this.accountToken = accountToken;
        this.tokenUrl = tokenUrl;
        this.httpHelper = httpHelper;
        this.expiration = LocalDateTime.now().minusMonths(1L);
        this.token = new OAuth2Token();
    }

    public OAuth2Token getToken() {
        return this.token;
    }

    public void setExpiration(LocalDateTime time) {
        this.expiration = time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doOAuth2Request(URL url, String form) throws Exception {
        String answer;
        Object object = lock;
        synchronized (object) {
            if (this.expiration.isBefore(LocalDateTime.now())) {
                this.token = this.getAccessToken(this.token, this.accountToken, this.accountSecret, this.tokenUrl);
                this.expiration = LocalDateTime.now().plusSeconds(this.token.getAccessExpiration());
            }
        }
        byte[] body = form.getBytes(StandardCharsets.UTF_8);
        HttpsURLConnection conn = this.httpHelper.getHttpsURLConnection(url);
        try (AutoCloseableHttpsUrlConnection conc = new AutoCloseableHttpsUrlConnection(conn);){
            conn.setRequestProperty("Authorization", "Bearer " + this.token.getAccessToken());
            answer = this.httpHelper.PostRequest(body, conn);
        }
        return answer;
    }

    private OAuth2Token getAccessToken(OAuth2Token token, String accountToken, String accountSecret, URL tokenUrl) throws Exception {
        String answer = null;
        try {
            HttpsURLConnection conn = this.httpHelper.getHttpsURLConnection(tokenUrl);
            try (AutoCloseableHttpsUrlConnection conc = new AutoCloseableHttpsUrlConnection(conn);){
                String form = token.getRefreshToken() != null ? String.format(refreshForm, accountSecret, token.getRefreshToken()) : String.format(tokenForm, accountSecret, accountToken);
                byte[] body = form.getBytes(StandardCharsets.UTF_8);
                answer = this.httpHelper.PostRequest(body, conn);
            }
        }
        catch (Exception ex) {
            if (token.getRefreshToken() != null) {
                token.setRefreshToken(null);
                this.getAccessToken(token, accountToken, accountSecret, tokenUrl);
            }
            throw ex;
        }
        OAuth2Token result = (OAuth2Token)InstanceHolder.mapper.readValue(answer, OAuth2Token.class);
        return result;
    }

    private static class InstanceHolder {
        private static final ConcurrentMap<String, OAuth2Wrapper> InstanceCollection = new ConcurrentHashMap<String, OAuth2Wrapper>();
        private static final ObjectMapper mapper = new ObjectMapper();

        private InstanceHolder() {
        }

        static {
            mapper.registerModule((Module)new AfterburnerModule());
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        }
    }
}

