/*
 * Decompiled with CFR 0.152.
 */
package com.emailage.javawrapper.utilities;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public class HttpHelper {
    public HttpsURLConnection getHttpsURLConnection(URL url) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        HttpsURLConnection conn;
        double version = Double.parseDouble(System.getProperty("java.specification.version"));
        if (version == 1.7) {
            SSLContext context = SSLContext.getInstance("TLSv1.1");
            context.init(null, null, null);
            conn = (HttpsURLConnection)url.openConnection();
            conn.setSSLSocketFactory(context.getSocketFactory());
        } else {
            conn = (HttpsURLConnection)url.openConnection();
        }
        return conn;
    }

    public String PostRequest(byte[] body, HttpsURLConnection conn) throws IOException {
        int bodySize = body.length;
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded; charset=utf-8");
        conn.setRequestProperty("Content-Length", Integer.toString(bodySize));
        conn.setRequestProperty("Content-Language", "en-US");
        conn.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.name());
        conn.setDoOutput(true);
        StringBuilder answer = new StringBuilder();
        try (DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
             BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)wr, StandardCharsets.UTF_8.name()));){
            String value = new String(body, StandardCharsets.UTF_8.name());
            writer.write(value);
        }
        Charset charset = Charset.forName(StandardCharsets.UTF_8.name());
        try (BufferedReader input = new BufferedReader(new InputStreamReader(conn.getInputStream(), charset));){
            String str;
            while (null != (str = input.readLine())) {
                answer.append(str);
            }
        }
        return answer.toString();
    }
}

