/*
 * Decompiled with CFR 0.152.
 */
package com.emailage.javawrapper;

import com.emailage.javawrapper.model.ConfigurationParameters;
import com.emailage.javawrapper.model.Enums;
import com.emailage.javawrapper.model.ExtraInputParameter;
import com.emailage.javawrapper.model.exception.EmailageApiRequestException;
import com.emailage.javawrapper.model.exception.EmailageParameterException;
import com.emailage.javawrapper.model.response.EmailageResponse;
import com.emailage.javawrapper.utilities.AutoCloseableHttpsUrlConnection;
import com.emailage.javawrapper.utilities.OAuth;
import com.emailage.javawrapper.utilities.Validation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;

public class EmailageClient {
    private static final String RequestBaseUrlSand = "https://sandbox.emailage.com/emailagevalidator/";
    private static final String RequestBaseUrlProd = "https://api.emailage.com/emailagevalidator/";
    private static final String RequestBaseFraudUrlSand = "https://sandbox.emailage.com/emailageValidator/flag/";
    private static final String RequestBaseFraudUrlProd = "https://api.emailage.com/emailageValidator/flag/";
    private static Logger Log = Logger.getLogger(EmailageClient.class.getName());
    private static Pattern compiledUTF8Pattern = Pattern.compile("\ufeff");
    private static ObjectMapper mapper = new ObjectMapper();

    public static EmailageResponse QueryEmail(String email, ConfigurationParameters parameters) throws IOException, EmailageApiRequestException {
        EmailageClient.validateParams(email, parameters.isValidateBeforeSending());
        String query = "query=" + URLEncoder.encode(email, StandardCharsets.UTF_8.name());
        String result = EmailageClient.PostQuery(APIUrl.Query, null, query, parameters);
        String decodedString = URLDecoder.decode(result, StandardCharsets.UTF_8.name());
        return EmailageClient.deserialize(decodedString);
    }

    public static EmailageResponse QueryEmailAndIP(String email, String IP, ConfigurationParameters parameters) throws IOException, EmailageApiRequestException {
        EmailageClient.validateParams(email, IP, parameters.isValidateBeforeSending());
        String queryElement = EmailageClient.constructQueryField(email, IP);
        StringBuffer queryBuffer = new StringBuffer("query=");
        queryBuffer.append(queryElement);
        String result = EmailageClient.PostQuery(APIUrl.Query, null, queryBuffer.toString(), parameters);
        String decodedString = URLDecoder.decode(result, StandardCharsets.UTF_8.name());
        return EmailageClient.deserialize(decodedString);
    }

    public static EmailageResponse QueryEmailAndIPPlusExtraArgs(String email, String IP, ExtraInputParameter extraArgs, ConfigurationParameters parameters) throws IOException, EmailageParameterException, EmailageApiRequestException {
        EmailageClient.validateParams(email, IP, parameters.isValidateBeforeSending());
        String queryElement = EmailageClient.constructQueryField(email, IP);
        StringBuffer queryBuffer = new StringBuffer("query=");
        queryBuffer.append(queryElement);
        queryBuffer.append(extraArgs.buildExtraInputParameterRequest());
        return EmailageClient.deserialize(EmailageClient.PostQuery(APIUrl.Query, null, queryBuffer.toString(), parameters));
    }

    public static EmailageResponse MarkEmailAsFraud(String email, Enums.FraudType fraudType, Enums.FraudCode fraudCode, ConfigurationParameters parameters) throws EmailageApiRequestException, IOException {
        String query = "query=" + URLEncoder.encode(email, StandardCharsets.UTF_8.name()) + "&fraudcodeID=" + fraudCode.toInt() + "&flag=" + (Object)((Object)fraudType);
        String result = EmailageClient.PostQuery(APIUrl.MarkAsFraud, fraudType, query, parameters);
        String decodedString = URLDecoder.decode(result, StandardCharsets.UTF_8.name());
        EmailageResponse response = EmailageClient.deserialize(decodedString);
        response.getQuery().setEmail(URLDecoder.decode(response.getQuery().getEmail(), StandardCharsets.UTF_8.name()));
        return response;
    }

    protected static HttpsURLConnection getHttpsURLConnection(URL url) throws NoSuchAlgorithmException, KeyManagementException, IOException {
        HttpsURLConnection conn;
        double version = Double.parseDouble(System.getProperty("java.specification.version"));
        if (version == 1.7) {
            SSLContext context = SSLContext.getInstance("TLSv1.1");
            context.init(null, null, null);
            conn = (HttpsURLConnection)url.openConnection();
            conn.setSSLSocketFactory(context.getSocketFactory());
        } else {
            conn = (HttpsURLConnection)url.openConnection();
        }
        return conn;
    }

    private static String PostQuery(APIUrl endpoint, Enums.FraudType fraudType, String urlParameters, ConfigurationParameters parameters) throws EmailageApiRequestException, MalformedURLException {
        String resultFormat = parameters.getResultFormat().toString();
        String hashAlgorithmString = parameters.getHashAlgorithm().toString();
        String endpointurl = null;
        if (parameters.getEnvironment() == Enums.Environment.Production && endpoint == APIUrl.Query) {
            endpointurl = RequestBaseUrlProd;
        } else if (parameters.getEnvironment() == Enums.Environment.Sandbox && endpoint == APIUrl.Query) {
            endpointurl = RequestBaseUrlSand;
        } else if (parameters.getEnvironment() == Enums.Environment.Production && endpoint == APIUrl.MarkAsFraud) {
            endpointurl = RequestBaseFraudUrlProd;
        } else if (parameters.getEnvironment() == Enums.Environment.Sandbox && endpoint == APIUrl.MarkAsFraud) {
            endpointurl = RequestBaseFraudUrlSand;
        }
        String oriUrl = null != fraudType ? endpointurl + "?flag=" + fraudType.toString() + "&format=" + resultFormat + "&" + urlParameters : endpointurl + "?format=" + resultFormat;
        if (parameters.getUserEmail() != null && parameters.getUserEmail().trim().length() > 0) {
            oriUrl = oriUrl + "&user_email=" + parameters.getUserEmail();
        }
        String requestUrl = OAuth.getUrl("POST", hashAlgorithmString, oriUrl, parameters.getAccountSecret(), parameters.getAcccountToken());
        Log.finer("requestUrl: " + requestUrl);
        byte[] postData = urlParameters.getBytes(StandardCharsets.UTF_8);
        int postDataLength = postData.length;
        URL url = new URL(requestUrl);
        StringBuilder answer = new StringBuilder();
        try {
            HttpsURLConnection conn = EmailageClient.getHttpsURLConnection(url);
            try (AutoCloseableHttpsUrlConnection conc = new AutoCloseableHttpsUrlConnection(conn);){
                conn.setRequestProperty("Content-Language", "en-US");
                conn.setRequestProperty("Content-Type", "application/json; charset=utf-8");
                conn.setRequestProperty("Accept-Charset", StandardCharsets.UTF_8.name());
                conn.setRequestProperty("Content-Length", Integer.toString(postDataLength));
                conn.setDoOutput(true);
                try (DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
                     BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)wr, StandardCharsets.UTF_8.name()));){
                    String value = new String(postData, StandardCharsets.UTF_8.name());
                    writer.write(value);
                }
                Charset charset = Charset.forName(StandardCharsets.UTF_8.name());
                try (BufferedReader input = new BufferedReader(new InputStreamReader(conn.getInputStream(), charset));){
                    String str;
                    while (null != (str = input.readLine())) {
                        answer.append(str);
                    }
                }
            }
        }
        catch (Exception e1) {
            throw new EmailageApiRequestException("Could not complete API request", e1);
        }
        return answer.toString();
    }

    private static EmailageResponse deserialize(String response) throws IOException {
        Matcher matcher = compiledUTF8Pattern.matcher(response.trim());
        EmailageResponse query = (EmailageResponse)mapper.readValue(matcher.replaceFirst(""), EmailageResponse.class);
        query.getQuery().setRaw(response);
        return query;
    }

    private static boolean validateParams(String email, boolean isValidationActive) throws IllegalArgumentException {
        if (isValidationActive && !Validation.validateEmail(email)) {
            throw new IllegalArgumentException("Email supplied is not valid : " + email);
        }
        return true;
    }

    private static boolean validateParams(String email, String ipAddress, boolean isValidationActive) throws IllegalArgumentException {
        if (isValidationActive) {
            if (email == null && ipAddress == null) {
                throw new IllegalArgumentException("Email or Ip Address must be supplied");
            }
            if (email != null && !Validation.validateEmail(email)) {
                throw new IllegalArgumentException("Email supplied is not valid : " + email);
            }
            if (ipAddress != null && !Validation.validateIpAddress(ipAddress)) {
                throw new IllegalArgumentException("Ip Address supplied is not a valid ipv4 or ipv6 address : " + email);
            }
        }
        return true;
    }

    private static String constructQueryField(String email, String IP) throws UnsupportedEncodingException {
        StringBuffer queryElement = new StringBuffer();
        if (email != null) {
            queryElement.append(email);
        }
        if (email != null && IP != null) {
            queryElement.append("+");
        }
        if (IP != null) {
            queryElement.append(IP);
        }
        return URLEncoder.encode(queryElement.toString(), StandardCharsets.UTF_8.name());
    }

    static {
        mapper.registerModule((Module)new AfterburnerModule());
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
    }

    private static enum APIUrl {
        Query,
        MarkAsFraud;

    }
}

