/*
 * Decompiled with CFR 0.152.
 */
package com.emailage.javawrapper.example;

import com.emailage.javawrapper.EmailageClient;
import com.emailage.javawrapper.model.ConfigurationParameters;
import com.emailage.javawrapper.model.Enums;
import com.emailage.javawrapper.model.ExtraInputParameter;
import com.emailage.javawrapper.model.response.EmailageResponse;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;

public class TestClient {
    public static void main(String[] args) {
        String result;
        EmailageResponse validResult;
        Enums.Format resultFormat = Enums.Format.Json;
        Enums.SignatureMethod signatureMethod = Enums.SignatureMethod.HMAC_SHA256;
        String user_email = null;
        Enums.Environment environment = Enums.Environment.Production;
        String accountSecret = "replace-me";
        String authToken = "replace-me";
        ConfigurationParameters parameters = new ConfigurationParameters();
        parameters.setUserEmail(user_email);
        parameters.setAcccountToken(authToken);
        parameters.setAccountSecret(accountSecret);
        parameters.setEnvironment(environment);
        parameters.setHashAlgorithm(signatureMethod);
        parameters.setResultFormat(resultFormat);
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new AfterburnerModule());
        try {
            System.out.println("Querying Email");
            validResult = EmailageClient.QueryEmail("test@test.com", parameters);
            result = mapper.writeValueAsString((Object)validResult);
            System.out.println(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.out.println("Querying Email + IP");
            validResult = EmailageClient.QueryEmailAndIP("test@test.com", "147.12.12.13", parameters);
            result = mapper.writeValueAsString((Object)validResult);
            System.out.println(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.out.println("Querying Email + IP + Extra Arguments");
            ExtraInputParameter extraArgs = new ExtraInputParameter();
            extraArgs.setbilladdress("123 Any St.");
            extraArgs.setbillpostal("85225");
            extraArgs.setbillcity("Chandler");
            extraArgs.setbillregion("AZ");
            extraArgs.setbillcountry("us");
            extraArgs.setphone("4805551212");
            extraArgs.settransamount(1234.56);
            extraArgs.settranscurrency("USD");
            extraArgs.setexistingcustomer(false);
            extraArgs.setfirstname("Bob");
            extraArgs.setlastname("Smith");
            EmailageResponse validResult2 = EmailageClient.QueryEmailAndIPPlusExtraArgs("test@test.com", "147.12.12.13", extraArgs, parameters);
            String result2 = mapper.writeValueAsString((Object)validResult2);
            System.out.println(result2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            System.out.println("Marking an Email as Fraud");
            validResult = EmailageClient.MarkEmailAsFraud("test@test.com", Enums.FraudType.Fraud, Enums.FraudCode.CARD_NOT_PRESENT, parameters);
            result = mapper.writeValueAsString((Object)validResult);
            System.out.println(result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

