/*
 * Decompiled with CFR 0.152.
 */
package com.electronwill.nightconfig.toml;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.CharacterOutput;
import com.electronwill.nightconfig.toml.ArrayWriter;
import com.electronwill.nightconfig.toml.StringWriter;
import com.electronwill.nightconfig.toml.TableWriter;
import com.electronwill.nightconfig.toml.TemporalWriter;
import com.electronwill.nightconfig.toml.TomlWriter;
import java.time.temporal.Temporal;
import java.util.List;

final class ValueWriter {
    static void write(Object value, CharacterOutput output, TomlWriter writer) {
        if (value instanceof Config) {
            TableWriter.writeInline((UnmodifiableConfig)((Config)value), output, writer);
        } else if (value instanceof List) {
            List list = (List)value;
            if (!list.isEmpty() && list.get(0) instanceof Config) {
                for (Object table : list) {
                    TableWriter.writeInline((UnmodifiableConfig)((Config)table), output, writer);
                }
            } else {
                ArrayWriter.write((List)value, output, writer);
            }
        } else if (value instanceof String) {
            String string = (String)value;
            if (writer.writesLiteral(string)) {
                StringWriter.writeLiteral(string, output);
            } else {
                StringWriter.writeBasic(string, output);
            }
        } else if (value instanceof Temporal) {
            TemporalWriter.write((Temporal)value, output);
        } else if (value instanceof Float || value instanceof Double) {
            double d = (Double)value;
            if (Double.isNaN(d)) {
                output.write("nan");
            } else if (d == Double.POSITIVE_INFINITY) {
                output.write("+inf");
            } else if (d == Double.NEGATIVE_INFINITY) {
                output.write("-inf");
            } else {
                output.write(value.toString());
            }
        } else {
            output.write(value.toString());
        }
    }

    private ValueWriter() {
    }
}

