/*
 * Decompiled with CFR 0.152.
 */
package com.electronwill.nightconfig.json;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.FormatDetector;
import com.electronwill.nightconfig.core.io.ConfigParser;
import com.electronwill.nightconfig.core.io.ConfigWriter;
import com.electronwill.nightconfig.core.utils.WriterSupplier;
import com.electronwill.nightconfig.json.FancyJsonWriter;
import com.electronwill.nightconfig.json.JsonParser;
import com.electronwill.nightconfig.json.MinimalJsonWriter;
import java.io.IOException;
import java.io.Writer;

public abstract class JsonFormat<W extends ConfigWriter>
implements ConfigFormat<Config> {
    private static final JsonFormat<FancyJsonWriter> FANCY = new JsonFormat<FancyJsonWriter>(){

        @Override
        public FancyJsonWriter createWriter() {
            return new FancyJsonWriter();
        }

        @Override
        public ConfigParser<Config> createParser() {
            return new JsonParser(this);
        }
    };
    private static final JsonFormat<MinimalJsonWriter> MINIMAL = new JsonFormat<MinimalJsonWriter>(){

        @Override
        public MinimalJsonWriter createWriter() {
            return new MinimalJsonWriter();
        }

        @Override
        public ConfigParser<Config> createParser() {
            return new JsonParser(this);
        }
    };

    public static JsonFormat<FancyJsonWriter> fancyInstance() {
        return FANCY;
    }

    public static JsonFormat<MinimalJsonWriter> minimalInstance() {
        return MINIMAL;
    }

    public static JsonFormat<FancyJsonWriter> emptyTolerantInstance() {
        return new JsonFormat<FancyJsonWriter>(){

            @Override
            public FancyJsonWriter createWriter() {
                return new FancyJsonWriter();
            }

            @Override
            public ConfigParser<Config> createParser() {
                return new JsonParser(this).setEmptyDataAccepted(true);
            }
        };
    }

    public static JsonFormat<MinimalJsonWriter> minimalEmptyTolerantInstance() {
        return new JsonFormat<MinimalJsonWriter>(){

            @Override
            public MinimalJsonWriter createWriter() {
                return new MinimalJsonWriter();
            }

            @Override
            public ConfigParser<Config> createParser() {
                return new JsonParser(this).setEmptyDataAccepted(true);
            }
        };
    }

    public static Config newConfig() {
        return FANCY.createConfig();
    }

    public static Config newConcurrentConfig() {
        return FANCY.createConcurrentConfig();
    }

    private JsonFormat() {
    }

    public abstract W createWriter();

    public abstract ConfigParser<Config> createParser();

    public Config createConfig() {
        return Config.of((ConfigFormat)this);
    }

    public Config createConcurrentConfig() {
        return Config.ofConcurrent((ConfigFormat)this);
    }

    public boolean supportsComments() {
        return false;
    }

    public void initEmptyFile(WriterSupplier ws) throws IOException {
        try (Writer writer = ws.get();){
            writer.write("{}");
        }
    }

    static {
        FormatDetector.registerExtension((String)"json", FANCY);
    }
}

