/*
 * Decompiled with CFR 0.152.
 */
package com.electronwill.nightconfig.hocon;

import com.electronwill.nightconfig.core.NullObject;
import com.electronwill.nightconfig.core.UnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.UnmodifiableConfig;
import com.electronwill.nightconfig.core.io.CharacterOutput;
import com.electronwill.nightconfig.core.io.ConfigWriter;
import com.electronwill.nightconfig.core.io.IndentStyle;
import com.electronwill.nightconfig.core.io.NewlineStyle;
import com.electronwill.nightconfig.core.io.Utils;
import com.electronwill.nightconfig.core.io.WriterOutput;
import com.electronwill.nightconfig.core.io.WritingException;
import com.electronwill.nightconfig.core.utils.FakeUnmodifiableCommentedConfig;
import com.electronwill.nightconfig.core.utils.StringUtils;
import com.electronwill.nightconfig.hocon.CommentStyle;
import com.electronwill.nightconfig.hocon.KeyValueSeparatorStyle;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public final class HoconWriter
implements ConfigWriter {
    private static final char[] NULL_CHARS = new char[]{'n', 'u', 'l', 'l'};
    private static final char[] TRUE_CHARS = new char[]{'t', 'r', 'u', 'e'};
    private static final char[] FALSE_CHARS = new char[]{'f', 'a', 'l', 's', 'e'};
    private static final char[] EMPTY_OBJECT = new char[]{'{', '}'};
    private static final char[] EMPTY_ARRAY = new char[]{'[', ']'};
    private static final char[] TO_ESCAPE = new char[]{'\"', '\n', '\r', '\t', '\\'};
    private static final char[] ESCAPED = new char[]{'\"', 'n', 'r', 't', '\\'};
    private static final char[] VALUE_SEPARATOR = new char[]{',', ' '};
    private static final char[] FORBIDDEN_IN_UNQUOTED = new char[]{'$', '\"', '{', '}', '[', ']', ':', '=', ',', '+', '#', '`', '^', '?', '!', '@', '*', '&', '\\'};
    private Predicate<UnmodifiableConfig> indentObjectElementsPredicate = c -> true;
    private Predicate<Collection<?>> indentArrayElementsPredicate = c -> true;
    private boolean newlineAfterObjectStart;
    private char[] newline;
    private char[] indent;
    private char[] kvSeparator;
    private char[] commentPrefix;
    private int currentIndentLevel;

    public HoconWriter() {
        this.newline = NewlineStyle.system().chars;
        this.indent = IndentStyle.TABS.chars;
        this.kvSeparator = KeyValueSeparatorStyle.COLON.chars;
        this.commentPrefix = CommentStyle.HASH.chars;
    }

    public void write(UnmodifiableConfig config, Writer writer) {
        this.currentIndentLevel = -1;
        Object commentedConfig = config instanceof UnmodifiableCommentedConfig ? (UnmodifiableCommentedConfig)config : new FakeUnmodifiableCommentedConfig(config);
        this.writeObject((UnmodifiableCommentedConfig)commentedConfig, (CharacterOutput)new WriterOutput(writer), true);
    }

    private void writeObject(UnmodifiableCommentedConfig config, CharacterOutput output, boolean root) {
        if (config.isEmpty()) {
            output.write(EMPTY_OBJECT);
            return;
        }
        if (!root) {
            output.write('{');
        }
        if (this.newlineAfterObjectStart) {
            output.write(this.newline);
        }
        Iterator it = config.entrySet().iterator();
        boolean indentElements = this.indentObjectElementsPredicate.test((UnmodifiableConfig)config);
        if (indentElements) {
            output.write(this.newline);
            this.increaseIndentLevel();
        }
        do {
            UnmodifiableCommentedConfig.Entry entry = (UnmodifiableCommentedConfig.Entry)it.next();
            String key = entry.getKey();
            Object value = entry.getValue();
            List comments = StringUtils.splitLines((String)entry.getComment());
            for (String comment : comments) {
                output.write(this.commentPrefix);
                output.write(comment);
                output.write(this.newline);
            }
            if (indentElements) {
                this.writeIndent(output);
            }
            this.writeString(key, output);
            if (value instanceof UnmodifiableConfig) {
                output.write(' ');
            } else {
                output.write(this.kvSeparator);
            }
            this.writeValue(value, output);
            if (indentElements) {
                output.write(this.newline);
                continue;
            }
            output.write(',');
        } while (it.hasNext());
        if (indentElements) {
            this.decreaseIndentLevel();
            this.writeIndent(output);
        }
        if (!root) {
            output.write('}');
        }
    }

    private void writeValue(Object v, CharacterOutput output) {
        if (v == null || v == NullObject.NULL_OBJECT) {
            output.write(NULL_CHARS);
        } else if (v instanceof String) {
            this.writeString(v.toString(), output);
        } else if (v instanceof Enum) {
            this.writeString(((Enum)v).name(), output);
        } else if (v instanceof Number) {
            output.write(v.toString());
        } else if (v instanceof UnmodifiableCommentedConfig) {
            this.writeObject((UnmodifiableCommentedConfig)v, output, false);
        } else if (v instanceof UnmodifiableConfig) {
            this.writeObject((UnmodifiableCommentedConfig)new FakeUnmodifiableCommentedConfig((UnmodifiableConfig)v), output, false);
        } else if (v instanceof Collection) {
            this.writeArray((Collection)v, output);
        } else if (v instanceof Boolean) {
            this.writeBoolean((Boolean)v, output);
        } else {
            throw new WritingException("Unsupported value type: " + v.getClass());
        }
    }

    private void writeArray(Collection<?> collection, CharacterOutput output) {
        if (collection.isEmpty()) {
            output.write(EMPTY_ARRAY);
            return;
        }
        output.write('[');
        if (this.newlineAfterObjectStart) {
            output.write(this.newline);
        }
        Iterator<?> it = collection.iterator();
        boolean indentElements = this.indentArrayElementsPredicate.test(collection);
        if (indentElements) {
            output.write(this.newline);
            this.increaseIndentLevel();
        }
        while (true) {
            Object value = it.next();
            if (indentElements) {
                this.writeIndent(output);
            }
            this.writeValue(value, output);
            if (!it.hasNext()) break;
            output.write(VALUE_SEPARATOR);
            if (!indentElements) continue;
            output.write(this.newline);
        }
        if (indentElements) {
            output.write(this.newline);
        }
        if (indentElements) {
            this.decreaseIndentLevel();
            this.writeIndent(output);
        }
        output.write(']');
    }

    private void writeBoolean(boolean b, CharacterOutput output) {
        if (b) {
            output.write(TRUE_CHARS);
        } else {
            output.write(FALSE_CHARS);
        }
    }

    private void writeString(String s, CharacterOutput output) {
        if (this.canBeUnquoted(s)) {
            output.write(s);
            return;
        }
        output.write('\"');
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            int escapeIndex = Utils.arrayIndexOf((char[])TO_ESCAPE, (char)c);
            if (escapeIndex == -1) {
                output.write(c);
                continue;
            }
            char escaped = ESCAPED[escapeIndex];
            output.write('\\');
            output.write(escaped);
        }
        output.write('\"');
    }

    private boolean canBeUnquoted(CharSequence s) {
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            if (!Utils.arrayContains((char[])FORBIDDEN_IN_UNQUOTED, (char)s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void increaseIndentLevel() {
        ++this.currentIndentLevel;
    }

    private void decreaseIndentLevel() {
        --this.currentIndentLevel;
    }

    private void writeIndent(CharacterOutput output) {
        for (int i = 0; i < this.currentIndentLevel; ++i) {
            output.write(this.indent);
        }
    }

    public HoconWriter setIndentObjectElementsPredicate(Predicate<UnmodifiableConfig> indentObjectElementsPredicate) {
        this.indentObjectElementsPredicate = indentObjectElementsPredicate;
        return this;
    }

    public HoconWriter setIndentArrayElementsPredicate(Predicate<Collection<?>> indentArrayElementsPredicate) {
        this.indentArrayElementsPredicate = indentArrayElementsPredicate;
        return this;
    }

    public HoconWriter setNewlineAfterObjectStart(boolean newlineAfterObjectStart) {
        this.newlineAfterObjectStart = newlineAfterObjectStart;
        return this;
    }

    public HoconWriter setIndent(IndentStyle indentStyle) {
        this.indent = indentStyle.chars;
        return this;
    }

    public HoconWriter setIndent(String indentString) {
        this.indent = indentString.toCharArray();
        return this;
    }

    public HoconWriter setNewline(NewlineStyle newlineStyle) {
        this.newline = newlineStyle.chars;
        return this;
    }

    public HoconWriter setNewline(String newlineString) {
        this.newline = newlineString.toCharArray();
        return this;
    }

    public HoconWriter setKeyValueSeparator(KeyValueSeparatorStyle separatorStyle) {
        this.kvSeparator = separatorStyle.chars;
        return this;
    }

    public HoconWriter setKeyValueSeparator(String separatorString) {
        this.kvSeparator = separatorString.toCharArray();
        return this;
    }

    public HoconWriter setCommentPrefix(CommentStyle commentPrefixStyle) {
        this.commentPrefix = commentPrefixStyle.chars;
        return this;
    }

    public HoconWriter setCommentPrefix(String commentPrefixString) {
        this.commentPrefix = commentPrefixString.toCharArray();
        return this;
    }
}

