/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.services.slavesprovisioning.chain.steps;

import com.elasticbox.jenkins.k8s.plugin.clouds.KubernetesCloud;
import com.elasticbox.jenkins.k8s.repositories.PodRepository;
import com.elasticbox.jenkins.k8s.repositories.error.RepositoryException;
import com.elasticbox.jenkins.k8s.services.error.ServiceException;
import com.elasticbox.jenkins.k8s.services.slavesprovisioning.chain.AbstractPodDeployment;
import com.elasticbox.jenkins.k8s.services.slavesprovisioning.chain.PodDeploymentContext;
import com.elasticbox.jenkins.k8s.services.task.ScheduledPoolingTask;
import com.elasticbox.jenkins.k8s.services.task.TaskException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.fabric8.kubernetes.api.model.Pod;
import java.util.logging.Level;
import java.util.logging.Logger;

@Singleton
public class WaitForPodToBeRunning
extends AbstractPodDeployment {
    private static final Logger LOGGER = Logger.getLogger(WaitForPodToBeRunning.class.getName());
    @Inject
    private PodRepository podRepository;
    private static final long DELAY_IN_SECONDS = 1L;
    private static final long INITIAL_DELAY_IN_SECONDS = 1L;
    private static final long TIMEOUT_IN_SECONDS = 90L;
    private long initialDelay;
    private long delay;
    private long timeout;

    public WaitForPodToBeRunning() {
        this(1L, 1L, 90L);
    }

    public WaitForPodToBeRunning(long initialDelay, long delay, long timeout) {
        this.initialDelay = initialDelay;
        this.delay = delay;
        this.timeout = timeout;
    }

    @Override
    public void handle(PodDeploymentContext deploymentContext) throws ServiceException {
        String podName = deploymentContext.getPodToDeploy().getMetadata().getName();
        KubernetesCloud kubeCloud = deploymentContext.getCloudToDeployInto();
        try {
            new WaitForThePodToBeRunningTask(this.podRepository, kubeCloud.getName(), kubeCloud.getPredefinedNamespace(), podName, this.delay, this.initialDelay, this.timeout).execute();
            LOGGER.log(Level.INFO, "Pod is up and running");
        }
        catch (TaskException error) {
            LOGGER.severe("Error waiting for the Pod to be running: " + podName);
            throw new ServiceException("Error waiting for the Pod to be running", error);
        }
    }

    private static class WaitForThePodToBeRunningTask
    extends ScheduledPoolingTask<PodState> {
        private String kubeName;
        private String namespace;
        private String podName;
        private PodRepository podRepository;

        public WaitForThePodToBeRunningTask(PodRepository podRepository, String kubeName, String namespace, String podName, long delay, long initialDelay, long timeout) {
            super(delay, initialDelay, timeout);
            this.podRepository = podRepository;
            this.kubeName = kubeName;
            this.podName = podName;
            this.namespace = namespace;
            this.result = PodState.UNKNOWN;
        }

        @Override
        protected void performExecute() throws TaskException {
            try {
                Pod pod = this.podRepository.getPod(this.kubeName, this.namespace, this.podName);
                String phase = pod.getStatus().getPhase();
                PodState podStatus = PodState.findByDescription(phase);
                if (podStatus == PodState.FAILED) {
                    LOGGER.info("Pod is at the Failed stage");
                    throw new TaskException("Pod deployment failed");
                }
                this.result = podStatus;
                LOGGER.config("Pod: " + pod.getMetadata().getName() + " is at the " + ((PodState)((Object)this.result)).getStatus() + "stage");
            }
            catch (RepositoryException exception) {
                String message = "Error getting pod in cloud: " + this.kubeName + " in namespace: " + this.namespace + " and pod name : " + this.podName;
                LOGGER.log(Level.SEVERE, message, exception);
                throw new TaskException(message, exception);
            }
        }

        @Override
        public boolean isDone() {
            PodState result = (PodState)((Object)this.getResult());
            return result == PodState.RUNNING;
        }
    }

    public static enum PodState {
        PENDING("Pending"),
        RUNNING("Running"),
        SUCCEEDED("Succeeded"),
        FAILED("Failed"),
        UNKNOWN("Unknown");

        private String status;

        private PodState(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }

        public static PodState findByDescription(String status) {
            for (PodState state : PodState.values()) {
                if (!state.getStatus().equals(status)) continue;
                return state;
            }
            return UNKNOWN;
        }
    }
}

