/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.services.slavesprovisioning.chain.steps;

import com.elasticbox.jenkins.k8s.plugin.clouds.PodSlaveConfigurationParams;
import com.elasticbox.jenkins.k8s.services.error.ServiceException;
import com.elasticbox.jenkins.k8s.services.slavesprovisioning.chain.AbstractPodDeployment;
import com.elasticbox.jenkins.k8s.services.slavesprovisioning.chain.PodDeploymentContext;
import com.google.inject.Singleton;
import hudson.model.Label;
import java.util.logging.Logger;
import org.apache.commons.lang.ArrayUtils;

@Singleton
public class SelectSuitablePodConfiguration
extends AbstractPodDeployment {
    private static final Logger LOGGER = Logger.getLogger(SelectSuitablePodConfiguration.class.getName());

    @Override
    public void handle(PodDeploymentContext deploymentContext) throws ServiceException {
        Label jobLabel = deploymentContext.getJobLabel();
        if (jobLabel == null) {
            PodSlaveConfigurationParams podConfiguration = deploymentContext.getAvailablePodConfigurations().get(0);
            LOGGER.config("No label provided, returning first available pod configuration: " + podConfiguration);
            deploymentContext.setPodConfigurationChosen(podConfiguration);
            return;
        }
        for (PodSlaveConfigurationParams config : deploymentContext.getAvailablePodConfigurations()) {
            LOGGER.config("Looking for a slave configuration with label: " + jobLabel);
            Object[] labels = config.getLabels();
            if (!ArrayUtils.contains((Object[])labels, (Object)jobLabel.getName())) continue;
            deploymentContext.setPodConfigurationChosen(config);
            return;
        }
        LOGGER.config("There is no Pod slave configuration to handle this label: " + jobLabel.getName());
    }
}

