/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.services.slavesprovisioning.chain.steps;

import com.elasticbox.jenkins.k8s.plugin.clouds.KubernetesCloud;
import com.elasticbox.jenkins.k8s.repositories.PodRepository;
import com.elasticbox.jenkins.k8s.repositories.error.RepositoryException;
import com.elasticbox.jenkins.k8s.services.error.ServiceException;
import com.elasticbox.jenkins.k8s.services.slavesprovisioning.chain.AbstractPodDeployment;
import com.elasticbox.jenkins.k8s.services.slavesprovisioning.chain.PodDeploymentContext;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.fabric8.kubernetes.api.model.Pod;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@Singleton
public class PodDeployer
extends AbstractPodDeployment {
    private static final Logger LOGGER = Logger.getLogger(PodDeployer.class.getName());
    public static final Map<String, String> POD_SLAVE_KUBERNETES_LABEL = ImmutableMap.of((Object)"jenkins", (Object)"slave");
    @Inject
    private PodRepository podRepository;

    @Override
    public void handle(PodDeploymentContext deploymentContext) throws ServiceException {
        Pod podToDeploy = deploymentContext.getPodToDeploy();
        KubernetesCloud cloudToDeployInto = deploymentContext.getCloudToDeployInto();
        String deploymentNamespace = deploymentContext.getDeploymentNamespace();
        try {
            this.podRepository.create(cloudToDeployInto.getName(), deploymentNamespace, podToDeploy);
            String podName = podToDeploy.getMetadata().getName();
            LOGGER.log(Level.INFO, "Pod: " + podName + " created");
        }
        catch (RepositoryException exception) {
            String message = "Error getting the Kubernetes client for the cloud " + cloudToDeployInto.getName();
            LOGGER.log(Level.SEVERE, message);
            throw new ServiceException(message, exception);
        }
    }
}

