/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.services.slavesprovisioning.chain.steps;

import com.elasticbox.jenkins.k8s.plugin.clouds.KubernetesCloud;
import com.elasticbox.jenkins.k8s.plugin.clouds.PodSlaveConfigurationParams;
import com.elasticbox.jenkins.k8s.plugin.slaves.KubernetesSlave;
import com.elasticbox.jenkins.k8s.repositories.PodRepository;
import com.elasticbox.jenkins.k8s.repositories.error.RepositoryException;
import com.elasticbox.jenkins.k8s.services.error.ServiceException;
import com.elasticbox.jenkins.k8s.services.slavesprovisioning.chain.AbstractPodDeployment;
import com.elasticbox.jenkins.k8s.services.slavesprovisioning.chain.PodDeploymentContext;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import hudson.model.Label;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.Pod;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.JenkinsLocationConfiguration;

@Singleton
public class CreatePodFromPodConfiguration
extends AbstractPodDeployment {
    private static final Logger LOGGER = Logger.getLogger(CreatePodFromPodConfiguration.class.getName());
    public static final String ELASTICKUBE_COM_JENKINS_LABEL = "elastickube.com/jenkins-label";
    public static final String ELASTICKUBE_COM_JENKINS_SLAVE = "elastickube.com/jenkins-slave";
    @Inject
    private PodRepository podRepository;

    @Override
    public void handle(PodDeploymentContext deploymentContext) throws ServiceException {
        KubernetesCloud cloudToDeployInto = deploymentContext.getCloudToDeployInto();
        PodSlaveConfigurationParams podConfigurationChosen = deploymentContext.getPodConfigurationChosen();
        if (podConfigurationChosen == null) {
            throw new ServiceException("No pod configuration available to handle label: " + deploymentContext.getJobLabel());
        }
        try {
            Pod podToDeploy = this.podRepository.pod(cloudToDeployInto.getName(), cloudToDeployInto.getPredefinedNamespace(), podConfigurationChosen.getPodYaml());
            this.addName(podToDeploy, deploymentContext);
            this.addRestartPolicy(podToDeploy, deploymentContext);
            this.addLabels(podToDeploy, deploymentContext);
            this.addEnvironmentVariables(podToDeploy, deploymentContext);
            deploymentContext.setPodToDeploy(podToDeploy);
        }
        catch (RepositoryException exception) {
            LOGGER.log(Level.SEVERE, "Error creating Pod model object: " + podConfigurationChosen);
            throw new ServiceException("Error creating Pod model object", exception);
        }
    }

    public void addName(Pod podToDeploy, PodDeploymentContext deploymentContext) {
        String nodeName = deploymentContext.getKubernetesSlave().getNodeName();
        podToDeploy.getMetadata().setName(nodeName);
        LOGGER.info("Pod object model created from PodConfiguration with name: " + nodeName);
    }

    public void addRestartPolicy(Pod podToDeploy, PodDeploymentContext deploymentContext) {
        podToDeploy.getSpec().setRestartPolicy("Never");
    }

    public void addEnvironmentVariables(Pod podToDeploy, PodDeploymentContext deploymentContext) {
        KubernetesSlave kubernetesSlave = deploymentContext.getKubernetesSlave();
        for (Container container : podToDeploy.getSpec().getContainers()) {
            List currentEnv = container.getEnv();
            boolean found = false;
            for (EnvVar var : currentEnv) {
                if (!var.getName().equals("JENKINS_URL")) continue;
                found = true;
                break;
            }
            if (!found) {
                String url = JenkinsLocationConfiguration.get().getUrl();
                currentEnv.add(new EnvVar("JENKINS_URL", url, null));
            }
            container.setWorkingDir("/home/jenkins");
            container.getArgs().add(kubernetesSlave.getComputer().getJnlpMac());
            container.getArgs().add(kubernetesSlave.getComputer().getName());
            LOGGER.log(Level.INFO, "Added environment variables to container: " + container.getName());
        }
    }

    public void addLabels(Pod podToDeploy, PodDeploymentContext deploymentContext) {
        Map podLabels = podToDeploy.getMetadata().getLabels();
        Label jobLabel = deploymentContext.getJobLabel();
        if (jobLabel != null) {
            podLabels.put(ELASTICKUBE_COM_JENKINS_LABEL, jobLabel.getName());
            LOGGER.info("JobLabel [elastickube.com/jenkins-label = " + jobLabel.getName() + "] added to Pod ");
        }
        String podName = podToDeploy.getMetadata().getName();
        podLabels.put(ELASTICKUBE_COM_JENKINS_SLAVE, podName);
        LOGGER.info("Label [elastickube.com/jenkins-slave = " + podName + "] added to Pod ");
        podToDeploy.getMetadata().setLabels(podLabels);
    }
}

