/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.services.slavesprovisioning.chain.steps;

import com.elasticbox.jenkins.k8s.plugin.clouds.KubernetesCloud;
import com.elasticbox.jenkins.k8s.repositories.PodRepository;
import com.elasticbox.jenkins.k8s.repositories.error.RepositoryException;
import com.elasticbox.jenkins.k8s.services.error.ServiceException;
import com.elasticbox.jenkins.k8s.services.slavesprovisioning.chain.AbstractPodDeployment;
import com.elasticbox.jenkins.k8s.services.slavesprovisioning.chain.PodDeploymentContext;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.fabric8.kubernetes.api.model.Pod;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

@Singleton
public class CheckProvisioningAllowed
extends AbstractPodDeployment {
    private static final Logger LOGGER = Logger.getLogger(CheckProvisioningAllowed.class.getName());
    @Inject
    private PodRepository podRepository;

    @Override
    public void handle(PodDeploymentContext deploymentContext) throws ServiceException {
        KubernetesCloud cloudToDeployInto = deploymentContext.getCloudToDeployInto();
        int cloudCapacity = cloudToDeployInto.getInstanceCap();
        if (cloudCapacity == 0) {
            String message = "It is impossible to deploy a slave in a cloud which capacity is zero";
            LOGGER.log(Level.SEVERE, message);
            throw new RuntimeException(message);
        }
        String deploymentNamespace = StringUtils.isNotBlank((String)deploymentContext.getDeploymentNamespace()) ? deploymentContext.getDeploymentNamespace() : cloudToDeployInto.getPredefinedNamespace();
        try {
            List<Pod> pods = this.podRepository.getRunningPods(cloudToDeployInto.getName(), deploymentNamespace);
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Cloud defined max. capacity: " + cloudCapacity + ". Current capacity: " + pods.size());
            }
            if (pods.size() >= cloudCapacity) {
                String message = "Not provisioning, max cloud capacity: " + cloudCapacity + " reached";
                LOGGER.log(Level.SEVERE, message);
                throw new ServiceException(message);
            }
            LOGGER.log(Level.INFO, "Pod deployment granted, cloud capacity: " + pods.size());
        }
        catch (RepositoryException e) {
            LOGGER.log(Level.SEVERE, "Error getting the kubernetes client for the cloud " + cloudToDeployInto.getName());
            throw new ServiceException("Error getting the kubernetes client for the cloud " + cloudToDeployInto.getName());
        }
    }
}

