/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.repositories.api.charts.github;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public class GitHubUrl {
    private String baseUrl;
    private URI parsedUrl;

    public GitHubUrl(String url) {
        this.baseUrl = GitHubUrl.normalize(url);
        try {
            this.parsedUrl = new URI(this.baseUrl);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Malformed URL: " + url);
        }
    }

    private static String normalize(String url) {
        if (StringUtils.isBlank((String)url)) {
            return null;
        }
        if (url.contains("/tree/")) {
            url = url.replaceFirst("/tree/.*$", "");
        }
        if (!url.endsWith("/")) {
            url = url + '/';
        }
        return url;
    }

    public String protocol() {
        return this.parsedUrl.getScheme();
    }

    public String host() {
        return this.parsedUrl.getHost();
    }

    public int port() {
        return this.parsedUrl.getPort();
    }

    public String getHostAndPortTogether() {
        StringBuilder builder = new StringBuilder(this.parsedUrl.getScheme());
        builder.append("://");
        builder.append(this.parsedUrl.getHost());
        if (this.parsedUrl.getPort() > 0) {
            builder.append(":");
            builder.append(this.parsedUrl.getPort());
        }
        builder.append("/");
        return builder.toString();
    }

    public String ownerInCaseOfRepoUrl() {
        String[] split = this.parsedUrl.getPath().split("/");
        if (split.length >= 1) {
            return split[1];
        }
        return null;
    }

    public String repoInCaseOfRepoUrl() {
        String[] split = this.parsedUrl.getPath().split("/");
        if (split.length >= 2) {
            return split[2];
        }
        return null;
    }

    public String path() {
        String path = this.parsedUrl.getPath();
        if (path.charAt(path.length() - 1) == '/') {
            return path.substring(1, path.length() - 1);
        }
        return path.substring(1);
    }

    public String[] pathAsArray() {
        String[] split = this.parsedUrl.getPath().split("/");
        return Arrays.copyOfRange(split, 1, split.length - 1);
    }

    public String query() {
        String query = this.parsedUrl.getQuery();
        if (query != null && query.charAt(query.length() - 1) == '/') {
            return query.substring(0, query.length() - 1);
        }
        return query;
    }

    public String commitId(String id) {
        return this.baseUrl + "commit/" + id;
    }

    public String toString() {
        return this.baseUrl;
    }
}

