/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.repositories.api;

import com.elasticbox.jenkins.k8s.repositories.KubernetesRepository;
import com.elasticbox.jenkins.k8s.repositories.ServiceRepository;
import com.elasticbox.jenkins.k8s.repositories.error.RepositoryException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@Singleton
public class ServiceRepositoryApiImpl
implements ServiceRepository {
    private static final Logger LOGGER = Logger.getLogger(ServiceRepositoryApiImpl.class.getName());
    @Inject
    KubernetesRepository kubeRepository;

    @Override
    public void create(String kubeName, String namespace, Service service) throws RepositoryException {
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config("Creating Service: " + service.getMetadata().getName());
        }
        ((ClientNonNamespaceOperation)this.kubeRepository.getClient(kubeName).services().inNamespace(namespace)).create((Object[])new Service[]{service});
    }

    @Override
    public void create(String kubeName, String namespace, Service service, Map<String, String> labels) throws RepositoryException {
        if (labels != null) {
            Map currentLabels = service.getMetadata().getLabels();
            currentLabels.putAll(labels);
            service.getMetadata().setLabels(currentLabels);
        }
        this.create(kubeName, namespace, service);
    }

    @Override
    public void delete(String kubeName, String namespace, Service service) throws RepositoryException {
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config("Deleting Service: " + service.getMetadata().getName());
        }
        ((ClientNonNamespaceOperation)this.kubeRepository.getClient(kubeName).services().inNamespace(namespace)).delete((Object[])new Service[]{service});
    }
}

