/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.repositories.api;

import com.elasticbox.jenkins.k8s.repositories.KubernetesRepository;
import com.elasticbox.jenkins.k8s.repositories.PodRepository;
import com.elasticbox.jenkins.k8s.repositories.error.RepositoryException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientNonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

@Singleton
public class PodRepositoryApiImpl
implements PodRepository {
    private static final Logger LOGGER = Logger.getLogger(PodRepositoryApiImpl.class.getName());
    @Inject
    KubernetesRepository kubeRepository;

    @Override
    public void create(String kubeName, String namespace, Pod pod) throws RepositoryException {
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config("Creating Pod: " + pod.getMetadata().getName());
        }
        ((ClientNonNamespaceOperation)this.kubeRepository.getClient(kubeName).pods().inNamespace(namespace)).create((Object[])new Pod[]{pod});
    }

    @Override
    public void create(String kubeName, String namespace, Pod pod, Map<String, String> labels) throws RepositoryException {
        if (labels != null) {
            Map currentLabels = pod.getMetadata().getLabels();
            currentLabels.putAll(labels);
            pod.getMetadata().setLabels(currentLabels);
        }
        this.create(kubeName, namespace, pod);
    }

    @Override
    public void delete(String kubeName, String namespace, Pod pod) throws RepositoryException {
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config("Deleting Pod: " + pod.getMetadata().getName());
        }
        ((ClientNonNamespaceOperation)this.kubeRepository.getClient(kubeName).pods().inNamespace(namespace)).delete((Object[])new Pod[]{pod});
    }

    @Override
    public void delete(String kubeName, String namespace, String podName) throws RepositoryException {
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config("Deleting Pod: " + podName);
        }
        ((ClientPodResource)((ClientNonNamespaceOperation)this.kubeRepository.getClient(kubeName).pods().inNamespace(namespace)).withName(podName)).delete();
    }

    @Override
    public Pod pod(String kubeName, String namespace, String yaml) throws RepositoryException {
        try {
            Pod pod = (Pod)((ClientPodResource)((ClientNonNamespaceOperation)this.kubeRepository.getClient(kubeName).pods().inNamespace(namespace)).load((Object)IOUtils.toInputStream((String)yaml))).get();
            return pod;
        }
        catch (KubernetesClientException exception) {
            RepositoryException repoException = new RepositoryException("Error while parsing Yaml", exception);
            LOGGER.warning("Yaml definition not valid: " + repoException.getCausedByMessages());
            throw repoException;
        }
    }

    @Override
    public List<Pod> getAllPods(String kubeName, String namespace) throws RepositoryException {
        KubernetesClient client = this.kubeRepository.getClient(kubeName);
        PodList list = (PodList)((ClientNonNamespaceOperation)client.pods().inNamespace(namespace)).list();
        return list.getItems();
    }

    @Override
    public List<Pod> getRunningPods(String kubeName, String namespace) throws RepositoryException {
        KubernetesClient client = this.kubeRepository.getClient(kubeName);
        PodList list = (PodList)((FilterWatchListDeletable)((ClientNonNamespaceOperation)client.pods().inNamespace(namespace)).withField("status.phase", "Running")).list();
        return list.getItems();
    }

    @Override
    public Pod getPod(String kubeName, String namespace, String podName) throws RepositoryException {
        KubernetesClient client = this.kubeRepository.getClient(kubeName);
        Pod pod = (Pod)((ClientPodResource)((ClientNonNamespaceOperation)client.pods().inNamespace(namespace)).withName(podName)).get();
        return pod;
    }
}

