/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.repositories.api;

import com.elasticbox.jenkins.k8s.plugin.clouds.KubernetesCloudParams;
import com.elasticbox.jenkins.k8s.repositories.KubernetesRepository;
import com.elasticbox.jenkins.k8s.repositories.api.kubeclient.KubernetesClientFactory;
import com.elasticbox.jenkins.k8s.repositories.error.RepositoryException;
import com.elasticbox.jenkins.k8s.util.KeyValuePair;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.fabric8.kubernetes.api.model.EditableNamespace;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceBuilder;
import io.fabric8.kubernetes.api.model.NamespaceFluent;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.DefaultKubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Logger;

@Singleton
public class KubernetesRepositoryApiImpl
implements KubernetesRepository {
    private static final Logger LOGGER = Logger.getLogger(KubernetesRepositoryApiImpl.class.getName());
    @Inject
    KubernetesClientFactory kubeFactory;

    @Override
    public boolean testConnection(KubernetesCloudParams kubeCloudParams) throws RepositoryException {
        try {
            KubernetesClient kubeClient = this.kubeFactory.createKubernetesClient(kubeCloudParams);
            return this.getNamespacesInternal(kubeClient).size() > 0;
        }
        catch (KubernetesClientException excep) {
            throw new RepositoryException(excep);
        }
    }

    @Override
    public boolean testConnection(String kubernetesUri) throws RepositoryException {
        ConfigBuilder builder = (ConfigBuilder)((ConfigBuilder)new ConfigBuilder().withMasterUrl(kubernetesUri)).withTrustCerts(true);
        DefaultKubernetesClient kubeClient = new DefaultKubernetesClient((Config)builder.build());
        try {
            return this.getNamespacesInternal((KubernetesClient)kubeClient).size() > 0;
        }
        catch (KubernetesClientException exception) {
            throw new RepositoryException("Error checking Kubernetes cloud connection: ", exception);
        }
    }

    @Override
    public KubernetesClient getClient(String kubeName) throws RepositoryException {
        return kubeName != null ? this.kubeFactory.getKubernetesClient(kubeName) : new DefaultKubernetesClient();
    }

    @Override
    public boolean namespaceExists(String kubeName, String namespace) throws RepositoryException {
        return this.namespaceExistsInternal(this.getClient(kubeName), namespace);
    }

    private boolean namespaceExistsInternal(KubernetesClient kubeClient, String namespace) throws RepositoryException {
        Namespace existingNamespace = null;
        try {
            existingNamespace = (Namespace)((ClientResource)kubeClient.namespaces().withName(namespace)).get();
        }
        catch (KubernetesClientException kce) {
            throw new RepositoryException(kce);
        }
        return existingNamespace != null;
    }

    @Override
    public Namespace createNamespece(String kubeName, String namespace, KeyValuePair<String, String> ... labels) throws RepositoryException {
        EditableNamespace newNamespace = ((NamespaceBuilder)((NamespaceFluent.MetadataNested)new NamespaceBuilder().withNewMetadata().withName(namespace)).endMetadata()).build();
        if (labels.length > 0) {
            HashMap<String, String> labelsMap = new HashMap<String, String>();
            for (KeyValuePair<String, String> label : Arrays.asList(labels)) {
                labelsMap.put(label.getKey(), label.getValue());
            }
            newNamespace.getMetadata().setLabels(labelsMap);
        }
        return (Namespace)this.getClient(kubeName).namespaces().create((Object[])new Namespace[]{newNamespace});
    }

    @Override
    public List<String> getNamespaces(String kubeName) {
        try {
            return this.getNamespacesInternal(this.getClient(kubeName));
        }
        catch (RepositoryException excep) {
            LOGGER.severe("Unable to get client: " + excep.getMessage());
            return null;
        }
        catch (KubernetesClientException excep) {
            LOGGER.severe("Unable to get namespaces: " + new RepositoryException(excep).getInitialCause());
            return null;
        }
    }

    @Override
    public List<String> getNamespaces(KubernetesCloudParams kubeCloudParams) {
        try {
            KubernetesClient kubeClient = this.kubeFactory.createKubernetesClient(kubeCloudParams);
            return this.getNamespacesInternal(kubeClient);
        }
        catch (KubernetesClientException excep) {
            LOGGER.severe("Unable to get namespaces: " + new RepositoryException(excep).getInitialCause());
            return null;
        }
    }

    private List<String> getNamespacesInternal(KubernetesClient kubeClient) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (Namespace namespace : ((NamespaceList)kubeClient.namespaces().list()).getItems()) {
            returnList.add(namespace.getMetadata().getName());
        }
        return returnList;
    }
}

