/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.plugin.slaves;

import com.elasticbox.jenkins.k8s.plugin.clouds.KubernetesCloud;
import hudson.Extension;
import hudson.model.Label;
import hudson.slaves.Cloud;
import hudson.slaves.CloudProvisioningListener;
import hudson.slaves.NodeProvisioner;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

@Extension
public class KubernetesSlaveProvisioningStrategy
extends NodeProvisioner.Strategy {
    private static final Logger LOGGER = Logger.getLogger(KubernetesSlaveProvisioningStrategy.class.getName());
    private NodeProvisioner.StrategyState strategyState;

    public NodeProvisioner.StrategyDecision apply(@Nonnull NodeProvisioner.StrategyState state) {
        this.strategyState = state;
        int excessWorkload = state.getSnapshot().getQueueLength() - state.getSnapshot().getConnectingExecutors() - state.getPlannedCapacitySnapshot();
        return this.apply(state.getLabel(), excessWorkload);
    }

    NodeProvisioner.StrategyDecision apply(Label label, int excessWorkload) {
        LOGGER.fine("Applying provisioning for label: " + label + " with excessWorkload: " + excessWorkload);
        if (excessWorkload <= 0) {
            return NodeProvisioner.StrategyDecision.PROVISIONING_COMPLETED;
        }
        for (KubernetesCloud kubeCloud : KubernetesCloud.getKubernetesClouds()) {
            if (!kubeCloud.canProvision(label)) continue;
            LOGGER.fine("Checking 'canProvision' listeners for cloud: " + (Object)((Object)kubeCloud));
            for (CloudProvisioningListener listener : CloudProvisioningListener.all()) {
                if (listener.canProvision((Cloud)kubeCloud, label, excessWorkload) == null) continue;
                return excessWorkload > 1 ? NodeProvisioner.StrategyDecision.CONSULT_REMAINING_STRATEGIES : NodeProvisioner.StrategyDecision.PROVISIONING_COMPLETED;
            }
            Collection<NodeProvisioner.PlannedNode> nodes = kubeCloud.provision(label, excessWorkload);
            LOGGER.fine("Calling 'onStarted' listeners with: " + nodes);
            for (CloudProvisioningListener listener : CloudProvisioningListener.all()) {
                listener.onStarted((Cloud)kubeCloud, label, nodes);
            }
            for (NodeProvisioner.PlannedNode node : nodes) {
                LOGGER.log(Level.INFO, "Started provisioning \"{0}\" from \"{1}\". Remaining excess workload: {2}", new Object[]{node.displayName, kubeCloud.getDisplayName(), excessWorkload -= node.numExecutors});
            }
            if (this.strategyState != null) {
                this.strategyState.recordPendingLaunches(nodes);
            }
            if (excessWorkload > 0) continue;
            return NodeProvisioner.StrategyDecision.PROVISIONING_COMPLETED;
        }
        LOGGER.fine("Provisioning not complete, checking remaining strategies for excess workload: " + excessWorkload);
        return NodeProvisioner.StrategyDecision.CONSULT_REMAINING_STRATEGIES;
    }
}

