/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.plugin.clouds;

import com.elasticbox.jenkins.k8s.plugin.clouds.PodSlaveConfigurationParams;
import com.elasticbox.jenkins.k8s.repositories.PodRepository;
import com.elasticbox.jenkins.k8s.repositories.error.RepositoryException;
import com.elasticbox.jenkins.k8s.util.PluginHelper;
import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.fabric8.kubernetes.api.model.Pod;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class PodSlaveConfig
implements Describable<PodSlaveConfig> {
    private static final Logger LOGGER = Logger.getLogger(PodSlaveConfig.class.getName());
    private final String id;
    private final PodSlaveConfigurationParams podSlaveConfigurationParams;

    @DataBoundConstructor
    public PodSlaveConfig(String id, String description, String podYaml, String labels) {
        this.id = id;
        this.podSlaveConfigurationParams = new PodSlaveConfigurationParams(description, podYaml, labels);
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.podSlaveConfigurationParams.getDescription();
    }

    public String getPodYaml() {
        return this.podSlaveConfigurationParams.getPodYaml();
    }

    public PodSlaveConfigurationParams getPodSlaveConfigurationParams() {
        return this.podSlaveConfigurationParams;
    }

    public String getLabels() {
        return this.podSlaveConfigurationParams.getLabelsAsString();
    }

    public Descriptor<PodSlaveConfig> getDescriptor() {
        Jenkins instance = Jenkins.getInstance();
        return instance != null ? instance.getDescriptor(this.getClass()) : null;
    }

    public String toString() {
        return this.podSlaveConfigurationParams.toString();
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<PodSlaveConfig> {
        private static final String POD_SLAVE_CONFIGURATION = "Pod Slave Configuration";
        @Inject
        transient PodRepository podRepository;

        public String getDisplayName() {
            return POD_SLAVE_CONFIGURATION;
        }

        public FormValidation doTestYaml(@QueryParameter String podYaml) {
            if (PluginHelper.anyOfThemIsBlank(podYaml)) {
                return FormValidation.error((String)"Required fields not provided");
            }
            try {
                Pod pod = this.podRepository.pod(null, null, podYaml);
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Pod: " + pod);
                }
                return FormValidation.ok((String)"Validation successful");
            }
            catch (RepositoryException exception) {
                return FormValidation.error((String)("Validation error - " + exception.getCausedByMessages()));
            }
        }

        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String endpointUrl) {
            return PluginHelper.doFillCredentialsIdItems(endpointUrl);
        }
    }
}

