/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.plugin.clouds;

import com.elasticbox.jenkins.k8s.auth.Authentication;
import com.elasticbox.jenkins.k8s.plugin.clouds.ChartRepositoryConfig;
import com.elasticbox.jenkins.k8s.plugin.clouds.KubernetesCloudParams;
import com.elasticbox.jenkins.k8s.plugin.clouds.PodSlaveConfig;
import com.elasticbox.jenkins.k8s.plugin.clouds.PodSlaveConfigurationParams;
import com.elasticbox.jenkins.k8s.plugin.slaves.KubernetesSlave;
import com.elasticbox.jenkins.k8s.repositories.KubernetesRepository;
import com.elasticbox.jenkins.k8s.repositories.api.kubeclient.KubernetesClientFactory;
import com.elasticbox.jenkins.k8s.repositories.error.RepositoryException;
import com.elasticbox.jenkins.k8s.services.SlaveProvisioningService;
import com.elasticbox.jenkins.k8s.services.error.ServiceException;
import com.elasticbox.jenkins.k8s.util.PluginHelper;
import com.google.inject.Inject;
import com.google.inject.Injector;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Label;
import hudson.model.Node;
import hudson.slaves.AbstractCloudImpl;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLHandshakeException;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class KubernetesCloud
extends AbstractCloudImpl {
    private static final Logger LOGGER = Logger.getLogger(KubernetesCloud.class.getName());
    public static final String NAME_PREFIX = "KubeCloud-";
    private final String displayName;
    private final String credentialsId;
    private final KubernetesCloudParams kubeCloudParams;
    private final List<ChartRepositoryConfig> chartRepositoryConfigurations;
    private final List<PodSlaveConfig> podSlaveConfigurations;
    @Inject
    transient KubernetesClientFactory kubeFactory;
    @Inject
    transient SlaveProvisioningService slaveProvisioningService;

    @DataBoundConstructor
    public KubernetesCloud(String name, String displayName, String endpointUrl, String predefinedNamespace, String maxContainers, String credentialsId, String serverCert, List<ChartRepositoryConfig> chartRepositoryConfigurations, List<PodSlaveConfig> podSlaveConfigurations) {
        super(StringUtils.isNotEmpty((String)name) ? name : NAME_PREFIX + UUID.randomUUID().toString(), maxContainers);
        this.displayName = displayName;
        this.credentialsId = credentialsId;
        this.kubeCloudParams = new KubernetesCloudParams(endpointUrl, predefinedNamespace, PluginHelper.getAuthenticationData(credentialsId), serverCert);
        this.chartRepositoryConfigurations = chartRepositoryConfigurations;
        this.podSlaveConfigurations = podSlaveConfigurations;
        this.injectMembers();
        if (StringUtils.isNotEmpty((String)name)) {
            this.kubeFactory.resetKubernetesClient(name);
        }
    }

    public static List<KubernetesCloud> getKubernetesClouds() {
        ArrayList<KubernetesCloud> clouds = new ArrayList<KubernetesCloud>();
        Jenkins instance = Jenkins.getInstance();
        if (instance != null) {
            for (Cloud cloud : instance.clouds) {
                if (!(cloud instanceof KubernetesCloud)) continue;
                clouds.add((KubernetesCloud)cloud);
            }
        }
        return clouds;
    }

    public static KubernetesCloud getKubernetesCloud(String kubeName) {
        Jenkins instance = Jenkins.getInstance();
        if (instance == null) {
            return null;
        }
        Cloud cloud = instance.getCloud(kubeName);
        return cloud != null && cloud instanceof KubernetesCloud ? (KubernetesCloud)cloud : null;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getPredefinedNamespace() {
        return this.kubeCloudParams.getNamespace();
    }

    public String getEndpointUrl() {
        return this.kubeCloudParams.getEndpointUrl();
    }

    public String getMaxContainers() {
        return super.getInstanceCapStr();
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public List<ChartRepositoryConfig> getChartRepositoryConfigurations() {
        return this.chartRepositoryConfigurations;
    }

    public List<PodSlaveConfig> getPodSlaveConfigurations() {
        return this.podSlaveConfigurations;
    }

    public ChartRepositoryConfig getChartRepositoryConfiguration(String chartsRepo) {
        for (ChartRepositoryConfig config : this.getChartRepositoryConfigurations()) {
            if (!config.getDescription().equals(chartsRepo)) continue;
            return config;
        }
        return null;
    }

    public Collection<NodeProvisioner.PlannedNode> provision(final Label label, int excessWorkload) {
        LOGGER.info("Slave provisioning requested for label '" + label + "', excess workload: " + excessWorkload);
        final ArrayList<PodSlaveConfigurationParams> podSlaveConfigurationParams = new ArrayList<PodSlaveConfigurationParams>();
        for (PodSlaveConfig config : this.podSlaveConfigurations) {
            podSlaveConfigurationParams.add(config.getPodSlaveConfigurationParams());
        }
        ArrayList<NodeProvisioner.PlannedNode> plannedSlavesToDeploy = new ArrayList<NodeProvisioner.PlannedNode>();
        for (int i = 1; i <= excessWorkload; ++i) {
            plannedSlavesToDeploy.add(new NodeProvisioner.PlannedNode("Jenkins Kubernetes Slave", Computer.threadPoolForRemoting.submit(new Callable<Node>(){

                @Override
                public Node call() throws Exception {
                    KubernetesSlave slave = KubernetesCloud.this.slaveProvisioningService.slaveProvision(KubernetesCloud.this, podSlaveConfigurationParams, label);
                    return slave;
                }
            }), 1));
        }
        return plannedSlavesToDeploy;
    }

    public boolean canProvision(Label label) {
        LOGGER.info("Checking label: " + label);
        ArrayList<PodSlaveConfigurationParams> podSlaveConfigurationParams = new ArrayList<PodSlaveConfigurationParams>();
        for (PodSlaveConfig config : this.podSlaveConfigurations) {
            podSlaveConfigurationParams.add(config.getPodSlaveConfigurationParams());
        }
        try {
            FormValidation testConnection = ((DescriptorImpl)this.getDescriptor()).doTestConnection(this.getEndpointUrl(), this.getPredefinedNamespace(), this.getCredentialsId(), null);
            if (testConnection.kind == FormValidation.Kind.ERROR) {
                LOGGER.warning("Unable to connect to: " + (Object)((Object)this) + testConnection.getMessage());
                return false;
            }
            return this.slaveProvisioningService.canProvision(this, podSlaveConfigurationParams, label);
        }
        catch (ServiceException exception) {
            LOGGER.info("Error while checking if provision is allowed");
            return false;
        }
    }

    public KubernetesCloudParams getKubernetesCloudParams() {
        return this.kubeCloudParams;
    }

    public String toString() {
        return "KubernetesCloud [" + this.getDisplayName() + "@" + this.kubeCloudParams.getEndpointUrl() + "]";
    }

    protected Object readResolve() {
        this.injectMembers();
        return this;
    }

    private void injectMembers() {
        if (this.kubeFactory == null) {
            ((DescriptorImpl)this.getDescriptor()).injector.injectMembers((Object)this);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        private static final String KUBERNETES_CLOUD = "Kubernetes cloud";
        @Inject
        private Injector injector;
        @Inject
        KubernetesRepository kubeRepository;

        public String getDisplayName() {
            return KUBERNETES_CLOUD;
        }

        public Injector getInjector() {
            return this.injector;
        }

        public ListBoxModel doFillPredefinedNamespaceItems(@QueryParameter String endpointUrl, @QueryParameter String credentialsId, @QueryParameter String serverCert) {
            if (StringUtils.isEmpty((String)endpointUrl)) {
                return PluginHelper.doFillNamespaceItems(null);
            }
            Authentication authData = PluginHelper.getAuthenticationData(credentialsId);
            KubernetesCloudParams kubeCloudParams = new KubernetesCloudParams(endpointUrl, null, authData, serverCert);
            return PluginHelper.doFillNamespaceItems(this.kubeRepository.getNamespaces(kubeCloudParams));
        }

        public FormValidation doTestConnection(@QueryParameter String endpointUrl, @QueryParameter String namespace, @QueryParameter String credentialsId, @QueryParameter String serverCert) {
            if (StringUtils.isEmpty((String)endpointUrl)) {
                return FormValidation.error((String)"Required fields not provided");
            }
            Authentication authData = PluginHelper.getAuthenticationData(credentialsId);
            KubernetesCloudParams kubeCloudParams = new KubernetesCloudParams(endpointUrl, namespace, authData, serverCert);
            kubeCloudParams.setDisableCertCheck(false);
            try {
                if (this.kubeRepository.testConnection(kubeCloudParams)) {
                    if (LOGGER.isLoggable(Level.CONFIG)) {
                        LOGGER.config("Connection successful to Kubernetes Cloud at: " + endpointUrl);
                    }
                    return FormValidation.ok((String)"Connection successful");
                }
                LOGGER.severe("Unable to connect to Kubernetes clouds at: " + endpointUrl);
                return FormValidation.error((String)"Connection error");
            }
            catch (RepositoryException excep) {
                String msg = "Connection error - " + excep.getCausedByMessages();
                if (excep.getCause() != null && excep.getCause().getCause() instanceof SSLHandshakeException) {
                    kubeCloudParams.setDisableCertCheck(true);
                    try {
                        if (this.kubeRepository.testConnection(kubeCloudParams)) {
                            if (LOGGER.isLoggable(Level.CONFIG)) {
                                LOGGER.config("Connection successful disabling Cert check to Kubernetes Cloud at: " + endpointUrl);
                            }
                            return FormValidation.warning((String)"Warning: Connection successful but the server certificate is not trusted");
                        }
                    }
                    catch (RepositoryException exception) {
                        msg = "Connection error - " + exception.getCausedByMessages();
                    }
                }
                LOGGER.severe(msg);
                return FormValidation.error((String)msg);
            }
        }

        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String endpointUrl) {
            return PluginHelper.doFillCredentialsIdItems(endpointUrl);
        }

        public FormValidation doCheckEndpointUrl(@QueryParameter String endpointUrl) {
            if (StringUtils.isBlank((String)endpointUrl)) {
                return FormValidation.error((String)"Endpoint Url is required");
            }
            return FormValidation.ok();
        }
    }
}

