/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.plugin.clouds;

import com.elasticbox.jenkins.k8s.chart.ChartRepo;
import com.elasticbox.jenkins.k8s.repositories.ChartRepository;
import com.elasticbox.jenkins.k8s.repositories.error.RepositoryException;
import com.elasticbox.jenkins.k8s.util.PluginHelper;
import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class ChartRepositoryConfig
implements Describable<ChartRepositoryConfig> {
    private static final Logger LOGGER = Logger.getLogger(ChartRepositoryConfig.class.getName());
    private final String description;
    private final String chartsRepoUrl;
    private final String credentialsId;

    @DataBoundConstructor
    public ChartRepositoryConfig(String description, String chartsRepoUrl, String credentialsId) {
        this.description = description;
        this.chartsRepoUrl = chartsRepoUrl;
        this.credentialsId = credentialsId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getChartsRepoUrl() {
        return this.chartsRepoUrl;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    public Descriptor<ChartRepositoryConfig> getDescriptor() {
        Jenkins instance = Jenkins.getInstance();
        return instance != null ? instance.getDescriptor(this.getClass()) : null;
    }

    public String toString() {
        return "ChartRepositoryConfig [" + this.getDescription() + "@" + this.getChartsRepoUrl() + "]";
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<ChartRepositoryConfig> {
        private static final String CHART_REPOSITORY_CONFIGURATION = "Chart Repository Configuration";
        @Inject
        private transient ChartRepository chartRepository;

        public String getDisplayName() {
            return CHART_REPOSITORY_CONFIGURATION;
        }

        public FormValidation doTestConnection(@QueryParameter String chartsRepoUrl, @QueryParameter String credentialsId) {
            if (StringUtils.isEmpty((String)chartsRepoUrl)) {
                return FormValidation.error((String)"Required fields not provided");
            }
            ChartRepo chartRepoData = PluginHelper.getChartRepoData(chartsRepoUrl, credentialsId);
            try {
                List<String> chartNames = this.chartRepository.chartNames(chartRepoData);
                if (chartNames != null && !chartNames.isEmpty()) {
                    return FormValidation.ok((String)"Connection successful");
                }
                return FormValidation.error((String)"Invalid repository");
            }
            catch (RepositoryException excep) {
                String msg = "Connection error - " + excep.getCausedByMessages();
                LOGGER.severe(msg);
                return FormValidation.error((String)msg);
            }
        }

        public ListBoxModel doFillCredentialsIdItems(@QueryParameter String endpointUrl) {
            return PluginHelper.doFillCredentialsIdItems(endpointUrl);
        }
    }
}

