/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.plugin.builders;

import com.elasticbox.jenkins.k8s.chart.ChartRepo;
import com.elasticbox.jenkins.k8s.plugin.builders.ChartBuildStepDescriptor;
import com.elasticbox.jenkins.k8s.plugin.clouds.ChartRepositoryConfig;
import com.elasticbox.jenkins.k8s.plugin.clouds.KubernetesCloud;
import com.elasticbox.jenkins.k8s.services.ChartDeploymentService;
import com.elasticbox.jenkins.k8s.services.error.ServiceException;
import com.elasticbox.jenkins.k8s.util.PluginHelper;
import com.elasticbox.jenkins.k8s.util.TaskLogger;
import com.google.inject.Inject;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.Builder;
import java.io.IOException;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import jenkins.tasks.SimpleBuildStep;

public abstract class BaseChartBuildStep
extends Builder
implements SimpleBuildStep {
    private static final Logger LOGGER = Logger.getLogger(BaseChartBuildStep.class.getName());
    protected String id;
    protected String kubeName;
    protected String namespace;
    protected String chartsRepo;
    protected String chartName;
    @Inject
    transient ChartDeploymentService deploymentService;

    protected Object readResolve() {
        this.injectMembers();
        return this;
    }

    protected void injectMembers() {
        ((ChartBuildStepDescriptor)this.getDescriptor()).getInjector().injectMembers((Object)this);
    }

    public String getId() {
        return this.id;
    }

    public String getKubeName() {
        return this.kubeName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getChartsRepo() {
        return this.chartsRepo;
    }

    public String getChartName() {
        return this.chartName;
    }

    public void perform(@Nonnull Run<?, ?> run, @Nonnull FilePath filePath, @Nonnull Launcher launcher, @Nonnull TaskListener taskListener) throws InterruptedException, IOException {
        TaskLogger taskLogger = new TaskLogger(taskListener, LOGGER);
        taskLogger.info("Executing Chart build step: " + run);
        try {
            KubernetesCloud kubeCloud = KubernetesCloud.getKubernetesCloud(this.getKubeName());
            taskLogger.info("Using Kubernetes clouds config: " + (Object)((Object)kubeCloud));
            ChartRepositoryConfig config = kubeCloud.getChartRepositoryConfiguration(this.getChartsRepo());
            taskLogger.info("Using Chart repository config: " + config);
            ChartRepo chartRepo = PluginHelper.getChartRepoData(config.getChartsRepoUrl(), config.getCredentialsId());
            this.doPerform(run, taskLogger, chartRepo);
        }
        catch (ServiceException exception) {
            taskLogger.error(exception.getCausedByMessages());
            throw new IOException(exception);
        }
        catch (NullPointerException exception) {
            String message = "Cannot initialize resources: " + exception.getMessage();
            taskLogger.error(message);
            throw new IOException(message, exception);
        }
    }

    protected abstract void doPerform(Run<?, ?> var1, TaskLogger var2, ChartRepo var3) throws ServiceException;
}

