/*
 * Decompiled with CFR 0.152.
 */
package com.elasticbox.jenkins.k8s.cfg;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.elasticbox.jenkins.k8s.plugin.auth.TokenCredentialsImpl;
import com.elasticbox.jenkins.k8s.plugin.clouds.ChartRepositoryConfig;
import com.elasticbox.jenkins.k8s.plugin.clouds.KubernetesCloud;
import com.elasticbox.jenkins.k8s.plugin.clouds.PodSlaveConfig;
import com.elasticbox.jenkins.k8s.repositories.KubernetesRepository;
import com.elasticbox.jenkins.k8s.repositories.api.KubernetesRepositoryApiImpl;
import com.elasticbox.jenkins.k8s.repositories.error.RepositoryException;
import com.elasticbox.jenkins.k8s.util.PluginHelper;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.util.Secret;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.io.IOUtils;

public class PluginInitializer {
    private static final Logger LOGGER = Logger.getLogger(PluginInitializer.class.getName());
    private static final String MAX_SLAVES = "30";
    private static final String DEFAULT_HELM_CHART_REPO = "Default Helm charts repository";
    private static final String DEFAULT_HELM_CHART_REPO_URL = "https://github.com/helm/charts";
    public static final String LOCAL_CLOUD_NAME = "KubeCloud-Local";
    public static final String KUBERNETES_API_SERVER_ADDR = "KUBERNETES_PORT_443_TCP_ADDR";
    public static final String KUBERNETES_API_SERVER_PORT = "KUBERNETES_PORT_443_TCP_PORT";
    public static final String JENKINS_SERVICE_HOST = "JENKINS_SERVICE_HOST";
    public static final String JENKINS_SERVICE_PORT = "JENKINS_SERVICE_PORT";
    private static final String DEFAULT_JENKINS_SLAVE_POD_YAML = "default-jenkins-slave-pod.yaml";
    private static final String KUBE_SERVICE_TOKEN_ID = "KubeServiceToken";
    static String KUBE_TOKEN_PATH = "/run/secrets/kubernetes.io/serviceaccount/token";
    static KubernetesRepository kubeRepository = new KubernetesRepositoryApiImpl();

    @Initializer(after=InitMilestone.JOB_LOADED)
    public static void checkLocalKubernetesCloud() {
        LOGGER.info("KubeCloud-Checking if running inside a Kubernetes Cloud (Auto-discovery)...");
        String kubernetesAddr = System.getenv(KUBERNETES_API_SERVER_ADDR);
        String kubernetesAddrPort = System.getenv(KUBERNETES_API_SERVER_PORT);
        if (PluginHelper.anyOfThemIsBlank(kubernetesAddr, kubernetesAddrPort)) {
            LOGGER.info("KubeCloud-Not running inside a Kubernetes Cloud.");
            return;
        }
        String kubernetesUri = "https://" + kubernetesAddr + ":" + kubernetesAddrPort;
        LOGGER.info("KubeCloud-Kubernetes Cloud found! Checking if local Kubernetes cloud is configured at: " + kubernetesUri);
        Jenkins jenkins = Jenkins.getInstance();
        if (jenkins == null) {
            return;
        }
        if (jenkins.getCloud(LOCAL_CLOUD_NAME) != null) {
            LOGGER.info("KubeCloud-Local Kubernetes Cloud already configured.");
            return;
        }
        try {
            if (!kubeRepository.testConnection(kubernetesUri)) {
                LOGGER.warning("KubeCloud-No valid Local Kubernetes Cloud connection obtained.");
                return;
            }
            ChartRepositoryConfig chartRepositoryConfig = new ChartRepositoryConfig(DEFAULT_HELM_CHART_REPO, DEFAULT_HELM_CHART_REPO_URL, "");
            PodSlaveConfig defaultPodSlaveConfig = PluginInitializer.getDefaultPodSlaveConfig();
            String credentialsId = PluginInitializer.checkLocalKubernetesToken();
            KubernetesCloud cloud = new KubernetesCloud(LOCAL_CLOUD_NAME, LOCAL_CLOUD_NAME, kubernetesUri, "default", MAX_SLAVES, credentialsId, "", Collections.singletonList(chartRepositoryConfig), defaultPodSlaveConfig != null ? Collections.singletonList(defaultPodSlaveConfig) : Collections.EMPTY_LIST);
            LOGGER.info("KubeCloud-Adding local Kubernetes Cloud configuration: " + (Object)((Object)cloud));
            jenkins.clouds.add((Object)cloud);
            jenkins.setNumExecutors(0);
        }
        catch (RepositoryException exception) {
            LOGGER.log(Level.SEVERE, "KubeCloud-" + exception.getCausedByMessages(), exception);
        }
        catch (IOException excep) {
            LOGGER.log(Level.SEVERE, "KubeCloud-Error setting number of executors in master to 0.", excep);
        }
    }

    private static String checkLocalKubernetesToken() {
        File file = new File(KUBE_TOKEN_PATH);
        if (file.exists() && file.canRead()) {
            try {
                String token = IOUtils.toString((URI)file.toURI());
                TokenCredentialsImpl kubeServiceToken = new TokenCredentialsImpl(CredentialsScope.SYSTEM, KUBE_SERVICE_TOKEN_ID, "Local Kubernetes service token", Secret.fromString((String)token));
                SystemCredentialsProvider.getInstance().getCredentials().add(kubeServiceToken);
                SystemCredentialsProvider.getInstance().save();
                return KUBE_SERVICE_TOKEN_ID;
            }
            catch (IOException excep) {
                LOGGER.warning("Unable to read Kubernetes service token file: " + excep);
            }
        }
        return "";
    }

    private static PodSlaveConfig getDefaultPodSlaveConfig() {
        String yamlString;
        InputStream yamlStream = PodSlaveConfig.class.getResourceAsStream("PodSlaveConfig/default-jenkins-slave-pod.yaml");
        try {
            yamlString = IOUtils.toString((InputStream)yamlStream);
        }
        catch (IOException exception) {
            LOGGER.severe("KubeCloud-" + exception);
            return null;
        }
        String jenkinsServiceHost = System.getenv(JENKINS_SERVICE_HOST);
        String jenkinsServicePort = System.getenv(JENKINS_SERVICE_PORT);
        if (jenkinsServiceHost != null && jenkinsServicePort != null) {
            yamlString = yamlString.replace("${JENKINS_URL}", "http://" + jenkinsServiceHost + ':' + jenkinsServicePort);
        }
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config("Default Pod Yaml definition: " + yamlString);
        }
        PodSlaveConfig podSlaveConfig = new PodSlaveConfig(DEFAULT_JENKINS_SLAVE_POD_YAML, "Default JenkinsSlave Pod", yamlString, null);
        return podSlaveConfig;
    }
}

