/*
 * Decompiled with CFR 0.152.
 */
package com.effective.android.panel.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import com.effective.android.panel.log.LogTracker;
import com.effective.android.panel.utils.DisplayUtil;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tH\u0007J\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\rJ\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u0004H\u0007J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0004H\u0007J\u0018\u0010\u0015\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/effective/android/panel/utils/PanelUtil;", "", "()V", "lHeight", "", "pHeight", "clearData", "", "context", "Landroid/content/Context;", "getKeyBoardHeight", "hasMeasuredKeyboard", "", "hasMeasuredKeyboard$panel_release", "hideKeyboard", "view", "Landroid/view/View;", "isPanelHeightBelowKeyboardHeight", "curPanelHeight", "setKeyBoardHeight", "height", "showKeyboard", "panel_release"})
public final class PanelUtil {
    private static int pHeight;
    private static int lHeight;
    public static final PanelUtil INSTANCE;

    @JvmStatic
    public static final void clearData(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        pHeight = -1;
        lHeight = -1;
        SharedPreferences sp = context.getSharedPreferences("ky_panel_name", 0);
        sp.edit().clear().apply();
    }

    @JvmStatic
    public static final boolean showKeyboard(@NotNull Context context, @NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        view.requestFocus();
        Object object = context.getSystemService("input_method");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager mInputManager = (InputMethodManager)object;
        return mInputManager.showSoftInput(view, 0);
    }

    @JvmStatic
    public static final boolean hideKeyboard(@NotNull Context context, @NotNull View view) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
        Object object = context.getSystemService("input_method");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.view.inputmethod.InputMethodManager");
        }
        InputMethodManager mInputManager = (InputMethodManager)object;
        return mInputManager.hideSoftInputFromWindow(view.getWindowToken(), 0);
    }

    @JvmStatic
    public static final int getKeyBoardHeight(@NotNull Context context) {
        int defaultHeight;
        String key;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        boolean isPortrait = DisplayUtil.isPortrait(context);
        if (isPortrait && pHeight != -1) {
            return pHeight;
        }
        if (!isPortrait && lHeight != -1) {
            return lHeight;
        }
        SharedPreferences sp = context.getSharedPreferences("ky_panel_name", 0);
        int result = sp.getInt(key = isPortrait ? "keyboard_height_for_p" : "keyboard_height_for_l", defaultHeight = DisplayUtil.dip2px(context, isPortrait ? 290.0f : 198.0f));
        if (result != defaultHeight) {
            if (isPortrait) {
                pHeight = result;
            } else {
                lHeight = result;
            }
        }
        return result;
    }

    @JvmStatic
    public static final boolean isPanelHeightBelowKeyboardHeight(@NotNull Context context, int curPanelHeight) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return INSTANCE.hasMeasuredKeyboard$panel_release(context) && PanelUtil.getKeyBoardHeight(context) > curPanelHeight;
    }

    @JvmStatic
    public static final boolean setKeyBoardHeight(@NotNull Context context, int height) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (PanelUtil.getKeyBoardHeight(context) == height) {
            LogTracker.log("PanelUtil#onGlobalLayout", "current KeyBoardHeight is equal\uff0cjust ignore\uff01");
            return false;
        }
        boolean isPortrait = DisplayUtil.isPortrait(context);
        if (isPortrait && pHeight == height) {
            LogTracker.log("PanelUtil#onGlobalLayout", "current KeyBoardHeight is equal\uff0cjust ignore\uff01");
            return false;
        }
        if (!isPortrait && lHeight == height) {
            LogTracker.log("PanelUtil#onGlobalLayout", "current KeyBoardHeight is equal\uff0cjust ignore\uff01");
            return false;
        }
        SharedPreferences sp = context.getSharedPreferences("ky_panel_name", 0);
        String key = isPortrait ? "keyboard_height_for_p" : "keyboard_height_for_l";
        boolean result = sp.edit().putInt(key, height).commit();
        if (result) {
            if (isPortrait) {
                pHeight = height;
            } else {
                lHeight = height;
            }
        }
        return result;
    }

    public final boolean hasMeasuredKeyboard$panel_release(@NotNull Context context) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        PanelUtil.getKeyBoardHeight(context);
        return pHeight != -1 || lHeight != -1;
    }

    private PanelUtil() {
    }

    static {
        PanelUtil panelUtil;
        INSTANCE = panelUtil = new PanelUtil();
        pHeight = -1;
        lHeight = -1;
    }
}

