/*
 * Decompiled with CFR 0.152.
 */
package com.effective.android.panel.view.content;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.EditText;
import androidx.annotation.IdRes;
import com.effective.android.panel.interfaces.ContentScrollMeasurer;
import com.effective.android.panel.interfaces.ViewAssertion;
import com.effective.android.panel.log.LogTracker;
import com.effective.android.panel.utils.PanelUtil;
import com.effective.android.panel.view.PanelSwitchLayout;
import com.effective.android.panel.view.content.IContentContainer;
import com.effective.android.panel.view.content.IInputAction;
import com.effective.android.panel.view.content.IResetAction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u00010B)\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\b\u0012\b\b\u0001\u0010\t\u001a\u00020\b\u00a2\u0006\u0002\u0010\nJ\b\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\bH\u0016J\u0012\u0010!\u001a\u0004\u0018\u00010\u00162\u0006\u0010\"\u001a\u00020\bH\u0016J\b\u0010#\u001a\u00020\u0011H\u0016J\b\u0010$\u001a\u00020\u0014H\u0016JN\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\b2\u0006\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020,0+2\u0006\u0010-\u001a\u00020\b2\u0006\u0010.\u001a\u00020\u00062\u0006\u0010/\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0017\u001a\u001e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00190\u0018j\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0019`\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/effective/android/panel/view/content/ContentContainerImpl;", "Lcom/effective/android/panel/view/content/IContentContainer;", "Lcom/effective/android/panel/interfaces/ViewAssertion;", "mViewGroup", "Landroid/view/ViewGroup;", "autoReset", "", "editTextId", "", "resetId", "(Landroid/view/ViewGroup;ZII)V", "context", "Landroid/content/Context;", "kotlin.jvm.PlatformType", "mEditText", "Landroid/widget/EditText;", "mInputAction", "Lcom/effective/android/panel/view/content/IInputAction;", "mPixelInputView", "mResetAction", "Lcom/effective/android/panel/view/content/IResetAction;", "mResetView", "Landroid/view/View;", "map", "Ljava/util/HashMap;", "Lcom/effective/android/panel/view/content/ContentContainerImpl$ViewPosition;", "Lkotlin/collections/HashMap;", "tag", "", "assertView", "", "changeContainerHeight", "targetHeight", "findTriggerView", "id", "getInputActionImpl", "getResetActionImpl", "layoutContainer", "l", "t", "r", "b", "contentScrollMeasurers", "", "Lcom/effective/android/panel/interfaces/ContentScrollMeasurer;", "defaultScrollHeight", "canScrollOutsize", "reset", "ViewPosition", "panel-androidx_release"})
public final class ContentContainerImpl
implements IContentContainer,
ViewAssertion {
    private final EditText mEditText;
    private final Context context;
    private final View mResetView;
    private final IInputAction mInputAction;
    private final IResetAction mResetAction;
    private final String tag;
    private final EditText mPixelInputView;
    private final HashMap<Integer, ViewPosition> map;
    private final ViewGroup mViewGroup;
    private final boolean autoReset;
    private final int editTextId;
    private final int resetId;

    @Override
    @NotNull
    public IInputAction getInputActionImpl() {
        return this.mInputAction;
    }

    @Override
    @NotNull
    public IResetAction getResetActionImpl() {
        return this.mResetAction;
    }

    @Override
    @Nullable
    public View findTriggerView(int id2) {
        return this.mViewGroup.findViewById(id2);
    }

    @Override
    public void layoutContainer(int l, int t, int r, int b, @NotNull List<ContentScrollMeasurer> contentScrollMeasurers, int defaultScrollHeight, boolean canScrollOutsize, boolean reset) {
        Intrinsics.checkParameterIsNotNull(contentScrollMeasurers, (String)"contentScrollMeasurers");
        this.mViewGroup.layout(l, t, r, b);
        if (!canScrollOutsize) {
            return;
        }
        for (ContentScrollMeasurer contentScrollMeasurer : contentScrollMeasurers) {
            View view;
            int viewId = contentScrollMeasurer.getScrollViewId();
            if (viewId == -1) continue;
            View view2 = view = this.mViewGroup.findViewById(viewId);
            boolean bl = false;
            boolean bl2 = false;
            View it = view2;
            boolean bl3 = false;
            ViewPosition viewPosition = this.map.get(viewId);
            if (viewPosition == null) {
                View view3 = view;
                Intrinsics.checkExpressionValueIsNotNull((Object)view3, (String)"view");
                viewPosition = new ViewPosition(viewId, view3.getLeft(), view.getTop(), view.getRight(), view.getBottom());
                ((Map)this.map).put(viewId, viewPosition);
            }
            int willScrollDistance = 0;
            if (reset) {
                if (viewPosition.hasChange()) {
                    int viewLeft = viewPosition.getL();
                    int viewTop = viewPosition.getT();
                    int viewRight = viewPosition.getR();
                    int viewBottom = viewPosition.getB();
                    view.layout(viewLeft, viewTop, viewRight, viewBottom);
                    viewPosition.reset();
                }
            } else {
                willScrollDistance = contentScrollMeasurer.getScrollDistance(defaultScrollHeight);
                if (willScrollDistance > defaultScrollHeight) {
                    return;
                }
                if (willScrollDistance < 0) {
                    willScrollDistance = 0;
                }
                int diffY = defaultScrollHeight - willScrollDistance;
                viewPosition.change(viewPosition.getL(), viewPosition.getT() + diffY, viewPosition.getR(), viewPosition.getB() + diffY);
                view.layout(viewPosition.getChangeL(), viewPosition.getChangeT(), viewPosition.getChangeR(), viewPosition.getChangeB());
            }
            LogTracker.log(PanelSwitchLayout.Companion.getTAG() + "#onLayout", "ContentScrollMeasurer(id " + viewId + " , defaultScrollHeight " + defaultScrollHeight + " , scrollDistance " + willScrollDistance + " reset " + reset + ") origin (l " + viewPosition.getL() + ",t " + viewPosition.getT() + ",r " + viewPosition.getL() + ", b " + viewPosition.getB() + ')');
            LogTracker.log(PanelSwitchLayout.Companion.getTAG() + "#onLayout", "ContentScrollMeasurer(id " + viewId + " , defaultScrollHeight " + defaultScrollHeight + " , scrollDistance " + willScrollDistance + " reset " + reset + ") layout parent(l " + l + ",t " + t + ",r " + r + ",b " + b + ") self(l " + viewPosition.getChangeL() + ",t " + viewPosition.getChangeT() + ",r " + viewPosition.getChangeR() + ", b" + viewPosition.getChangeB() + ')');
        }
    }

    @Override
    public void changeContainerHeight(int targetHeight) {
        ViewGroup.LayoutParams layoutParams = this.mViewGroup.getLayoutParams();
        if (layoutParams != null && layoutParams.height != targetHeight) {
            layoutParams.height = targetHeight;
            this.mViewGroup.setLayoutParams(layoutParams);
        }
    }

    @Override
    public void assertView() {
        if (this.mEditText == null) {
            throw (Throwable)new RuntimeException("ContentContainer should set edit_view to get the editText!");
        }
    }

    public ContentContainerImpl(@NotNull ViewGroup mViewGroup, boolean autoReset, @IdRes int editTextId, @IdRes int resetId) {
        Integer imeOptions;
        Intrinsics.checkParameterIsNotNull((Object)mViewGroup, (String)"mViewGroup");
        this.mViewGroup = mViewGroup;
        this.autoReset = autoReset;
        this.editTextId = editTextId;
        this.resetId = resetId;
        this.mEditText = (EditText)this.mViewGroup.findViewById(this.editTextId);
        this.context = this.mViewGroup.getContext();
        this.mResetView = this.mViewGroup.findViewById(this.resetId);
        String string = ContentContainerImpl.class.getSimpleName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"ContentContainerImpl::class.java.simpleName");
        this.tag = string;
        EditText editText = this.mEditText;
        this.mPixelInputView = new EditText((Context)(editText != null ? editText.getContext() : null));
        this.assertView();
        EditText editText2 = this.mEditText;
        Integer n = imeOptions = editText2 != null ? Integer.valueOf(editText2.getImeOptions()) : null;
        if (imeOptions != null) {
            imeOptions = imeOptions | 0x10000000;
            EditText editText3 = this.mEditText;
            if (editText3 != null) {
                editText3.setImeOptions(imeOptions.intValue());
            }
            this.mPixelInputView.setImeOptions(imeOptions.intValue());
        }
        this.mResetAction = new IResetAction(){
            private boolean enableReset;
            private Runnable action;

            @Override
            public boolean hookDispatchTouchEvent(@Nullable MotionEvent ev, boolean consume) {
                MotionEvent motionEvent = ev;
                if (motionEvent != null) {
                    MotionEvent motionEvent2 = motionEvent;
                    boolean bl = false;
                    boolean bl2 = false;
                    MotionEvent event = motionEvent2;
                    boolean bl3 = false;
                    if (event.getAction() == 1) {
                        Runnable runnable = this.action;
                        if (runnable != null) {
                            Runnable runnable2 = runnable;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            Runnable it = runnable2;
                            boolean bl6 = false;
                            if (autoReset && this.enableReset && !consume && (mResetView == null || this.eventInViewArea(mResetView, event))) {
                                it.run();
                                LogTracker.log(tag + "#hookDispatchTouchEvent", "hook ACTION_UP");
                                return true;
                            }
                        }
                    }
                }
                return false;
            }

            @Override
            public boolean hookOnTouchEvent(@Nullable MotionEvent ev) {
                block3: {
                    MotionEvent motionEvent = ev;
                    if (motionEvent == null) break block3;
                    MotionEvent motionEvent2 = motionEvent;
                    boolean bl = false;
                    boolean bl2 = false;
                    MotionEvent event = motionEvent2;
                    boolean bl3 = false;
                    if (event.getAction() == 0) {
                        Runnable runnable = this.action;
                        if (runnable != null) {
                            Runnable runnable2 = runnable;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            Runnable it = runnable2;
                            boolean bl6 = false;
                            if (autoReset && this.enableReset && (mResetView == null || this.eventInViewArea(mResetView, event))) {
                                it.run();
                                LogTracker.log(tag + "#hookOnTouchEvent", "hook ACTION_DOWN");
                            }
                        }
                    }
                }
                return true;
            }

            @Override
            public void enableReset(boolean enable) {
                this.enableReset = enable;
            }

            @Override
            public void setResetCallback(@NotNull Runnable runnable) {
                Intrinsics.checkParameterIsNotNull((Object)runnable, (String)"runnable");
                this.action = runnable;
            }

            public final boolean eventInViewArea(@NotNull View view, @Nullable MotionEvent ev) {
                Intrinsics.checkParameterIsNotNull((Object)view, (String)"view");
                MotionEvent motionEvent = ev;
                if (motionEvent != null) {
                    MotionEvent motionEvent2 = motionEvent;
                    boolean bl = false;
                    boolean bl2 = false;
                    MotionEvent it = motionEvent2;
                    boolean bl3 = false;
                    float x = ev.getRawX();
                    float y = ev.getRawY();
                    Rect rect = new Rect();
                    view.getGlobalVisibleRect(rect);
                    return x >= (float)rect.left && x <= (float)rect.right && y >= (float)rect.top && y <= (float)rect.bottom;
                }
                return false;
            }
        };
        this.mInputAction = new IInputAction(){
            private final EditText mainInputView;
            private int mainFocusIndex;
            private final WeakHashMap<Integer, EditText> secondaryViews;
            private boolean secondaryViewRequestFocus;
            private View.OnClickListener onClickListener;
            private boolean realEditViewAttach;
            private int curPanelId;
            private boolean checkoutInputRight;
            private final RequestFocusRunnable requestFocusRunnable;
            private final ResetSelectionRunnable resetSelectionRunnable;

            private final void giveUpFocusRight() {
                this.checkoutInputRight = true;
                this.realEditViewAttach = false;
                if (mPixelInputView.hasFocus()) {
                    mPixelInputView.clearFocus();
                }
                this.checkoutInputRight = false;
            }

            @Override
            @NotNull
            public EditText getFullScreenPixelInputView() {
                mPixelInputView.setBackground((Drawable)null);
                return mPixelInputView;
            }

            @Override
            public void recycler() {
                this.mainInputView.removeCallbacks((Runnable)this.requestFocusRunnable);
                this.mainInputView.removeCallbacks((Runnable)this.resetSelectionRunnable);
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void updateFullScreenParams(boolean isFullScreen, int panelId, int panelHeight) {
                if (panelId == this.curPanelId) {
                    return;
                }
                this.curPanelId = panelId;
                if (this.secondaryViewRequestFocus) {
                    this.secondaryViewRequestFocus = false;
                    return;
                }
                mPixelInputView.setVisibility(isFullScreen ? 0 : 8);
                if (mPixelInputView.getParent() instanceof ViewGroup) {
                    ViewParent viewParent = mPixelInputView.getParent();
                    if (viewParent == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
                    }
                    ((ViewGroup)viewParent).setFocusableInTouchMode(true);
                    ViewParent viewParent2 = mPixelInputView.getParent();
                    if (viewParent2 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type android.view.ViewGroup");
                    }
                    ((ViewGroup)viewParent2).setFocusable(true);
                }
                if (!isFullScreen) {
                    2.retrieveFocusRight$default(this, false, false, 3, null);
                    return;
                }
                if (panelId == 0) {
                    this.retrieveFocusRight(true, true);
                    return;
                }
                if (panelId != -1) {
                    Context context = context;
                    Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                    if (!PanelUtil.isPanelHeightBelowKeyboardHeight(context, panelHeight)) {
                        this.retrieveFocusRight(false, true);
                        return;
                    }
                }
                this.giveUpFocusRight();
            }

            @Override
            public void addSecondaryInputView(@NotNull EditText editText) {
                Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
                int key = editText.hashCode();
                if (!this.secondaryViews.containsKey(key)) {
                    editText.setOnFocusChangeListener(new View.OnFocusChangeListener(this){
                        final /* synthetic */ 2 this$0;

                        public final void onFocusChange(View v, boolean hasFocus) {
                            2.access$setSecondaryViewRequestFocus$p(this.this$0, hasFocus);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                    ((Map)this.secondaryViews).put(key, editText);
                }
            }

            @Override
            public void removeSecondaryInputView(@NotNull EditText editText) {
                Intrinsics.checkParameterIsNotNull((Object)editText, (String)"editText");
                int key = editText.hashCode();
                if (this.secondaryViews.containsKey(key)) {
                    this.secondaryViews.remove(key);
                }
            }

            private final void retrieveFocusRight(boolean requestFocus, boolean resetSelection) {
                this.checkoutInputRight = true;
                this.realEditViewAttach = true;
                if (mPixelInputView.hasFocus()) {
                    mPixelInputView.clearFocus();
                }
                this.recycler();
                if (requestFocus) {
                    this.requestFocusRunnable.setResetSelection(resetSelection);
                    this.mainInputView.postDelayed((Runnable)this.requestFocusRunnable, 200L);
                } else if (resetSelection) {
                    this.resetSelectionRunnable.run();
                } else {
                    this.checkoutInputRight = false;
                }
            }

            static /* synthetic */ void retrieveFocusRight$default(2 var0, boolean bl, boolean bl2, int n, Object object) {
                if ((n & 1) != 0) {
                    bl = false;
                }
                if ((n & 2) != 0) {
                    bl2 = false;
                }
                var0.retrieveFocusRight(bl, bl2);
            }

            @Override
            public void setEditTextClickListener(@NotNull View.OnClickListener l) {
                Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
                this.onClickListener = l;
                this.mainInputView.setOnClickListener(new View.OnClickListener(this){
                    final /* synthetic */ 2 this$0;

                    public final void onClick(View v) {
                        if (2.access$getRealEditViewAttach$p(this.this$0)) {
                            View.OnClickListener onClickListener = 2.access$getOnClickListener$p(this.this$0);
                            if (onClickListener != null) {
                                onClickListener.onClick(v);
                            }
                        } else {
                            ContentContainerImpl.access$getMPixelInputView$p(this.this$0.this).requestFocus();
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }

            @Override
            public void setEditTextFocusChangeListener(@NotNull View.OnFocusChangeListener l) {
                Intrinsics.checkParameterIsNotNull((Object)l, (String)"l");
                this.mainInputView.setOnFocusChangeListener(new View.OnFocusChangeListener(this, l){
                    final /* synthetic */ 2 this$0;
                    final /* synthetic */ View.OnFocusChangeListener $l;

                    public final void onFocusChange(View v, boolean hasFocus) {
                        if (hasFocus) {
                            if (2.access$getRealEditViewAttach$p(this.this$0)) {
                                this.$l.onFocusChange(v, hasFocus);
                            } else {
                                ContentContainerImpl.access$getMPixelInputView$p(this.this$0.this).requestFocus();
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$l = onFocusChangeListener;
                    }
                });
                mPixelInputView.setOnFocusChangeListener(new View.OnFocusChangeListener(l){
                    final /* synthetic */ View.OnFocusChangeListener $l;

                    public final void onFocusChange(View v, boolean hasFocus) {
                        if (hasFocus) {
                            this.$l.onFocusChange(v, hasFocus);
                        }
                    }
                    {
                        this.$l = onFocusChangeListener;
                    }
                });
            }

            @Override
            public void hideKeyboard(boolean clearFocus) {
                EditText targetView = this.realEditViewAttach ? this.mainInputView : mPixelInputView;
                Context context = context;
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                PanelUtil.hideKeyboard(context, (View)targetView);
                if (clearFocus) {
                    targetView.clearFocus();
                }
            }

            @Override
            public boolean showKeyboard() {
                EditText targetView = this.realEditViewAttach ? this.mainInputView : mPixelInputView;
                Context context = context;
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"context");
                return PanelUtil.showKeyboard(context, (View)targetView);
            }

            @Override
            public void requestKeyboard() {
                EditText targetView;
                EditText editText = targetView = this.realEditViewAttach ? this.mainInputView : mPixelInputView;
                if (targetView.hasFocus()) {
                    targetView.performClick();
                } else {
                    targetView.requestFocus();
                }
            }
            {
                EditText editText = $outer.mEditText;
                if (editText == null) {
                    Intrinsics.throwNpe();
                }
                this.mainInputView = editText;
                this.mainFocusIndex = -1;
                this.secondaryViews = new WeakHashMap();
                this.realEditViewAttach = true;
                this.curPanelId = Integer.MAX_VALUE;
                this.checkoutInputRight = true;
                this.requestFocusRunnable = new RequestFocusRunnable();
                this.resetSelectionRunnable = new ResetSelectionRunnable();
                this.mainInputView.addTextChangedListener(new TextWatcher(){

                    public void afterTextChanged(@Nullable Editable s) {
                        if (realEditViewAttach && mainInputView.hasFocus() && !checkoutInputRight) {
                            mainFocusIndex = mainInputView.getSelectionStart();
                        }
                    }

                    public void beforeTextChanged(@Nullable CharSequence s, int start, int count, int after) {
                    }

                    public void onTextChanged(@Nullable CharSequence s, int start, int before, int count) {
                    }
                });
                this.mainInputView.setAccessibilityDelegate(new View.AccessibilityDelegate(){

                    public void sendAccessibilityEvent(@Nullable View host, int eventType) {
                        super.sendAccessibilityEvent(host, eventType);
                        if (eventType == 8192 && realEditViewAttach && mainInputView.hasFocus() && !checkoutInputRight) {
                            mainFocusIndex = mainInputView.getSelectionStart();
                        }
                    }
                });
            }

            public static final /* synthetic */ boolean access$getSecondaryViewRequestFocus$p(2 $this) {
                return $this.secondaryViewRequestFocus;
            }

            public static final /* synthetic */ void access$setSecondaryViewRequestFocus$p(2 $this, boolean bl) {
                $this.secondaryViewRequestFocus = bl;
            }

            public static final /* synthetic */ void access$setRealEditViewAttach$p(2 $this, boolean bl) {
                $this.realEditViewAttach = bl;
            }

            public static final /* synthetic */ View.OnClickListener access$getOnClickListener$p(2 $this) {
                return $this.onClickListener;
            }

            public static final /* synthetic */ void access$setOnClickListener$p(2 $this, View.OnClickListener onClickListener) {
                $this.onClickListener = onClickListener;
            }

            @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000*\u0001\u0000\b\u008a\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"com/effective/android/panel/view/content/ContentContainerImpl$2.RequestFocusRunnable", "Ljava/lang/Runnable;", "(Lcom/effective/android/panel/view/content/ContentContainerImpl$2;)V", "resetSelection", "", "getResetSelection", "()Z", "setResetSelection", "(Z)V", "run", "", "panel-androidx_release"})
            public final class RequestFocusRunnable
            implements Runnable {
                private boolean resetSelection;

                public final boolean getResetSelection() {
                    return this.resetSelection;
                }

                public final void setResetSelection(boolean bl) {
                    this.resetSelection = bl;
                }

                @Override
                public void run() {
                    mainInputView.requestFocus();
                    if (this.resetSelection) {
                        mainInputView.postDelayed((Runnable)resetSelectionRunnable, 100L);
                    } else {
                        checkoutInputRight = false;
                    }
                }
            }

            @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0013\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000*\u0001\u0000\b\u008a\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"com/effective/android/panel/view/content/ContentContainerImpl$2.ResetSelectionRunnable", "Ljava/lang/Runnable;", "(Lcom/effective/android/panel/view/content/ContentContainerImpl$2;)V", "run", "", "panel-androidx_release"})
            public final class ResetSelectionRunnable
            implements Runnable {
                @Override
                public void run() {
                    if (mainFocusIndex != -1 && mainFocusIndex <= mainInputView.getText().length()) {
                        mainInputView.setSelection(mainFocusIndex);
                    } else {
                        mainInputView.setSelection(mainInputView.getText().length());
                    }
                    checkoutInputRight = false;
                }
            }
        };
        this.map = new HashMap();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0019\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ&\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010!\u001a\u00020\u0003J\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\t\u0010#\u001a\u00020\u0003H\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J;\u0010'\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010+\u001a\u00020)J\t\u0010,\u001a\u00020\u0003H\u00d6\u0001J\u0006\u0010-\u001a\u00020\u001dJ\t\u0010.\u001a\u00020/H\u00d6\u0001R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\n\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\n\"\u0004\b\u0011\u0010\u000eR\u001a\u0010\u0012\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\n\"\u0004\b\u0014\u0010\u000eR\u001a\u0010\u0015\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\n\"\u0004\b\u0017\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\n\u00a8\u00060"}, d2={"Lcom/effective/android/panel/view/content/ContentContainerImpl$ViewPosition;", "", "id", "", "l", "t", "r", "b", "(IIIII)V", "getB", "()I", "changeB", "getChangeB", "setChangeB", "(I)V", "changeL", "getChangeL", "setChangeL", "changeR", "getChangeR", "setChangeR", "changeT", "getChangeT", "setChangeT", "getId", "getL", "getR", "getT", "change", "", "newL", "newT", "newR", "newB", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "", "other", "hasChange", "hashCode", "reset", "toString", "", "panel-androidx_release"})
    private static final class ViewPosition {
        private int changeL;
        private int changeT;
        private int changeR;
        private int changeB;
        private final int id;
        private final int l;
        private final int t;
        private final int r;
        private final int b;

        public final int getChangeL() {
            return this.changeL;
        }

        public final void setChangeL(int n) {
            this.changeL = n;
        }

        public final int getChangeT() {
            return this.changeT;
        }

        public final void setChangeT(int n) {
            this.changeT = n;
        }

        public final int getChangeR() {
            return this.changeR;
        }

        public final void setChangeR(int n) {
            this.changeR = n;
        }

        public final int getChangeB() {
            return this.changeB;
        }

        public final void setChangeB(int n) {
            this.changeB = n;
        }

        public final boolean hasChange() {
            return this.changeL != this.l || this.changeT != this.t || this.changeR != this.r || this.changeB != this.b;
        }

        public final void change(int newL, int newT, int newR, int newB) {
            this.changeL = newL;
            this.changeT = newT;
            this.changeR = newR;
            this.changeB = newB;
        }

        public final void reset() {
            this.changeL = this.l;
            this.changeT = this.t;
            this.changeR = this.r;
            this.changeB = this.b;
        }

        public final int getId() {
            return this.id;
        }

        public final int getL() {
            return this.l;
        }

        public final int getT() {
            return this.t;
        }

        public final int getR() {
            return this.r;
        }

        public final int getB() {
            return this.b;
        }

        public ViewPosition(int id2, int l, int t, int r, int b) {
            this.id = id2;
            this.l = l;
            this.t = t;
            this.r = r;
            this.b = b;
            this.changeL = this.l;
            this.changeT = this.t;
            this.changeR = this.r;
            this.changeB = this.b;
        }

        public final int component1() {
            return this.id;
        }

        public final int component2() {
            return this.l;
        }

        public final int component3() {
            return this.t;
        }

        public final int component4() {
            return this.r;
        }

        public final int component5() {
            return this.b;
        }

        @NotNull
        public final ViewPosition copy(int id2, int l, int t, int r, int b) {
            return new ViewPosition(id2, l, t, r, b);
        }

        public static /* synthetic */ ViewPosition copy$default(ViewPosition viewPosition, int n, int n2, int n3, int n4, int n5, int n6, Object object) {
            if ((n6 & 1) != 0) {
                n = viewPosition.id;
            }
            if ((n6 & 2) != 0) {
                n2 = viewPosition.l;
            }
            if ((n6 & 4) != 0) {
                n3 = viewPosition.t;
            }
            if ((n6 & 8) != 0) {
                n4 = viewPosition.r;
            }
            if ((n6 & 0x10) != 0) {
                n5 = viewPosition.b;
            }
            return viewPosition.copy(n, n2, n3, n4, n5);
        }

        @NotNull
        public String toString() {
            return "ViewPosition(id=" + this.id + ", l=" + this.l + ", t=" + this.t + ", r=" + this.r + ", b=" + this.b + ")";
        }

        public int hashCode() {
            return (((this.id * 31 + this.l) * 31 + this.t) * 31 + this.r) * 31 + this.b;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ViewPosition)) break block3;
                    ViewPosition viewPosition = (ViewPosition)object;
                    if (this.id != viewPosition.id || this.l != viewPosition.l || this.t != viewPosition.t || this.r != viewPosition.r || this.b != viewPosition.b) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

