/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.consul.v1;

import com.ecwid.consul.UrlParameters;
import com.ecwid.consul.Utils;
import com.ecwid.consul.v1.ConsistencyMode;
import java.util.ArrayList;
import java.util.List;

public final class QueryParams
implements UrlParameters {
    public static final QueryParams DEFAULT = new QueryParams(ConsistencyMode.DEFAULT);
    private final String datacenter;
    private final ConsistencyMode consistencyMode;
    private final long waitTime;
    private final long index;
    private final String near;

    private QueryParams(String datacenter, ConsistencyMode consistencyMode, long waitTime, long index, String near) {
        this.datacenter = datacenter;
        this.consistencyMode = consistencyMode;
        this.waitTime = waitTime;
        this.index = index;
        this.near = near;
    }

    private QueryParams(String datacenter, ConsistencyMode consistencyMode, long waitTime, long index) {
        this(datacenter, consistencyMode, waitTime, index, null);
    }

    public QueryParams(String datacenter) {
        this(datacenter, ConsistencyMode.DEFAULT, -1L, -1L);
    }

    public QueryParams(ConsistencyMode consistencyMode) {
        this(null, consistencyMode, -1L, -1L);
    }

    public QueryParams(String datacenter, ConsistencyMode consistencyMode) {
        this(datacenter, consistencyMode, -1L, -1L);
    }

    public QueryParams(long waitTime, long index) {
        this(null, ConsistencyMode.DEFAULT, waitTime, index);
    }

    public QueryParams(String datacenter, long waitTime, long index) {
        this(datacenter, ConsistencyMode.DEFAULT, waitTime, index, null);
    }

    public String getDatacenter() {
        return this.datacenter;
    }

    public ConsistencyMode getConsistencyMode() {
        return this.consistencyMode;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public long getIndex() {
        return this.index;
    }

    public String getNear() {
        return this.near;
    }

    @Override
    public List<String> toUrlParameters() {
        ArrayList<String> params = new ArrayList<String>();
        if (this.datacenter != null) {
            params.add("dc=" + Utils.encodeValue(this.datacenter));
        }
        if (this.consistencyMode != ConsistencyMode.DEFAULT) {
            params.add(this.consistencyMode.name().toLowerCase());
        }
        if (this.waitTime != -1L) {
            params.add("wait=" + Utils.toSecondsString(this.waitTime));
        }
        if (this.index != -1L) {
            params.add("index=" + Utils.toUnsignedString(this.index));
        }
        if (this.near != null) {
            params.add("near=" + Utils.encodeValue(this.near));
        }
        return params;
    }

    public static final class Builder {
        private String datacenter = null;
        private ConsistencyMode consistencyMode = ConsistencyMode.DEFAULT;
        private long waitTime = -1L;
        private long index = -1L;
        private String near = null;

        public static Builder builder() {
            return new Builder();
        }

        private Builder() {
        }

        public Builder setConsistencyMode(ConsistencyMode consistencyMode) {
            this.consistencyMode = consistencyMode;
            return this;
        }

        public Builder setDatacenter(String datacenter) {
            this.datacenter = datacenter;
            return this;
        }

        public Builder setWaitTime(long waitTime) {
            this.waitTime = waitTime;
            return this;
        }

        public Builder setIndex(long index) {
            this.index = index;
            return this;
        }

        public Builder setNear(String near) {
            this.near = near;
            return this;
        }

        public QueryParams build() {
            return new QueryParams(this.datacenter, this.consistencyMode, this.waitTime, this.index, this.near);
        }
    }
}

