/*
 * Decompiled with CFR 0.152.
 */
package com.ecwid.consul;

import com.ecwid.consul.UrlParameters;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;

public class Utils {
    public static String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("So strange - every JVM has to support UTF-8 encoding.");
        }
    }

    public static String generateUrl(String baseUrl, UrlParameters ... params) {
        if (params == null) {
            return baseUrl;
        }
        ArrayList<String> allParams = new ArrayList<String>();
        for (UrlParameters item : params) {
            if (item == null) continue;
            allParams.addAll(item.toUrlParameters());
        }
        StringBuilder result = new StringBuilder(baseUrl);
        Iterator paramsIterator = allParams.iterator();
        if (paramsIterator.hasNext()) {
            result.append("?").append((String)paramsIterator.next());
            while (paramsIterator.hasNext()) {
                result.append("&").append((String)paramsIterator.next());
            }
        }
        return result.toString();
    }
}

