/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns.util;

import com.eatthepath.pushy.apns.util.InterruptionLevel;
import com.eatthepath.pushy.apns.util.LiveActivityEvent;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class ApnsPayloadBuilder {
    private String alertBody = null;
    private String localizedAlertKey = null;
    private String[] localizedAlertArguments = null;
    private String alertTitle = null;
    private String localizedAlertTitleKey = null;
    private String[] localizedAlertTitleArguments = null;
    private String alertSubtitle = null;
    private String localizedAlertSubtitleKey = null;
    private String[] localizedAlertSubtitleArguments = null;
    private String launchImageFileName = null;
    private boolean showActionButton = true;
    private String actionButtonLabel = null;
    private String localizedActionButtonKey = null;
    private Integer badgeNumber = null;
    private String soundFileName = null;
    private Map<String, Object> soundForCriticalAlert = null;
    private String categoryName = null;
    private boolean contentAvailable = false;
    private boolean mutableContent = false;
    private String threadId = null;
    private String targetContentId = null;
    private String summaryArgument = null;
    private Integer summaryArgumentCount = null;
    private InterruptionLevel interruptionLevel = null;
    private Double relevanceScore = null;
    private String[] urlArguments = null;
    private final HashMap<String, Object> customProperties = new HashMap();
    private boolean preferStringRepresentationForAlerts = false;
    private LiveActivityEvent event = null;
    private Instant timestamp = null;
    private Instant dismissalDate = null;
    private Instant staleDate = null;
    private String attributesType = null;
    private Map<String, Object> attributes = null;
    private Map<String, Object> contentState = null;
    private static final String APS_KEY = "aps";
    private static final String ALERT_KEY = "alert";
    private static final String BADGE_KEY = "badge";
    private static final String SOUND_KEY = "sound";
    private static final String CATEGORY_KEY = "category";
    private static final String CONTENT_AVAILABLE_KEY = "content-available";
    private static final String MUTABLE_CONTENT_KEY = "mutable-content";
    private static final String THREAD_ID_KEY = "thread-id";
    private static final String TARGET_CONTENT_ID_KEY = "target-content-id";
    private static final String SUMMARY_ARGUMENT_KEY = "summary-arg";
    private static final String SUMMARY_ARGUMENT_COUNT_KEY = "summary-arg-count";
    private static final String URL_ARGS_KEY = "url-args";
    private static final String INTERRUPTION_LEVEL_KEY = "interruption-level";
    private static final String RELEVANCE_SCORE_KEY = "relevance-score";
    private static final String ALERT_TITLE_KEY = "title";
    private static final String ALERT_TITLE_LOC_KEY = "title-loc-key";
    private static final String ALERT_TITLE_ARGS_KEY = "title-loc-args";
    private static final String ALERT_SUBTITLE_KEY = "subtitle";
    private static final String ALERT_SUBTITLE_LOC_KEY = "subtitle-loc-key";
    private static final String ALERT_SUBTITLE_ARGS_KEY = "subtitle-loc-args";
    private static final String ALERT_BODY_KEY = "body";
    private static final String ALERT_LOC_KEY = "loc-key";
    private static final String ALERT_ARGS_KEY = "loc-args";
    private static final String ACTION_KEY = "action";
    private static final String ACTION_LOC_KEY = "action-loc-key";
    private static final String LAUNCH_IMAGE_KEY = "launch-image";
    private static final String MDM_KEY = "mdm";
    private static final String TIMESTAMP_KEY = "timestamp";
    private static final String DISMISSAL_DATE_KEY = "dismissal-date";
    private static final String STALE_DATE_KEY = "stale-date";
    private static final String EVENT_KEY = "event";
    private static final String ATTRIBUTES_TYPE_KEY = "attributes-type";
    private static final String ATTRIBUTES_KEY = "attributes";
    private static final String CONTENT_STATE_KEY = "content-state";
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final String DEFAULT_SOUND_FILENAME = "default";

    public ApnsPayloadBuilder setPreferStringRepresentationForAlerts(boolean preferStringRepresentationForAlerts) {
        this.preferStringRepresentationForAlerts = preferStringRepresentationForAlerts;
        return this;
    }

    public ApnsPayloadBuilder setAlertBody(String alertBody) {
        this.alertBody = alertBody;
        return this;
    }

    public ApnsPayloadBuilder setLocalizedAlertMessage(String localizedAlertKey, String ... alertArguments) {
        this.localizedAlertKey = localizedAlertKey;
        this.localizedAlertArguments = alertArguments != null && alertArguments.length > 0 ? alertArguments : null;
        return this;
    }

    public ApnsPayloadBuilder setAlertTitle(String alertTitle) {
        this.alertTitle = alertTitle;
        return this;
    }

    public ApnsPayloadBuilder setLocalizedAlertTitle(String localizedAlertTitleKey, String ... alertTitleArguments) {
        this.localizedAlertTitleKey = localizedAlertTitleKey;
        this.localizedAlertTitleArguments = alertTitleArguments != null && alertTitleArguments.length > 0 ? alertTitleArguments : null;
        return this;
    }

    public ApnsPayloadBuilder setAlertSubtitle(String alertSubtitle) {
        this.alertSubtitle = alertSubtitle;
        return this;
    }

    public ApnsPayloadBuilder setLocalizedAlertSubtitle(String localizedAlertSubtitleKey, String ... alertSubtitleArguments) {
        this.localizedAlertSubtitleKey = localizedAlertSubtitleKey;
        this.localizedAlertSubtitleArguments = alertSubtitleArguments != null && alertSubtitleArguments.length > 0 ? alertSubtitleArguments : null;
        return this;
    }

    public ApnsPayloadBuilder setLaunchImageFileName(String launchImageFilename) {
        this.launchImageFileName = launchImageFilename;
        return this;
    }

    public ApnsPayloadBuilder setShowActionButton(boolean showActionButton) {
        this.showActionButton = showActionButton;
        return this;
    }

    public ApnsPayloadBuilder setActionButtonLabel(String action) {
        this.actionButtonLabel = action;
        this.localizedActionButtonKey = null;
        return this;
    }

    public ApnsPayloadBuilder setLocalizedActionButtonKey(String localizedActionButtonKey) {
        this.localizedActionButtonKey = localizedActionButtonKey;
        this.actionButtonLabel = null;
        return this;
    }

    public ApnsPayloadBuilder setBadgeNumber(Integer badgeNumber) {
        this.badgeNumber = badgeNumber;
        return this;
    }

    public ApnsPayloadBuilder setCategoryName(String categoryName) {
        this.categoryName = categoryName;
        return this;
    }

    @Deprecated
    public ApnsPayloadBuilder setSoundFileName(String soundFileName) {
        return this.setSound(soundFileName);
    }

    public ApnsPayloadBuilder setSound(String soundFileName) {
        this.soundFileName = soundFileName;
        this.soundForCriticalAlert = null;
        return this;
    }

    public ApnsPayloadBuilder setSound(String soundFileName, boolean isCriticalAlert, double soundVolume) {
        Objects.requireNonNull(soundFileName, "Sound file name must not be null.");
        if (soundVolume < 0.0 || soundVolume > 1.0) {
            throw new IllegalArgumentException("Sound volume must be between 0.0 and 1.0 (inclusive).");
        }
        this.soundFileName = null;
        this.soundForCriticalAlert = ApnsPayloadBuilder.buildSoundForCriticalAlertMap(soundFileName, isCriticalAlert, soundVolume);
        return this;
    }

    private static Map<String, Object> buildSoundForCriticalAlertMap(String name, boolean critical, double volume) {
        HashMap<String, Object> soundForCriticalAlertMap = new HashMap<String, Object>(3, 1.0f);
        soundForCriticalAlertMap.put("name", name);
        soundForCriticalAlertMap.put("critical", critical ? 1 : 0);
        soundForCriticalAlertMap.put("volume", volume);
        return soundForCriticalAlertMap;
    }

    public ApnsPayloadBuilder setContentAvailable(boolean contentAvailable) {
        this.contentAvailable = contentAvailable;
        return this;
    }

    public ApnsPayloadBuilder setMutableContent(boolean mutableContent) {
        this.mutableContent = mutableContent;
        return this;
    }

    public ApnsPayloadBuilder setThreadId(String threadId) {
        this.threadId = threadId;
        return this;
    }

    public ApnsPayloadBuilder setTargetContentId(String targetContentId) {
        this.targetContentId = targetContentId;
        return this;
    }

    public ApnsPayloadBuilder setSummaryArgument(String summaryArgument) {
        this.summaryArgument = summaryArgument;
        return this;
    }

    public ApnsPayloadBuilder setSummaryArgumentCount(Integer summaryArgumentCount) {
        if (summaryArgumentCount != null && summaryArgumentCount < 1) {
            throw new IllegalArgumentException("Summary argument count must be positive.");
        }
        this.summaryArgumentCount = summaryArgumentCount;
        return this;
    }

    public ApnsPayloadBuilder setInterruptionLevel(InterruptionLevel interruptionLevel) {
        this.interruptionLevel = interruptionLevel;
        return this;
    }

    public ApnsPayloadBuilder setRelevanceScore(Double relevanceScore) {
        if (relevanceScore != null && relevanceScore.isNaN()) {
            throw new IllegalArgumentException("Relevance score must be a number, but was actually " + relevanceScore);
        }
        this.relevanceScore = relevanceScore;
        return this;
    }

    public ApnsPayloadBuilder setStaleDate(Instant staleDate) {
        this.staleDate = staleDate;
        return this;
    }

    public ApnsPayloadBuilder setUrlArguments(List<String> arguments) {
        return this.setUrlArguments(arguments != null ? arguments.toArray(EMPTY_STRING_ARRAY) : null);
    }

    public ApnsPayloadBuilder setUrlArguments(String ... arguments) {
        this.urlArguments = arguments;
        return this;
    }

    public ApnsPayloadBuilder addCustomProperty(String key, Object value) {
        if (APS_KEY.equals(key)) {
            throw new IllegalArgumentException("Custom property key must not be aps");
        }
        this.customProperties.put(key, value);
        return this;
    }

    public ApnsPayloadBuilder setAttributesType(String attributesType) {
        this.attributesType = attributesType;
        return this;
    }

    public ApnsPayloadBuilder setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
        return this;
    }

    public ApnsPayloadBuilder setContentState(Map<String, Object> contentState) {
        this.contentState = contentState;
        return this;
    }

    public ApnsPayloadBuilder setEvent(LiveActivityEvent event) {
        this.event = event;
        return this;
    }

    public ApnsPayloadBuilder setTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public ApnsPayloadBuilder setDismissalDate(Instant dismissalDate) {
        this.dismissalDate = dismissalDate;
        return this;
    }

    protected Map<String, Object> buildPayloadMap() {
        boolean isLiveActivityPayload = this.event != null;
        HashMap<String, Object> payload = new HashMap<String, Object>();
        HashMap<String, Object> aps = new HashMap<String, Object>();
        if (this.badgeNumber != null) {
            aps.put(BADGE_KEY, this.badgeNumber);
        }
        if (this.soundFileName != null && !isLiveActivityPayload) {
            aps.put(SOUND_KEY, this.soundFileName);
        } else if (this.soundForCriticalAlert != null) {
            aps.put(SOUND_KEY, this.soundForCriticalAlert);
        }
        if (this.categoryName != null) {
            aps.put(CATEGORY_KEY, this.categoryName);
        }
        if (this.contentAvailable) {
            aps.put(CONTENT_AVAILABLE_KEY, 1);
        }
        if (this.mutableContent) {
            aps.put(MUTABLE_CONTENT_KEY, 1);
        }
        if (this.threadId != null) {
            aps.put(THREAD_ID_KEY, this.threadId);
        }
        if (this.targetContentId != null) {
            aps.put(TARGET_CONTENT_ID_KEY, this.targetContentId);
        }
        if (this.urlArguments != null) {
            aps.put(URL_ARGS_KEY, this.urlArguments);
        }
        if (this.interruptionLevel != null) {
            aps.put(INTERRUPTION_LEVEL_KEY, this.interruptionLevel.getValue());
        }
        if (this.relevanceScore != null) {
            aps.put(RELEVANCE_SCORE_KEY, this.relevanceScore);
        }
        if (this.timestamp != null) {
            aps.put(TIMESTAMP_KEY, this.timestamp.getEpochSecond());
        }
        if (this.event != null) {
            aps.put(EVENT_KEY, this.event.getValue());
        }
        if (this.attributesType != null) {
            aps.put(ATTRIBUTES_TYPE_KEY, this.attributesType);
        }
        if (this.attributes != null) {
            aps.put(ATTRIBUTES_KEY, this.attributes);
        }
        if (this.contentState != null) {
            aps.put(CONTENT_STATE_KEY, this.contentState);
        }
        if (this.dismissalDate != null) {
            aps.put(DISMISSAL_DATE_KEY, this.dismissalDate.getEpochSecond());
        }
        if (this.staleDate != null) {
            aps.put(STALE_DATE_KEY, this.staleDate.getEpochSecond());
        }
        HashMap<String, Object> alert = new HashMap<String, Object>();
        if (this.alertBody != null) {
            alert.put(ALERT_BODY_KEY, this.alertBody);
        }
        if (this.alertTitle != null) {
            alert.put(ALERT_TITLE_KEY, this.alertTitle);
        }
        if (this.alertSubtitle != null) {
            alert.put(ALERT_SUBTITLE_KEY, this.alertSubtitle);
        }
        if (this.summaryArgument != null) {
            alert.put(SUMMARY_ARGUMENT_KEY, this.summaryArgument);
        }
        if (this.summaryArgumentCount != null) {
            alert.put(SUMMARY_ARGUMENT_COUNT_KEY, this.summaryArgumentCount);
        }
        if (this.showActionButton) {
            if (this.localizedActionButtonKey != null) {
                alert.put(ACTION_LOC_KEY, this.localizedActionButtonKey);
            }
            if (this.actionButtonLabel != null) {
                alert.put(ACTION_KEY, this.actionButtonLabel);
            }
        } else {
            alert.put(ACTION_LOC_KEY, null);
        }
        if (this.localizedAlertKey != null) {
            alert.put(ALERT_LOC_KEY, this.localizedAlertKey);
            if (this.localizedAlertArguments != null) {
                alert.put(ALERT_ARGS_KEY, Arrays.asList(this.localizedAlertArguments));
            }
        }
        if (this.localizedAlertTitleKey != null) {
            alert.put(ALERT_TITLE_LOC_KEY, this.localizedAlertTitleKey);
            if (this.localizedAlertTitleArguments != null) {
                alert.put(ALERT_TITLE_ARGS_KEY, Arrays.asList(this.localizedAlertTitleArguments));
            }
        }
        if (this.localizedAlertSubtitleKey != null) {
            alert.put(ALERT_SUBTITLE_LOC_KEY, this.localizedAlertSubtitleKey);
            if (this.localizedAlertSubtitleArguments != null) {
                alert.put(ALERT_SUBTITLE_ARGS_KEY, Arrays.asList(this.localizedAlertSubtitleArguments));
            }
        }
        if (this.launchImageFileName != null) {
            alert.put(LAUNCH_IMAGE_KEY, this.launchImageFileName);
        }
        if (this.soundFileName != null && isLiveActivityPayload) {
            alert.put(SOUND_KEY, this.soundFileName);
        }
        if (alert.size() == 1 && alert.containsKey(ALERT_BODY_KEY) && this.preferStringRepresentationForAlerts) {
            aps.put(ALERT_KEY, alert.get(ALERT_BODY_KEY));
        } else if (!alert.isEmpty()) {
            aps.put(ALERT_KEY, alert);
        }
        payload.put(APS_KEY, aps);
        payload.putAll(this.customProperties);
        return payload;
    }

    public abstract String build();

    protected Map<String, String> buildMdmPayloadMap(String pushMagicValue) {
        return Collections.singletonMap(MDM_KEY, pushMagicValue);
    }

    public abstract String buildMdmPayload(String var1);
}

