/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.pushy.apns;

import com.eatthepath.pushy.apns.ApnsClientHandler;
import com.eatthepath.pushy.apns.AugmentingReflectiveChannelFactory;
import com.eatthepath.pushy.apns.ClientChannelClassUtil;
import com.eatthepath.pushy.apns.PooledObjectFactory;
import com.eatthepath.pushy.apns.TokenAuthenticationApnsClientHandler;
import com.eatthepath.pushy.apns.auth.ApnsSigningKey;
import com.eatthepath.pushy.apns.proxy.ProxyHandlerFactory;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.flush.FlushConsolidationHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import io.netty.resolver.dns.DefaultDnsServerAddressStreamProvider;
import io.netty.resolver.dns.DnsServerAddressStreamProvider;
import io.netty.resolver.dns.RoundRobinDnsAddressResolverGroup;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseNotifier;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ApnsChannelFactory
implements PooledObjectFactory<Channel>,
Closeable {
    private final SslContext sslContext;
    private final AtomicBoolean hasReleasedSslContext = new AtomicBoolean(false);
    private final AddressResolverGroup<? extends SocketAddress> addressResolverGroup;
    private final Bootstrap bootstrapTemplate;
    private final AtomicLong currentDelaySeconds = new AtomicLong(0L);
    private static final long MIN_CONNECT_DELAY_SECONDS = 1L;
    private static final long MAX_CONNECT_DELAY_SECONDS = 60L;
    private static final AttributeKey<Promise<Channel>> CHANNEL_READY_PROMISE_ATTRIBUTE_KEY = AttributeKey.valueOf(ApnsChannelFactory.class, (String)"channelReadyPromise");
    private static final Logger log = LoggerFactory.getLogger(ApnsChannelFactory.class);

    ApnsChannelFactory(final SslContext sslContext, final ApnsSigningKey signingKey, final long tokenExpirationMillis, final ProxyHandlerFactory proxyHandlerFactory, int connectTimeoutMillis, final long idlePingIntervalMillis, final long gracefulShutdownTimeoutMillis, final Http2FrameLogger frameLogger, InetSocketAddress apnsServerAddress, EventLoopGroup eventLoopGroup) {
        this.sslContext = sslContext;
        if (this.sslContext instanceof ReferenceCounted) {
            ((ReferenceCounted)this.sslContext).retain();
        }
        this.addressResolverGroup = proxyHandlerFactory == null ? new RoundRobinDnsAddressResolverGroup(ClientChannelClassUtil.getDatagramChannelClass(eventLoopGroup), (DnsServerAddressStreamProvider)DefaultDnsServerAddressStreamProvider.INSTANCE) : NoopAddressResolverGroup.INSTANCE;
        this.bootstrapTemplate = new Bootstrap();
        this.bootstrapTemplate.group(eventLoopGroup);
        this.bootstrapTemplate.option(ChannelOption.TCP_NODELAY, (Object)true);
        this.bootstrapTemplate.remoteAddress((SocketAddress)apnsServerAddress);
        this.bootstrapTemplate.resolver(this.addressResolverGroup);
        if (connectTimeoutMillis > 0) {
            this.bootstrapTemplate.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)connectTimeoutMillis);
        }
        this.bootstrapTemplate.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(final SocketChannel channel) {
                final ChannelPipeline pipeline = channel.pipeline();
                if (proxyHandlerFactory != null) {
                    pipeline.addFirst(new ChannelHandler[]{proxyHandlerFactory.createProxyHandler()});
                }
                SslHandler sslHandler = sslContext.newHandler(channel.alloc());
                sslHandler.handshakeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

                    public void operationComplete(Future<Channel> handshakeFuture) {
                        if (handshakeFuture.isSuccess()) {
                            String authority = channel.remoteAddress().getHostName();
                            ApnsClientHandler.ApnsClientHandlerBuilder clientHandlerBuilder = signingKey != null ? new TokenAuthenticationApnsClientHandler.TokenAuthenticationApnsClientHandlerBuilder().signingKey(signingKey).tokenExpirationMillis(tokenExpirationMillis).authority(authority).idlePingIntervalMillis(idlePingIntervalMillis) : new ApnsClientHandler.ApnsClientHandlerBuilder().authority(authority).idlePingIntervalMillis(idlePingIntervalMillis);
                            if (frameLogger != null) {
                                clientHandlerBuilder.frameLogger(frameLogger);
                            }
                            ApnsClientHandler apnsClientHandler = clientHandlerBuilder.build();
                            if (gracefulShutdownTimeoutMillis > 0L) {
                                apnsClientHandler.gracefulShutdownTimeoutMillis(gracefulShutdownTimeoutMillis);
                            }
                            pipeline.addLast(new ChannelHandler[]{new FlushConsolidationHandler(256, true)});
                            pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(idlePingIntervalMillis, 0L, 0L, TimeUnit.MILLISECONDS)});
                            pipeline.addLast(new ChannelHandler[]{apnsClientHandler});
                            pipeline.remove((ChannelHandler)ConnectionNegotiationErrorHandler.INSTANCE);
                            ((Promise)channel.attr(CHANNEL_READY_PROMISE_ATTRIBUTE_KEY).get()).trySuccess((Object)channel);
                        } else {
                            ApnsChannelFactory.tryFailureAndLogRejectedCause((Promise)channel.attr(CHANNEL_READY_PROMISE_ATTRIBUTE_KEY).get(), handshakeFuture.cause());
                        }
                    }
                });
                pipeline.addLast(new ChannelHandler[]{sslHandler});
                pipeline.addLast(new ChannelHandler[]{ConnectionNegotiationErrorHandler.INSTANCE});
            }
        });
    }

    @Override
    public Future<Channel> create(final Promise<Channel> channelReadyPromise) {
        final long delay = this.currentDelaySeconds.get();
        channelReadyPromise.addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

            public void operationComplete(Future<Channel> future) {
                long updatedDelay = future.isSuccess() ? 0L : Math.max(Math.min(delay * 2L, 60L), 1L);
                ApnsChannelFactory.this.currentDelaySeconds.compareAndSet(delay, updatedDelay);
            }
        });
        this.bootstrapTemplate.config().group().schedule(new Runnable(){

            @Override
            public void run() {
                Bootstrap bootstrap = (Bootstrap)ApnsChannelFactory.this.bootstrapTemplate.clone().channelFactory(new AugmentingReflectiveChannelFactory<SocketChannel, Promise>(ClientChannelClassUtil.getSocketChannelClass(ApnsChannelFactory.this.bootstrapTemplate.config().group()), CHANNEL_READY_PROMISE_ATTRIBUTE_KEY, channelReadyPromise));
                ChannelFuture connectFuture = bootstrap.connect();
                connectFuture.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                    public void operationComplete(ChannelFuture future) {
                        if (!future.isSuccess()) {
                            ApnsChannelFactory.tryFailureAndLogRejectedCause(channelReadyPromise, future.cause());
                        }
                    }
                });
                connectFuture.channel().closeFuture().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                    public void operationComplete(ChannelFuture future) {
                        channelReadyPromise.tryFailure((Throwable)new IllegalStateException("Channel closed before HTTP/2 preface completed."));
                    }
                });
            }
        }, delay, TimeUnit.SECONDS);
        return channelReadyPromise;
    }

    @Override
    public Future<Void> destroy(Channel channel, Promise<Void> promise) {
        channel.close().addListener((GenericFutureListener)new PromiseNotifier(new Promise[]{promise}));
        return promise;
    }

    @Override
    public void close() {
        this.addressResolverGroup.close();
        if (this.sslContext instanceof ReferenceCounted && this.hasReleasedSslContext.compareAndSet(false, true)) {
            ((ReferenceCounted)this.sslContext).release();
        }
    }

    private static void tryFailureAndLogRejectedCause(Promise<?> promise, Throwable cause) {
        if (!promise.tryFailure(cause)) {
            log.warn("Tried to mark promise as \"failed,\" but it was already done.", cause);
        }
    }

    @ChannelHandler.Sharable
    private static class ConnectionNegotiationErrorHandler
    extends ChannelInboundHandlerAdapter {
        static final ConnectionNegotiationErrorHandler INSTANCE = new ConnectionNegotiationErrorHandler();

        private ConnectionNegotiationErrorHandler() {
        }

        public void exceptionCaught(ChannelHandlerContext context, Throwable cause) {
            ApnsChannelFactory.tryFailureAndLogRejectedCause((Promise)context.channel().attr(CHANNEL_READY_PROMISE_ATTRIBUTE_KEY).get(), cause);
        }
    }
}

