/*
 * Decompiled with CFR 0.152.
 */
package com.easylibs.utils;

import android.util.Log;
import com.easylibs.http.EasyHttp;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.Type;

public final class JsonUtils {
    private static final Gson M_GSON = new GsonBuilder().disableHtmlEscaping().create();

    public static String jsonify(Object object) {
        return M_GSON.toJson(object);
    }

    public static <T> T objectify(String string, Class<T> clazz) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        try {
            return (T)M_GSON.fromJson(string, clazz);
        }
        catch (Exception exception) {
            Log.e((String)EasyHttp.LOG_TAG, (String)("JsonUtils#objectify() Class " + clazz + ", Json: " + string), (Throwable)exception);
            return null;
        }
    }

    public static <T> T objectify(String string, Type type) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        try {
            return (T)M_GSON.fromJson(string, type);
        }
        catch (Exception exception) {
            Log.e((String)EasyHttp.LOG_TAG, (String)("JsonUtils#objectify() Type: " + type + ", Json: " + string), (Throwable)exception);
            return null;
        }
    }
}

