/*
 * Decompiled with CFR 0.152.
 */
package com.easylibs.http;

import android.content.Context;
import com.easylibs.http.EasyHttpResponse;
import com.easylibs.listener.EventListener;
import com.easylibs.utils.ContentType;
import com.easylibs.utils.JsonUtils;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.lang.ref.WeakReference;
import java.lang.reflect.Type;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

public class EasyHttpRequest<T> {
    private WeakReference<Context> contextWeakRef;
    private int httpMethod;
    private String url;
    private HashMap<String, String> headers;
    private String requestBody;
    private ContentType requestBodyContentType;
    private ContentType responseContentType;
    private Type responseType;
    private int socketTimeOutMs;
    private boolean setRetryCountCalled;
    private int retryCount;
    private boolean ignoreCached;
    private long cacheTtl;
    private boolean setCacheTtlCalled;
    private long cacheSoftTtl;
    private boolean refreshedResponseDeliveryRequired;
    private Object tag;
    private WeakReference<EventListener> eventListenerWeakRef;
    private int eventCode;

    public Context getContext() {
        return this.contextWeakRef == null ? null : (Context)this.contextWeakRef.get();
    }

    public void setContext(Context context) {
        this.contextWeakRef = new WeakReference<Context>(context);
    }

    public int getHttpMethod() {
        switch (this.httpMethod) {
            case 1: 
            case 2: {
                return this.httpMethod;
            }
        }
        return this.requestBody == null ? 1 : 2;
    }

    public void setHttpMethod(int n) {
        this.httpMethod = n;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String string) {
        this.url = string;
    }

    public HashMap<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(HashMap<String, String> hashMap) {
        this.headers = hashMap;
    }

    @Deprecated
    public void setPostObject(Object object) {
        this.setJsonBody(object);
    }

    public void setJsonBody(Object object) {
        String string = object instanceof CharSequence || object instanceof JsonObject || object instanceof JSONObject || object instanceof JsonArray || object instanceof JSONArray ? object.toString() : JsonUtils.jsonify(object);
        this.setRequestBody(string, ContentType.JSON);
    }

    public void setRequestBody(String string, ContentType contentType) {
        this.requestBody = string;
        this.requestBodyContentType = contentType;
    }

    public String getRequestBody() {
        return this.requestBody;
    }

    public ContentType getRequestBodyContentType() {
        return this.requestBodyContentType;
    }

    public ContentType getResponseContentType() {
        return this.responseContentType;
    }

    public void setResponseContentType(ContentType contentType) {
        this.responseContentType = contentType;
    }

    public Type getResponseType() {
        return this.responseType;
    }

    public void setResponseType(Type type) {
        this.responseType = type;
    }

    public void setResponseType(Class<T> clazz) {
        this.responseType = clazz;
    }

    public int getSocketTimeOutMs() {
        return this.socketTimeOutMs;
    }

    public void setSocketTimeOutMs(int n) {
        this.socketTimeOutMs = n;
    }

    public int getRetryCount() {
        if (!this.setRetryCountCalled) {
            return this.getHttpMethod() == 1 ? 1 : 0;
        }
        return this.retryCount;
    }

    public void setRetryCount(int n) {
        this.setRetryCountCalled = true;
        this.retryCount = n;
    }

    public boolean isIgnoreCached() {
        return this.ignoreCached;
    }

    public void setIgnoreCached(boolean bl) {
        this.ignoreCached = bl;
    }

    public long getCacheTtl() {
        if (!this.setCacheTtlCalled) {
            return this.getHttpMethod() == 1 ? 0L : -1L;
        }
        return this.cacheTtl;
    }

    public void setCacheTtl(long l) {
        this.setCacheTtlCalled = true;
        this.cacheTtl = l;
    }

    public long getCacheSoftTtl() {
        return this.cacheSoftTtl;
    }

    public void setCacheSoftTtl(long l) {
        this.setCacheSoftTtl(l, false);
    }

    public void setCacheSoftTtl(long l, boolean bl) {
        this.cacheSoftTtl = l;
        this.refreshedResponseDeliveryRequired = bl;
    }

    public Object getTag() {
        return this.tag;
    }

    public void setTag(Object object) {
        this.tag = object;
    }

    public void setEventCode(int n) {
        this.eventCode = n;
    }

    public void setEventListener(EventListener eventListener) {
        this.eventListenerWeakRef = new WeakReference<EventListener>(eventListener);
    }

    public void onResponse(EasyHttpResponse<T> easyHttpResponse) {
        if (this.eventListenerWeakRef == null) {
            return;
        }
        EventListener eventListener = (EventListener)this.eventListenerWeakRef.get();
        if (eventListener != null) {
            easyHttpResponse.setEasyHttpRequest(this);
            eventListener.onEvent(this.eventCode, easyHttpResponse);
            if (!this.refreshedResponseDeliveryRequired) {
                this.eventListenerWeakRef = null;
            }
        }
    }

    public static class Method {
        public static final int GET = 1;
        public static final int POST = 2;
    }
}

