/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.sub.vlms.main;

import android.content.Context;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.easefun.polyvsdk.sub.auxilliary.CheckThrows;
import com.easefun.polyvsdk.sub.auxilliary.RetrofitHelper;
import com.easefun.polyvsdk.sub.auxilliary.cache.auxiliary.Md5Util;
import com.easefun.polyvsdk.sub.vlms.listener.PolyvVlmsApiListener;
import java.util.HashMap;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;

public class PolyvVlmsManager {
    public PolyvVlmsManager(Context context) {
        RetrofitHelper.init(context);
    }

    private String generateAccessTokenSign(String api_id, String school_id, long timestamp, String key) {
        return this.generateAccessTokenSign(api_id, null, school_id, timestamp, key);
    }

    private String generateAccessTokenSign(String api_id, String refresh_token, String school_id, long timestamp, String key) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("api_id=").append(api_id);
        if (!TextUtils.isEmpty((CharSequence)refresh_token)) {
            stringBuilder.append("&refresh_token=").append(refresh_token);
        }
        stringBuilder.append("&school_id=").append(school_id).append("&timestamp=").append(timestamp).append("&key=").append(key);
        return Md5Util.getMd5(stringBuilder.toString()).toUpperCase();
    }

    @Nullable
    public Call<ResponseBody> getAccessToken(String api_id, String school_id, String key, PolyvVlmsApiListener.GetAccessTokenListener listener) {
        try {
            return this.getAccessToken_t(api_id, school_id, key, listener);
        }
        catch (Exception e) {
            if (listener != null) {
                listener.fail(e);
            }
            return null;
        }
    }

    public Call<ResponseBody> getAccessToken_t(String api_id, String school_id, String key, PolyvVlmsApiListener.GetAccessTokenListener listener) throws Exception {
        CheckThrows.checkNotNull("api_id", api_id);
        CheckThrows.checkNotNull("school_id", school_id);
        CheckThrows.checkNotNull("key", key);
        long timestamp = System.currentTimeMillis();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("api_id", api_id);
        map.put("school_id", school_id);
        map.put("timestamp", timestamp);
        map.put("sign", this.generateAccessTokenSign(api_id, school_id, timestamp, key));
        Call<ResponseBody> getAccessTokenCall = RetrofitHelper.getPolyvVlmsApi().getAccessToken(map);
        getAccessTokenCall.enqueue((Callback)new PolyvVlmsApiListener.GetAccessTokenCallback(listener));
        return getAccessTokenCall;
    }

    public Call<ResponseBody> refreshAccessToken(String api_id, String refresh_token, String school_id, String key, PolyvVlmsApiListener.GetAccessTokenListener listener) {
        try {
            return this.refreshAccessToken_t(api_id, refresh_token, school_id, key, listener);
        }
        catch (Exception e) {
            if (listener != null) {
                listener.fail(e);
            }
            return null;
        }
    }

    public Call<ResponseBody> refreshAccessToken_t(String api_id, String refresh_token, String school_id, String key, PolyvVlmsApiListener.GetAccessTokenListener listener) throws Exception {
        CheckThrows.checkNotNull("api_id", api_id);
        CheckThrows.checkNotNull("refresh_token", refresh_token);
        CheckThrows.checkNotNull("school_id", school_id);
        CheckThrows.checkNotNull("key", key);
        long timestamp = System.currentTimeMillis();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("api_id", api_id);
        map.put("refresh_token", refresh_token);
        map.put("school_id", school_id);
        map.put("timestamp", timestamp);
        map.put("sign", this.generateAccessTokenSign(api_id, refresh_token, school_id, timestamp, key));
        Call<ResponseBody> refreshAccessTokenCall = RetrofitHelper.getPolyvVlmsApi().refreshAccessToken(map);
        refreshAccessTokenCall.enqueue((Callback)new PolyvVlmsApiListener.GetAccessTokenCallback(listener));
        return refreshAccessTokenCall;
    }

    public Call<ResponseBody> getCourses(String school_id, int page, int page_size, String access_token, PolyvVlmsApiListener.GetCoursesListener listener) {
        return this.getCourses(school_id, null, null, null, page, page_size, access_token, listener);
    }

    public Call<ResponseBody> getCourses(String school_id, String category_id, String is_free, String type, int page, int page_size, String access_token, PolyvVlmsApiListener.GetCoursesListener listener) {
        try {
            return this.getCourses_t(school_id, category_id, is_free, type, page, page_size, access_token, listener);
        }
        catch (Exception e) {
            if (listener != null) {
                listener.fail(e);
            }
            return null;
        }
    }

    public Call<ResponseBody> getCourses_t(String school_id, String category_id, String is_free, String type, int page, int page_size, String access_token, PolyvVlmsApiListener.GetCoursesListener listener) throws Exception {
        CheckThrows.checkNotNull("school_id", school_id);
        CheckThrows.checkRange_lessequal0("page", page);
        CheckThrows.checkRange_lessequal0("page_size", page_size);
        CheckThrows.checkNotNull("access_token", access_token);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("school_id", school_id);
        if (category_id != null) {
            map.put("category_id", category_id);
        }
        if (is_free != null) {
            map.put("is_free", is_free);
        }
        if (type != null) {
            map.put("type", type);
        }
        map.put("page", page);
        map.put("page_size", page_size);
        map.put("access_token", access_token);
        Call<ResponseBody> getCoursesCall = RetrofitHelper.getPolyvVlmsApi().getCourses(map);
        getCoursesCall.enqueue((Callback)new PolyvVlmsApiListener.GetCoursesCallback(listener));
        return null;
    }

    public Call<ResponseBody> getCourseDetail(String school_id, String courseId, String access_token, PolyvVlmsApiListener.GetCourseDetailListener listener) {
        return this.getCourseDetail(school_id, courseId, null, access_token, listener);
    }

    public Call<ResponseBody> getCourseDetail(String school_id, String courseId, String is_detail, String access_token, PolyvVlmsApiListener.GetCourseDetailListener listener) {
        try {
            return this.getCourseDetail_t(school_id, courseId, is_detail, access_token, listener);
        }
        catch (Exception e) {
            if (listener != null) {
                listener.fail(e);
            }
            return null;
        }
    }

    public Call<ResponseBody> getCourseDetail_t(String school_id, String courseId, String is_detail, String access_token, PolyvVlmsApiListener.GetCourseDetailListener listener) throws Exception {
        CheckThrows.checkNotNull("school_id", school_id);
        CheckThrows.checkNotNull("courseId", courseId);
        CheckThrows.checkNotNull("access_token", access_token);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("school_id", school_id);
        if (is_detail != null) {
            map.put("is_detail", is_detail);
        }
        map.put("access_token", access_token);
        Call<ResponseBody> getCourseDetailCall = RetrofitHelper.getPolyvVlmsApi().getCourseDetail(courseId, map);
        getCourseDetailCall.enqueue((Callback)new PolyvVlmsApiListener.GetCourseDetailCallback(listener));
        return getCourseDetailCall;
    }

    public Call<ResponseBody> login(String school_id, String account, String password, String access_token, PolyvVlmsApiListener.LoginListener listener) {
        try {
            return this.login_t(school_id, account, password, access_token, listener);
        }
        catch (Exception e) {
            if (listener != null) {
                listener.fail(e);
            }
            return null;
        }
    }

    public Call<ResponseBody> login_t(String school_id, String account, String password, String access_token, PolyvVlmsApiListener.LoginListener listener) throws Exception {
        CheckThrows.checkNotNull("school_id", school_id);
        CheckThrows.checkNotNull("account", account);
        CheckThrows.checkNotNull("password", password);
        CheckThrows.checkNotNull("access_token", access_token);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("school_id", school_id);
        map.put("account", account);
        map.put("password", password);
        map.put("access_token", access_token);
        Call<ResponseBody> loginCall = RetrofitHelper.getPolyvVlmsApi().login(map);
        loginCall.enqueue((Callback)new PolyvVlmsApiListener.LoginCallback(listener));
        return loginCall;
    }

    public Call<ResponseBody> getCurriculum(String school_id, String course_id, String access_token, PolyvVlmsApiListener.GetCurriculumListener listener) {
        return this.getCurriculum(school_id, course_id, null, access_token, listener);
    }

    public Call<ResponseBody> getCurriculum(String school_id, String course_id, String user_id, String access_token, PolyvVlmsApiListener.GetCurriculumListener listener) {
        try {
            return this.getCurriculum_t(school_id, course_id, user_id, access_token, listener);
        }
        catch (Exception e) {
            if (listener != null) {
                listener.fail(e);
            }
            return null;
        }
    }

    public Call<ResponseBody> getCurriculum_t(String school_id, String course_id, String user_id, String access_token, PolyvVlmsApiListener.GetCurriculumListener listener) throws Exception {
        CheckThrows.checkNotNull("school_id", school_id);
        CheckThrows.checkNotNull("course_id", course_id);
        CheckThrows.checkNotNull("access_token", access_token);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("school_id", school_id);
        map.put("course_id", course_id);
        if (user_id != null) {
            map.put("user_id", user_id);
        }
        map.put("access_token", access_token);
        Call<ResponseBody> getCurriculumCall = RetrofitHelper.getPolyvVlmsApi().getCurriculum(map);
        getCurriculumCall.enqueue((Callback)new PolyvVlmsApiListener.GetCurriculumCallback(listener));
        return getCurriculumCall;
    }

    public Call<ResponseBody> addOrder(String school_id, String user_id, String course_id, String payment_type, String access_token, PolyvVlmsApiListener.AddOrderListener listener) {
        return this.addOrder(school_id, user_id, course_id, payment_type, null, access_token, listener);
    }

    public Call<ResponseBody> addOrder(String school_id, String user_id, String course_id, String payment_type, String trading_note, String access_token, PolyvVlmsApiListener.AddOrderListener listener) {
        try {
            return this.addOrder_t(school_id, user_id, course_id, payment_type, trading_note, access_token, listener);
        }
        catch (Exception e) {
            if (listener != null) {
                listener.fail(e);
            }
            return null;
        }
    }

    public Call<ResponseBody> addOrder_t(String school_id, String user_id, String course_id, String payment_type, String trading_note, String access_token, PolyvVlmsApiListener.AddOrderListener listener) throws Exception {
        CheckThrows.checkNotNull("school_id", school_id);
        CheckThrows.checkNotNull("user_id", user_id);
        CheckThrows.checkNotNull("course_id", course_id);
        CheckThrows.checkNotNull("payment_type", payment_type);
        CheckThrows.checkNotNull("access_token", access_token);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("school_id", school_id);
        map.put("user_id", user_id);
        map.put("course_id", course_id);
        map.put("payment_type", payment_type);
        if (trading_note != null) {
            map.put("trading_note", trading_note);
        }
        map.put("access_token", access_token);
        Call<ResponseBody> addOrderCall = RetrofitHelper.getPolyvVlmsApi().addOrder(map);
        addOrderCall.enqueue((Callback)new PolyvVlmsApiListener.AddOrderCallback(listener));
        return addOrderCall;
    }

    public Call<ResponseBody> getQuestion(String school_id, String course_id, String access_token, PolyvVlmsApiListener.GetQuestionListener listener) {
        try {
            return this.getQuestion_t(school_id, course_id, access_token, listener);
        }
        catch (Exception e) {
            if (listener != null) {
                listener.fail(e);
            }
            return null;
        }
    }

    public Call<ResponseBody> getQuestion_t(String school_id, String course_id, String access_token, PolyvVlmsApiListener.GetQuestionListener listener) throws Exception {
        CheckThrows.checkNotNull("school_id", school_id);
        CheckThrows.checkNotNull("course_id", course_id);
        CheckThrows.checkNotNull("access_token", access_token);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("school_id", school_id);
        map.put("course_id", course_id);
        map.put("access_token", access_token);
        Call<ResponseBody> getQuestionCall = RetrofitHelper.getPolyvVlmsApi().getQuestion(map);
        getQuestionCall.enqueue((Callback)new PolyvVlmsApiListener.GetQuestionCallback(listener));
        return getQuestionCall;
    }

    public Call<ResponseBody> getAnswer(String school_id, String question_id, String access_token, PolyvVlmsApiListener.GetAnswerListener listener) {
        try {
            return this.getAnswer_t(school_id, question_id, access_token, listener);
        }
        catch (Exception e) {
            if (listener != null) {
                listener.fail(e);
            }
            return null;
        }
    }

    public Call<ResponseBody> getAnswer_t(String school_id, String question_id, String access_token, PolyvVlmsApiListener.GetAnswerListener listener) throws Exception {
        CheckThrows.checkNotNull("school_id", school_id);
        CheckThrows.checkNotNull("question_id", question_id);
        CheckThrows.checkNotNull("access_token", access_token);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("school_id", school_id);
        map.put("question_id", question_id);
        map.put("access_token", access_token);
        Call<ResponseBody> getAnswerCall = RetrofitHelper.getPolyvVlmsApi().getAnswer(map);
        getAnswerCall.enqueue((Callback)new PolyvVlmsApiListener.GetAnswerCallback(listener));
        return getAnswerCall;
    }

    public Call<ResponseBody> addNewQuestion(String school_id, String course_id, String user_id, String title, String content, String access_token, PolyvVlmsApiListener.AddNewQuestionListener listener) {
        try {
            return this.addNewQuestion_t(school_id, course_id, user_id, title, content, access_token, listener);
        }
        catch (Exception e) {
            if (listener != null) {
                listener.fail(e);
            }
            return null;
        }
    }

    public Call<ResponseBody> addNewQuestion_t(String school_id, String course_id, String user_id, String title, String content, String access_token, PolyvVlmsApiListener.AddNewQuestionListener listener) throws Exception {
        CheckThrows.checkNotNull("school_id", school_id);
        CheckThrows.checkNotNull("course_id", course_id);
        CheckThrows.checkNotNull("user_id", user_id);
        CheckThrows.checkNotNull("title", title);
        CheckThrows.checkNotNull("content", content);
        CheckThrows.checkNotNull("access_token", access_token);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("school_id", school_id);
        map.put("course_id", course_id);
        map.put("user_id", user_id);
        map.put("title", title);
        map.put("content", content);
        map.put("access_token", access_token);
        Call<ResponseBody> addNewQuestionCall = RetrofitHelper.getPolyvVlmsApi().addNewQuestion(map);
        addNewQuestionCall.enqueue((Callback)new PolyvVlmsApiListener.AddNewQuestionCallback(listener));
        return addNewQuestionCall;
    }

    public Call<ResponseBody> addNewAnswer(String school_id, String course_id, String question_id, String user_id, String content, String access_token, PolyvVlmsApiListener.AddNewAnswerListener listener) {
        try {
            return this.addNewAnswer_t(school_id, course_id, question_id, user_id, content, access_token, listener);
        }
        catch (Exception e) {
            if (listener != null) {
                listener.fail(e);
            }
            return null;
        }
    }

    public Call<ResponseBody> addNewAnswer_t(String school_id, String course_id, String question_id, String user_id, String content, String access_token, PolyvVlmsApiListener.AddNewAnswerListener listener) throws Exception {
        CheckThrows.checkNotNull("school_id", school_id);
        CheckThrows.checkNotNull("course_id", course_id);
        CheckThrows.checkNotNull("question_id", question_id);
        CheckThrows.checkNotNull("user_id", user_id);
        CheckThrows.checkNotNull("content", content);
        CheckThrows.checkNotNull("access_token", access_token);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("school_id", school_id);
        map.put("course_id", course_id);
        map.put("question_id", question_id);
        map.put("user_id", user_id);
        map.put("content", content);
        map.put("access_token", access_token);
        Call<ResponseBody> addNewAnswerCall = RetrofitHelper.getPolyvVlmsApi().addNewAnswer(map);
        addNewAnswerCall.enqueue((Callback)new PolyvVlmsApiListener.AddNewAnswerCallback(listener));
        return addNewAnswerCall;
    }
}

