/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.sub.screenshot;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.support.annotation.Nullable;
import com.easefun.polyvsdk.sub.auxilliary.CheckThrows;
import com.easefun.polyvsdk.sub.auxilliary.IOUtil;
import com.easefun.polyvsdk.sub.auxilliary.MediaData;
import com.easefun.polyvsdk.sub.auxilliary.RetrofitHelper;
import com.easefun.polyvsdk.sub.auxilliary.SDCardUtil;
import com.easefun.polyvsdk.sub.auxilliary.cache.auxiliary.Md5Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class PolyvScreenShot {
    private static final String SNAPSHOT_STR = "polyvsnapshot";
    private Context context;

    public PolyvScreenShot(Context context) {
        this.context = context.getApplicationContext();
        RetrofitHelper.init(context);
    }

    public Call<ResponseBody> snapshot(String vid, int bitrate, int currenttime_second, ScreenshotListener listener) {
        return this.snapshot(vid, bitrate, currenttime_second, listener, SDCardUtil.createPath(this.context, SNAPSHOT_STR));
    }

    public Call<ResponseBody> snapshot(String vid, int bitrate, int currenttime_second, ScreenshotListener listener, String savePath) {
        return this.snapshot(vid, bitrate, currenttime_second, listener, savePath, false);
    }

    @Nullable
    public Call<ResponseBody> snapshot(String vid, int bitrate, int currenttime_second, ScreenshotListener listener, String savePath, boolean updateToMediaDatabase) {
        try {
            return this.snapshot_t(vid, bitrate, currenttime_second, listener, savePath, updateToMediaDatabase);
        }
        catch (Exception e) {
            if (listener != null) {
                listener.fail(e);
            }
            return null;
        }
    }

    public Call<ResponseBody> snapshot_t(String vid, int bitrate, int currenttime_second, ScreenshotListener listener, String savePath, boolean updateToMediaDatabase) throws Exception {
        CheckThrows.checkNotNull("vid", vid);
        CheckThrows.checkRange_lessequal0("bitrate", bitrate);
        CheckThrows.checkRange_less0("currenttime_second", currenttime_second);
        CheckThrows.checkNotNull("savePath", savePath);
        CheckThrows.checkNotFile("savePath", savePath);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vid", vid);
        map.put("level", bitrate);
        map.put("second", currenttime_second);
        map.put("sign", Md5Util.getMd5(vid + bitrate + currenttime_second + SNAPSHOT_STR));
        Call<ResponseBody> screenshotCall = RetrofitHelper.getPolyvGoApi().screenshot(map);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(vid).append("_").append(new SimpleDateFormat("yyyy-MM-dd_kk:mm:ss").format(new Date())).append(".jpg");
        String filePath = new File(savePath, stringBuilder.toString()).getAbsolutePath();
        screenshotCall.enqueue((Callback)new ScreenshotCallBack(updateToMediaDatabase, filePath, listener));
        return screenshotCall;
    }

    public static interface ScreenshotListener {
        public void fail(Throwable var1);

        public void success(String var1);
    }

    public class ScreenshotCallBack
    implements Callback<ResponseBody> {
        private boolean update;
        private String filePath;
        private ScreenshotListener listener;

        public ScreenshotCallBack(boolean update, String filePath, ScreenshotListener listener) {
            this.update = update;
            this.filePath = filePath;
            this.listener = listener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
            int code = response.code();
            if (code != 200 && code != 206) {
                this.onFailure(call, new Exception("response code is " + code));
                return;
            }
            FileOutputStream out = null;
            try {
                byte[] datas = ((ResponseBody)response.body()).bytes();
                Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])datas, (int)0, (int)datas.length);
                if (bitmap == null) {
                    this.onFailure(call, new Exception("decode data fail, bitmap is null"));
                    IOUtil.closeIO(out);
                    return;
                }
                out = new FileOutputStream(this.filePath);
                boolean result = bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
                if (!result) {
                    this.onFailure(call, new Exception("bitmap compress fail"));
                    IOUtil.closeIO(out);
                    return;
                }
                if (this.listener != null) {
                    this.listener.success(this.filePath);
                }
                if (this.update) {
                    MediaData.updateToMediaDatabase(PolyvScreenShot.this.context, this.filePath);
                }
                IOUtil.closeIO(out);
                return;
            }
            catch (FileNotFoundException e) {
                this.onFailure(call, e);
                return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                catch (IOException e2) {
                    this.onFailure(call, e2);
                    return;
                }
            }
            finally {
                IOUtil.closeIO(out);
            }
        }

        public void onFailure(Call<ResponseBody> call, Throwable t) {
            if (this.listener != null) {
                this.listener.fail(t);
            }
        }
    }
}

