/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.sub.danmaku.main;

import android.content.Context;
import android.support.annotation.IntRange;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.easefun.polyvsdk.sub.auxilliary.CheckThrows;
import com.easefun.polyvsdk.sub.auxilliary.LogUtil;
import com.easefun.polyvsdk.sub.auxilliary.RetrofitHelper;
import com.easefun.polyvsdk.sub.danmaku.auxiliary.BiliDanmukuParser;
import com.easefun.polyvsdk.sub.danmaku.auxiliary.BilibiliDanmakuTransfer;
import com.easefun.polyvsdk.sub.danmaku.entity.PolyvDanmakuEntity;
import com.easefun.polyvsdk.sub.danmaku.entity.PolyvDanmakuInfo;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import master.flame.danmaku.danmaku.loader.ILoader;
import master.flame.danmaku.danmaku.loader.IllegalDataException;
import master.flame.danmaku.danmaku.loader.android.DanmakuLoaderFactory;
import master.flame.danmaku.danmaku.model.android.Danmakus;
import master.flame.danmaku.danmaku.parser.BaseDanmakuParser;
import master.flame.danmaku.danmaku.parser.IDataSource;
import okhttp3.ResponseBody;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class PolyvDanmakuManager {
    public PolyvDanmakuManager(Context context) {
        RetrofitHelper.init(context);
    }

    public Call<ResponseBody> sendDanmaku(@NonNull PolyvDanmakuInfo danmakuInfo, SendDanmakuListener sendDanmakuListener) {
        try {
            return this.sendDanmaku_t(danmakuInfo, sendDanmakuListener);
        }
        catch (Exception e) {
            if (sendDanmakuListener != null) {
                sendDanmakuListener.fail(e);
            }
            return null;
        }
    }

    @Nullable
    public Call<ResponseBody> sendDanmaku_t(@NonNull PolyvDanmakuInfo danmakuInfo, SendDanmakuListener sendDanmakuListener) throws Exception {
        CheckThrows.checkNotNull("danmakuInfo", danmakuInfo);
        CheckThrows.checkNotNull("danmakuInfo.vid", danmakuInfo.vid);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vid", danmakuInfo.vid);
        map.put("msg", danmakuInfo.getMsg());
        map.put("time", danmakuInfo.getTime());
        map.put("fontSize", danmakuInfo.getFontSize());
        map.put("fontMode", danmakuInfo.getFontMode());
        map.put("fontColor,", danmakuInfo.getFontColor());
        Call<ResponseBody> sendCall = RetrofitHelper.getPolyvGoApi().sendDanmaku(map);
        sendCall.enqueue((Callback)new SendDanmakuCallBack(sendDanmakuListener));
        return sendCall;
    }

    public Call<List<PolyvDanmakuInfo>> getAllDanmaku(@NonNull String vid, GetDanmakuListener listener) {
        return this.getDanmaku(vid, 0, listener);
    }

    @Nullable
    public Call<List<PolyvDanmakuInfo>> getDanmaku(@NonNull String vid, @IntRange(from=1L) int limit, GetDanmakuListener listener) {
        try {
            return this.getDanmaku_t(vid, limit, listener);
        }
        catch (Exception e) {
            if (listener != null) {
                listener.fail(e);
            }
            return null;
        }
    }

    public Call<List<PolyvDanmakuInfo>> getDanmaku_t(@NonNull String vid, @IntRange(from=1L) int limit, GetDanmakuListener listener) throws Exception {
        CheckThrows.checkNotNull("vid", vid);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vid", vid);
        if (limit > 0) {
            map.put("limit", limit);
        }
        Call<List<PolyvDanmakuInfo>> getCall = RetrofitHelper.getPolyvGoApi().getDanmaku(map);
        getCall.enqueue((Callback)new GetDanmakuCallBack(listener));
        return getCall;
    }

    private static BaseDanmakuParser createParser(InputStream stream) {
        if (stream == null) {
            return new BaseDanmakuParser(){

                protected Danmakus parse() {
                    return new Danmakus();
                }
            };
        }
        ILoader loader = DanmakuLoaderFactory.create((String)DanmakuLoaderFactory.TAG_BILI);
        try {
            loader.load(stream);
        }
        catch (IllegalDataException e) {
            LogUtil.w("createParser", e);
        }
        BiliDanmukuParser parser = new BiliDanmukuParser();
        IDataSource dataSource = loader.getDataSource();
        parser.load(dataSource);
        return parser;
    }

    public static BaseDanmakuParser createParser(PolyvDanmakuEntity entity) {
        try {
            return PolyvDanmakuManager.createParser(BilibiliDanmakuTransfer.transferToInputStream(entity.getAllDanmaku()));
        }
        catch (IOException e) {
            return new BaseDanmakuParser(){

                protected Danmakus parse() {
                    return new Danmakus();
                }
            };
        }
    }

    public static interface SendDanmakuListener {
        public void fail(Throwable var1);

        public void success(String var1);
    }

    public static interface GetDanmakuListener {
        public void fail(Throwable var1);

        public void success(BaseDanmakuParser var1, PolyvDanmakuEntity var2);
    }

    public static class SendDanmakuCallBack
    implements Callback<ResponseBody> {
        SendDanmakuListener sendDanmakuListener;

        public SendDanmakuCallBack(SendDanmakuListener sendDanmakuListener) {
            this.sendDanmakuListener = sendDanmakuListener;
        }

        public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
            int code = response.code();
            if (code != 200 && code != 206) {
                this.onFailure(call, new Exception("response code is " + code));
                return;
            }
            try {
                if (this.sendDanmakuListener != null) {
                    this.sendDanmakuListener.success(((ResponseBody)response.body()).string());
                }
            }
            catch (IOException e) {
                this.onFailure(call, e);
            }
        }

        public void onFailure(Call<ResponseBody> call, Throwable t) {
            if (this.sendDanmakuListener != null) {
                this.sendDanmakuListener.fail(t);
            }
        }
    }

    public static class GetDanmakuCallBack
    implements Callback<List<PolyvDanmakuInfo>> {
        GetDanmakuListener getDanmakuListener;

        public GetDanmakuCallBack(GetDanmakuListener getDanmakuListener) {
            this.getDanmakuListener = getDanmakuListener;
        }

        public void onResponse(Call<List<PolyvDanmakuInfo>> call, Response<List<PolyvDanmakuInfo>> response) {
            int code = response.code();
            if (code != 200 && code != 206) {
                this.onFailure(call, new Exception("response code is " + code));
                return;
            }
            List ls_danmakuInfos = (List)response.body();
            PolyvDanmakuEntity danmakuEntity = new PolyvDanmakuEntity();
            danmakuEntity.setAllDanmaku(ls_danmakuInfos);
            try {
                if (this.getDanmakuListener != null) {
                    this.getDanmakuListener.success(PolyvDanmakuManager.createParser(BilibiliDanmakuTransfer.transferToInputStream(ls_danmakuInfos)), danmakuEntity);
                }
            }
            catch (IOException e) {
                this.onFailure(call, e);
            }
        }

        public void onFailure(Call<List<PolyvDanmakuInfo>> call, Throwable t) {
            if (this.getDanmakuListener != null) {
                this.getDanmakuListener.fail(t);
            }
        }
    }
}

