/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.sub.auxilliary.cache.image;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.util.LruCache;
import android.text.style.ImageSpan;
import com.easefun.polyvsdk.sub.auxilliary.IOUtil;
import com.easefun.polyvsdk.sub.auxilliary.LogUtil;
import com.easefun.polyvsdk.sub.auxilliary.SDCardUtil;
import com.easefun.polyvsdk.sub.auxilliary.cache.DiskLruCache;
import com.easefun.polyvsdk.sub.auxilliary.cache.auxiliary.AppHelper;
import com.easefun.polyvsdk.sub.auxilliary.cache.auxiliary.BitmapUtil;
import com.easefun.polyvsdk.sub.auxilliary.cache.auxiliary.Md5Util;
import com.easefun.polyvsdk.sub.auxilliary.cache.image.ImageData;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import pl.droidsonroids.gif.GifDrawable;
import pl.droidsonroids.gif.GifImageSpan;
import pl.droidsonroids.gif.RelativeImageSpan;

public class ImageLoader {
    private static ImageLoader imageLoader;
    private Handler mUIHandler;
    private List<String> urls;
    private Map<ImageLoaderListener, String> listeners;
    private LruCache<String, ImageData> mLruCache;
    private DiskLruCache diskCache;
    private static final int CACHE_MEMORY;
    private static final int DISK_CACHE_DEFAULT_SIZE = 0x1400000;
    private static final String DISK_CACHE_PATH = "vlms";
    private Thread mPoolThread;
    private Handler mPoolThreadHandler;
    private ExecutorService mThreadPool;
    private int mThreadCount;
    private Type mType = Type.LIFO;
    private LinkedList<Runnable> mTaskQueue;
    private Semaphore mSemaphorePoolThreadHandler = new Semaphore(0);
    private Semaphore mSemaphoreThreadPool;

    private ImageLoader(Context context, int threadCount, Type type, String cachePath, long fileCacheSize, long memoryCacheSize) {
        type = type == null ? Type.LIFO : type;
        this.init(context, threadCount, type, cachePath, fileCacheSize, memoryCacheSize);
        this.urls = new ArrayList<String>();
        this.listeners = new HashMap<ImageLoaderListener, String>();
        this.mUIHandler = new Handler(){

            public void handleMessage(Message msg) {
                HandlerData data = (HandlerData)msg.obj;
                if (data.t != null) {
                    data.listener.fail(data.t);
                } else if (data.imageData != null) {
                    data.listener.success(data.imageData, data.urlStr);
                } else {
                    data.listener.fail(new Exception("imagedata is null"));
                }
            }
        };
    }

    public static ImageLoader getInstance(Context context, int threadCount, Type type) {
        return ImageLoader.getInstance(context, threadCount, type, DISK_CACHE_PATH, 0x1400000L, CACHE_MEMORY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ImageLoader getInstance(Context context, int threadCount, Type type, String cachePath, long fileCacheSize, long memoryCacheSize) {
        if (imageLoader != null) return imageLoader;
        Class<ImageLoader> clazz = ImageLoader.class;
        synchronized (ImageLoader.class) {
            if (imageLoader != null) return imageLoader;
            imageLoader = new ImageLoader(context, threadCount, type, cachePath, fileCacheSize, memoryCacheSize);
            // ** MonitorExit[var8_6] (shouldn't be in output)
            return imageLoader;
        }
    }

    private void init(Context context, int threadCount, Type type, String filePath, long fileCacheSize, long memoryCacheSize) {
        this.initBackThread();
        this.mLruCache = new LruCache<String, ImageData>((int)memoryCacheSize){

            protected int sizeOf(String key, ImageData imageData) {
                return (int)imageData.getLength();
            }
        };
        try {
            File cacheDir = SDCardUtil.getDiskCacheDir(context, filePath);
            if (!cacheDir.exists()) {
                cacheDir.mkdirs();
            }
            this.diskCache = DiskLruCache.open(cacheDir, AppHelper.getVersionCode(context), 1, fileCacheSize);
        }
        catch (IOException e) {
            LogUtil.w("init", e);
        }
        this.mThreadPool = Executors.newFixedThreadPool(threadCount);
        this.mTaskQueue = new LinkedList();
        this.mType = type;
        this.mThreadCount = threadCount;
        this.mSemaphoreThreadPool = new Semaphore(threadCount);
    }

    @Deprecated
    public LruCache<String, ImageData> getLruCache() {
        return this.mLruCache;
    }

    @Deprecated
    public DiskLruCache getDiskCache() {
        return this.diskCache;
    }

    @Deprecated
    public ExecutorService getExecutorService() {
        return this.mThreadPool;
    }

    private void initBackThread() {
        this.mPoolThread = new Thread(){

            @Override
            public void run() {
                Looper.prepare();
                ImageLoader.this.mPoolThreadHandler = new Handler(){

                    public void handleMessage(Message msg) {
                        if (!ImageLoader.this.mThreadPool.isShutdown()) {
                            ImageLoader.this.mThreadPool.execute(ImageLoader.this.getTask());
                        }
                        try {
                            ImageLoader.this.mSemaphoreThreadPool.acquire();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                };
                ImageLoader.this.mSemaphorePoolThreadHandler.release();
                Looper.loop();
            }
        };
        this.mPoolThread.start();
    }

    public void release() {
        this.shutdownNow();
        this.clearLruCache();
    }

    public void shutdownNow() {
        this.mThreadPool.shutdownNow();
        this.mTaskQueue.clear();
        this.urls.clear();
        this.listeners.clear();
        this.mThreadPool = Executors.newFixedThreadPool(this.mThreadCount);
        this.mSemaphoreThreadPool.release(this.mThreadCount);
    }

    public void clearLruCache() {
        this.mLruCache.evictAll();
    }

    private synchronized Runnable getTask() {
        if (this.mTaskQueue.size() > 0) {
            if (this.mType == Type.FIFO) {
                return this.mTaskQueue.removeFirst();
            }
            if (this.mType == Type.LIFO) {
                return this.mTaskQueue.removeLast();
            }
        }
        return null;
    }

    private synchronized void addTask(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        this.mTaskQueue.add(runnable);
        try {
            if (this.mPoolThreadHandler == null) {
                this.mSemaphorePoolThreadHandler.acquire();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.mPoolThreadHandler.sendEmptyMessage(291);
    }

    private ImageData getBitmapFromLruCache(String urlStr) {
        return (ImageData)this.mLruCache.get((Object)urlStr);
    }

    @TargetApi(value=12)
    private void addBitmapToLruCache(String urlStr, ImageData imageData) {
        if (this.getBitmapFromLruCache(urlStr) == null && imageData != null) {
            this.mLruCache.put((Object)urlStr, (Object)imageData);
        }
    }

    public ImageData start(@NonNull Context context, @NonNull int[] wh, @NonNull String urlStr, @NonNull ImageLoaderListener listener) {
        ImageData imageData = this.getBitmapFromLruCache(urlStr);
        if (imageData == null) {
            this.addTask(this.buildTalk(context, wh, urlStr, listener));
        }
        return imageData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initTask(String urlStr, ImageLoaderListener listener) {
        Class<ImageLoader> clazz = ImageLoader.class;
        synchronized (ImageLoader.class) {
            if (this.urls.contains(urlStr)) {
                this.listeners.put(listener, urlStr);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return false;
            }
            this.urls.add(urlStr);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return true;
        }
    }

    private void successHandler(ImageData imageData, String urlStr, ImageLoaderListener listener) {
        if (listener != null) {
            HandlerData handlerData = new HandlerData();
            handlerData.listener = listener;
            handlerData.imageData = imageData;
            handlerData.urlStr = urlStr;
            Message message = this.mUIHandler.obtainMessage();
            message.obj = handlerData;
            this.mUIHandler.sendMessage(message);
        }
    }

    private void failHandler(Throwable t, String urlStr, ImageLoaderListener listener) {
        if (listener != null) {
            HandlerData handlerData = new HandlerData();
            handlerData.listener = listener;
            handlerData.t = t;
            handlerData.urlStr = urlStr;
            Message message = this.mUIHandler.obtainMessage();
            message.obj = handlerData;
            this.mUIHandler.sendMessage(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishTask(ImageData imageData, String urlStr, ImageLoaderListener listener) {
        Class<ImageLoader> clazz = ImageLoader.class;
        synchronized (ImageLoader.class) {
            this.urls.remove(urlStr);
            this.successHandler(imageData, urlStr, listener);
            this.addBitmapToLruCache(urlStr, imageData);
            if (this.listeners.size() > 0) {
                ArrayList<ImageLoaderListener> removeListeners = new ArrayList<ImageLoaderListener>();
                for (ImageLoaderListener waitListener : this.listeners.keySet()) {
                    String waitUrl = this.listeners.get(waitListener);
                    if (!urlStr.equals(waitUrl)) continue;
                    this.successHandler(imageData, urlStr, waitListener);
                    removeListeners.add(waitListener);
                }
                for (ImageLoaderListener removeListener : removeListeners) {
                    this.listeners.remove(removeListener);
                }
            }
            this.mSemaphoreThreadPool.release();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failTask(Throwable t, String urlStr, ImageLoaderListener listener) {
        Class<ImageLoader> clazz = ImageLoader.class;
        synchronized (ImageLoader.class) {
            this.urls.remove(urlStr);
            this.failHandler(t, urlStr, listener);
            if (this.listeners.size() > 0) {
                ArrayList<ImageLoaderListener> removeListeners = new ArrayList<ImageLoaderListener>();
                for (ImageLoaderListener waitListener : this.listeners.keySet()) {
                    String waitUrl = this.listeners.get(waitListener);
                    if (!urlStr.equals(waitUrl)) continue;
                    this.failHandler(t, urlStr, listener);
                    removeListeners.add(waitListener);
                }
                for (ImageLoaderListener removeListener : removeListeners) {
                    this.listeners.remove(removeListener);
                }
            }
            this.mSemaphoreThreadPool.release();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private Runnable buildTalk(final Context context, final int[] wh, final String urlStr, final ImageLoaderListener listener) {
        if (!this.initTask(urlStr, listener)) {
            return null;
        }
        return new Runnable(){

            @Override
            public void run() {
                String key = Md5Util.hashKeyForDisk(urlStr);
                try {
                    DiskLruCache.Snapshot snapShot = ImageLoader.this.diskCache.get(key);
                    if (snapShot != null) {
                        ImageLoader.this.finishTask(ImageLoader.this.generateImageData(context, urlStr, wh), urlStr, listener);
                        return;
                    }
                }
                catch (IOException e) {
                    LogUtil.w("buildTalk", e);
                }
                try {
                    DiskLruCache.Editor editor = ImageLoader.this.diskCache.edit(key);
                    if (editor != null) {
                        if (ImageLoader.this.downloadUrlToStream(urlStr, editor) && !ImageLoader.this.diskCache.isClosed()) {
                            editor.commit();
                        } else if (!ImageLoader.this.diskCache.isClosed()) {
                            editor.abort();
                            ImageLoader.this.diskCache.flush();
                            ImageLoader.this.failTask(new Exception("downloadUrlToStream is fail"), urlStr, listener);
                            return;
                        }
                        if (!ImageLoader.this.diskCache.isClosed()) {
                            ImageLoader.this.diskCache.flush();
                        }
                        ImageLoader.this.finishTask(ImageLoader.this.generateImageData(context, urlStr, wh), urlStr, listener);
                    } else {
                        ImageLoader.this.failTask(new Exception("editor is null"), urlStr, listener);
                    }
                }
                catch (IOException e) {
                    ImageLoader.this.failTask(e, urlStr, listener);
                }
                catch (IllegalStateException e) {
                    ImageLoader.this.failTask(e, urlStr, listener);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean downloadUrlToStream(String urlStr, DiskLruCache.Editor editor) {
        boolean bl;
        WritableByteChannel wbc = null;
        ReadableByteChannel rbc = null;
        try {
            wbc = Channels.newChannel(editor.newOutputStream(0));
            HttpURLConnection conn = (HttpURLConnection)new URL(urlStr).openConnection();
            rbc = Channels.newChannel(conn.getInputStream());
            ByteBuffer bb = ByteBuffer.allocate(1024);
            while (rbc.read(bb) != -1) {
                bb.flip();
                wbc.write(bb);
                bb.clear();
            }
            bl = true;
        }
        catch (IOException e) {
            try {
                LogUtil.w("downloadUrlToStream", e);
            }
            catch (Throwable throwable) {
                IOUtil.closeIO(wbc);
                IOUtil.closeIO(rbc);
                throw throwable;
            }
            IOUtil.closeIO(wbc);
            IOUtil.closeIO(rbc);
            return false;
        }
        IOUtil.closeIO(wbc);
        IOUtil.closeIO(rbc);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=12)
    private ImageData generateImageData(Context context, String urlStr, int[] wh) {
        block22: {
            ImageData imageData;
            String key = Md5Util.hashKeyForDisk(urlStr);
            DiskLruCache.Snapshot snapShot = null;
            try {
                snapShot = this.diskCache.get(key);
            }
            catch (IOException e) {
                LogUtil.w("generateImageData", e);
                return null;
            }
            BufferedInputStream bis = null;
            try {
                if (snapShot == null) break block22;
                GifDrawable drawable = null;
                long length = 0L;
                bis = new BufferedInputStream(snapShot.getInputStream(0));
                if (urlStr.toLowerCase().endsWith(".gif")) {
                    byte[] buf = new byte[bis.available() + 1];
                    bis.read(buf);
                    drawable = new GifDrawable(buf);
                    length = drawable.getFrameByteCount();
                } else {
                    Bitmap bitmap = BitmapUtil.decodeSampledBitmapFromInputStream(bis, wh[0], wh[1]);
                    if (bitmap == null || context == null) {
                        ImageData imageData2 = null;
                        return imageData2;
                    }
                    length = bitmap.getByteCount();
                    drawable = new BitmapDrawable(context.getResources(), bitmap);
                }
                drawable.setBounds(0, 0, wh[0], wh[1]);
                imageData = new ImageData((Drawable)drawable, length);
            }
            catch (IOException e) {
                LogUtil.w("generateImageData", e);
                break block22;
            }
            finally {
                if (bis != null) {
                    try {
                        bis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return imageData;
        }
        return null;
    }

    public static ImageSpan toImageSpan(Drawable drawable, String urlStr, int verticalAlignment) {
        return urlStr.toLowerCase().endsWith(".gif") ? new GifImageSpan(drawable, verticalAlignment) : new RelativeImageSpan(drawable, verticalAlignment);
    }

    static {
        CACHE_MEMORY = (int)(Runtime.getRuntime().maxMemory() / 8L);
    }

    public static interface ImageLoaderListener {
        public void fail(Throwable var1);

        public void success(ImageData var1, String var2);
    }

    private class HandlerData {
        @NonNull
        ImageLoaderListener listener;
        Throwable t;
        ImageData imageData;
        String urlStr;

        private HandlerData() {
        }
    }

    public static enum Type {
        FIFO,
        LIFO;

    }
}

