/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.screenshot;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.media.MediaScannerConnection;
import com.easefun.polyvsdk.PolyvDevMountInfo;
import com.easefun.polyvsdk.PolyvSDKClient;
import com.easefun.polyvsdk.Video;
import com.easefun.polyvsdk.ijk.IjkVideoView;
import com.easefun.polyvsdk.screenshot.ScreenshotException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;

@Deprecated
public class PolyvScreenshot
implements ScreenshotException {
    private static final String SCREENSHOTDIR = "/polyvscreenshot";
    private static final String URLPATH = "http://go.polyv.net/snapshot/videoimage.php";
    private String savePath;
    private long currentPosition;
    private ScreenshotListener screenshotListener;
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] DIGITS_UPPER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public void setSavePath(String savePath) {
        this.savePath = savePath;
    }

    public void setScreenshotListener(ScreenshotListener screenshotListener) {
        this.screenshotListener = screenshotListener;
    }

    private void callFail(int category) {
        if (this.screenshotListener != null) {
            this.screenshotListener.fail(category);
        }
    }

    private void callSuccess(String filepath) {
        if (this.screenshotListener != null) {
            this.screenshotListener.success(filepath);
        }
    }

    public static byte[] md5(String data) {
        return PolyvScreenshot.md5(PolyvScreenshot.getBytesUtf8(data));
    }

    public static byte[] getBytesUtf8(String string) {
        return PolyvScreenshot.getBytes(string, Charset.forName("UTF-8"));
    }

    private static byte[] getBytes(String string, Charset charset) {
        return string == null ? null : string.getBytes(charset);
    }

    public static byte[] md5(byte[] data) {
        return PolyvScreenshot.getMd5Digest().digest(data);
    }

    public static MessageDigest getMd5Digest() {
        return PolyvScreenshot.getDigest("MD5");
    }

    public static MessageDigest getDigest(String algorithm) {
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException var2) {
            throw new IllegalArgumentException(var2);
        }
    }

    public static char[] encodeHex(byte[] data) {
        return PolyvScreenshot.encodeHex(data, true);
    }

    public static char[] encodeHex(byte[] data, boolean toLowerCase) {
        return PolyvScreenshot.encodeHex(data, toLowerCase ? DIGITS_LOWER : DIGITS_UPPER);
    }

    protected static char[] encodeHex(byte[] data, char[] toDigits) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = toDigits[(0xF0 & data[i]) >>> 4];
            out[j++] = toDigits[0xF & data[i]];
        }
        return out;
    }

    private byte[] getBytes(InputStream is) throws IOException {
        ByteArrayOutputStream outstream = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        int len = -1;
        while ((len = is.read(buffer)) != -1) {
            outstream.write(buffer, 0, len);
        }
        outstream.close();
        return outstream.toByteArray();
    }

    public void screenshot(IjkVideoView ijkVideoView, final Context context, final boolean isupdate) {
        int position = ijkVideoView.getCurrentPosition();
        Video.HlsSpeedType hlsSpeedType = ijkVideoView.getHlsSpeedType();
        long max = (long)Math.floor((double)ijkVideoView.getDuration() / 1000.0);
        this.currentPosition = Math.round((double)position / 1000.0);
        if (hlsSpeedType == Video.HlsSpeedType.SPEED_1_5X) {
            this.currentPosition = (long)((double)this.currentPosition * 1.5);
        }
        if (this.currentPosition > max && hlsSpeedType != Video.HlsSpeedType.SPEED_1_5X) {
            this.currentPosition = max;
        }
        StringBuilder sb = new StringBuilder();
        Video video = ijkVideoView.getVideo();
        if (video == null) {
            this.callFail(5);
            return;
        }
        final String vid = video.getVid();
        final int dfNum = video.getDfNum();
        sb.append(vid).append(dfNum).append(this.currentPosition).append("polyvsnapshot");
        final String sign = new String(PolyvScreenshot.encodeHex(PolyvScreenshot.md5(sb.toString())));
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                FileOutputStream fos = null;
                StringBuilder sb1 = new StringBuilder();
                sb1.append("?vid=").append(vid).append("&level=").append(dfNum).append("&second=").append(PolyvScreenshot.this.currentPosition).append("&sign=").append(sign);
                try {
                    URL url = new URL(PolyvScreenshot.URLPATH + sb1.toString());
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setConnectTimeout(30000);
                    conn.setReadTimeout(15000);
                    conn.setRequestMethod("GET");
                    if (conn.getResponseCode() == 200) {
                        File ssDirFile;
                        byte[] datas = PolyvScreenshot.this.getBytes(conn.getInputStream());
                        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])datas, (int)0, (int)datas.length);
                        if (bitmap == null) {
                            PolyvScreenshot.this.callFail(6);
                            return;
                        }
                        if (PolyvScreenshot.this.savePath == null) {
                            File downloadDir = PolyvSDKClient.getInstance().getDownloadDir();
                            PolyvDevMountInfo.getInstance().mkdirs(downloadDir);
                            String downloadStr = downloadDir.getAbsolutePath();
                            String ssDir = downloadStr.substring(0, downloadStr.lastIndexOf("/")) + PolyvScreenshot.SCREENSHOTDIR;
                            PolyvScreenshot.this.savePath = ssDir;
                        }
                        if (!(ssDirFile = new File(PolyvScreenshot.this.savePath)).exists()) {
                            ssDirFile.mkdirs();
                        }
                        StringBuilder sb2 = new StringBuilder();
                        sb2.append("polyv_").append(vid).append("_").append(new SimpleDateFormat("yyyyMMddkkmmss").format(new Date())).append(".jpg");
                        fos = new FileOutputStream(new File(PolyvScreenshot.this.savePath, sb2.toString()));
                        boolean result = bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)fos);
                        File ssFile = new File(PolyvScreenshot.this.savePath, sb2.toString());
                        if (ssFile.exists() && ssFile.length() == 0L || !result) {
                            PolyvScreenshot.this.callFail(3);
                            return;
                        }
                        String filepath = PolyvScreenshot.this.savePath + "/" + sb2.toString();
                        PolyvScreenshot.this.callSuccess(filepath);
                        if (isupdate) {
                            MediaScannerConnection.scanFile((Context)context.getApplicationContext(), (String[])new String[]{filepath}, null, null);
                        }
                    } else {
                        PolyvScreenshot.this.callFail(4);
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    PolyvScreenshot.this.callFail(2);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    PolyvScreenshot.this.callFail(1);
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        }).start();
    }

    public static interface ScreenshotListener {
        public void fail(int var1);

        public void success(String var1);
    }
}

