/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.danmaku;

import com.easefun.polyvsdk.danmaku.DanmakuException;
import com.easefun.polyvsdk.danmaku.DanmakuInfo;
import com.easefun.polyvsdk.danmaku.DanmakuTool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DanmakuNewMsg
implements DanmakuException {
    private boolean isnewget;
    private DanmakuInfo serPreNewdanmaku;
    private NewMsgListener newMsgListener;

    public DanmakuNewMsg(DanmakuInfo serPreNewdanmaku) {
        this.serPreNewdanmaku = serPreNewdanmaku;
    }

    public void setNewMsgListener(NewMsgListener newMsgListener) {
        this.newMsgListener = newMsgListener;
    }

    private void callSuccess(List<DanmakuInfo> lists) {
        if (this.newMsgListener != null) {
            this.newMsgListener.success(lists);
        }
    }

    private void callFail(int category) {
        if (this.newMsgListener != null) {
            this.newMsgListener.fail(category);
        }
    }

    public List<DanmakuInfo> getNewDanmaku(String vid, int limit) {
        this.isnewget = false;
        List<DanmakuInfo> newDanmaku = null;
        if (this.serPreNewdanmaku != null) {
            newDanmaku = this.getDanmakuList(this.getJson(vid, limit), vid, false);
            if (newDanmaku != null) {
                Collections.reverse(newDanmaku);
            }
            return newDanmaku;
        }
        newDanmaku = this.getDanmakuList(this.getJson(vid, limit), vid, true);
        if (newDanmaku != null) {
            Collections.reverse(newDanmaku);
        }
        return newDanmaku;
    }

    private List<DanmakuInfo> getDanmakuList(String json, String vid, boolean isnull) {
        if (json == null) {
            this.callFail(1);
            return null;
        }
        if (json.equals("")) {
            this.callFail(3);
            return null;
        }
        if (json.equals(" ")) {
            this.callFail(2);
            return null;
        }
        ArrayList<DanmakuInfo> lists = new ArrayList<DanmakuInfo>();
        try {
            JSONArray jsonArray = new JSONArray(json);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = (JSONObject)jsonArray.opt(i);
                String time = jsonObject.getString("time");
                String fontMode = jsonObject.getString("fontMode");
                String fontSize = jsonObject.getString("fontSize");
                String fontColor = jsonObject.getString("fontColor");
                String msg = jsonObject.getString("msg");
                String timestamp = jsonObject.getString("timestamp");
                time = DanmakuTool.timeToSecond(time);
                fontMode = DanmakuTool.fontModeToCanResolve(fontMode) + "";
                fontColor = DanmakuTool.fontColorToCanResolve(fontColor);
                DanmakuInfo danmaku = new DanmakuInfo(vid, msg, time, Integer.parseInt(fontSize), fontMode, Integer.parseInt(fontColor), timestamp, "1", "1");
                if (!this.isnewget && isnull) {
                    this.serPreNewdanmaku = danmaku;
                    this.isnewget = !this.isnewget;
                } else if (danmaku.compareTo(this.serPreNewdanmaku) == 0) {
                    if (lists.size() != 0) break;
                    this.callFail(6);
                    return null;
                }
                lists.add(danmaku);
            }
            if (!isnull && lists.size() > 0) {
                this.serPreNewdanmaku = (DanmakuInfo)lists.get(0);
            }
            this.callSuccess(lists);
            return lists;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJson(final String vid, final int limit) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<String> future = executorService.submit(new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() {
                StringBuilder sb = new StringBuilder();
                sb.append("?vid=").append(vid);
                if (limit > 0) {
                    sb.append("&limit=").append(limit);
                }
                HttpURLConnection conn = null;
                try {
                    URL url = new URL("http://go.polyv.net/admin/printjson.php" + sb.toString());
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("GET");
                    conn.setConnectTimeout(30000);
                    if (conn.getResponseCode() == 200) {
                        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                        String json = null;
                        json = in.readLine();
                        if (json != null && json.length() > 2) {
                            String string = json;
                            return string;
                        }
                        String string = "";
                        return string;
                    }
                    String string = " ";
                    return string;
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    conn.disconnect();
                }
                return null;
            }
        });
        try {
            String string = future.get();
            return string;
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        finally {
            if (executorService != null) {
                executorService.shutdown();
            }
            executorService = null;
        }
        return null;
    }

    public static interface NewMsgListener {
        public void success(List<DanmakuInfo> var1);

        public void fail(int var1);
    }
}

