/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.danmaku;

import android.annotation.SuppressLint;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import com.easefun.polyvsdk.danmaku.BiliDanmukuParser;
import com.easefun.polyvsdk.danmaku.DanmakuException;
import com.easefun.polyvsdk.danmaku.DanmakuInfo;
import com.easefun.polyvsdk.danmaku.DanmakuTempMyself;
import com.easefun.polyvsdk.danmaku.DanmakuTool;
import com.easefun.polyvsdk.danmaku.DanmakuXmlSerializer;
import com.easefun.polyvsdk.ijk.IjkVideoView;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import master.flame.danmaku.controller.IDanmakuView;
import master.flame.danmaku.danmaku.loader.ILoader;
import master.flame.danmaku.danmaku.loader.IllegalDataException;
import master.flame.danmaku.danmaku.loader.android.DanmakuLoaderFactory;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.android.DanmakuContext;
import master.flame.danmaku.danmaku.model.android.Danmakus;
import master.flame.danmaku.danmaku.parser.BaseDanmakuParser;
import master.flame.danmaku.danmaku.parser.IDataSource;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Deprecated
public class DanmakuManager
implements DanmakuException {
    private static final String TAG = "DanmakuManager";
    private static final int SHOWNEWDANMAKU = 0;
    private static final int DELAYTIME = 5000;
    private String vid;
    private String msg;
    private String time;
    private int fontSize;
    private String fontMode;
    private int fontColor;
    private DanmakuInfo sendDanmaku;
    private List<DanmakuInfo> getDanmakus;
    private DanmakuInfo serPreNewDanmaku;
    private DanmakuInfo preNewdanmaku;
    private boolean isget;
    private Timer timer;
    private TimerTask timerTask;
    private List<DanmakuInfo> notshows;
    private IDanmakuView mDanmakuView;
    private BaseDanmakuParser mParser;
    private DanmakuContext mContext;
    private IjkVideoView videoView;
    private boolean isset;
    private boolean isshow;
    private boolean ishandleshow;
    @SuppressLint(value={"HandlerLeak"})
    private Handler handler = new Handler(){

        public void handleMessage(Message msg) {
            for (int i = 0; i < DanmakuManager.this.notshows.size(); ++i) {
                if (Integer.parseInt(((DanmakuInfo)DanmakuManager.this.notshows.get(i)).getTime()) != DanmakuManager.this.videoView.getCurrentPosition() / 1000) continue;
                if (DanmakuTempMyself.getTempDanmaku().size() == 0) {
                    DanmakuManager.this.setSendDanmaku((DanmakuInfo)DanmakuManager.this.notshows.get(i));
                    DanmakuManager.this.showDanmaku(DanmakuManager.this.mDanmakuView, DanmakuManager.this.mParser, DanmakuManager.this.mContext, false, true);
                    DanmakuManager.this.notshows.remove(i);
                    continue;
                }
                for (DanmakuInfo temp : DanmakuTempMyself.getTempDanmaku()) {
                    if (temp.getTimestamp().equals("1")) {
                        temp.setTimestamp(((DanmakuInfo)DanmakuManager.this.notshows.get(i)).getTimestamp());
                    }
                    if (((DanmakuInfo)DanmakuManager.this.notshows.get(i)).compareTo(temp) == 0) {
                        DanmakuTempMyself.removeTempDanmaku(temp);
                        DanmakuManager.this.notshows.remove(i);
                        DanmakuManager.this.ishandleshow = false;
                        break;
                    }
                    DanmakuManager.this.ishandleshow = true;
                }
                if (!DanmakuManager.this.ishandleshow) continue;
                DanmakuManager.this.setSendDanmaku((DanmakuInfo)DanmakuManager.this.notshows.get(i));
                DanmakuManager.this.showDanmaku(DanmakuManager.this.mDanmakuView, DanmakuManager.this.mParser, DanmakuManager.this.mContext, false, true);
                DanmakuManager.this.notshows.remove(i);
            }
            if (DanmakuManager.this.notshows.size() == 0) {
                DanmakuManager.this.handler.removeMessages(0);
            } else {
                DanmakuManager.this.handler.sendEmptyMessageDelayed(0, 1000L);
            }
        }
    };
    private SendDanmakuListener sendDanmakuListener;
    private GetDanmakuListener getDanmakuListener;

    public void release() {
        DanmakuTempMyself.clearTempDanmaku();
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.handler.removeMessages(0);
    }

    public DanmakuInfo getSerPreNewDanmaku() {
        return this.serPreNewDanmaku;
    }

    public void setSendDanmaku(DanmakuInfo sendDanmaku) {
        this.sendDanmaku = sendDanmaku;
        this.vid = sendDanmaku.getVid();
        this.msg = sendDanmaku.getMsg();
        this.time = sendDanmaku.getTime();
        this.fontSize = sendDanmaku.getFontSize();
        this.fontMode = sendDanmaku.getFontMode();
        this.fontColor = sendDanmaku.getFontColor();
    }

    public void setSendDanmakuListener(SendDanmakuListener sendDanmakuListener) {
        this.sendDanmakuListener = sendDanmakuListener;
    }

    private void callFail(int category) {
        if (this.sendDanmakuListener != null) {
            this.sendDanmakuListener.fail(category);
        }
    }

    private void callSuccess() {
        if (this.sendDanmakuListener != null) {
            this.sendDanmakuListener.success();
        }
    }

    public void setGetDanmakuListener(GetDanmakuListener getDanmakuListener) {
        this.getDanmakuListener = getDanmakuListener;
    }

    private void callFail_get(int category) {
        if (this.getDanmakuListener != null) {
            this.getDanmakuListener.fail(category);
        }
    }

    private void callSuccess_get(int total, List<DanmakuInfo> getDanmakus) {
        if (this.getDanmakuListener != null) {
            this.getDanmakuListener.success(total, getDanmakus);
        }
    }

    public void getNewDanmakuAndShow(final String vid, final int limit, int milliseconds, final IDanmakuView mDanmakuView, final BaseDanmakuParser mParser, final DanmakuContext mContext, final IjkVideoView videoView) {
        this.timer = new Timer(true);
        this.timerTask = new TimerTask(){

            @Override
            public void run() {
                List danmakuInfos;
                if (!DanmakuManager.this.isset) {
                    if (vid == null || mDanmakuView == null || mParser == null || mContext == null || videoView == null) {
                        return;
                    }
                    DanmakuManager.this.mDanmakuView = mDanmakuView;
                    DanmakuManager.this.mParser = mParser;
                    DanmakuManager.this.mContext = mContext;
                    DanmakuManager.this.videoView = videoView;
                    DanmakuManager.this.isset = !DanmakuManager.this.isset;
                }
                if ((danmakuInfos = DanmakuManager.this.getNewDanmaku(vid, limit)) != null) {
                    for (DanmakuInfo danmakuInfo : danmakuInfos) {
                        if (Integer.parseInt(danmakuInfo.getTime()) == videoView.getCurrentPosition() / 1000) {
                            if (DanmakuTempMyself.getTempDanmaku().size() == 0) {
                                DanmakuManager.this.setSendDanmaku(danmakuInfo);
                                DanmakuManager.this.showDanmaku(mDanmakuView, mParser, mContext, false, true);
                                continue;
                            }
                            for (DanmakuInfo temp : DanmakuTempMyself.getTempDanmaku()) {
                                if (temp.getTimestamp().equals("1")) {
                                    temp.setTimestamp(danmakuInfo.getTimestamp());
                                }
                                if (danmakuInfo.compareTo(temp) == 0) {
                                    DanmakuTempMyself.removeTempDanmaku(temp);
                                    DanmakuManager.this.isshow = false;
                                    break;
                                }
                                DanmakuManager.this.isshow = true;
                            }
                            if (!DanmakuManager.this.isshow) continue;
                            DanmakuManager.this.setSendDanmaku(danmakuInfo);
                            DanmakuManager.this.showDanmaku(mDanmakuView, mParser, mContext, false, true);
                            continue;
                        }
                        DanmakuManager.this.notshows.add(danmakuInfo);
                        DanmakuManager.this.handler.sendEmptyMessage(0);
                    }
                }
            }
        };
        this.notshows = new ArrayList<DanmakuInfo>();
        this.timer.schedule(this.timerTask, 5000L, (long)milliseconds);
    }

    public void getNewDanmakuAndShow(String vid, int milliseconds, IDanmakuView mDanmakuView, BaseDanmakuParser mParser, DanmakuContext mContext, IjkVideoView videoView) {
        this.getNewDanmakuAndShow(vid, 0, milliseconds, mDanmakuView, mParser, mContext, videoView);
    }

    private List<DanmakuInfo> getNewDanmaku(String vid, int limit) {
        this.isget = false;
        if (this.preNewdanmaku != null) {
            return this.getDanmakuList(this.getJson(vid, limit), vid, false);
        }
        return this.getDanmakuList(this.getJson(vid, limit), vid, true);
    }

    public BaseDanmakuParser getBaseDanmakuParser(InputStream stream) {
        if (stream == null) {
            return new BaseDanmakuParser(){

                protected Danmakus parse() {
                    return new Danmakus();
                }
            };
        }
        ILoader loader = DanmakuLoaderFactory.create((String)DanmakuLoaderFactory.TAG_BILI);
        try {
            loader.load(stream);
        }
        catch (IllegalDataException e) {
            e.printStackTrace();
        }
        BiliDanmukuParser parser = new BiliDanmukuParser();
        IDataSource dataSource = loader.getDataSource();
        parser.load(dataSource);
        return parser;
    }

    public void showDanmaku(IDanmakuView mDanmakuView, BaseDanmakuParser mParser, DanmakuContext mContext, boolean hasunderlineColor, boolean ignoremode) {
        if (this.sendDanmaku == null) {
            return;
        }
        if (this.msg == null || this.msg.trim().equals("")) {
            return;
        }
        if (this.fontSize != 16 && this.fontSize != 18 && this.fontSize != 24) {
            this.fontSize = 18;
        }
        if ((this.fontColor | 0xFF000000) > -1 || (this.fontColor | 0xFF000000) < -16777216) {
            this.fontColor = -1;
        }
        if (ignoremode) {
            int mode = Integer.parseInt(this.fontMode);
            switch (mode) {
                case 1: {
                    this.fontMode = "roll";
                    break;
                }
                case 5: {
                    this.fontMode = "top";
                    break;
                }
                case 4: {
                    this.fontMode = "bottom";
                }
            }
        } else if (this.fontMode == null || !this.fontMode.equals("top") && !this.fontMode.equals("bottom") && !this.fontMode.equals("roll")) {
            this.fontMode = "roll";
        }
        if (mDanmakuView != null && mParser != null && mContext != null) {
            BaseDanmaku danmaku = mContext.mDanmakuFactory.createDanmaku(DanmakuTool.fontModeToCanResolve(this.fontMode));
            danmaku.padding = 0;
            danmaku.borderColor = 0;
            danmaku.underlineColor = hasunderlineColor ? -16711936 : 0;
            this.showBaseDanmaku(mDanmakuView, mParser, danmaku);
        } else {
            Log.e((String)TAG, (String)"mDanmakuView\u6216mParser\u6216mContext\u4e3anull");
        }
    }

    public void showDanmaku(IDanmakuView mDanmakuView, BaseDanmakuParser mParser, DanmakuContext mContext) {
        this.showDanmaku(mDanmakuView, mParser, mContext, true, false);
    }

    private void showBaseDanmaku(IDanmakuView mDanmakuView, BaseDanmakuParser mParser, BaseDanmaku danmaku) {
        if (this.msg.contains("\n")) {
            String[] msgs = this.msg.split("\n");
            danmaku.lines = msgs;
        } else if (this.msg.contains("\\n")) {
            if (!this.msg.contains("\\\\n")) {
                String[] msgs = this.msg.split("\\\\n");
                danmaku.lines = msgs;
            } else {
                int index = -1;
                String nmsg = this.msg;
                char[] arr = this.msg.toCharArray();
                while ((index = nmsg.indexOf("\\\\n")) != -1) {
                    nmsg = nmsg.substring(index + 3);
                    int length = nmsg.length();
                    for (int i = 1; i <= this.msg.length() - length; ++i) {
                        nmsg = "0" + nmsg;
                    }
                    arr[index] = 47;
                    arr[index + 1] = 47;
                    arr[index + 2] = 110;
                }
                String rmsg = new String(arr);
                if (rmsg.contains("\\n")) {
                    String[] msgs = rmsg.split("\\\\n");
                    for (int i = 0; i < msgs.length; ++i) {
                        if (!msgs[i].contains("//n")) continue;
                        msgs[i] = msgs[i].replace("//n", "\\n");
                    }
                    danmaku.lines = msgs;
                } else {
                    danmaku.text = rmsg.replace("//n", "\\n");
                }
            }
        } else {
            danmaku.text = this.msg;
        }
        danmaku.isLive = false;
        danmaku.priority = 1;
        danmaku.setTime(mDanmakuView.getCurrentTime() + 200L);
        danmaku.textSize = (float)this.fontSize * (mParser.getDisplayer().getDensity() - 0.6f);
        danmaku.textColor = this.fontColor;
        danmaku.textShadowColor = this.fontColor != -16777216 ? -16777216 : -1;
        mDanmakuView.addDanmaku(danmaku);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getJson(final String vid, int limit) {
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<String> future = executorService.submit(new Callable<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String call() {
                StringBuilder sb = new StringBuilder();
                sb.append("?vid=").append(vid);
                HttpURLConnection conn = null;
                try {
                    URL url = new URL("http://go.polyv.net/admin/printjson.php" + sb.toString());
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("GET");
                    conn.setConnectTimeout(30000);
                    if (conn.getResponseCode() == 200) {
                        BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                        String json = null;
                        json = in.readLine();
                        if (json != null && json.length() > 2) {
                            String string = json;
                            return string;
                        }
                        String string = "";
                        return string;
                    }
                    String string = " ";
                    return string;
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    conn.disconnect();
                }
                return null;
            }
        });
        try {
            String string = future.get();
            return string;
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        finally {
            if (executorService != null) {
                executorService.shutdown();
            }
            executorService = null;
        }
        return null;
    }

    public InputStream getDanmakuByServer(String vid, int limit) {
        return this.parseJson(this.getJson(vid, limit), vid, limit);
    }

    public InputStream getDanmakuByServer(String vid) {
        return this.getDanmakuByServer(vid, 0);
    }

    private List<DanmakuInfo> getDanmakuList(String json, String vid, boolean isnull) {
        if (json == null || json.equals("") || json.equals(" ")) {
            return null;
        }
        ArrayList<DanmakuInfo> lists = new ArrayList<DanmakuInfo>();
        try {
            JSONArray jsonArray = new JSONArray(json);
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = (JSONObject)jsonArray.opt(i);
                String time = jsonObject.getString("time");
                String fontMode = jsonObject.getString("fontMode");
                String fontSize = jsonObject.getString("fontSize");
                String fontColor = jsonObject.getString("fontColor");
                String msg = jsonObject.getString("msg");
                String timestamp = jsonObject.getString("timestamp");
                time = DanmakuTool.timeToSecond(time);
                fontMode = DanmakuTool.fontModeToCanResolve(fontMode) + "";
                fontColor = DanmakuTool.fontColorToCanResolve(fontColor);
                DanmakuInfo danmaku = new DanmakuInfo(vid, msg, time, Integer.parseInt(fontSize), fontMode, Integer.parseInt(fontColor), timestamp, "1", "1");
                if (!this.isget && isnull) {
                    this.preNewdanmaku = danmaku;
                    this.isget = !this.isget;
                } else if (danmaku.compareTo(this.preNewdanmaku) == 0) {
                    if (lists.size() != 0) break;
                    return null;
                }
                lists.add(danmaku);
            }
            if (!isnull && lists.size() > 0) {
                this.preNewdanmaku = (DanmakuInfo)lists.get(0);
            }
            return lists;
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    private InputStream parseJson(String json, String vid, int limit) {
        if (json == null) {
            this.callFail_get(1);
            return null;
        }
        if (json.equals("")) {
            this.callFail_get(3);
            return null;
        }
        if (json.equals(" ")) {
            this.callFail_get(2);
            return null;
        }
        Log.i((String)TAG, (String)json);
        DanmakuXmlSerializer xmlSerializer = new DanmakuXmlSerializer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            xmlSerializer.setOutput(baos, "utf-8");
            xmlSerializer.startDocument("utf-8", true);
            xmlSerializer.startTag(null, "i").startTag(null, "chatserver").text("www.polyv.com").endTag(null, "chatserver").startTag(null, "chatid").text("123456").endTag(null, "chatid").startTag(null, "mission").text("0").endTag(null, "mission").startTag(null, "maxlimit").text(limit + "").endTag(null, "maxlimit").startTag(null, "source").text("k-v").endTag(null, "source");
            JSONArray jsonArray = new JSONArray(json);
            int limitNum = 0;
            limitNum = jsonArray.length() > limit ? limit : jsonArray.length();
            this.getDanmakus = new ArrayList<DanmakuInfo>();
            for (int i = 0; i < limitNum; ++i) {
                JSONObject jsonObject = (JSONObject)jsonArray.opt(i);
                String time = jsonObject.getString("time");
                String fontMode = jsonObject.getString("fontMode");
                String fontSize = jsonObject.getString("fontSize");
                String fontColor = jsonObject.getString("fontColor");
                String msg = jsonObject.getString("msg");
                String timestamp = jsonObject.getString("timestamp");
                time = DanmakuTool.timeToSecond(time);
                fontMode = DanmakuTool.fontModeToCanResolve(fontMode) + "";
                fontColor = DanmakuTool.fontColorToCanResolve(fontColor);
                DanmakuInfo danmaku = new DanmakuInfo(vid, msg, time, Integer.parseInt(fontSize), fontMode, Integer.parseInt(fontColor), timestamp, "1", "1");
                this.getDanmakus.add(danmaku);
                if (!this.isget) {
                    this.preNewdanmaku = danmaku;
                    this.serPreNewDanmaku = danmaku;
                    this.isget = !this.isget;
                }
                xmlSerializer.startTag(null, "d");
                xmlSerializer.attribute(null, "p", danmaku.toString());
                xmlSerializer.text(msg);
                xmlSerializer.endTag(null, "d");
            }
            xmlSerializer.endTag(null, "i");
            xmlSerializer.endDocument();
            Log.i((String)TAG, (String)baos.toString());
            Collections.reverse(this.getDanmakus);
            this.callSuccess_get(jsonArray.length(), this.getDanmakus);
            return new ByteArrayInputStream(baos.toByteArray());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalStateException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void sendDanmakuToServer() {
        if (this.sendDanmaku == null) {
            this.callFail(4);
            return;
        }
        if (this.vid == null || this.vid.equals("") || this.msg == null || this.msg.trim().equals("") || !this.time.matches("[0-9][0-9]:[0-5][0-9]:[0-5][0-9]")) {
            this.callFail(5);
            return;
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                StringBuilder sb = new StringBuilder();
                PrintWriter out = null;
                HttpURLConnection conn = null;
                try {
                    sb.append("vid=").append(DanmakuManager.this.vid).append("&msg=").append(URLEncoder.encode(DanmakuManager.this.msg, "UTF-8")).append("&time=").append(DanmakuManager.this.time);
                    if (DanmakuManager.this.fontSize != 16 && DanmakuManager.this.fontSize != 18 && DanmakuManager.this.fontSize != 24) {
                        sb.append("&fontSize=").append(18);
                    } else {
                        sb.append("&fontSize=").append(DanmakuManager.this.fontSize);
                    }
                    if (DanmakuManager.this.fontMode == null || !DanmakuManager.this.fontMode.equals("top") && !DanmakuManager.this.fontMode.equals("bottom") && !DanmakuManager.this.fontMode.equals("roll")) {
                        sb.append("&fontMode=").append("roll");
                    } else {
                        sb.append("&fontMode=").append(DanmakuManager.this.fontMode);
                    }
                    if ((DanmakuManager.this.fontColor | 0xFF000000) > -1 || (DanmakuManager.this.fontColor | 0xFF000000) < -16777216) {
                        sb.append("&fontColor=").append(DanmakuTool.fontColorToRGB(-1));
                    } else {
                        sb.append("&fontColor=").append(DanmakuTool.fontColorToRGB(DanmakuManager.this.fontColor));
                    }
                    URL url = new URL("http://go.polyv.net/admin/add.php");
                    conn = (HttpURLConnection)url.openConnection();
                    conn.setDoOutput(true);
                    conn.setRequestMethod("POST");
                    conn.setConnectTimeout(30000);
                    out = new PrintWriter(conn.getOutputStream());
                    out.print(sb.toString());
                    out.flush();
                    if (conn.getResponseCode() == 200) {
                        DanmakuTempMyself.addTempDanmaku(DanmakuManager.this.sendDanmaku);
                        DanmakuManager.this.callSuccess();
                        String json = new BufferedReader(new InputStreamReader(conn.getInputStream())).readLine();
                        JSONObject jsonObject = new JSONObject(json);
                        String timestamp = jsonObject.getString("ts");
                        DanmakuTempMyself.getLastDanmaku().setTimestamp(timestamp);
                    } else {
                        DanmakuManager.this.callFail(2);
                    }
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    DanmakuManager.this.callFail(1);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                finally {
                    if (conn != null) {
                        conn.disconnect();
                    }
                    if (out != null) {
                        out.close();
                    }
                }
            }
        }).start();
    }

    public static interface GetDanmakuListener {
        public void fail(int var1);

        public void success(int var1, List<DanmakuInfo> var2);
    }

    public static interface SendDanmakuListener {
        public void fail(int var1);

        public void success();
    }
}

