/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.vo;

import android.support.annotation.NonNull;
import com.easefun.polyvsdk.QuestionVO;
import com.easefun.polyvsdk.vo.PolyvQuestionChoicesVO;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PolyvQuestionVO {
    public static final int TYPE_QUESTION = 0;
    public static final int TYPE_AUDITION = 1;
    private final String examId;
    private final String userId;
    private final String vid;
    private final String showTime;
    private final int hours;
    private final int minutes;
    private final int seconds;
    private final String question;
    private final List<QuestionVO.ChoicesVO> choicesList;
    private List<PolyvQuestionChoicesVO> choicesList2;
    private final String answer;
    private final boolean skip;
    private final int type;
    private final String mp3url;
    private final int wrongTime;
    private final int wrongShow;
    private final int status;
    private final long createdTime;
    private final boolean isFromDownload;

    public PolyvQuestionVO(String examId, String userId, String vid, String showTime, int hours, int minutes, int seconds, String question, List<QuestionVO.ChoicesVO> choicesList, String answer, boolean skip, int type, String mp3url, int wrongTime, int wrongShow, int status, long createdTime, boolean isFromDownload) {
        this.examId = examId;
        this.userId = userId;
        this.vid = vid;
        this.showTime = showTime;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.question = question;
        this.choicesList = choicesList;
        this.choicesList2 = this.toPolyvQuestionChoicesVOList(choicesList);
        this.answer = answer;
        this.skip = skip;
        this.type = type;
        this.mp3url = mp3url;
        this.wrongTime = wrongTime;
        this.wrongShow = wrongShow;
        this.status = status;
        this.createdTime = createdTime;
        this.isFromDownload = isFromDownload;
    }

    public String getExamId() {
        return this.examId;
    }

    public String getUserId() {
        return this.userId;
    }

    public String getVid() {
        return this.vid;
    }

    public String getShowTime() {
        return this.showTime;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public String getQuestion() {
        return this.question;
    }

    public List<QuestionVO.ChoicesVO> getChoicesList() {
        return this.choicesList;
    }

    public List<PolyvQuestionChoicesVO> getChoicesList2() {
        return this.choicesList2;
    }

    public String getAnswer() {
        return this.answer;
    }

    public boolean isSkip() {
        return this.skip;
    }

    public int getType() {
        return this.type;
    }

    public String getMp3url() {
        return this.mp3url;
    }

    public int getWrongTime() {
        return this.wrongTime;
    }

    public int getWrongShow() {
        return this.wrongShow;
    }

    public int getStatus() {
        return this.status;
    }

    public long getCreatedTime() {
        return this.createdTime;
    }

    public boolean isFromDownload() {
        return this.isFromDownload;
    }

    private List<PolyvQuestionChoicesVO> toPolyvQuestionChoicesVOList(List<QuestionVO.ChoicesVO> list) {
        ArrayList<PolyvQuestionChoicesVO> arrayList = new ArrayList<PolyvQuestionChoicesVO>(list.size());
        for (QuestionVO.ChoicesVO choicesVO : list) {
            arrayList.add(new PolyvQuestionChoicesVO(choicesVO.getAnswer(), choicesVO.getRightAnswer()));
        }
        return arrayList;
    }

    @NonNull
    public static List<PolyvQuestionVO> formatQuestion(@NonNull String body, boolean isFromDownload) throws JSONException {
        JSONArray jSONArray = new JSONArray(body);
        ArrayList<PolyvQuestionVO> arrayList = null;
        int n2 = 0;
        if (jSONArray != null && (n2 = jSONArray.length()) != 0) {
            arrayList = new ArrayList(n2);
            JSONObject jSONObject = null;
            JSONArray jSONArray2 = null;
            PolyvQuestionVO polyvQuestionVO = null;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3;
                String string;
                ArrayList<QuestionVO.ChoicesVO> arrayList2;
                jSONObject = jSONArray.getJSONObject(i2);
                String string2 = jSONObject.optString("examId", "");
                String string3 = jSONObject.optString("userid", "");
                String string4 = jSONObject.optString("videoPoolId", "");
                String string5 = jSONObject.optString("showTime", "");
                int n4 = jSONObject.optInt("hours", 0);
                int n5 = jSONObject.optInt("minutes", 0);
                int n6 = jSONObject.optInt("seconds", 0);
                String string6 = jSONObject.optString("question", "");
                jSONArray2 = new JSONArray(jSONObject.optString("choices"));
                int n7 = 0;
                if (jSONArray2 != null && (n7 = jSONArray2.length()) != 0) {
                    arrayList2 = new ArrayList(n7);
                    string = null;
                    QuestionVO.ChoicesVO choicesVO = null;
                    for (int i3 = 0; i3 < n7; ++i3) {
                        string = jSONArray2.getJSONObject(i3);
                        String string7 = string.optString("answer", "");
                        n3 = string.optInt("right_answer", 0);
                        choicesVO = new QuestionVO.ChoicesVO(string7, n3);
                        PolyvQuestionChoicesVO polyvQuestionChoicesVO = new PolyvQuestionChoicesVO(string7, n3);
                        arrayList2.add(choicesVO);
                    }
                } else {
                    arrayList2 = new ArrayList<QuestionVO.ChoicesVO>(0);
                }
                string = jSONObject.optString("answer", "");
                boolean bl = jSONObject.optBoolean("skip", true);
                int n8 = jSONObject.optInt("type", 0);
                String string8 = jSONObject.optString("mp3url", "");
                int n9 = jSONObject.optInt("wrongTime", -1);
                n3 = jSONObject.optInt("wrongShow", 0);
                int n10 = jSONObject.optInt("status", 0);
                long l2 = jSONObject.optLong("createdTime", 0L);
                polyvQuestionVO = new PolyvQuestionVO(string2, string3, string4, string5, n4, n5, n6, string6, arrayList2, string, bl, n8, string8, n9, n3, n10, l2, isFromDownload);
                arrayList.add(polyvQuestionVO);
            }
        } else {
            arrayList = new ArrayList<PolyvQuestionVO>(0);
        }
        return arrayList;
    }

    public static QuestionVO copyToQuestion(PolyvQuestionVO questionVO) {
        return new QuestionVO(questionVO.getExamId(), questionVO.getUserId(), questionVO.getVid(), questionVO.getShowTime(), questionVO.getHours(), questionVO.getMinutes(), questionVO.getSeconds(), questionVO.getQuestion(), questionVO.getChoicesList(), questionVO.getAnswer(), questionVO.isSkip(), questionVO.getType(), questionVO.getMp3url(), questionVO.getWrongTime(), questionVO.getWrongShow(), questionVO.getStatus(), questionVO.getCreatedTime(), questionVO.isFromDownload());
    }
}

