/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.video;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import com.easefun.polyvsdk.PolyvBitRate;
import com.easefun.polyvsdk.PolyvQOSAnalytics;
import com.easefun.polyvsdk.PolyvSDKClient;
import com.easefun.polyvsdk.PolyvSDKUtil;
import com.easefun.polyvsdk.Video;
import com.easefun.polyvsdk.database.video.VideoDatabaseService;
import com.easefun.polyvsdk.ijk.widget.media.IMediaController;
import com.easefun.polyvsdk.ijk.widget.media.IRenderView;
import com.easefun.polyvsdk.live.chat.IPolyvLiveInnerPPTView;
import com.easefun.polyvsdk.live.chat.IPolyvPPTView;
import com.easefun.polyvsdk.marquee.PolyvMarqueeItem;
import com.easefun.polyvsdk.marquee.PolyvMarqueeView;
import com.easefun.polyvsdk.srt.a;
import com.easefun.polyvsdk.util.PolyvDnsUtil;
import com.easefun.polyvsdk.util.e;
import com.easefun.polyvsdk.video.IPolyvIjkVideoView;
import com.easefun.polyvsdk.video.IPolyvVideoView;
import com.easefun.polyvsdk.video.PolyvBaseMediaController;
import com.easefun.polyvsdk.video.PolyvIjkVideoView;
import com.easefun.polyvsdk.video.PolyvVideoUtil;
import com.easefun.polyvsdk.video.PolyvVideoViewListenerEvent;
import com.easefun.polyvsdk.video.auxiliary.PolyvAuxiliaryVideoView;
import com.easefun.polyvsdk.video.b;
import com.easefun.polyvsdk.video.c;
import com.easefun.polyvsdk.video.d;
import com.easefun.polyvsdk.video.listener.IPolyvOnAdvertisementCountDownListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnAdvertisementEventListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnAdvertisementEventListener2;
import com.easefun.polyvsdk.video.listener.IPolyvOnAdvertisementOutListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnAdvertisementOutListener2;
import com.easefun.polyvsdk.video.listener.IPolyvOnAuxiliaryPlayEndListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnBufferingUpdateListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnCompletionListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnErrorListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnInfoListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnPreparedListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnQuestionAnswerTipsListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnQuestionOutListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnQuestionOutListener2;
import com.easefun.polyvsdk.video.listener.IPolyvOnRemindCallbackListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnSeekCompleteListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnTeaserCountDownListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnTeaserOutListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnVideoPlayErrorListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnVideoPlayErrorListener2;
import com.easefun.polyvsdk.video.listener.IPolyvOnVideoSRTListener;
import com.easefun.polyvsdk.video.listener.IPolyvOnVideoSizeChangedListener;
import com.easefun.polyvsdk.vo.PolyvVideoProgressVO;
import com.easefun.polyvsdk.vo.PolyvVideoVO;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.json.JSONException;
import org.json.JSONObject;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;

public class PolyvVideoView
extends PolyvVideoViewListenerEvent
implements IPolyvVideoView {
    private static final String TAG = PolyvVideoView.class.getSimpleName();
    private Context mContext = null;
    private ExecutorService executorService = null;
    private PolyvAuxiliaryVideoView mAuxiliaryVideoView = null;
    private PolyvBaseMediaController mMediaController = null;
    private a polyvSRT = null;
    private com.easefun.polyvsdk.a.a polyvQuestion = null;
    private View playerBufferingView = null;
    private boolean isOpenTeaser = false;
    private boolean isOpenAd = false;
    private boolean isAutoContinue = false;
    private boolean isOpenPreload = false;
    private int preloadSecond = 0;
    private String viewerId = "";
    private String viewerName = "";
    private String viewerParam = "";
    private String viewLogParam1 = "";
    private String viewLogParam2 = "";
    private String viewLogParam3 = "";
    private String viewLogParam4 = "";
    private String viewLogParam5 = "";
    private int mCurrentBufferPercentage = 0;
    private boolean isBuffering = false;
    private long startLoaderTime = 0L;
    private boolean isSendLoading = false;
    private boolean isSeeking = false;
    private boolean isSendBuffer = false;
    private boolean isSendError = false;
    private long bufferStartTime = 0L;
    private int mSeekWhenPrepared = 0;
    private long mSeekLastTime = 0L;
    private boolean isStartPlay = true;
    private boolean isFullmp4OccurredError = false;
    private boolean isLoadingStop = false;
    private int watchTimeDuration = 0;
    private int stayTimeDuration = 0;
    private Timer playPollingTimer = null;
    private int streamMusicVolume = 0;
    private FutureTask<Boolean> mSetVideoFuture = null;
    private String playId = "";
    private String videoId = "";
    private PolyvBitRate bitRate = PolyvBitRate.ziDong;
    private Video.HlsSpeedType hlsSpeedType = Video.HlsSpeedType.SPEED_1X;
    private c playType = c.a;
    private PolyvVideoVO video = null;
    private com.easefun.polyvsdk.vo.d tokenVO = null;
    private float lastX = 0.0f;
    private float lastY = 0.0f;
    private boolean isPPTPlayback;
    private int portrait_left = 0;
    private int portrait_top = 0;
    private int layoutChange_left = -1;
    private int layoutChange_top = -1;
    private int tranLayoutWidth = 0;
    private int surfaceWidth = 0;
    private int surfaceHeight = 0;
    private IPolyvPPTView pptDrawView;
    private IPolyvLiveInnerPPTView pptInnerDrawView;
    private boolean isLifeBeControlledByThis;
    private boolean isPPTResume;
    private int mMinMeasureWidth;
    private int mMinMeasureHeight;
    private int mMeasureCount;
    private IRenderView.IRenderCallback mIRenderCallback;
    private boolean mIsTranGesture = false;
    private static final int BREAK = 7;
    private PolyvMarqueeView marqueeView;
    private PolyvMarqueeItem marqueeItem;
    private boolean isOpenMarquee;
    private Set<PolyvMarqueeItem> marqueeItems;
    private Handler handler = new Handler(Looper.getMainLooper());
    private IMediaPlayer.OnCompletionListener urlPlayCompletionListener = new IMediaPlayer.OnCompletionListener(){

        public void onCompletion(IMediaPlayer mp) {
            PolyvVideoView.this.callOnCompletionListener(mp);
        }
    };
    private IMediaPlayer.OnPreparedListener urlPlayPreparedListener = new IMediaPlayer.OnPreparedListener(){

        public void onPrepared(IMediaPlayer mp) {
            PolyvVideoView.super.getMediaPlayer().setOnSeekCompleteListener(PolyvVideoView.this.urlPlaySeekCompleteListener);
            PolyvVideoView.super.getMediaPlayer().setOnVideoSizeChangedListener(PolyvVideoView.this.urlPlayVideoSizeChangedListener);
            PolyvVideoView.super.getMediaPlayer().setOnBufferingUpdateListener(new IMediaPlayer.OnBufferingUpdateListener(){

                public void onBufferingUpdate(IMediaPlayer mp, int percent) {
                    PolyvVideoView.this.mCurrentBufferPercentage = percent;
                    PolyvVideoView.this.callOnBufferingUpdateListener(mp, percent);
                }
            });
            PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
            PolyvVideoView.this.callOnPreparedListener(mp);
            PolyvVideoView.this.start();
        }
    };
    private IMediaPlayer.OnErrorListener urlPlayErrorListener = new IMediaPlayer.OnErrorListener(){

        public boolean onError(IMediaPlayer mp, int what, int extra) {
            PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(mp == null ? "" : mp.getDataSource());
            arrayList.add("what:" + what + "extra:" + extra);
            PolyvVideoView.this.callOnErrorListener(mp, what, extra, PolyvVideoView.this.playId, PolyvVideoView.this.videoId, arrayList);
            return true;
        }
    };
    private IMediaPlayer.OnInfoListener urlPlayInfoListener = new IMediaPlayer.OnInfoListener(){

        public boolean onInfo(IMediaPlayer mp, int what, int extra) {
            PolyvVideoView.this.callOnInfoListener(mp, what, extra);
            if (PolyvVideoView.super.getMediaPlayer() != null) {
                if (what == 701) {
                    PolyvVideoView.this.setPlayerBufferingViewVisibility(0);
                    PolyvVideoView.this.PPTViewPause();
                } else if (what == 702) {
                    PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                    PolyvVideoView.this.PPTViewResume();
                }
            }
            return true;
        }
    };
    private IMediaPlayer.OnSeekCompleteListener urlPlaySeekCompleteListener = new IMediaPlayer.OnSeekCompleteListener(){

        public void onSeekComplete(IMediaPlayer mp) {
            PolyvVideoView.this.callOnSeekCompleteListener(mp);
        }
    };
    private IMediaPlayer.OnVideoSizeChangedListener urlPlayVideoSizeChangedListener = new IMediaPlayer.OnVideoSizeChangedListener(){

        public void onVideoSizeChanged(IMediaPlayer mp, int width, int height, int sar_num, int sar_den) {
            PolyvVideoView.this.callOnVideoSizeChangedListener(mp, width, height, sar_num, sar_den);
        }
    };
    private IMediaPlayer.OnCompletionListener mCompletionListener = new IMediaPlayer.OnCompletionListener(){

        public void onCompletion(IMediaPlayer mp) {
            if (mp != null) {
                long l2 = mp.getCurrentPosition();
                long l3 = mp.getDuration();
                if (l3 > 0L && l2 > 0L && l3 - l2 > 2000L) {
                    PolyvVideoView.this.saveVideoProgress(PolyvVideoView.this.videoId, true);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(mp.getDataSource());
                    arrayList.add("currentPosition:" + l2 + ",duration:" + l3);
                    PolyvVideoView.this.callOnVideoPlayErrorListener(30017, PolyvVideoView.this.playId, PolyvVideoView.this.videoId, arrayList);
                    return;
                }
            }
            PolyvVideoView.this.callOnCompletionListener(mp);
            if (!TextUtils.isEmpty((CharSequence)PolyvVideoView.this.videoId) && PolyvVideoView.this.isAutoContinue) {
                PolyvSDKClient.getInstance().getVideoProgressService().b(PolyvVideoView.this.videoId);
            }
            if (PolyvVideoView.this.playType == c.d && PolyvVideoView.this.mAuxiliaryVideoView != null && PolyvVideoView.this.isOpenAd && PolyvVideoView.this.video.isHaveAdvertLast()) {
                PolyvVideoView.this.setPPTLiveViewVisibility(4);
                PolyvVideoView.this.mAuxiliaryVideoView.playNext();
            }
        }
    };
    private IMediaPlayer.OnPreparedListener mPreparedListener = new IMediaPlayer.OnPreparedListener(){

        public void onPrepared(IMediaPlayer mp) {
            PolyvVideoProgressVO polyvVideoProgressVO;
            int n2;
            PolyvVideoView.super.getMediaPlayer().setOnSeekCompleteListener(PolyvVideoView.this.mSeekCompleteListener);
            PolyvVideoView.super.getMediaPlayer().setOnVideoSizeChangedListener(PolyvVideoView.this.mVideoSizeChangedListener);
            PolyvVideoView.super.getMediaPlayer().setOnBufferingUpdateListener(new IMediaPlayer.OnBufferingUpdateListener(){

                public void onBufferingUpdate(IMediaPlayer mp, int percent) {
                    PolyvVideoView.this.mCurrentBufferPercentage = percent;
                    PolyvVideoView.this.callOnBufferingUpdateListener(mp, percent);
                }
            });
            if (PolyvVideoView.this.playType == c.d) {
                if (!PolyvVideoView.this.isSendLoading) {
                    PolyvVideoView.this.isSendLoading = true;
                    n2 = (int)(System.currentTimeMillis() - PolyvVideoView.this.startLoaderTime);
                    PolyvQOSAnalytics.loading(PolyvVideoView.this.playId, PolyvVideoView.this.videoId, n2, "", "", PolyvQOSAnalytics.getQOSAnalyticsParam());
                }
                PolyvVideoView.this.beginDemandPlayPolling();
            } else if (PolyvVideoView.this.playType == c.c) {
                PolyvVideoView.this.setLocalWatchTime();
            }
            PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
            if (PolyvVideoView.this.mMediaController != null) {
                PolyvVideoView.this.mMediaController.setViewBitRate(PolyvVideoView.this.videoId, PolyvVideoView.this.bitRate.getNum());
            }
            if (PolyvVideoView.this.mSeekWhenPrepared != 0) {
                if (PolyvVideoView.this.mSeekWhenPrepared < 100) {
                    n2 = PolyvVideoView.this.getDuration() * PolyvVideoView.this.mSeekWhenPrepared / 100;
                    PolyvVideoView.this.seekTo(n2);
                } else {
                    PolyvVideoView.this.seekTo(PolyvVideoView.this.mSeekWhenPrepared);
                }
            } else if (!TextUtils.isEmpty((CharSequence)PolyvVideoView.this.videoId) && PolyvVideoView.this.isAutoContinue && (polyvVideoProgressVO = PolyvSDKClient.getInstance().getVideoProgressService().a(PolyvVideoView.this.videoId)) != null) {
                PolyvVideoView.this.seekTo(polyvVideoProgressVO.getProgress());
            }
            PolyvVideoView.this.callOnPreparedListener(mp);
            if (PolyvVideoView.this.isStartPlay && !PolyvVideoView.this.isLoadingStop) {
                PolyvVideoView.this.start();
                if (PolyvVideoView.this.isOpenPreload) {
                    PolyvVideoView.this.callOnPreloadPlayListener();
                }
            }
            PolyvVideoView.this.polyvQuestion.b();
            PolyvVideoView.this.polyvSRT.a();
        }
    };
    private IMediaPlayer.OnErrorListener mErrorListener = new IMediaPlayer.OnErrorListener(){

        public boolean onError(IMediaPlayer mp, int frameworkErr, int implErr) {
            String string = "";
            long l2 = 0L;
            long l3 = 0L;
            if (mp != null) {
                string = mp.getDataSource();
                l2 = mp.getCurrentPosition();
                l3 = mp.getDuration();
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (PolyvVideoView.this.playType == c.d && !PolyvVideoView.this.isSendError) {
                PolyvVideoView.this.isSendError = true;
                if (PolyvVideoView.this.video == null) {
                    PolyvQOSAnalytics.error(PolyvVideoView.this.playId, PolyvVideoView.this.videoId, "video_type_on_error_listener", "", "", "", "", PolyvQOSAnalytics.getQOSAnalyticsParam(), String.format(Locale.getDefault(), "video is null implErr:%d frameworkErr:%d", implErr, frameworkErr), string);
                } else if (PolyvVideoView.this.video.getFullmp4() == 1) {
                    if (!PolyvVideoView.this.isFullmp4OccurredError) {
                        PolyvVideoView.this.isFullmp4OccurredError = true;
                        PolyvVideoView.this.playNetMP4Video();
                        return true;
                    }
                    PolyvVideoUtil.playerErrorM3U8Statistics(PolyvVideoView.this.playId, PolyvVideoView.this.mContext, PolyvVideoView.this.video, PolyvVideoView.this.bitRate, PolyvVideoView.this.hlsSpeedType, frameworkErr, implErr, string);
                } else if (PolyvVideoView.this.video.getSeed() == 1) {
                    PolyvVideoUtil.playerErrorM3U8Statistics(PolyvVideoView.this.playId, PolyvVideoView.this.mContext, PolyvVideoView.this.video, PolyvVideoView.this.bitRate, PolyvVideoView.this.hlsSpeedType, frameworkErr, implErr, string);
                } else {
                    PolyvVideoUtil.playerErrorMP4Statistics(PolyvVideoView.this.playId, PolyvVideoView.this.mContext, PolyvVideoView.this.video, PolyvVideoView.this.bitRate, frameworkErr, implErr, string);
                }
            } else if (PolyvVideoView.this.playType == c.c) {
                File file = PolyvSDKClient.getInstance().getDownloadDir();
                String string2 = "";
                if (file != null) {
                    string2 = file.getAbsolutePath();
                }
                arrayList.add("\u4e0b\u8f7d\u76ee\u5f55\uff1a" + string2);
                PolyvQOSAnalytics.error(PolyvVideoView.this.playId, PolyvVideoView.this.videoId, "video_type_on_error_listener", "", "", "", "", PolyvQOSAnalytics.getQOSAnalyticsParam(), String.format(Locale.getDefault(), "video is null implErr:%d frameworkErr:%d", implErr, frameworkErr), string, string2);
            }
            PolyvVideoView.this.saveVideoProgress(PolyvVideoView.this.videoId);
            PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
            arrayList.add("\u64ad\u653e\u5730\u5740\uff1a" + string);
            arrayList.add("\u5f53\u524d\u64ad\u653e\u8fdb\u5ea6:" + l2);
            arrayList.add("\u89c6\u9891\u603b\u65f6\u957f:" + l3);
            arrayList.add("frameworkErr:" + frameworkErr + "implErr:" + implErr);
            PolyvVideoView.this.callOnErrorListener(mp, frameworkErr, implErr, PolyvVideoView.this.playId, PolyvVideoView.this.videoId, null, arrayList);
            return true;
        }
    };
    private IMediaPlayer.OnInfoListener mInfoListener = new IMediaPlayer.OnInfoListener(){

        public boolean onInfo(IMediaPlayer mp, int what, int extra) {
            PolyvVideoView.this.callOnInfoListener(mp, what, extra);
            if (PolyvVideoView.super.getMediaPlayer() != null) {
                if (what == 701) {
                    PolyvVideoView.this.PPTViewPause();
                    PolyvVideoView.this.setPlayerBufferingViewVisibility(0);
                    PolyvVideoView.this.isBuffering = true;
                    PolyvVideoView.this.bufferStartTime = System.currentTimeMillis();
                } else if (what == 702) {
                    PolyvVideoView.this.PPTViewResume();
                    PolyvVideoView.this.isBuffering = false;
                    if (PolyvVideoView.this.isSeeking) {
                        PolyvVideoView.this.isSeeking = false;
                    } else if (PolyvVideoView.this.playType == c.d && !PolyvVideoView.this.isSendBuffer) {
                        PolyvVideoView.this.isSendBuffer = true;
                        int n2 = (int)(System.currentTimeMillis() - PolyvVideoView.this.bufferStartTime);
                        PolyvQOSAnalytics.buffer(PolyvVideoView.this.playId, PolyvVideoView.this.videoId, n2, "", "", PolyvQOSAnalytics.getQOSAnalyticsParam());
                    }
                    PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                }
            }
            return true;
        }
    };
    private IMediaPlayer.OnSeekCompleteListener mSeekCompleteListener = new IMediaPlayer.OnSeekCompleteListener(){

        public void onSeekComplete(IMediaPlayer mp) {
            Log.i((String)TAG, (String)(mp.getCurrentPosition() + "/" + mp.getDuration()));
            PolyvVideoView.this.isSeeking = true;
            PolyvVideoView.this.callOnSeekCompleteListener(mp);
            PolyvVideoView.this.polyvQuestion.b();
        }
    };
    private IMediaPlayer.OnVideoSizeChangedListener mVideoSizeChangedListener = new IMediaPlayer.OnVideoSizeChangedListener(){

        public void onVideoSizeChanged(IMediaPlayer mp, int width, int height, int sar_num, int sar_den) {
            PolyvVideoView.this.callOnVideoSizeChangedListener(mp, width, height, sar_num, sar_den);
        }
    };
    private boolean mNeedGesture = false;
    private GestureDetector mGestureDetector = null;
    private int eventType = 0;
    private static final int NONE = 0;
    private static final int RIGHT_DOWN = 1;
    private static final int RIGHT_UP = 2;
    private static final int LEFT_DOWN = 3;
    private static final int LEFT_UP = 4;
    private static final int SWIPE_LEFT = 5;
    private static final int SWIPE_RIGHT = 6;
    private static final double RADIUS_SLOP = 0.7853981633974483;

    public PolyvVideoView(Context context) {
        this(context, null);
    }

    public PolyvVideoView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PolyvVideoView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        PolyvIjkVideoView polyvIjkVideoView = new PolyvIjkVideoView(context, attrs, defStyleAttr);
        polyvIjkVideoView.setPolyvVideoView(this);
        this.addView((View)polyvIjkVideoView);
        this.init(context, polyvIjkVideoView);
    }

    @TargetApi(value=21)
    public PolyvVideoView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        PolyvIjkVideoView polyvIjkVideoView = new PolyvIjkVideoView(context, attrs, defStyleAttr, defStyleRes);
        polyvIjkVideoView.setPolyvVideoView(this);
        this.addView((View)polyvIjkVideoView);
        this.init(context, polyvIjkVideoView);
    }

    private void init(Context context, IPolyvIjkVideoView ijkVideoView) {
        this.mContext = context;
        this.executorService = Executors.newSingleThreadExecutor();
        this.polyvSRT = new a(this);
        this.polyvQuestion = new com.easefun.polyvsdk.a.a(this);
        this.initIPolyvIjkVideoView(ijkVideoView);
        IjkMediaPlayer.loadLibrariesOnce(null);
        IjkMediaPlayer.native_profileBegin((String)"libijkplayer.so");
        this.mGestureDetector = new GestureDetector(this.mContext, new GestureDetector.OnGestureListener(){

            public boolean onSingleTapUp(MotionEvent e2) {
                PolyvVideoView.this.callOnGestureClickListener(true, true);
                PolyvVideoView.this.eventType = 0;
                return false;
            }

            public void onShowPress(MotionEvent e2) {
            }

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                if (e1 == null || e2 == null) {
                    return false;
                }
                if (PolyvVideoView.this.isPPTPlayback && !PolyvVideoView.this.mIsTranGesture && !PolyvVideoView.this.isPPTViewCanMove()) {
                    return false;
                }
                if (PolyvVideoView.this.lastX == 0.0f || PolyvVideoView.this.lastY == 0.0f) {
                    PolyvVideoView.this.lastX = e1.getX();
                    PolyvVideoView.this.lastY = e1.getY();
                }
                int n2 = PolyvVideoView.this.isPPTPlayback ? (PolyvVideoView.this.isPPTViewCanMove() ? ((View)PolyvVideoView.this.getParent()).getMeasuredWidth() : PolyvVideoView.this.tranLayoutWidth) : PolyvVideoView.this.getMeasuredWidth();
                int n3 = (int)((double)n2 * 0.5 / 100.0);
                double d2 = Math.sqrt(Math.pow(distanceX, 2.0) + Math.pow(distanceY, 2.0));
                if (d2 >= (double)n3) {
                    double d3 = (double)distanceY / d2;
                    if (Math.abs(d3) > 0.7853981633974483) {
                        if (PolyvVideoView.this.lastX > (float)(n2 / 2)) {
                            if (PolyvVideoView.this.eventType == 0 || PolyvVideoView.this.eventType == 2 || PolyvVideoView.this.eventType == 1) {
                                if (PolyvVideoView.this.lastY > e2.getY()) {
                                    PolyvVideoView.this.eventType = 2;
                                    PolyvVideoView.this.callOnGestureRightUpListener(true, false);
                                } else {
                                    PolyvVideoView.this.eventType = 1;
                                    PolyvVideoView.this.callOnGestureRightDownListener(true, false);
                                }
                            }
                        } else if (PolyvVideoView.this.eventType == 0 || PolyvVideoView.this.eventType == 4 || PolyvVideoView.this.eventType == 3) {
                            if (PolyvVideoView.this.lastY > e2.getY()) {
                                PolyvVideoView.this.eventType = 4;
                                PolyvVideoView.this.callOnGestureLeftUpListener(true, false);
                            } else {
                                PolyvVideoView.this.eventType = 3;
                                PolyvVideoView.this.callOnGestureLeftDownListener(true, false);
                            }
                        }
                    } else if (PolyvVideoView.this.eventType == 0 || PolyvVideoView.this.eventType == 5 || PolyvVideoView.this.eventType == 6) {
                        if (PolyvVideoView.this.lastX > e2.getX()) {
                            PolyvVideoView.this.eventType = 5;
                            PolyvVideoView.this.callOnGestureSwipeLeftListener(true, false);
                        } else {
                            PolyvVideoView.this.eventType = 6;
                            PolyvVideoView.this.callOnGestureSwipeRightListener(true, false);
                        }
                    }
                    PolyvVideoView.this.lastX = e2.getX();
                    PolyvVideoView.this.lastY = e2.getY();
                }
                return false;
            }

            public void onLongPress(MotionEvent e2) {
            }

            public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
                return false;
            }

            public boolean onDown(MotionEvent e2) {
                return false;
            }
        });
    }

    @Override
    public void setVid(@NonNull String videoId) {
        this.setVid(videoId, false);
    }

    @Override
    public void setVid(@NonNull String videoId, boolean isMustFromLocal) {
        this.setVid(videoId, isMustFromLocal, Video.HlsSpeedType.SPEED_1X);
    }

    @Override
    public void setVid(@NonNull String videoId, boolean isMustFromLocal, @NonNull Video.HlsSpeedType hlsSpeedType) {
        this.setVid(videoId, PolyvBitRate.ziDong.getNum(), isMustFromLocal, hlsSpeedType);
    }

    @Override
    public void setVid(@NonNull String videoId, int bitRateNum) {
        this.setVid(videoId, bitRateNum, false);
    }

    @Override
    public void setVid(@NonNull String videoId, int bitRateNum, boolean isMustFromLocal) {
        this.setVid(videoId, bitRateNum, isMustFromLocal, Video.HlsSpeedType.SPEED_1X);
    }

    @Override
    public void setVid(@NonNull String videoId, int bitRateNum, boolean isMustFromLocal, @NonNull Video.HlsSpeedType hlsSpeedType) {
        this.setVid(videoId, bitRateNum, isMustFromLocal, hlsSpeedType, false);
    }

    @Override
    public void setPPTVid(@NonNull String videoId, int bitRate, boolean isMustFromLocal) {
        this.setVid(videoId, bitRate, isMustFromLocal, Video.HlsSpeedType.SPEED_1X, true);
    }

    private void setVid(final @NonNull String videoId, final int bitRateNum, final boolean isMustFromLocal, final @NonNull Video.HlsSpeedType hlsSpeedType, final boolean isPPTPlayback) {
        this.executorService.execute(new com.easefun.polyvsdk.util.c(this.mContext));
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                Object object;
                PolyvVideoView.this.releaseInterior();
                PolyvVideoView.this.resetProperty();
                PolyvVideoView.this.initSetting(isPPTPlayback);
                PolyvVideoView.this.setPlayerBufferingViewVisibility(0);
                if (!PolyvSDKUtil.validateVideoId(videoId)) {
                    PolyvVideoView.this.callOnVideoPlayErrorListener(20014, PolyvVideoView.this.playId, videoId);
                    PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                    return;
                }
                String string = PolyvSDKClient.getInstance().getUserId();
                String string2 = PolyvSDKClient.getInstance().getReadtoken();
                String string3 = PolyvSDKClient.getInstance().getWritetoken();
                if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2) || TextUtils.isEmpty((CharSequence)string3)) {
                    PolyvVideoView.this.callOnVideoPlayErrorListener(20010, PolyvVideoView.this.playId, videoId);
                    PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                    return;
                }
                if (!PolyvSDKClient.getInstance().mutilAccount && !string.equals(object = videoId.substring(0, 10))) {
                    PolyvVideoView.this.callOnVideoPlayErrorListener(20009, PolyvVideoView.this.playId, videoId);
                    PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                    return;
                }
                object = PolyvBitRate.getBitRate(bitRateNum);
                if (object == null) {
                    PolyvVideoView.this.callOnVideoPlayErrorListener(20015, PolyvVideoView.this.playId, videoId);
                    PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                    return;
                }
                if (hlsSpeedType == null) {
                    PolyvVideoView.this.callOnVideoPlayErrorListener(30001, PolyvVideoView.this.playId, videoId);
                    PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                    return;
                }
                if (isMustFromLocal) {
                    if (ContextCompat.checkSelfPermission((Context)PolyvVideoView.this.mContext, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                        PolyvVideoView.this.callOnVideoPlayErrorListener(30018, PolyvVideoView.this.playId, videoId);
                        PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                        return;
                    }
                    if (!PolyvSDKUtil.checkOpWriteExternalStorage(PolyvVideoView.this.mContext)) {
                        PolyvVideoView.this.callOnVideoPlayErrorListener(30018, PolyvVideoView.this.playId, videoId);
                        PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                        return;
                    }
                }
                if (object == PolyvBitRate.ziDong) {
                    List<PolyvBitRate> list = PolyvBitRate.getDescBitRateList();
                    for (PolyvBitRate polyvBitRate : list) {
                        b b2 = PolyvVideoUtil.loadLocalVideo(videoId, polyvBitRate.getNum(), hlsSpeedType);
                        if (b2.a() == 1) {
                            PolyvVideoView.this.gotoPlayLocalVideo(videoId, polyvBitRate, hlsSpeedType, b2.b());
                            return;
                        }
                        if (b2.a() != 3 || !isMustFromLocal) continue;
                        PolyvVideoView.this.callOnVideoPlayErrorListener(20007, PolyvVideoView.this.playId, videoId);
                        PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                        return;
                    }
                    if (isMustFromLocal) {
                        PolyvVideoView.this.callOnVideoPlayErrorListener(30002, PolyvVideoView.this.playId, videoId);
                        PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                        return;
                    }
                    if (!PolyvSDKUtil.isOpenNetwork(PolyvVideoView.this.mContext)) {
                        PolyvVideoView.this.callOnVideoPlayErrorListener(20003, PolyvVideoView.this.playId, videoId);
                        PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                        return;
                    }
                    PolyvVideoView.this.gotoPlayNetVideo(videoId, object, hlsSpeedType, true);
                } else {
                    b b3 = PolyvVideoUtil.loadLocalVideo(videoId, bitRateNum, hlsSpeedType);
                    switch (b3.a()) {
                        case 1: {
                            PolyvVideoView.this.gotoPlayLocalVideo(videoId, object, hlsSpeedType, b3.b());
                            break;
                        }
                        case 2: {
                            if (isMustFromLocal) {
                                PolyvVideoView.this.callOnVideoPlayErrorListener(30002, PolyvVideoView.this.playId, videoId);
                                PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                                return;
                            }
                            if (!PolyvSDKUtil.isOpenNetwork(PolyvVideoView.this.mContext)) {
                                PolyvVideoView.this.callOnVideoPlayErrorListener(20003, PolyvVideoView.this.playId, videoId);
                                PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                                return;
                            }
                            PolyvVideoView.this.gotoPlayNetVideo(videoId, object, hlsSpeedType, true);
                            break;
                        }
                        case 3: {
                            if (isMustFromLocal) {
                                PolyvVideoView.this.callOnVideoPlayErrorListener(20007, PolyvVideoView.this.playId, videoId);
                                PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                                return;
                            }
                            PolyvVideoView.this.gotoPlayNetVideo(videoId, object, hlsSpeedType, true);
                        }
                    }
                }
            }
        });
    }

    private void gotoPlayLocalVideo(@NonNull String videoId, @NonNull PolyvBitRate bitRate, @NonNull Video.HlsSpeedType hlsSpeedType, @NonNull String path) {
        PolyvVideoVO polyvVideoVO;
        Object object;
        String string;
        String string2 = PolyvSDKUtil.getPid();
        int n2 = videoId.indexOf("_");
        String string3 = videoId.substring(0, n2);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PolyvSDKClient.getInstance().getDownloadDir().getAbsolutePath()).append(File.separator).append(string3).append("_").append(bitRate.getNum()).append(File.separator).append(string3).append("_").append(bitRate.getNum()).append(".json");
        File file = new File(stringBuilder.toString());
        if (!file.exists()) {
            stringBuilder.delete(0, stringBuilder.length());
            stringBuilder.append(PolyvSDKClient.getInstance().getDownloadDir().getAbsolutePath()).append(File.separator).append(string3).append("_").append(bitRate.getNum()).append(".json");
        }
        if (TextUtils.isEmpty((CharSequence)(string = PolyvSDKUtil.getFile2String(stringBuilder.toString())))) {
            object = PolyvSDKClient.getInstance().getVideoDBService();
            polyvVideoVO = ((VideoDatabaseService)object).getVideo(videoId);
        } else {
            object = null;
            try {
                object = new JSONObject(string);
            }
            catch (JSONException jSONException) {
                Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(jSONException, -1));
            }
            if (object == null) {
                VideoDatabaseService videoDatabaseService = PolyvSDKClient.getInstance().getVideoDBService();
                polyvVideoVO = videoDatabaseService.getVideo(videoId);
            } else {
                polyvVideoVO = PolyvVideoVO.fromJSONObject(videoId, (JSONObject)object, true);
            }
        }
        this.polyvQuestion.a(polyvVideoVO);
        this.polyvSRT.a(polyvVideoVO);
        this.isStartPlay = true;
        this.setVideoParam(string2, videoId, bitRate, hlsSpeedType, c.c, polyvVideoVO);
        if (this.mAuxiliaryVideoView != null) {
            this.mAuxiliaryVideoView.hide();
        }
        this.setPPTLiveViewVisibility(0);
        object = new ArrayList();
        ((ArrayList)object).add(new d(1, "device_type", "1"));
        ((ArrayList)object).add(new d(1, "videopool_id", string3));
        ((ArrayList)object).add(new d(1, "signature", PolyvSDKClient.getInstance().getVideoPoolIdSignToString(string3)));
        this.setVideoURIFromSelf(path, (ArrayList<d>)object);
    }

    private void gotoPlayNetVideo(@NonNull String videoId, @NonNull PolyvBitRate bitRate, @NonNull Video.HlsSpeedType hlsSpeedType, boolean isNew) {
        Object object;
        Video video;
        this.setPlayerBufferingViewVisibility(0);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string = PolyvSDKUtil.getPid();
        try {
            video = PolyvSDKUtil.loadVideoJSON2Video(videoId, arrayList, arrayList2);
        }
        catch (Exception exception) {
            String string2 = PolyvSDKUtil.getExceptionFullMessage(exception, -1);
            Log.e((String)TAG, (String)string2);
            PolyvQOSAnalytics.error(string, videoId, "video_type_video_is_null", "", "", "", "", PolyvQOSAnalytics.getQOSAnalyticsParam(), PolyvSDKUtil.getExceptionFullMessage(exception));
            arrayList.add(string2);
            this.callOnVideoPlayErrorListener(30011, string, videoId, arrayList, arrayList2);
            this.setPlayerBufferingViewVisibility(8);
            return;
        }
        if (video == null) {
            Log.e((String)TAG, (String)"video is null");
            PolyvQOSAnalytics.error(string, videoId, "video_type_video_is_null", "", "", "", "", PolyvQOSAnalytics.getQOSAnalyticsParam());
            this.callOnVideoPlayErrorListener(20016, string, videoId, arrayList, arrayList2);
            this.setPlayerBufferingViewVisibility(8);
            return;
        }
        if (video.isOutflow()) {
            Log.e((String)TAG, (String)"error out flow");
            PolyvQOSAnalytics.error(string, videoId, "video_type_out_flow", "", "", "", "", PolyvQOSAnalytics.getQOSAnalyticsParam());
            this.callOnVideoPlayErrorListener(20004, string, videoId);
            this.setPlayerBufferingViewVisibility(8);
            return;
        }
        if (video.isTimeoutFlow()) {
            Log.e((String)TAG, (String)"error timeout flow");
            PolyvQOSAnalytics.error(string, videoId, "video_type_timout_flow", "", "", "", "", PolyvQOSAnalytics.getQOSAnalyticsParam());
            this.callOnVideoPlayErrorListener(20005, string, videoId);
            this.setPlayerBufferingViewVisibility(8);
            return;
        }
        this.callOnVideoStatusListener(video.getStatus());
        if (video.getStatus() < 60) {
            Log.e((String)TAG, (String)("\u89c6\u9891\u72b6\u6001\u9519\u8bef\u4e0d\u80fd\u64ad\u653e " + video.getStatus()));
            PolyvQOSAnalytics.error(string, videoId, "video_type_video_status_error", "", "", "", "", PolyvQOSAnalytics.getQOSAnalyticsParam(), String.valueOf(video.getStatus()));
            this.callOnVideoPlayErrorListener(20011, string, videoId);
            this.setPlayerBufferingViewVisibility(8);
            return;
        }
        if (bitRate == PolyvBitRate.ziDong) {
            object = e.a(this.mContext);
            bitRate = object == null ? PolyvBitRate.getBitRate(video.getMyBr(), PolyvBitRate.ziDong) : object;
        } else {
            e.a(this.mContext, bitRate);
        }
        if (bitRate.getNum() > video.getDfNum()) {
            bitRate = PolyvBitRate.getBitRate(video.getDfNum());
        }
        if (bitRate == null) {
            bitRate = PolyvBitRate.getMinBitRate();
        }
        object = video.getFileSize();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            long l2 = (Long)iterator.next();
            if (l2 > 0L) continue;
            bitRate = PolyvBitRate.getMinBitRate();
            break;
        }
        if (hlsSpeedType == Video.HlsSpeedType.SPEED_1_5X) {
            if (bitRate == PolyvBitRate.ziDong) {
                if (TextUtils.isEmpty((CharSequence)video.getHls15XIndex())) {
                    Log.e((String)TAG, (String)"hls 15x index empty");
                    PolyvQOSAnalytics.error(string, videoId, "video_type_hls_15x_index_empty", "", "", "", "", PolyvQOSAnalytics.getQOSAnalyticsParam());
                    this.callOnVideoPlayErrorListener(30003, string, videoId);
                    this.setPlayerBufferingViewVisibility(8);
                    return;
                }
            } else {
                int n2 = video.getHls15X().size();
                if (n2 == 0 || n2 < bitRate.getNum()) {
                    Log.e((String)TAG, (String)"hls 15x error");
                    PolyvQOSAnalytics.error(string, videoId, "video_type_hls_15x_error", "", "", "", "", PolyvQOSAnalytics.getQOSAnalyticsParam(), String.format(Locale.getDefault(), "size:%d bitrate:%d", n2, bitRate.getNum()));
                    this.callOnVideoPlayErrorListener(30004, string, videoId);
                    this.setPlayerBufferingViewVisibility(8);
                    return;
                }
            }
        }
        int n3 = PolyvVideoUtil.getVideoType(video);
        switch (n3) {
            case 1: {
                int n4 = video.getMp4().size();
                if (n4 == video.getDfNum()) break;
                Log.e((String)TAG, (String)String.format("mp4\u94fe\u63a5\u6570\u91cf\u9519\u8bef mp4 link num[%d] dfnum[%d]", n4, video.getDfNum()));
                PolyvQOSAnalytics.error(string, videoId, "video_type_mp4_link_num_error", "", "", "", "", PolyvQOSAnalytics.getQOSAnalyticsParam());
                this.callOnVideoPlayErrorListener(20017, string, videoId);
                this.setPlayerBufferingViewVisibility(8);
                return;
            }
            case 2: {
                if (!this.validateM3U8VideoLinkNum(string, videoId, hlsSpeedType, video)) {
                    return;
                }
                if (bitRate == PolyvBitRate.ziDong || hlsSpeedType != Video.HlsSpeedType.SPEED_1_5X || !TextUtils.isEmpty((CharSequence)video.getHls15X().get(bitRate.getIndexByVideoUrlList()))) break;
                Log.e((String)TAG, (String)String.format("1.5\u500d%s\u7801\u7387\u89c6\u9891\u6b63\u5728\u7f16\u7801\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", bitRate.getName()));
                this.callOnVideoPlayErrorListener(30005, string, videoId);
                this.setPlayerBufferingViewVisibility(8);
                return;
            }
            case 3: {
                String string3;
                if (!this.validateM3U8VideoLinkNum(string, videoId, hlsSpeedType, video)) {
                    return;
                }
                String string4 = "";
                if (hlsSpeedType == Video.HlsSpeedType.SPEED_1X) {
                    if (bitRate == PolyvBitRate.ziDong) {
                        string3 = video.getHlsIndex();
                    } else {
                        string3 = video.getHls().get(bitRate.getIndexByVideoUrlList());
                        string4 = video.getHls2().get(bitRate.getIndexByVideoUrlList());
                    }
                } else {
                    string3 = bitRate == PolyvBitRate.ziDong ? video.getHls15XIndex() : video.getHls15X().get(bitRate.getIndexByVideoUrlList());
                }
                if (!TextUtils.isEmpty((CharSequence)string4)) {
                    try {
                        new URL(string4);
                    }
                    catch (MalformedURLException malformedURLException) {
                        Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(malformedURLException, -1));
                        PolyvQOSAnalytics.error(string, videoId, "video_type_video_url_2_error", "", "", "", "", PolyvQOSAnalytics.getQOSAnalyticsParam(), PolyvSDKUtil.getExceptionFullMessage(malformedURLException), string4);
                        this.callOnVideoPlayErrorListener(30016, string, videoId);
                        this.setPlayerBufferingViewVisibility(8);
                        return;
                    }
                }
                try {
                    new URL(string3);
                }
                catch (MalformedURLException malformedURLException) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(malformedURLException, -1));
                    PolyvQOSAnalytics.error(string, videoId, "video_type_video_url_error", "", "", "", "", PolyvQOSAnalytics.getQOSAnalyticsParam(), PolyvSDKUtil.getExceptionFullMessage(malformedURLException), string3);
                    this.callOnVideoPlayErrorListener(30013, string, videoId);
                    this.setPlayerBufferingViewVisibility(8);
                    return;
                }
                ArrayList<String> arrayList3 = new ArrayList<String>();
                this.tokenVO = PolyvVideoUtil.requestToken(video.getVid(), this.getViewerId(), this.getViewerName(), this.getViewerParam(), video.getTimestamp(), arrayList3);
                if (this.tokenVO == null) {
                    Log.e((String)TAG, (String)"token is null");
                    for (String string5 : arrayList3) {
                        Log.e((String)TAG, (String)string5);
                    }
                    PolyvQOSAnalytics.error(string, videoId, "video_type_token_is_null", "", "", "", "", PolyvQOSAnalytics.getQOSAnalyticsParam());
                    this.callOnVideoPlayErrorListener(30015, string, videoId);
                    this.setPlayerBufferingViewVisibility(8);
                    return;
                }
                if (bitRate == PolyvBitRate.ziDong || hlsSpeedType != Video.HlsSpeedType.SPEED_1_5X || !TextUtils.isEmpty((CharSequence)video.getHls15X().get(bitRate.getIndexByVideoUrlList()))) break;
                Log.e((String)TAG, (String)String.format("1.5\u500d%s\u7801\u7387\u89c6\u9891\u6b63\u5728\u7f16\u7801\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", bitRate.getName()));
                this.callOnVideoPlayErrorListener(30005, string, videoId);
                this.setPlayerBufferingViewVisibility(8);
                return;
            }
            case 4: {
                String string6 = video.getPlaySourceUrl();
                if (!TextUtils.isEmpty((CharSequence)string6)) break;
                Log.e((String)TAG, (String)("play source url empty" + string6));
                PolyvQOSAnalytics.error(string, videoId, "video_type_source_url_empty", "", "", "", "", PolyvQOSAnalytics.getQOSAnalyticsParam(), string6);
                this.callOnVideoPlayErrorListener(30019, string, videoId);
                this.setPlayerBufferingViewVisibility(8);
                return;
            }
        }
        this.polyvQuestion.a(string, video);
        this.polyvSRT.b(video);
        this.setVideoParam(string, videoId, (PolyvBitRate)((Object)bitRate), hlsSpeedType, c.d, video);
        if (!isNew) {
            this.playNetVideo(true);
        } else if (this.mAuxiliaryVideoView == null) {
            this.playNetVideo(true);
        } else {
            this.mAuxiliaryVideoView.setData(video);
            if (this.isOpenAd && video.isHaveAdvertFirst()) {
                this.setPPTLiveViewVisibility(4);
                this.mAuxiliaryVideoView.playNext();
            } else if (this.isOpenTeaser && video.isHaveTeaser()) {
                this.setPPTLiveViewVisibility(4);
                this.mAuxiliaryVideoView.playNext();
            } else {
                this.mAuxiliaryVideoView.hide();
                this.playNetVideo(true);
            }
        }
    }

    @Override
    public String getCurrentVid() {
        return this.videoId;
    }

    @Override
    public String getCurrentVideoId() {
        return this.videoId;
    }

    @Override
    public int getBitRate() {
        if (this.bitRate == null) {
            return PolyvBitRate.ziDong.getNum();
        }
        return this.bitRate.getNum();
    }

    @Override
    public Video.HlsSpeedType getHlsSpeedType() {
        return this.hlsSpeedType;
    }

    @Override
    @Nullable
    public Video getVideo() {
        return PolyvVideoVO.copyToVideo(this.video);
    }

    @Override
    public int getLevel() {
        if (this.video == null) {
            return 0;
        }
        return this.video.getDfNum();
    }

    @Override
    public int getWatchTimeDuration() {
        return this.watchTimeDuration;
    }

    @Override
    public int getStayTimeDuration() {
        return this.stayTimeDuration;
    }

    @Override
    public boolean isLocalPlay() {
        return this.playType == c.c;
    }

    @Override
    public boolean isPlayStageMain() {
        return true;
    }

    @Override
    public void setVideoPath(@NonNull String path) {
        this.setVideoURI(Uri.parse((String)path));
    }

    @Override
    public void setVideoURI(@NonNull Uri uri) {
        this.setVideoURI(uri, false);
    }

    @Override
    public void setPPTVideoURI(@NonNull Uri uri) {
        this.setVideoURI(uri, true);
    }

    private void setVideoURI(final @NonNull Uri uri, final boolean isPPTPlayback) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                PolyvVideoView.this.releaseInterior();
                PolyvVideoView.this.resetProperty();
                PolyvVideoView.this.initSetting(isPPTPlayback);
                PolyvVideoView.this.playType = c.b;
                if (PolyvVideoView.this.mAuxiliaryVideoView != null) {
                    PolyvVideoView.this.mAuxiliaryVideoView.hide();
                }
                PolyvVideoView.this.setPPTLiveViewVisibility(0);
                PolyvVideoView.this.setPlayerBufferingViewVisibility(0);
                PolyvVideoView.this.setVideoURIFromSelfUrlPlay(uri);
            }
        });
    }

    private void setVideoURIFromSelfUrlPlay(@NonNull Uri uri) {
        super.setOnCompletionListener(this.urlPlayCompletionListener);
        super.setOnPreparedListener(this.urlPlayPreparedListener);
        super.setOnErrorListener(this.urlPlayErrorListener);
        super.setOnInfoListener(this.urlPlayInfoListener);
        this.handlerSetVideoURI(uri);
    }

    private void setVideoURIFromSelf(@NonNull String path) {
        this.setVideoURIFromSelf(path, null);
    }

    private void setVideoURIFromSelf(@NonNull String path, ArrayList<d> optionParams) {
        this.setVideoURIFromSelf(Uri.parse((String)path), optionParams);
    }

    private void setVideoURIFromSelf(@NonNull Uri uri, ArrayList<d> optionParams) {
        super.setOnCompletionListener(this.mCompletionListener);
        super.setOnPreparedListener(this.mPreparedListener);
        super.setOnErrorListener(this.mErrorListener);
        super.setOnInfoListener(this.mInfoListener);
        if (optionParams == null) {
            optionParams = new ArrayList(1);
        }
        optionParams.add(new d(1, "user_agent", "polyv-android-sdk2.2.0-20171212"));
        Object[][] objectArray = new Object[optionParams.size()][3];
        int n2 = 0;
        for (d d2 : optionParams) {
            objectArray[n2][0] = d2.a();
            objectArray[n2][1] = d2.b();
            objectArray[n2][2] = d2.c();
            ++n2;
        }
        this.setOptionParameters(objectArray);
        this.handlerSetVideoURI(uri);
    }

    private void handlerSetVideoURI(final Uri uri) {
        this.cancelSetVideoFuture();
        this.mSetVideoFuture = new FutureTask<Boolean>(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                PolyvVideoView.super.setVideoURI(uri);
                return true;
            }
        });
        this.handler.post(this.mSetVideoFuture);
    }

    private void cancelSetVideoFuture() {
        if (this.mSetVideoFuture == null) {
            return;
        }
        if (this.mSetVideoFuture.isDone()) {
            this.mSetVideoFuture = null;
            return;
        }
        if (this.mSetVideoFuture.isCancelled()) {
            this.mSetVideoFuture = null;
            return;
        }
        if (this.mSetVideoFuture.cancel(true)) {
            this.mSetVideoFuture = null;
            return;
        }
        try {
            this.mSetVideoFuture.get(5L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
        }
        this.mSetVideoFuture = null;
    }

    private void setLocalWatchTime() {
        this.endPlayPolling();
        this.playPollingTimer = new Timer();
        this.playPollingTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                PolyvVideoView.this.stayTimeDuration++;
                if (!PolyvVideoView.this.isBuffering && PolyvVideoView.this.isPlaying()) {
                    PolyvVideoView.this.watchTimeDuration++;
                }
            }
        }, 0L, 1000L);
    }

    private void beginDemandPlayPolling() {
        this.endPlayPolling();
        this.playPollingTimer = new Timer();
        this.playPollingTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                PolyvVideoView.this.stayTimeDuration++;
                if (!PolyvVideoView.this.isBuffering && PolyvVideoView.this.isPlaying()) {
                    PolyvVideoView.this.watchTimeDuration++;
                    if (PolyvVideoView.this.watchTimeDuration % 6 == 0) {
                        PolyvVideoUtil.statDemand(PolyvVideoView.this.playId, PolyvVideoView.this.videoId, 0L, PolyvVideoView.this.watchTimeDuration, PolyvVideoView.this.stayTimeDuration, PolyvVideoView.this.getCurrentPosition() / 1000, PolyvVideoView.this.getDuration(), PolyvVideoView.this.getViewerId(), PolyvVideoView.this.getViewLogParam1(), PolyvVideoView.this.getViewLogParam2(), PolyvVideoView.this.getViewLogParam3(), PolyvVideoView.this.getViewLogParam4(), PolyvVideoView.this.getViewLogParam5());
                    }
                }
            }
        }, 0L, 1000L);
    }

    private void endPlayPolling() {
        if (this.playPollingTimer != null) {
            this.playPollingTimer.cancel();
            this.playPollingTimer = null;
        }
        this.watchTimeDuration = 0;
        this.stayTimeDuration = 0;
    }

    public void setPlayerBufferingViewVisibility(final int visibility) {
        if (this.playerBufferingView != null && this.handler != null) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    if (PolyvVideoView.this.playerBufferingView != null) {
                        PolyvVideoView.this.playerBufferingView.setVisibility(visibility);
                    }
                }
            });
        }
    }

    private void playNetVideo(boolean isStartNow) {
        if (isStartNow) {
            this.setPPTLiveViewVisibility(0);
        }
        this.isStartPlay = isStartNow;
        this.startLoaderTime = System.currentTimeMillis();
        this.cleanSurfaceHolderCanvas();
        this.setPlayerBufferingViewVisibility(0);
        int n2 = PolyvVideoUtil.getVideoType(this.video);
        switch (n2) {
            case 1: {
                this.playNetMP4Video();
                break;
            }
            case 2: {
                StringBuilder stringBuilder = new StringBuilder();
                if (this.bitRate == PolyvBitRate.ziDong) {
                    switch (this.hlsSpeedType) {
                        case SPEED_1X: {
                            stringBuilder.append(this.video.getHlsIndex());
                            break;
                        }
                        case SPEED_1_5X: {
                            stringBuilder.append(this.video.getHls15XIndex());
                        }
                    }
                } else {
                    switch (this.hlsSpeedType) {
                        case SPEED_1X: {
                            stringBuilder.append(this.video.getHls().get(this.bitRate.getIndexByVideoUrlList()));
                            break;
                        }
                        case SPEED_1_5X: {
                            stringBuilder.append(this.video.getHls15X().get(this.bitRate.getIndexByVideoUrlList()));
                        }
                    }
                }
                long l2 = System.currentTimeMillis();
                String string = PolyvSDKClient.getInstance().getWebSignToString(String.valueOf(l2), this.videoId);
                stringBuilder.append("?ts=").append(l2).append("&sign=").append(string).append("&pid=").append(this.playId);
                this.setVideoURIFromSelf(stringBuilder.toString());
                break;
            }
            case 3: {
                String string;
                String string2 = "";
                if (this.hlsSpeedType == Video.HlsSpeedType.SPEED_1X) {
                    if (this.bitRate == PolyvBitRate.ziDong) {
                        string = this.video.getHlsIndex();
                    } else {
                        string = this.video.getHls().get(this.bitRate.getIndexByVideoUrlList());
                        string2 = this.video.getHls2().get(this.bitRate.getIndexByVideoUrlList());
                    }
                } else {
                    string = this.bitRate == PolyvBitRate.ziDong ? this.video.getHls15XIndex() : this.video.getHls15X().get(this.bitRate.getIndexByVideoUrlList());
                }
                String string3 = PolyvDnsUtil.getIPByUrl(string2);
                ArrayList<d> arrayList = new ArrayList<d>();
                if (!TextUtils.isEmpty((CharSequence)string3) && PolyvSDKUtil.isIpAddr(string3)) {
                    URL uRL = null;
                    try {
                        uRL = new URL(string2);
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    if (uRL != null) {
                        arrayList.add(new d(1, "ip_addr", string3));
                        arrayList.add(new d(1, "ip_host", uRL.getHost()));
                    }
                }
                arrayList.add(new d(1, "key_seed", String.valueOf(this.video.getSeedConst())));
                arrayList.add(new d(1, "key_token", this.tokenVO.d().a()));
                this.setVideoURIFromSelf(string, arrayList);
                break;
            }
            case 4: {
                String string = this.video.getPlaySourceUrl() + "?pid=" + this.playId;
                this.setVideoURIFromSelf(string);
            }
        }
    }

    private void playNetMP4Video() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.bitRate == PolyvBitRate.ziDong) {
            stringBuilder.append(this.video.getMp4().get(0));
        } else {
            stringBuilder.append(this.video.getMp4().get(this.bitRate.getIndexByVideoUrlList()));
        }
        stringBuilder.append("?pid=").append(this.playId);
        this.setVideoURIFromSelf(stringBuilder.toString());
    }

    private boolean validateM3U8VideoLinkNum(@NonNull String playId, @NonNull String videoId, @NonNull Video.HlsSpeedType hlsSpeedType, @NonNull PolyvVideoVO videoVO) {
        switch (hlsSpeedType) {
            case SPEED_1X: {
                int n2 = videoVO.getHls().size();
                if (n2 == videoVO.getDfNum()) break;
                Log.e((String)TAG, (String)String.format("m3u8\u94fe\u63a5\u6570\u91cf\u9519\u8bef m3u8 link num[%d] dfnum[%d]", n2, videoVO.getDfNum()));
                PolyvQOSAnalytics.error(playId, videoId, "video_type_m3u8_link_num_error", "", "", "", "", PolyvQOSAnalytics.getQOSAnalyticsParam(), String.format(Locale.getDefault(), "hls:%d dfNum:%d", n2, videoVO.getDfNum()));
                this.callOnVideoPlayErrorListener(20018, playId, videoId);
                this.setPlayerBufferingViewVisibility(8);
                return false;
            }
            case SPEED_1_5X: {
                int n3 = videoVO.getHls15X().size();
                if (n3 == videoVO.getDfNum()) break;
                Log.e((String)TAG, (String)String.format("m3u8 15x\u94fe\u63a5\u6570\u91cf\u9519\u8bef m3u8 15x link num[%d] dfnum[%d]", n3, videoVO.getDfNum()));
                PolyvQOSAnalytics.error(playId, videoId, "video_type_m3u8_15x_link_num_error", "", "", "", "", PolyvQOSAnalytics.getQOSAnalyticsParam(), String.format(Locale.getDefault(), "hls15x:%d dfNum:%d", n3, videoVO.getDfNum()));
                this.callOnVideoPlayErrorListener(30006, playId, videoId);
                this.setPlayerBufferingViewVisibility(8);
                return false;
            }
        }
        return true;
    }

    private void cleanSurfaceHolderCanvas() {
        if (this.getSurfaceHolder() != null) {
            Canvas canvas = null;
            try {
                canvas = this.surfaceHeight > 0 && this.surfaceWidth > 0 ? this.getSurfaceHolder().lockCanvas(new Rect(0, 0, this.surfaceWidth, this.surfaceHeight)) : this.getSurfaceHolder().lockCanvas();
            }
            catch (Exception exception) {
                Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
            }
            if (canvas != null) {
                canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                this.getSurfaceHolder().unlockCanvasAndPost(canvas);
            }
        }
    }

    @Override
    public boolean changeBitRate(int bitRate) {
        return this.switchLevel(bitRate);
    }

    @Override
    public boolean changeBitRate(int bitRate, boolean isMustFromLocal) {
        return this.switchLevel(bitRate, isMustFromLocal);
    }

    @Override
    public boolean switchLevel(int bitRateNum) {
        return this.switchLevel(bitRateNum, false);
    }

    @Override
    public boolean switchLevel(final int bitRateNum, final boolean isMustFromLocal) {
        if (!PolyvSDKUtil.validateVideoId(this.videoId)) {
            this.callOnVideoPlayErrorListener(20014, this.playId, this.videoId);
            this.setPlayerBufferingViewVisibility(8);
            return false;
        }
        PolyvBitRate polyvBitRate = PolyvBitRate.getBitRate(bitRateNum);
        if (polyvBitRate == null) {
            this.callOnVideoPlayErrorListener(20015, this.playId, this.videoId);
            this.setPlayerBufferingViewVisibility(8);
            return false;
        }
        if (this.hlsSpeedType == null) {
            this.callOnVideoPlayErrorListener(30001, this.playId, this.videoId);
            this.setPlayerBufferingViewVisibility(8);
            return false;
        }
        if (PolyvVideoView.super.getMediaPlayer() == null) {
            this.callOnVideoPlayErrorListener(30009, this.playId, this.videoId);
            this.setPlayerBufferingViewVisibility(8);
            return false;
        }
        if (this.bitRate == polyvBitRate) {
            this.callOnVideoPlayErrorListener(30007, this.playId, this.videoId);
            this.setPlayerBufferingViewVisibility(8);
            return false;
        }
        if (polyvBitRate != PolyvBitRate.ziDong && polyvBitRate.getNum() > this.video.getDfNum()) {
            this.callOnVideoPlayErrorListener(30014, this.playId, this.videoId);
            this.setPlayerBufferingViewVisibility(8);
            return false;
        }
        if (isMustFromLocal) {
            if (ContextCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                this.callOnVideoPlayErrorListener(30018, this.playId, this.videoId);
                this.setPlayerBufferingViewVisibility(8);
                return false;
            }
            if (!PolyvSDKUtil.checkOpWriteExternalStorage(this.mContext)) {
                this.callOnVideoPlayErrorListener(30018, this.playId, this.videoId);
                this.setPlayerBufferingViewVisibility(8);
                return false;
            }
        }
        if (polyvBitRate == PolyvBitRate.ziDong) {
            List<PolyvBitRate> list = PolyvBitRate.getDescBitRateList(false);
            for (PolyvBitRate polyvBitRate2 : list) {
                b b2 = PolyvVideoUtil.loadLocalVideo(this.videoId, polyvBitRate2.getNum(), this.hlsSpeedType);
                if (b2.a() != 3 || !isMustFromLocal) continue;
                this.callOnVideoPlayErrorListener(20007, this.playId, this.videoId);
                this.setPlayerBufferingViewVisibility(8);
                return false;
            }
            if (isMustFromLocal) {
                this.callOnVideoPlayErrorListener(30002, this.playId, this.videoId);
                this.setPlayerBufferingViewVisibility(8);
                return false;
            }
            if (!PolyvSDKUtil.isOpenNetwork(this.mContext)) {
                this.cleanSurfaceHolderCanvas();
                this.callOnVideoPlayErrorListener(20003, this.playId, this.videoId);
                this.setPlayerBufferingViewVisibility(8);
                return false;
            }
        } else {
            b b3 = PolyvVideoUtil.loadLocalVideo(this.videoId, polyvBitRate.getNum(), this.hlsSpeedType);
            if (b3.a() == 2) {
                if (isMustFromLocal) {
                    this.callOnVideoPlayErrorListener(30002, this.playId, this.videoId);
                    this.setPlayerBufferingViewVisibility(8);
                    return false;
                }
                if (!PolyvSDKUtil.isOpenNetwork(this.mContext)) {
                    this.cleanSurfaceHolderCanvas();
                    this.callOnVideoPlayErrorListener(20003, this.playId, this.videoId);
                    this.setPlayerBufferingViewVisibility(8);
                    return false;
                }
            } else if (b3.a() == 3 && isMustFromLocal) {
                this.callOnVideoPlayErrorListener(20007, this.playId, this.videoId);
                this.setPlayerBufferingViewVisibility(8);
                return false;
            }
        }
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                if (!PolyvSDKUtil.validateVideoId(PolyvVideoView.this.videoId)) {
                    PolyvVideoView.this.callOnVideoPlayErrorListener(20014, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                    PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                    return;
                }
                PolyvBitRate polyvBitRate = PolyvBitRate.getBitRate(bitRateNum);
                if (polyvBitRate == null) {
                    PolyvVideoView.this.callOnVideoPlayErrorListener(20015, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                    PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                    return;
                }
                if (PolyvVideoView.this.hlsSpeedType == null) {
                    PolyvVideoView.this.callOnVideoPlayErrorListener(30001, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                    PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                    return;
                }
                if (PolyvVideoView.super.getMediaPlayer() == null) {
                    PolyvVideoView.this.callOnVideoPlayErrorListener(30009, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                    PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                    return;
                }
                if (PolyvVideoView.this.bitRate == polyvBitRate) {
                    PolyvVideoView.this.callOnVideoPlayErrorListener(30007, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                    PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                    return;
                }
                if (polyvBitRate != PolyvBitRate.ziDong && polyvBitRate.getNum() > PolyvVideoView.this.video.getDfNum()) {
                    PolyvVideoView.this.callOnVideoPlayErrorListener(30014, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                    PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                    return;
                }
                if (isMustFromLocal) {
                    if (ContextCompat.checkSelfPermission((Context)PolyvVideoView.this.mContext, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                        PolyvVideoView.this.callOnVideoPlayErrorListener(30018, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                        PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                        return;
                    }
                    if (!PolyvSDKUtil.checkOpWriteExternalStorage(PolyvVideoView.this.mContext)) {
                        PolyvVideoView.this.callOnVideoPlayErrorListener(30018, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                        PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                        return;
                    }
                }
                PolyvVideoView.this.mSeekWhenPrepared = PolyvVideoView.this.getCurrentPosition();
                PolyvVideoView.this.releaseInterior();
                if (polyvBitRate == PolyvBitRate.ziDong) {
                    List<PolyvBitRate> list = PolyvBitRate.getDescBitRateList(false);
                    for (PolyvBitRate polyvBitRate2 : list) {
                        b b2 = PolyvVideoUtil.loadLocalVideo(PolyvVideoView.this.videoId, polyvBitRate2.getNum(), PolyvVideoView.this.hlsSpeedType);
                        if (b2.a() == 1) {
                            PolyvVideoView.this.gotoPlayLocalVideo(PolyvVideoView.this.videoId, polyvBitRate2, PolyvVideoView.this.hlsSpeedType, b2.b());
                            PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                            return;
                        }
                        if (b2.a() != 3 || !isMustFromLocal) continue;
                        PolyvVideoView.this.callOnVideoPlayErrorListener(20007, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                        PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                        return;
                    }
                    if (isMustFromLocal) {
                        PolyvVideoView.this.callOnVideoPlayErrorListener(30002, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                        PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                        return;
                    }
                    if (!PolyvSDKUtil.isOpenNetwork(PolyvVideoView.this.mContext)) {
                        PolyvVideoView.this.cleanSurfaceHolderCanvas();
                        PolyvVideoView.this.callOnVideoPlayErrorListener(20003, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                        PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                        return;
                    }
                    PolyvVideoView.this.gotoPlayNetVideo(PolyvVideoView.this.videoId, polyvBitRate, PolyvVideoView.this.hlsSpeedType, false);
                } else {
                    b b3 = PolyvVideoUtil.loadLocalVideo(PolyvVideoView.this.videoId, polyvBitRate.getNum(), PolyvVideoView.this.hlsSpeedType);
                    if (b3.a() == 2) {
                        if (isMustFromLocal) {
                            PolyvVideoView.this.callOnVideoPlayErrorListener(30002, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                            PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                            return;
                        }
                        if (!PolyvSDKUtil.isOpenNetwork(PolyvVideoView.this.mContext)) {
                            PolyvVideoView.this.cleanSurfaceHolderCanvas();
                            PolyvVideoView.this.callOnVideoPlayErrorListener(20003, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                            PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                            return;
                        }
                    }
                    switch (b3.a()) {
                        case 1: {
                            PolyvVideoView.this.gotoPlayLocalVideo(PolyvVideoView.this.videoId, polyvBitRate, PolyvVideoView.this.hlsSpeedType, b3.b());
                            PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                            break;
                        }
                        case 2: {
                            PolyvVideoView.this.gotoPlayNetVideo(PolyvVideoView.this.videoId, polyvBitRate, PolyvVideoView.this.hlsSpeedType, false);
                            break;
                        }
                        case 3: {
                            if (isMustFromLocal) {
                                PolyvVideoView.this.callOnVideoPlayErrorListener(20007, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                                PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                                return;
                            }
                            PolyvVideoView.this.gotoPlayNetVideo(PolyvVideoView.this.videoId, polyvBitRate, PolyvVideoView.this.hlsSpeedType, false);
                        }
                    }
                }
            }
        });
        return true;
    }

    @Override
    public void changeHlsSpeedType(Video.HlsSpeedType hlsSpeedType) {
        this.changeHlsSpeedType(hlsSpeedType, false);
    }

    @Override
    public void changeHlsSpeedType(final Video.HlsSpeedType hlsSpeedType, final boolean isMustFromLocal) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                int n2;
                if (!PolyvSDKUtil.validateVideoId(PolyvVideoView.this.videoId)) {
                    PolyvVideoView.this.callOnVideoPlayErrorListener(20014, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                    PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                    return;
                }
                if (PolyvVideoView.this.bitRate == null) {
                    PolyvVideoView.this.callOnVideoPlayErrorListener(20015, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                    PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                    return;
                }
                if (hlsSpeedType == null) {
                    PolyvVideoView.this.callOnVideoPlayErrorListener(30001, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                    PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                    return;
                }
                if (PolyvVideoView.super.getMediaPlayer() == null) {
                    PolyvVideoView.this.callOnVideoPlayErrorListener(30010, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                    PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                    return;
                }
                if (PolyvVideoView.this.hlsSpeedType == hlsSpeedType) {
                    PolyvVideoView.this.callOnVideoPlayErrorListener(30008, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                    PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                    return;
                }
                if (isMustFromLocal) {
                    if (ContextCompat.checkSelfPermission((Context)PolyvVideoView.this.mContext, (String)"android.permission.WRITE_EXTERNAL_STORAGE") != 0) {
                        PolyvVideoView.this.callOnVideoPlayErrorListener(30018, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                        PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                        return;
                    }
                    if (!PolyvSDKUtil.checkOpWriteExternalStorage(PolyvVideoView.this.mContext)) {
                        PolyvVideoView.this.callOnVideoPlayErrorListener(30018, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                        PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                        return;
                    }
                }
                if ((n2 = PolyvVideoView.this.getDuration()) == 0) {
                    PolyvVideoView.this.mSeekWhenPrepared = 0;
                } else {
                    PolyvVideoView.this.mSeekWhenPrepared = PolyvVideoView.this.getCurrentPosition() / 1000 * 100 / (n2 / 1000);
                }
                PolyvVideoView.this.releaseInterior();
                if (PolyvVideoView.this.bitRate == PolyvBitRate.ziDong) {
                    List<PolyvBitRate> list = PolyvBitRate.getDescBitRateList(false);
                    for (PolyvBitRate polyvBitRate : list) {
                        b b2 = PolyvVideoUtil.loadLocalVideo(PolyvVideoView.this.videoId, polyvBitRate.getNum(), hlsSpeedType);
                        if (b2.a() == 1) {
                            PolyvVideoView.this.gotoPlayLocalVideo(PolyvVideoView.this.videoId, polyvBitRate, hlsSpeedType, b2.b());
                            PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                            return;
                        }
                        if (b2.a() != 3 || !isMustFromLocal) continue;
                        PolyvVideoView.this.callOnVideoPlayErrorListener(20007, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                        PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                        return;
                    }
                    if (isMustFromLocal) {
                        PolyvVideoView.this.callOnVideoPlayErrorListener(30002, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                        PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                        return;
                    }
                    if (!PolyvSDKUtil.isOpenNetwork(PolyvVideoView.this.mContext)) {
                        PolyvVideoView.this.cleanSurfaceHolderCanvas();
                        PolyvVideoView.this.callOnVideoPlayErrorListener(20003, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                        PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                        return;
                    }
                    PolyvVideoView.this.gotoPlayNetVideo(PolyvVideoView.this.videoId, PolyvVideoView.this.bitRate, hlsSpeedType, false);
                } else {
                    b b3 = PolyvVideoUtil.loadLocalVideo(PolyvVideoView.this.videoId, PolyvVideoView.this.bitRate.getNum(), hlsSpeedType);
                    if (b3.a() == 2) {
                        if (isMustFromLocal) {
                            PolyvVideoView.this.callOnVideoPlayErrorListener(30002, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                            PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                            return;
                        }
                        if (!PolyvSDKUtil.isOpenNetwork(PolyvVideoView.this.mContext)) {
                            PolyvVideoView.this.cleanSurfaceHolderCanvas();
                            PolyvVideoView.this.callOnVideoPlayErrorListener(20003, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                            PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                            return;
                        }
                    }
                    switch (b3.a()) {
                        case 1: {
                            PolyvVideoView.this.gotoPlayLocalVideo(PolyvVideoView.this.videoId, PolyvVideoView.this.bitRate, hlsSpeedType, b3.b());
                            PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                            break;
                        }
                        case 2: {
                            PolyvVideoView.this.gotoPlayNetVideo(PolyvVideoView.this.videoId, PolyvVideoView.this.bitRate, hlsSpeedType, false);
                            break;
                        }
                        case 3: {
                            if (isMustFromLocal) {
                                PolyvVideoView.this.callOnVideoPlayErrorListener(20007, PolyvVideoView.this.playId, PolyvVideoView.this.videoId);
                                PolyvVideoView.this.setPlayerBufferingViewVisibility(8);
                                return;
                            }
                            PolyvVideoView.this.gotoPlayNetVideo(PolyvVideoView.this.videoId, PolyvVideoView.this.bitRate, hlsSpeedType, false);
                        }
                    }
                }
            }
        });
    }

    @Override
    public void pause() {
        this.pause(false);
    }

    @Override
    public void pause(boolean isNotShowAdvert) {
        super.pause();
        this.PPTViewPause();
        this.callOnPlayPauseListenerPause();
        if (!isNotShowAdvert && this.isOpenAd && this.mAuxiliaryVideoView != null) {
            this.mAuxiliaryVideoView.runPauseAdvert();
        }
    }

    @Override
    public void seekTo(long pos) {
        this.seekTo((int)pos);
    }

    @Override
    public void seekTo(int pos) {
        long l2 = System.currentTimeMillis();
        if (this.mSeekLastTime == 0L) {
            this.mSeekLastTime = l2;
        } else {
            if (l2 - this.mSeekLastTime < 100L) {
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            this.mSeekLastTime = l2;
        }
        if (pos > 0) {
            if (pos < 1000) {
                pos = 1000;
            }
            pos = pos / 1000 * 1000;
        }
        super.seekTo(pos);
    }

    @Override
    public int getBufferPercentage() {
        if (super.getMediaPlayer() != null) {
            return this.mCurrentBufferPercentage;
        }
        return 0;
    }

    @Override
    public String getViewerId() {
        return this.viewerId;
    }

    @Override
    public void setViewerId(String viewerId) {
        this.viewerId = viewerId;
    }

    @Override
    public String getViewerName() {
        return this.viewerName;
    }

    @Override
    public void setViewerName(String viewerName) {
        this.viewerName = viewerName;
    }

    @Override
    public String getViewerParam() {
        return this.viewerParam;
    }

    @Override
    public void setViewerParam(String viewerParam) {
        this.viewerParam = viewerParam;
    }

    @Override
    public String getViewLogParam1() {
        return this.viewLogParam1;
    }

    @Override
    public void setViewLogParam1(String viewLogParam1) {
        this.viewLogParam1 = viewLogParam1;
    }

    @Override
    public String getViewLogParam2() {
        return this.viewLogParam2;
    }

    @Override
    public void setViewLogParam2(String viewLogParam2) {
        this.viewLogParam2 = viewLogParam2;
    }

    @Override
    public String getViewLogParam3() {
        return this.viewLogParam3;
    }

    @Override
    public void setViewLogParam3(String viewLogParam3) {
        this.viewLogParam3 = viewLogParam3;
    }

    @Override
    public String getViewLogParam4() {
        return this.viewLogParam4;
    }

    @Override
    public void setViewLogParam4(String viewLogParam4) {
        this.viewLogParam4 = viewLogParam4;
    }

    @Override
    public String getViewLogParam5() {
        return this.viewLogParam5;
    }

    @Override
    public void setViewLogParam5(String viewLogParam5) {
        this.viewLogParam5 = viewLogParam5;
    }

    @Override
    public void release() {
        this.release(true);
    }

    @Override
    public void release(final boolean cleartargetstate) {
        this.executorService.execute(new Runnable(){

            @Override
            public void run() {
                PolyvVideoView.this.releaseInterior(cleartargetstate);
            }
        });
    }

    private void releaseInterior() {
        this.releaseInterior(true);
    }

    private void releaseInterior(boolean cleartargetstate) {
        this.saveVideoProgress(this.videoId);
        super.release(cleartargetstate);
        this.isBuffering = false;
        this.isLoadingStop = false;
        this.endPlayPolling();
        this.cleanSurfaceHolderCanvas();
        if (this.mAuxiliaryVideoView != null) {
            this.mAuxiliaryVideoView.release();
        }
        if (this.mMediaController != null) {
            this.mMediaController.release();
        }
        if (this.polyvQuestion != null) {
            this.polyvQuestion.f();
        }
        if (this.polyvSRT != null) {
            this.polyvSRT.b();
        }
    }

    @Override
    public void start() {
        if (this.isInPlaybackState()) {
            PolyvVideoProgressVO polyvVideoProgressVO;
            this.PPTViewResume(true);
            if (!TextUtils.isEmpty((CharSequence)this.videoId) && this.isAutoContinue && this.getCurrentState() == this.getStatePlaybackCompletedCode() && (polyvVideoProgressVO = PolyvSDKClient.getInstance().getVideoProgressService().a(this.videoId)) != null && polyvVideoProgressVO.getProgress() > 0) {
                this.seekTo(polyvVideoProgressVO.getProgress());
            }
            try {
                super.start();
            }
            catch (Exception exception) {
                this.callOnVideoPlayErrorListener(20008, this.playId, this.videoId);
                return;
            }
            this.callOnPlayPauseListenerPlay();
            this.setPlayerBufferingViewVisibility(8);
        }
    }

    private boolean isPPTViewCanMove() {
        if (this.isPPTPlayback && this.pptDrawView != null) {
            return this.pptDrawView.isPPTViewCanMove();
        }
        return false;
    }

    @Override
    public void setPPTLiveDrawView(IPolyvPPTView pptView, boolean isLifeBeControlledByVideoView) {
        this.isPPTPlayback = true;
        this.pptDrawView = pptView;
        if (this.pptDrawView instanceof IPolyvLiveInnerPPTView) {
            this.pptInnerDrawView = (IPolyvLiveInnerPPTView)((Object)this.pptDrawView);
        }
        this.isLifeBeControlledByThis = isLifeBeControlledByVideoView;
    }

    private void PPTViewPause() {
        if (this.isPPTPlayback && this.pptDrawView != null && this.isLifeBeControlledByThis) {
            this.pptDrawView.pause();
        }
    }

    private void PPTViewResume() {
        this.PPTViewResume(false);
    }

    private void PPTViewResume(boolean isIngorePlaying) {
        this.isPPTResume = true;
        if (this.isPPTPlayback && this.pptDrawView != null && this.isLifeBeControlledByThis && (this.isPlaying() || isIngorePlaying)) {
            this.pptDrawView.resume();
        }
    }

    @Override
    public boolean isPPTResume() {
        return this.isPPTResume;
    }

    @Override
    public void setPPTStatus(boolean isPPTResume) {
        this.isPPTResume = isPPTResume;
    }

    private void PPTViewDestroy() {
        if (this.isPPTPlayback && this.pptDrawView != null && this.isLifeBeControlledByThis) {
            this.pptDrawView.destroy(false);
        }
    }

    private void setPPTLiveViewVisibility(int visibility) {
        if (this.isPPTPlayback && this.pptDrawView != null) {
            if (visibility == 0) {
                this.pptDrawView.showView(5);
            } else {
                this.pptDrawView.hideView(5);
            }
        }
    }

    @Override
    public boolean canShowControllerToPPTPlayback() {
        return !this.isPPTPlayback || this.mIsTranGesture || this.isPPTViewCanMove();
    }

    @Override
    public void PPTLiveLayoutChange() {
        if (this.isPPTPlayback) {
            if (this.isPPTViewCanMove()) {
                if (this.pptInnerDrawView != null) {
                    this.pptInnerDrawView.videoViewPPTLiveLayoutChange();
                }
                return;
            }
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    RelativeLayout.LayoutParams layoutParams = null;
                    if (PolyvVideoView.this.getParent().getParent() instanceof RelativeLayout) {
                        layoutParams = (RelativeLayout.LayoutParams)((View)PolyvVideoView.this.getParent()).getLayoutParams();
                    } else if (PolyvVideoView.this.getParent().getParent() instanceof LinearLayout) {
                        layoutParams = (LinearLayout.LayoutParams)((View)PolyvVideoView.this.getParent()).getLayoutParams();
                    } else if (PolyvVideoView.this.getParent().getParent() instanceof FrameLayout) {
                        layoutParams = (FrameLayout.LayoutParams)((View)PolyvVideoView.this.getParent()).getLayoutParams();
                    } else {
                        return;
                    }
                    PolyvVideoView.this.layoutChange_left = layoutParams.leftMargin;
                    PolyvVideoView.this.layoutChange_top = layoutParams.topMargin;
                    if (PolyvVideoView.this.pptInnerDrawView != null) {
                        PolyvVideoView.this.pptInnerDrawView.setLayoutChange_left(PolyvVideoView.this.layoutChange_left);
                        PolyvVideoView.this.pptInnerDrawView.setLayoutChange_top(PolyvVideoView.this.layoutChange_top);
                    }
                    layoutParams.topMargin = 0;
                    layoutParams.leftMargin = ((View)PolyvVideoView.this.getParent().getParent()).getMeasuredWidth() - layoutParams.width;
                    ((View)PolyvVideoView.this.getParent()).setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                }
            });
        }
    }

    @Override
    public void PPTLiveLayoutResume() {
        if (this.isPPTPlayback) {
            if (this.isPPTViewCanMove()) {
                if (this.pptInnerDrawView != null) {
                    this.pptInnerDrawView.videoViewPPTLiveLayoutResume();
                }
                return;
            }
            if (this.pptInnerDrawView != null) {
                this.layoutChange_left = this.pptInnerDrawView.getLayoutChange_left();
                this.layoutChange_top = this.pptInnerDrawView.getLayoutChange_top();
            }
            if (this.layoutChange_top > -1 && this.layoutChange_left > -1) {
                this.handler.post(new Runnable(){

                    @Override
                    public void run() {
                        RelativeLayout.LayoutParams layoutParams = null;
                        if (PolyvVideoView.this.getParent().getParent() instanceof RelativeLayout) {
                            layoutParams = (RelativeLayout.LayoutParams)((View)PolyvVideoView.this.getParent()).getLayoutParams();
                        } else if (PolyvVideoView.this.getParent().getParent() instanceof LinearLayout) {
                            layoutParams = (LinearLayout.LayoutParams)((View)PolyvVideoView.this.getParent()).getLayoutParams();
                        } else if (PolyvVideoView.this.getParent().getParent() instanceof FrameLayout) {
                            layoutParams = (FrameLayout.LayoutParams)((View)PolyvVideoView.this.getParent()).getLayoutParams();
                        } else {
                            return;
                        }
                        layoutParams.topMargin = Math.min(PolyvVideoView.this.layoutChange_top, ((View)PolyvVideoView.this.getParent().getParent()).getMeasuredHeight() - layoutParams.height);
                        layoutParams.leftMargin = Math.min(PolyvVideoView.this.layoutChange_left, ((View)PolyvVideoView.this.getParent().getParent()).getMeasuredWidth() - layoutParams.width);
                        ((View)PolyvVideoView.this.getParent()).setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                        PolyvVideoView.this.layoutChange_left = -1;
                        PolyvVideoView.this.layoutChange_top = -1;
                        if (PolyvVideoView.this.pptInnerDrawView != null) {
                            PolyvVideoView.this.pptInnerDrawView.setLayoutChange_left(PolyvVideoView.this.layoutChange_left);
                            PolyvVideoView.this.pptInnerDrawView.setLayoutChange_top(PolyvVideoView.this.layoutChange_top);
                        }
                    }
                });
            }
        }
    }

    protected void onConfigurationChanged(final Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.isPPTPlayback && !this.isPPTViewCanMove()) {
            this.handler.post(new Runnable(){

                @Override
                public void run() {
                    RelativeLayout.LayoutParams layoutParams = null;
                    if (PolyvVideoView.this.getParent().getParent() instanceof RelativeLayout) {
                        layoutParams = (RelativeLayout.LayoutParams)((View)PolyvVideoView.this.getParent()).getLayoutParams();
                    } else if (PolyvVideoView.this.getParent().getParent() instanceof LinearLayout) {
                        layoutParams = (LinearLayout.LayoutParams)((View)PolyvVideoView.this.getParent()).getLayoutParams();
                    } else if (PolyvVideoView.this.getParent().getParent() instanceof FrameLayout) {
                        layoutParams = (FrameLayout.LayoutParams)((View)PolyvVideoView.this.getParent()).getLayoutParams();
                    } else {
                        return;
                    }
                    int n2 = ((View)PolyvVideoView.this.getParent().getParent()).getMeasuredHeight();
                    int n3 = ((View)PolyvVideoView.this.getParent().getParent()).getMeasuredWidth();
                    if (newConfig.orientation == 1) {
                        if (PolyvVideoView.this.pptInnerDrawView != null) {
                            PolyvVideoView.this.layoutChange_left = PolyvVideoView.this.pptInnerDrawView.getLayoutChange_left();
                            PolyvVideoView.this.layoutChange_top = PolyvVideoView.this.pptInnerDrawView.getLayoutChange_top();
                            PolyvVideoView.this.portrait_left = PolyvVideoView.this.pptInnerDrawView.getPortrait_left();
                            PolyvVideoView.this.portrait_top = PolyvVideoView.this.pptInnerDrawView.getPortrait_top();
                        }
                        layoutParams.topMargin = Math.min(PolyvVideoView.this.layoutChange_top > -1 ? PolyvVideoView.this.layoutChange_top : PolyvVideoView.this.portrait_top, Math.max(n2, n3) - layoutParams.height);
                        layoutParams.leftMargin = Math.min(PolyvVideoView.this.layoutChange_left > -1 ? PolyvVideoView.this.layoutChange_left : PolyvVideoView.this.portrait_left, Math.min(n2, n3) - layoutParams.width);
                        ((View)PolyvVideoView.this.getParent()).setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    } else if (newConfig.orientation == 2) {
                        PolyvVideoView.this.portrait_left = layoutParams.leftMargin;
                        PolyvVideoView.this.portrait_top = layoutParams.topMargin;
                        if (PolyvVideoView.this.pptInnerDrawView != null) {
                            PolyvVideoView.this.pptInnerDrawView.setPortrait_left(PolyvVideoView.this.portrait_left);
                            PolyvVideoView.this.pptInnerDrawView.setPortrait_top(PolyvVideoView.this.portrait_top);
                        }
                        layoutParams.topMargin = 0;
                        layoutParams.leftMargin = Math.max(n2, n3) - layoutParams.width;
                        ((View)PolyvVideoView.this.getParent()).setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                    }
                }
            });
        }
    }

    private void initSetting(boolean isPPTPlayback) {
        this.isPPTPlayback = isPPTPlayback;
        super.clearCanvasInStart(false);
        if (this.marqueeView != null && this.marqueeView.getAllItem() != null && this.marqueeView.getAllItem().size() > 0) {
            this.marqueeItems = this.marqueeView.copyAllItem();
            this.marqueeView.runOnUiRemoveAllItem();
        }
        if (this.mIRenderCallback == null) {
            this.mIRenderCallback = new IRenderView.IRenderCallback(){

                public void onSurfaceCreated(@NonNull IRenderView.ISurfaceHolder holder, int width, int height) {
                }

                public void onSurfaceChanged(@NonNull IRenderView.ISurfaceHolder holder, int format, int width, int height) {
                    PolyvVideoView.this.surfaceWidth = width;
                    PolyvVideoView.this.surfaceHeight = height;
                }

                public void onSurfaceDestroyed(@NonNull IRenderView.ISurfaceHolder holder) {
                }
            };
            this.getRenderView().addRenderCallback(this.mIRenderCallback);
        }
        if (isPPTPlayback) {
            this.initPPTLiveSetting();
        }
    }

    private void initPPTLiveSetting() {
        this.mMeasureCount = 0;
        this.isPPTResume = false;
        this.clearCanvasInStart(true);
        this.getRenderView().setMeasureCallback(new IRenderView.IMeasureCallback(){

            public void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                if (!PolyvVideoView.this.isPPTResume) {
                    PolyvVideoView.this.mMinMeasureWidth = widthMeasureSpec;
                    PolyvVideoView.this.mMinMeasureHeight = heightMeasureSpec;
                } else if (++PolyvVideoView.this.mMeasureCount == 2) {
                    if (widthMeasureSpec <= PolyvVideoView.this.mMinMeasureWidth && heightMeasureSpec <= PolyvVideoView.this.mMinMeasureHeight) {
                        PolyvVideoView.this.getRenderView().setMeasureCallback(null);
                        PolyvVideoView.this.setParentLayoutParams(widthMeasureSpec, heightMeasureSpec);
                    }
                } else if (PolyvVideoView.this.mMeasureCount == 3) {
                    PolyvVideoView.this.getRenderView().setMeasureCallback(null);
                    PolyvVideoView.this.setParentLayoutParams(widthMeasureSpec, heightMeasureSpec);
                }
            }
        });
        if (this.getSurfaceHolder() != null) {
            Canvas canvas;
            Canvas canvas2 = canvas = this.surfaceHeight > 0 && this.surfaceWidth > 0 ? this.getSurfaceHolder().lockCanvas(new Rect(0, 0, this.surfaceWidth, this.surfaceHeight)) : this.getSurfaceHolder().lockCanvas();
            if (canvas != null) {
                canvas.drawColor(0, PorterDuff.Mode.CLEAR);
                this.getSurfaceHolder().unlockCanvasAndPost(canvas);
            }
        }
    }

    private void setParentLayoutParams(final int widthMeasureSpec, final int heightMeasureSpec) {
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                RelativeLayout.LayoutParams layoutParams = null;
                RelativeLayout.LayoutParams layoutParams2 = null;
                if (PolyvVideoView.this.getParent().getParent() instanceof RelativeLayout) {
                    layoutParams = new RelativeLayout.LayoutParams(widthMeasureSpec, heightMeasureSpec);
                    layoutParams2 = (RelativeLayout.LayoutParams)((View)PolyvVideoView.this.getParent()).getLayoutParams();
                } else if (PolyvVideoView.this.getParent().getParent() instanceof LinearLayout) {
                    layoutParams = new LinearLayout.LayoutParams(widthMeasureSpec, heightMeasureSpec);
                    layoutParams2 = (LinearLayout.LayoutParams)((View)PolyvVideoView.this.getParent()).getLayoutParams();
                } else if (PolyvVideoView.this.getParent().getParent() instanceof FrameLayout) {
                    layoutParams = new FrameLayout.LayoutParams(widthMeasureSpec, heightMeasureSpec);
                    layoutParams2 = (FrameLayout.LayoutParams)((View)PolyvVideoView.this.getParent()).getLayoutParams();
                } else {
                    return;
                }
                int n2 = ((View)PolyvVideoView.this.getParent().getParent()).getMeasuredWidth();
                int n3 = ((View)PolyvVideoView.this.getParent().getParent()).getMeasuredHeight();
                int n4 = layoutParams2.leftMargin;
                int n5 = layoutParams2.topMargin;
                if (n4 + widthMeasureSpec > n2) {
                    n4 = n2 - widthMeasureSpec;
                }
                if (n5 + heightMeasureSpec > n3) {
                    n5 = n3 - heightMeasureSpec;
                }
                layoutParams.leftMargin = n4;
                layoutParams.topMargin = n5;
                PolyvVideoView.this.eventType = 7;
                ((View)PolyvVideoView.this.getParent()).addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                        PolyvVideoView.this.eventType = 0;
                        ((View)PolyvVideoView.this.getParent()).removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                    }
                });
                ((View)PolyvVideoView.this.getParent()).setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                if (PolyvVideoView.this.pptInnerDrawView != null) {
                    PolyvVideoView.this.pptInnerDrawView.videoViewMeasureFinish();
                }
            }
        });
    }

    @Override
    public void setMarqueeView(PolyvMarqueeView marqueeView, PolyvMarqueeItem marqueeItem) {
        this.marqueeView = marqueeView;
        this.marqueeItem = marqueeItem;
    }

    @Override
    public void setOpenMarquee(boolean isOpenMarquee) {
        this.isOpenMarquee = isOpenMarquee;
    }

    private boolean onTouchEvent(MotionEvent event, boolean isTran) {
        this.mIsTranGesture = isTran;
        if (this.mNeedGesture) {
            if (this.mGestureDetector != null) {
                this.mGestureDetector.onTouchEvent(event);
            }
            if (this.isPPTPlayback && !isTran && !this.isPPTViewCanMove()) {
                if (event.getAction() == 0) {
                    this.lastX = event.getX();
                    this.lastY = event.getY();
                }
                if (event.getAction() == 2) {
                    switch (this.eventType) {
                        case 0: {
                            float f2 = event.getX();
                            float f3 = event.getY();
                            int n2 = (int)(f2 - this.lastX);
                            int n3 = (int)(f3 - this.lastY);
                            View view = (View)this.getParent();
                            int n4 = view.getLeft() + n2;
                            int n5 = view.getTop() + n3;
                            int n6 = ((View)view.getParent()).getMeasuredWidth();
                            int n7 = ((View)view.getParent()).getMeasuredHeight();
                            if (n2 < 0 && n4 < 0) {
                                n4 = 0;
                            }
                            if (n3 < 0 && n5 < 0) {
                                n5 = 0;
                            }
                            if (n2 > 0 && view.getRight() + n2 > n6) {
                                n4 = view.getLeft() + (n6 - view.getRight());
                            }
                            if (n3 > 0 && view.getBottom() + n3 > n7) {
                                n5 = view.getTop() + (n7 - view.getBottom());
                            }
                            RelativeLayout.LayoutParams layoutParams = null;
                            if (this.getParent().getParent() instanceof RelativeLayout) {
                                layoutParams = (RelativeLayout.LayoutParams)view.getLayoutParams();
                            } else if (this.getParent().getParent() instanceof LinearLayout) {
                                layoutParams = (LinearLayout.LayoutParams)view.getLayoutParams();
                            } else {
                                if (!(this.getParent().getParent() instanceof FrameLayout)) break;
                                layoutParams = (FrameLayout.LayoutParams)view.getLayoutParams();
                            }
                            layoutParams.leftMargin = n4;
                            layoutParams.topMargin = n5;
                            view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                        }
                    }
                }
            }
            if (event.getAction() == 1) {
                switch (this.eventType) {
                    case 1: {
                        this.callOnGestureRightDownListener(false, true);
                        break;
                    }
                    case 2: {
                        this.callOnGestureRightUpListener(false, true);
                        break;
                    }
                    case 3: {
                        this.callOnGestureLeftDownListener(false, true);
                        break;
                    }
                    case 4: {
                        this.callOnGestureLeftUpListener(false, true);
                        break;
                    }
                    case 5: {
                        this.callOnGestureSwipeLeftListener(false, true);
                        break;
                    }
                    case 6: {
                        this.callOnGestureSwipeRightListener(false, true);
                    }
                }
                this.lastX = 0.0f;
                this.lastY = 0.0f;
                this.eventType = 0;
            }
            return true;
        }
        if (this.isInPlaybackState() && this.mMediaController != null && (!this.isPPTPlayback || isTran)) {
            this.toggleMediaControlsVisiblity();
        }
        return false;
    }

    @Override
    public void clearGestureInfo() {
        if (this.eventType != 0) {
            this.lastX = 0.0f;
            this.lastY = 0.0f;
            this.eventType = 0;
        }
    }

    @Override
    public boolean onPPTLiveTranTouchEvent(MotionEvent event, int width) {
        this.tranLayoutWidth = width;
        return this.onTouchEvent(event, true);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.onTouchEvent(event, false);
    }

    @Override
    protected void callOnPreparedListener(IMediaPlayer mediaPlayer) {
        super.callOnPreparedListener(mediaPlayer);
        this.PPTViewResume(true);
        if (this.isOpenMarquee && this.marqueeView != null) {
            if (this.marqueeItems != null) {
                for (PolyvMarqueeItem polyvMarqueeItem : this.marqueeItems) {
                    this.marqueeView.addItem(polyvMarqueeItem);
                }
                this.marqueeItems = null;
            } else {
                this.marqueeView.addItem(this.marqueeItem);
            }
        }
    }

    @Override
    protected void callOnVideoPlayErrorListener(int playErrorReason, String playId, String videoId) {
        this.callOnVideoPlayErrorListener(playErrorReason, playId, videoId, null);
    }

    @Override
    protected void callOnVideoPlayErrorListener(int playErrorReason, String playId, String videoId, List<String> exceptionList) {
        this.callOnVideoPlayErrorListener(playErrorReason, playId, videoId, exceptionList, null);
    }

    @Override
    protected void callOnVideoPlayErrorListener(int playErrorReason, String playId, String videoId, List<String> exceptionList, List<String> logList) {
        super.callOnVideoPlayErrorListener(playErrorReason, playId, videoId, exceptionList, logList);
        this.PPTViewPause();
    }

    @Override
    protected void callOnErrorListener(IMediaPlayer mediaPlayer, int frameworkErr, int implErr, String playId, String videoId) {
        this.callOnErrorListener(mediaPlayer, frameworkErr, implErr, playId, videoId, null);
    }

    @Override
    protected void callOnErrorListener(IMediaPlayer mediaPlayer, int frameworkErr, int implErr, String playId, String videoId, List<String> exceptionList) {
        this.callOnErrorListener(mediaPlayer, frameworkErr, implErr, playId, videoId, exceptionList, null);
    }

    @Override
    protected void callOnErrorListener(IMediaPlayer mediaPlayer, int frameworkErr, int implErr, String playId, String videoId, List<String> exceptionList, List<String> logList) {
        super.callOnErrorListener(mediaPlayer, frameworkErr, implErr, playId, videoId, exceptionList, logList);
        this.PPTViewPause();
    }

    @Override
    protected void callOnCompletionListener(IMediaPlayer mediaPlayer) {
        super.callOnCompletionListener(mediaPlayer);
        this.PPTViewPause();
    }

    public boolean onTrackballEvent(MotionEvent ev) {
        if (this.isInPlaybackState() && this.mMediaController != null) {
            this.toggleMediaControlsVisiblity();
        }
        return true;
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        boolean bl;
        boolean bl2 = bl = keyCode != 4 && keyCode != 24 && keyCode != 25 && keyCode != 164 && keyCode != 82 && keyCode != 5 && keyCode != 6;
        if (this.isInPlaybackState() && bl && this.mMediaController != null) {
            if (keyCode == 79 || keyCode == 85) {
                if (this.isPlaying()) {
                    this.pause();
                    this.mMediaController.show();
                } else {
                    this.start();
                    this.mMediaController.hide();
                }
                return true;
            }
            if (keyCode == 126) {
                if (!this.isPlaying()) {
                    this.start();
                    this.mMediaController.hide();
                }
                return true;
            }
            if (keyCode == 86 || keyCode == 127) {
                if (this.isPlaying()) {
                    this.pause();
                    this.mMediaController.show();
                }
                return true;
            }
            this.toggleMediaControlsVisiblity();
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onWindowVisibilityChanged(int visibility) {
        if (visibility == 8) {
            this.saveVideoProgress(this.videoId);
            int n2 = this.getCurrentPosition();
            if (n2 > 0) {
                this.mSeekWhenPrepared = n2;
            }
        }
        super.onWindowVisibilityChanged(visibility);
    }

    private void saveVideoProgress(String videoId) {
        this.saveVideoProgress(videoId, false);
    }

    private void saveVideoProgress(String videoId, boolean isErrorCompletion) {
        if (TextUtils.isEmpty((CharSequence)videoId)) {
            return;
        }
        if (!this.isAutoContinue) {
            return;
        }
        if (!this.isInPlaybackState()) {
            return;
        }
        if (!isErrorCompletion && this.getCurrentState() == this.getStatePlaybackCompletedCode()) {
            return;
        }
        com.easefun.polyvsdk.database.b.a a2 = PolyvSDKClient.getInstance().getVideoProgressService();
        a2.a(0, 7, 0);
        int n2 = this.getCurrentPosition();
        if (n2 > 0) {
            a2.a(new PolyvVideoProgressVO(videoId, n2));
        }
    }

    private void toggleMediaControlsVisiblity() {
        if (this.mMediaController.isShowing()) {
            this.mMediaController.hide();
        } else {
            this.mMediaController.show();
        }
    }

    @Override
    public boolean isOpenSound() {
        AudioManager audioManager = (AudioManager)this.mContext.getApplicationContext().getSystemService("audio");
        int n2 = audioManager.getStreamVolume(3);
        if (n2 != 0) {
            this.streamMusicVolume = n2;
        }
        return n2 != 0;
    }

    @Override
    public void openSound() {
        AudioManager audioManager = (AudioManager)this.mContext.getApplicationContext().getSystemService("audio");
        if (this.streamMusicVolume == 0) {
            audioManager.setStreamVolume(3, audioManager.getStreamMaxVolume(3) / 2, 0);
        } else {
            audioManager.setStreamVolume(3, this.streamMusicVolume, 0);
        }
    }

    @Override
    public void closeSound() {
        AudioManager audioManager = (AudioManager)this.mContext.getApplicationContext().getSystemService("audio");
        this.streamMusicVolume = audioManager.getStreamVolume(3);
        audioManager.setStreamVolume(3, 0, 0);
    }

    @Override
    public void setVolume(int volume) {
        if (volume < 0) {
            volume = 0;
        } else if (volume > 100) {
            volume = 100;
        }
        double d2 = (double)volume / 100.0;
        AudioManager audioManager = (AudioManager)this.getContext().getSystemService("audio");
        int n2 = audioManager.getStreamMaxVolume(3);
        int n3 = (int)((double)n2 * d2);
        audioManager.setStreamVolume(3, n3, 0);
    }

    @Override
    public int getVolume() {
        AudioManager audioManager = (AudioManager)this.getContext().getSystemService("audio");
        int n2 = audioManager.getStreamVolume(3);
        int n3 = audioManager.getStreamMaxVolume(3);
        double d2 = (double)n2 / (double)n3;
        return (int)(d2 * 100.0);
    }

    @Override
    public void setBrightness(Activity activity, int brightness) {
        if (brightness <= 0 && brightness != -1) {
            brightness = Build.VERSION.SDK_INT > 16 ? 0 : 1;
        } else if (brightness > 100) {
            brightness = 100;
        }
        Window window = activity.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        layoutParams.screenBrightness = brightness == -1 ? -1.0f : (float)brightness / 100.0f;
        window.setAttributes(layoutParams);
    }

    @Override
    public int getBrightness(Activity activity) {
        Window window = activity.getWindow();
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        int n2 = 0;
        try {
            n2 = layoutParams.screenBrightness == -1.0f ? Settings.System.getInt((ContentResolver)activity.getContentResolver(), (String)"screen_brightness") * 100 / 255 : (int)(layoutParams.screenBrightness * 100.0f);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n2;
    }

    @Override
    public boolean setBrightness(int brightness) {
        if (brightness < 0) {
            brightness = 0;
        } else if (brightness > 100) {
            brightness = 100;
        }
        int n2 = 1;
        try {
            n2 = Settings.System.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"screen_brightness_mode");
        }
        catch (Settings.SettingNotFoundException settingNotFoundException) {
            Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(settingNotFoundException, -1));
            return false;
        }
        if (n2 == 1) {
            Settings.System.putInt((ContentResolver)this.mContext.getContentResolver(), (String)"screen_brightness_mode", (int)0);
        }
        brightness = (int)((float)brightness * 255.0f / 100.0f);
        try {
            Settings.System.putInt((ContentResolver)this.mContext.getContentResolver(), (String)"screen_brightness", (int)brightness);
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
            return false;
        }
        return true;
    }

    @Override
    public int getBrightness() {
        int n2 = Settings.System.getInt((ContentResolver)this.mContext.getContentResolver(), (String)"screen_brightness", (int)-1);
        n2 = (int)((float)n2 / 255.0f * 100.0f);
        return n2;
    }

    @Override
    public boolean canStart() {
        return this.isInPlaybackState();
    }

    @Override
    public void setVideoLayout(int layout) {
        this.setAspectRatio(layout);
    }

    @Override
    public boolean setAspectRatio(int screen) {
        if (this.getRenderView() == null) {
            return false;
        }
        if (this.getCurrentAspectRatio() == screen) {
            return false;
        }
        this.setCurrentAspectRatio(screen);
        this.getRenderView().setAspectRatio(screen);
        return true;
    }

    @Override
    public int getAspectRatio() {
        return this.getCurrentAspectRatio();
    }

    @Override
    public void setPlayerBufferingIndicator(@NonNull View view) {
        this.playerBufferingView = view;
    }

    @Override
    public void setMediaBufferingIndicator(@NonNull View view) {
        this.setPlayerBufferingIndicator(view);
    }

    @Override
    public void setAuxiliaryVideoView(PolyvAuxiliaryVideoView auxiliaryVideoView) {
        this.mAuxiliaryVideoView = auxiliaryVideoView;
        if (this.mAuxiliaryVideoView != null) {
            this.mAuxiliaryVideoView.setOpenAd(this.isOpenAd);
            this.mAuxiliaryVideoView.setOpenTeaser(this.isOpenTeaser);
            this.mAuxiliaryVideoView.setOpenRemind(this.isOpenPreload, this.preloadSecond);
            this.mAuxiliaryVideoView.setOnAdvertisementOutListener(this.getOnAdvertisementOutListener());
            this.mAuxiliaryVideoView.setOnAdvertisementOutListener(this.getOnAdvertisementOutListener2());
            this.mAuxiliaryVideoView.setOnAdvertisementCountDownListener(this.getOnAdvertisementCountDownListener());
            this.mAuxiliaryVideoView.setOnAdvertisementEventListener(this.getOnAdvertisementEventListener());
            this.mAuxiliaryVideoView.setOnAdvertisementEventListener(this.getOnAdvertisementEventListener2());
            this.mAuxiliaryVideoView.setOnTeaserOutListener(this.getOnTeaserOutListener());
            this.mAuxiliaryVideoView.setOnTeaserCountDownListener(this.getOnTeaserCountDownListener());
            this.mAuxiliaryVideoView.setOnRemindCallback(new IPolyvOnRemindCallbackListener(){

                @Override
                public void callback() {
                    PolyvVideoView.this.playNetVideo(false);
                }
            });
            this.mAuxiliaryVideoView.setOnAuxiliaryPlayEndListener(new IPolyvOnAuxiliaryPlayEndListener(){

                @Override
                public void onBeforeEnd(boolean isSendRemind) {
                    PolyvVideoView.this.setPPTLiveViewVisibility(0);
                    if (isSendRemind) {
                        if (PolyvVideoView.this.isInPlaybackState()) {
                            PolyvVideoView.this.start();
                            PolyvVideoView.this.callOnPreloadPlayListener();
                        } else {
                            PolyvVideoView.this.isStartPlay = true;
                        }
                    } else {
                        PolyvVideoView.this.playNetVideo(true);
                    }
                }

                @Override
                public void onAfterEnd() {
                }
            });
        }
    }

    @Override
    public PolyvAuxiliaryVideoView getAuxiliaryVideoView() {
        return this.mAuxiliaryVideoView;
    }

    @Override
    public void setMediaController(PolyvBaseMediaController mediaController) {
        this.mMediaController = mediaController;
        super.setMediaController(mediaController);
    }

    @Override
    public PolyvBaseMediaController getMediaController() {
        return this.mMediaController;
    }

    @Override
    public void setOpenTeaser(boolean isOpenTeaser) {
        this.isOpenTeaser = isOpenTeaser;
        if (this.mAuxiliaryVideoView != null) {
            this.mAuxiliaryVideoView.setOpenTeaser(isOpenTeaser);
        }
    }

    @Override
    public void setOpenAd(boolean isOpenAd) {
        this.isOpenAd = isOpenAd;
        if (this.mAuxiliaryVideoView != null) {
            this.mAuxiliaryVideoView.setOpenAd(isOpenAd);
        }
    }

    @Override
    public void setOpenQuestion(boolean isOpenQuestion) {
        this.polyvQuestion.a(isOpenQuestion);
    }

    @Override
    public void setOpenSRT(boolean isOpenSRT) {
        this.polyvSRT.a(isOpenSRT);
    }

    @Override
    public void setAutoContinue(boolean isAutoContinue) {
        this.isAutoContinue = isAutoContinue;
    }

    @Override
    public boolean isOpenPreload() {
        return this.isOpenPreload;
    }

    @Override
    public void setOpenPreload(boolean isOpenPreload) {
        this.setOpenPreload(isOpenPreload, 1);
    }

    @Override
    public void setOpenPreload(boolean isOpenPreload, int preloadSecond) {
        this.isOpenPreload = isOpenPreload;
        this.preloadSecond = preloadSecond;
        if (this.mAuxiliaryVideoView != null) {
            this.mAuxiliaryVideoView.setOpenRemind(isOpenPreload, preloadSecond);
        }
    }

    @Override
    public void setQuestionOverdueTime(int month, int day, int hour) {
        this.polyvQuestion.a(month, day, hour);
    }

    @Override
    public void setQuestionAnswerOverdueTime(int month, int day, int hour) {
        this.polyvQuestion.b(month, day, hour);
    }

    @Override
    @Deprecated
    public void setOnBufferingUpdateListener(IPolyvOnBufferingUpdateListener l2) {
        super.setOnBufferingUpdateListener(l2);
    }

    @Override
    @Deprecated
    public void setOnVideoPlayErrorLisener(IPolyvOnVideoPlayErrorListener l2) {
        super.setOnVideoPlayErrorLisener(l2);
    }

    @Override
    @Deprecated
    public void setOnVideoPlayErrorListener(IPolyvOnVideoPlayErrorListener l2) {
        super.setOnVideoPlayErrorListener(l2);
        this.polyvQuestion.a(l2);
    }

    @Override
    public void setOnVideoPlayErrorListener(IPolyvOnVideoPlayErrorListener2 l2) {
        super.setOnVideoPlayErrorListener(l2);
        this.polyvQuestion.a(l2);
    }

    @Override
    @Deprecated
    public void setOnCompletionListener(IPolyvOnCompletionListener l2) {
        super.setOnCompletionListener(l2);
    }

    @Override
    @Deprecated
    public void setOnPreparedListener(IPolyvOnPreparedListener l2) {
        super.setOnPreparedListener(l2);
    }

    @Override
    @Deprecated
    public void setOnErrorListener(IPolyvOnErrorListener l2) {
        super.setOnErrorListener(l2);
    }

    @Override
    @Deprecated
    public void setOnInfoListener(IPolyvOnInfoListener l2) {
        super.setOnInfoListener(l2);
    }

    @Override
    @Deprecated
    public void setOnSeekCompleteListener(IPolyvOnSeekCompleteListener l2) {
        super.setOnSeekCompleteListener(l2);
    }

    @Override
    @Deprecated
    public void setOnVideoSizeChangedListener(IPolyvOnVideoSizeChangedListener l2) {
        super.setOnVideoSizeChangedListener(l2);
    }

    @Override
    public void setOnVideoSRTListener(IPolyvOnVideoSRTListener l2) {
        this.polyvSRT.a(l2);
    }

    @Override
    @Deprecated
    public void setOnAdvertisementOutListener(IPolyvOnAdvertisementOutListener l2) {
        super.setOnAdvertisementOutListener(l2);
        if (this.mAuxiliaryVideoView != null) {
            this.mAuxiliaryVideoView.setOnAdvertisementOutListener(l2);
        }
    }

    @Override
    public void setOnAdvertisementOutListener(IPolyvOnAdvertisementOutListener2 l2) {
        super.setOnAdvertisementOutListener(l2);
        if (this.mAuxiliaryVideoView != null) {
            this.mAuxiliaryVideoView.setOnAdvertisementOutListener(l2);
        }
    }

    @Override
    public void setOnAdvertisementCountDownListener(IPolyvOnAdvertisementCountDownListener l2) {
        super.setOnAdvertisementCountDownListener(l2);
        if (this.mAuxiliaryVideoView != null) {
            this.mAuxiliaryVideoView.setOnAdvertisementCountDownListener(l2);
        }
    }

    @Override
    @Deprecated
    public void setOnAdvertisementEventListener(IPolyvOnAdvertisementEventListener l2) {
        super.setOnAdvertisementEventListener(l2);
        if (this.mAuxiliaryVideoView != null) {
            this.mAuxiliaryVideoView.setOnAdvertisementEventListener(l2);
        }
    }

    @Override
    public void setOnAdvertisementEventListener(IPolyvOnAdvertisementEventListener2 l2) {
        super.setOnAdvertisementEventListener(l2);
        if (this.mAuxiliaryVideoView != null) {
            this.mAuxiliaryVideoView.setOnAdvertisementEventListener(l2);
        }
    }

    @Override
    public void setOnTeaserOutListener(IPolyvOnTeaserOutListener l2) {
        super.setOnTeaserOutListener(l2);
        if (this.mAuxiliaryVideoView != null) {
            this.mAuxiliaryVideoView.setOnTeaserOutListener(l2);
        }
    }

    @Override
    public void setOnTeaserCountDownListener(IPolyvOnTeaserCountDownListener l2) {
        super.setOnTeaserCountDownListener(l2);
        if (this.mAuxiliaryVideoView != null) {
            this.mAuxiliaryVideoView.setOnTeaserCountDownListener(l2);
        }
    }

    @Override
    @Deprecated
    public void setOnQuestionOutListener(IPolyvOnQuestionOutListener l2) {
        this.polyvQuestion.a(l2);
    }

    @Override
    public void setOnQuestionOutListener(IPolyvOnQuestionOutListener2 l2) {
        this.polyvQuestion.a(l2);
    }

    @Override
    public void setOnQuestionAnswerTipsListener(IPolyvOnQuestionAnswerTipsListener l2) {
        this.polyvQuestion.a(l2);
    }

    @Override
    @Deprecated
    public IMediaPlayer getMediaPlayer() {
        return null;
    }

    @Override
    public float getSpeed() {
        if (this.hlsSpeedType != null && this.hlsSpeedType == Video.HlsSpeedType.SPEED_1_5X) {
            float f2 = super.getSpeed();
            if (f2 == 0.0f) {
                return 1.5f;
            }
            return 1.5f * f2;
        }
        return super.getSpeed();
    }

    @Override
    public void destroy() {
        this.PPTViewDestroy();
        this.executorService.submit(new Runnable(){

            @Override
            public void run() {
                PolyvVideoView.this.releaseInterior();
                PolyvVideoView.this.clearListener();
                PolyvVideoView.this.mContext = null;
                if (PolyvVideoView.this.executorService != null) {
                    PolyvVideoView.this.executorService.shutdown();
                    PolyvVideoView.this.executorService = null;
                }
                if (PolyvVideoView.this.mAuxiliaryVideoView != null) {
                    PolyvVideoView.this.mAuxiliaryVideoView.destroy();
                    PolyvVideoView.this.mAuxiliaryVideoView = null;
                }
                if (PolyvVideoView.this.mMediaController != null) {
                    PolyvVideoView.this.mMediaController.destroy();
                    PolyvVideoView.this.mMediaController = null;
                }
                if (PolyvVideoView.this.polyvSRT != null) {
                    PolyvVideoView.this.polyvSRT.d();
                    PolyvVideoView.this.polyvSRT = null;
                }
                if (PolyvVideoView.this.polyvQuestion != null) {
                    PolyvVideoView.this.polyvQuestion.g();
                    PolyvVideoView.this.polyvQuestion = null;
                }
                PolyvVideoView.this.playerBufferingView = null;
                PolyvVideoView.this.resetProperty();
                PolyvVideoView.this.mCompletionListener = null;
                PolyvVideoView.this.mPreparedListener = null;
                PolyvVideoView.this.mErrorListener = null;
                PolyvVideoView.this.mInfoListener = null;
                PolyvVideoView.this.mSeekCompleteListener = null;
                PolyvVideoView.this.mVideoSizeChangedListener = null;
                IjkMediaPlayer.native_profileEnd();
            }
        });
    }

    @Override
    public boolean changeSRT(@NonNull String key) {
        return this.polyvSRT.a(key);
    }

    @Override
    @Nullable
    public String getCurrSRTKey() {
        return this.polyvSRT.c();
    }

    @Override
    public void answerQuestion() {
        this.polyvQuestion.c();
    }

    @Override
    public void answerQuestion(@NonNull List<Integer> indexList) {
        this.polyvQuestion.a(indexList);
    }

    @Override
    public void answerQuestionFault() {
        this.polyvQuestion.d();
    }

    @Override
    public void skipQuestion() {
        this.polyvQuestion.e();
    }

    @Override
    public GestureDetector getGestureDetector() {
        return this.mGestureDetector;
    }

    @Override
    public boolean getNeedGestureDetector() {
        return this.mNeedGesture;
    }

    @Override
    public void setNeedGestureDetector(boolean need) {
        this.mNeedGesture = need;
    }

    @Override
    public boolean isPreparedState() {
        return super.getMediaPlayer() != null && this.getCurrentState() == this.getStatePreparedCode();
    }

    @Override
    public boolean isPlayState() {
        return this.isPlayState(false);
    }

    @Override
    public boolean isPlayState(boolean isAndBuffer) {
        if (isAndBuffer) {
            return this.isInPlaybackState() && this.isPlaying();
        }
        return this.isInPlaybackState() && this.isPlaying() && !this.isBuffering;
    }

    @Override
    public boolean isInPlaybackState() {
        return this.isInPlaybackStateForwarding();
    }

    @Override
    public boolean isPausState() {
        return this.isPauseState();
    }

    @Override
    public boolean isPauseState() {
        return this.isInPlaybackState() && this.getCurrentState() == this.getStatePauseCode();
    }

    @Override
    public boolean isBufferState() {
        return this.isInPlaybackState() && this.isBuffering;
    }

    @Override
    public boolean isCompletedState() {
        return this.isInPlaybackState() && this.getCurrentState() == this.getStatePlaybackCompletedCode();
    }

    @Override
    public void onActivityResume() {
        this.isLoadingStop = false;
        if (this.mAuxiliaryVideoView != null && this.mAuxiliaryVideoView.getVisibility() == 0) {
            this.mAuxiliaryVideoView.start();
        } else if (this.isPauseState()) {
            this.start();
        }
    }

    @Override
    public boolean onActivityStop() {
        boolean bl;
        if (this.mAuxiliaryVideoView != null && this.mAuxiliaryVideoView.getVisibility() == 0) {
            bl = true;
            this.mAuxiliaryVideoView.pause();
        } else {
            bl = this.isPlayState(true);
            if (bl) {
                this.pause();
            } else {
                this.isLoadingStop = true;
            }
        }
        return bl;
    }

    @Override
    @Deprecated
    public void setOnCompletionListener(final IMediaPlayer.OnCompletionListener l2) {
        super.setOnCompletionListener(new IPolyvOnCompletionListener(){

            public void onCompletion(IMediaPlayer iMediaPlayer) {
                if (l2 != null) {
                    l2.onCompletion(iMediaPlayer);
                }
            }
        });
    }

    @Override
    @Deprecated
    public void setOnErrorListener(final IMediaPlayer.OnErrorListener l2) {
        super.setOnErrorListener(new IPolyvOnErrorListener(){

            public boolean onError(IMediaPlayer iMediaPlayer, int i2, int i1) {
                if (l2 != null) {
                    return l2.onError(iMediaPlayer, i2, i1);
                }
                return true;
            }
        });
    }

    @Override
    @Deprecated
    public void setOnInfoListener(final IMediaPlayer.OnInfoListener l2) {
        super.setOnInfoListener(new IPolyvOnInfoListener(){

            public boolean onInfo(IMediaPlayer iMediaPlayer, int i2, int i1) {
                if (l2 != null) {
                    return l2.onInfo(iMediaPlayer, i2, i1);
                }
                return true;
            }
        });
    }

    @Override
    @Deprecated
    public void setOnPreparedListener(final IMediaPlayer.OnPreparedListener l2) {
        super.setOnPreparedListener(new IPolyvOnPreparedListener(){

            public void onPrepared(IMediaPlayer iMediaPlayer) {
                if (l2 != null) {
                    l2.onPrepared(iMediaPlayer);
                }
            }
        });
    }

    @Override
    @Deprecated
    public void setOnBufferingUpdateListener(final IMediaPlayer.OnBufferingUpdateListener l2) {
        super.setOnBufferingUpdateListener(new IPolyvOnBufferingUpdateListener(){

            public void onBufferingUpdate(IMediaPlayer iMediaPlayer, int i2) {
                if (l2 != null) {
                    l2.onBufferingUpdate(iMediaPlayer, i2);
                }
            }
        });
    }

    @Override
    @Deprecated
    public void setMediaController(IMediaController controller) {
    }

    @Override
    @Deprecated
    public void playNext() {
    }

    @Override
    @Deprecated
    public void setUserAgent(String ua) {
    }

    private void setVideoParam(@NonNull String playId, @NonNull String videoId, @NonNull PolyvBitRate bitRate, @NonNull Video.HlsSpeedType hlsSpeedType, @NonNull c playType, PolyvVideoVO videoVO) {
        this.playId = playId;
        this.videoId = videoId;
        this.bitRate = bitRate;
        this.hlsSpeedType = hlsSpeedType;
        this.playType = playType;
        this.video = videoVO;
    }

    private void resetProperty() {
        this.playId = "";
        this.videoId = "";
        this.bitRate = PolyvBitRate.ziDong;
        this.hlsSpeedType = Video.HlsSpeedType.SPEED_1X;
        this.playType = c.a;
        this.video = null;
        this.tokenVO = null;
        this.mCurrentBufferPercentage = 0;
        this.watchTimeDuration = 0;
        this.stayTimeDuration = 0;
        this.mSeekWhenPrepared = 0;
        this.isSendLoading = false;
        this.isSeeking = false;
        this.isSendBuffer = false;
        this.isSendError = false;
        this.isBuffering = false;
        this.isFullmp4OccurredError = false;
        if (this.polyvSRT != null) {
            this.polyvSRT.c(null);
        }
        if (this.polyvQuestion != null) {
            this.polyvQuestion.a();
        }
    }
}

