/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.marquee;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.os.Build;
import android.text.SpannableString;
import android.text.style.ScaleXSpan;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.easefun.polyvsdk.marquee.PolyvMarqueeItem;

final class PolyvMarqueeTextView
extends TextView {
    private float spacing;
    private CharSequence srcText;
    private boolean hasStroke;
    private boolean blurStroke;
    private int strokeWidth;
    private int strokeColor;

    public PolyvMarqueeTextView(Context context) {
        this(context, null);
    }

    public PolyvMarqueeTextView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public PolyvMarqueeTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, new PolyvMarqueeItem());
    }

    public PolyvMarqueeTextView(Context context, AttributeSet attrs, int defStyleAttr, PolyvMarqueeItem polyvMarqueeItem) {
        super(context, attrs, defStyleAttr);
        this.hasStroke = polyvMarqueeItem.isHasStroke();
        this.blurStroke = polyvMarqueeItem.isBlurStroke();
        this.strokeWidth = polyvMarqueeItem.getStrokeWidth();
        this.strokeColor = Color.argb((int)polyvMarqueeItem.getStrokeAlpha(), (int)Color.red((int)polyvMarqueeItem.getStrokeColor()), (int)Color.green((int)polyvMarqueeItem.getStrokeColor()), (int)Color.blue((int)polyvMarqueeItem.getStrokeColor()));
    }

    public int getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setSpacing(float spacing) {
        this.spacing = spacing;
        if (spacing > 0.0f) {
            this.applySpacing();
        }
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        this.srcText = text;
        if (this.spacing > 0.0f) {
            this.applySpacing();
        } else {
            super.setText(text, type);
        }
    }

    private void applySpacing() {
        if (this.srcText == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < this.srcText.length(); ++i2) {
            stringBuilder.append(this.srcText.charAt(i2));
            if (i2 + 1 >= this.srcText.length()) continue;
            stringBuilder.append("\u00a0");
        }
        SpannableString spannableString = new SpannableString((CharSequence)stringBuilder.toString());
        if (stringBuilder.toString().length() > 1) {
            for (int i3 = 1; i3 < stringBuilder.toString().length(); i3 += 2) {
                spannableString.setSpan((Object)new ScaleXSpan(this.spacing), i3, i3 + 1, 33);
            }
        }
        super.setText((CharSequence)spannableString, TextView.BufferType.SPANNABLE);
    }

    protected void onDraw(Canvas canvas) {
        if (this.hasStroke) {
            ColorStateList colorStateList = this.getTextColors();
            this.getPaint().setStyle(Paint.Style.STROKE);
            this.getPaint().setStrokeWidth((float)this.strokeWidth);
            if (this.blurStroke) {
                PolyvMarqueeTextView.disableHardwareRendering((View)this);
                this.getPaint().setMaskFilter((MaskFilter)new BlurMaskFilter((float)this.strokeWidth, BlurMaskFilter.Blur.SOLID));
            }
            this.setTextColor(this.strokeColor);
            super.onDraw(canvas);
            this.getPaint().setStyle(Paint.Style.FILL);
            this.setTextColor(colorStateList);
        }
        super.onDraw(canvas);
    }

    public static void disableHardwareRendering(View v) {
        if (Build.VERSION.SDK_INT >= 11) {
            v.setLayerType(1, null);
        }
    }
}

