/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.log;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.Log;
import com.easefun.polyvsdk.PolyvDevMountInfo;
import com.easefun.polyvsdk.PolyvSDKClient;
import com.easefun.polyvsdk.PolyvSDKUtil;
import com.easefun.polyvsdk.log.a;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class PolyvLogFile {
    private static final String TAG = PolyvLogFile.class.getSimpleName();
    private static final ExecutorService executorService = Executors.newSingleThreadExecutor();

    public static void extractLogcat2File(String playId, String videoId) {
        PolyvLogFile.extractLogcat2File(playId, videoId, null);
    }

    public static void extractLogcat2File(String playId, String videoId, List<String> exceptionList) {
        PolyvLogFile.extractLogcat2File(playId, videoId, exceptionList, null);
    }

    public static void extractLogcat2File(final String playId, final String videoId, final List<String> exceptionList, final List<String> logList) {
        if (TextUtils.isEmpty((CharSequence)playId)) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)videoId)) {
            return;
        }
        executorService.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            @Override
            public void run() {
                void var10_25;
                String string;
                boolean bl;
                File file = PolyvSDKClient.getInstance().getDownloadDir();
                if (file == null) {
                    String string2 = "download is null";
                    Log.e((String)TAG, (String)string2);
                    PolyvLogFile.sendErrorTestEvent(playId, videoId, string2);
                    a.a(playId, videoId, exceptionList);
                    return;
                }
                try {
                    bl = PolyvDevMountInfo.getInstance().mkdirs(file);
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
                    bl = false;
                }
                if (!bl) {
                    String string3 = "download not exists";
                    Log.e((String)TAG, (String)string3);
                    PolyvLogFile.sendErrorTestEvent(playId, videoId, string3);
                    a.a(playId, videoId, exceptionList);
                    return;
                }
                File file2 = new File(file.getAbsolutePath(), "polyvlog");
                try {
                    bl = PolyvDevMountInfo.getInstance().mkdirs(file2);
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
                    bl = false;
                }
                if (!bl) {
                    String string4 = "polyvlog not exists";
                    Log.e((String)TAG, (String)string4);
                    PolyvLogFile.sendErrorTestEvent(playId, videoId, string4);
                    a.a(playId, videoId, exceptionList);
                    return;
                }
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(System.currentTimeMillis());
                String string5 = calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5);
                File file3 = new File(file2, string5);
                try {
                    bl = PolyvDevMountInfo.getInstance().mkdirs(file3);
                }
                catch (Exception exception) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
                    bl = false;
                }
                if (!bl) {
                    String string2 = "today not exists";
                    Log.e((String)TAG, (String)string2);
                    PolyvLogFile.sendErrorTestEvent(playId, videoId, string2);
                    a.a(playId, videoId, exceptionList);
                    return;
                }
                File file4 = new File(file3, "polyv_log_" + System.currentTimeMillis() + ".txt");
                if (!file4.exists()) {
                    try {
                        file4.createNewFile();
                    }
                    catch (Exception exception) {
                        String string3 = PolyvSDKUtil.getExceptionFullMessage(exception, -1);
                        Log.e((String)TAG, (String)string3);
                        PolyvLogFile.sendErrorTestEvent(playId, videoId, string3);
                        a.a(playId, videoId, exceptionList);
                        return;
                    }
                }
                calendar.add(5, -1);
                String string4 = calendar.get(1) + "-" + (calendar.get(2) + 1) + "-" + calendar.get(5);
                String[] stringArray = file2.list();
                if (stringArray != null) {
                    for (String string6 : stringArray) {
                        if (string5.equals(string6) || string4.equals(string6)) continue;
                        this.a(new File(file2, string6));
                    }
                }
                String string7 = "";
                Process process = null;
                try {
                    process = Runtime.getRuntime().exec("logcat -d -v time -t 70");
                }
                catch (Exception exception) {
                    String string8 = PolyvSDKUtil.getExceptionFullMessage(exception, -1);
                }
                if (process != null && TextUtils.isEmpty((CharSequence)(string = this.a(process.getErrorStream())))) {
                    String string9 = this.a(process.getInputStream());
                }
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss:SSS", Locale.getDefault());
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append("============================").append(simpleDateFormat.format(new Date())).append("==").append(videoId).append("==").append("polyv-android-sdk2.2.0-20171212").append("==========================\n");
                if (logList != null) {
                    for (String string10 : logList) {
                        stringBuilder.append(string10).append("\n");
                    }
                }
                stringBuilder.append("-------------------------------------------------\n");
                if (exceptionList != null) {
                    for (String string10 : exceptionList) {
                        stringBuilder.append(string10).append("\n");
                    }
                }
                stringBuilder.append("-------------------------------------------------\n");
                stringBuilder.append((String)var10_25);
                Object object = null;
                try {
                    object = new FileOutputStream(file4);
                    ((FileOutputStream)object).write(stringBuilder.toString().getBytes());
                }
                catch (Exception exception) {
                    String string11 = PolyvSDKUtil.getExceptionFullMessage(exception, -1);
                    Log.e((String)TAG, (String)string11);
                    PolyvLogFile.sendErrorTestEvent(playId, videoId, string11);
                    a.a(playId, videoId, exceptionList);
                    return;
                }
                finally {
                    if (object != null) {
                        try {
                            ((FileOutputStream)object).close();
                        }
                        catch (IOException iOException) {
                            Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
                        }
                    }
                }
                int n2 = -1;
                if (process != null) {
                    try {
                        process.waitFor();
                        n2 = process.exitValue();
                    }
                    catch (Exception exception) {
                        Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(exception));
                    }
                }
                Log.i((String)TAG, (String)("logcat exit value " + n2 + ",\u9519\u8bef\u65e5\u5fd7\u4fdd\u5b58\u5728" + file4.getAbsolutePath() + "\u8bf7\u67e5\u770b"));
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private String a(@NonNull InputStream inputStream) {
                ReadableByteChannel readableByteChannel = null;
                ByteArrayOutputStream byteArrayOutputStream = null;
                Channel channel = null;
                try {
                    readableByteChannel = Channels.newChannel(inputStream);
                    byteArrayOutputStream = new ByteArrayOutputStream();
                    channel = Channels.newChannel(byteArrayOutputStream);
                    ByteBuffer byteBuffer = ByteBuffer.allocate(4096);
                    while (true) {
                        int n2;
                        if ((n2 = readableByteChannel.read(byteBuffer)) == -1) break;
                        byteBuffer.flip();
                        channel.write(byteBuffer);
                        byteBuffer.clear();
                    }
                    byteBuffer.clear();
                    String string = byteArrayOutputStream.toString();
                    return string;
                }
                catch (Exception exception) {
                    String string = PolyvSDKUtil.getExceptionFullMessage(exception, -1);
                    return string;
                }
                finally {
                    if (channel != null) {
                        try {
                            channel.close();
                        }
                        catch (IOException iOException) {
                            Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
                        }
                    }
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (IOException iOException) {
                            Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
                        }
                    }
                    if (readableByteChannel != null) {
                        try {
                            readableByteChannel.close();
                        }
                        catch (IOException iOException) {
                            Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
                        }
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
                        }
                    }
                }
            }

            private boolean a(File file) {
                if (file.isDirectory()) {
                    String[] stringArray;
                    for (String string : stringArray = file.list()) {
                        boolean bl = this.a(new File(file, string));
                        if (bl) continue;
                        return false;
                    }
                }
                if (file.exists()) {
                    return file.delete();
                }
                return true;
            }
        });
    }

    private static void sendErrorTestEvent(String pid, String vid, String msg) {
        ArrayList<String> arrayList = new ArrayList<String>(1);
        arrayList.add(msg);
        a.a(pid, vid, arrayList);
    }
}

