/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk.database.question;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.easefun.polyvsdk.QuestionVO;
import com.easefun.polyvsdk.database.question.a;
import com.easefun.polyvsdk.vo.PolyvQuestionVO;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class QuestionDatabaseService {
    private static final String DATEBASENAME = "polyv_sdk_question.db";
    private a questionOpenHelper = null;
    private static final String separator1 = ",";
    private static final String separator1_EScape = "&quot";
    private static final String separator2 = ";";
    private static final String separator2_EScape = "&amp";

    public QuestionDatabaseService(Context context) {
        this.questionOpenHelper = new a(context, DATEBASENAME, null, 1);
    }

    @NonNull
    public List<PolyvQuestionVO> listQuestion(@NonNull String vid) {
        String[] stringArray;
        String string;
        String[] stringArray2;
        SQLiteDatabase sQLiteDatabase = this.questionOpenHelper.getReadableDatabase();
        Cursor cursor = sQLiteDatabase.query("question_table", stringArray2 = new String[]{"examId", "userId", "vid", "showTime", "hours", "minutes", "seconds", "question", "choices", "answer", "skip", "type", "mp3Url", "wrongTime", "wrongShow", "status", "createdTime", "isFromDownload"}, string = "vid = ?", stringArray = new String[]{vid}, null, null, null);
        int n2 = cursor.getCount();
        if (n2 == 0) {
            return new ArrayList<PolyvQuestionVO>(0);
        }
        cursor.moveToFirst();
        ArrayList<PolyvQuestionVO> arrayList = new ArrayList<PolyvQuestionVO>(n2);
        PolyvQuestionVO polyvQuestionVO = null;
        do {
            String string2 = cursor.getString(cursor.getColumnIndex("examId"));
            String string3 = cursor.getString(cursor.getColumnIndex("userId"));
            String string4 = cursor.getString(cursor.getColumnIndex("vid"));
            String string5 = cursor.getString(cursor.getColumnIndex("showTime"));
            int n3 = cursor.getInt(cursor.getColumnIndex("hours"));
            int n4 = cursor.getInt(cursor.getColumnIndex("minutes"));
            int n5 = cursor.getInt(cursor.getColumnIndex("seconds"));
            String string6 = cursor.getString(cursor.getColumnIndex("question"));
            String string7 = cursor.getString(cursor.getColumnIndex("choices"));
            String string8 = cursor.getString(cursor.getColumnIndex("answer"));
            boolean bl = cursor.getShort(cursor.getColumnIndex("skip")) != 0;
            int n6 = cursor.getInt(cursor.getColumnIndex("type"));
            String string9 = cursor.getString(cursor.getColumnIndex("mp3Url"));
            int n7 = cursor.getInt(cursor.getColumnIndex("wrongTime"));
            int n8 = cursor.getInt(cursor.getColumnIndex("wrongShow"));
            int n9 = cursor.getInt(cursor.getColumnIndex("status"));
            long l2 = cursor.getLong(cursor.getColumnIndex("createdTime"));
            boolean bl2 = cursor.getShort(cursor.getColumnIndex("isFromDownload")) != 0;
            polyvQuestionVO = new PolyvQuestionVO(string2, string3, string4, string5, n3, n4, n5, string6, this.stringToChoicesList(string7), string8, bl, n6, string9, n7, n8, n9, l2, bl2);
            arrayList.add(polyvQuestionVO);
        } while (cursor.moveToNext());
        cursor.close();
        return arrayList;
    }

    public List<Long> insertQuestionList(@NonNull List<PolyvQuestionVO> questionList) {
        SQLiteDatabase sQLiteDatabase = this.questionOpenHelper.getWritableDatabase();
        ContentValues contentValues = null;
        Date date = new Date();
        ArrayList<Long> arrayList = new ArrayList<Long>(questionList.size());
        for (PolyvQuestionVO polyvQuestionVO : questionList) {
            contentValues = new ContentValues();
            contentValues.put("examId", polyvQuestionVO.getExamId());
            contentValues.put("userId", polyvQuestionVO.getUserId());
            contentValues.put("vid", polyvQuestionVO.getVid());
            contentValues.put("showTime", polyvQuestionVO.getShowTime());
            contentValues.put("hours", Integer.valueOf(polyvQuestionVO.getHours()));
            contentValues.put("minutes", Integer.valueOf(polyvQuestionVO.getMinutes()));
            contentValues.put("seconds", Integer.valueOf(polyvQuestionVO.getSeconds()));
            contentValues.put("question", polyvQuestionVO.getQuestion());
            contentValues.put("choices", this.choicesListToString(polyvQuestionVO.getChoicesList()));
            contentValues.put("answer", polyvQuestionVO.getAnswer());
            contentValues.put("skip", Boolean.valueOf(polyvQuestionVO.isSkip()));
            contentValues.put("type", Integer.valueOf(polyvQuestionVO.getType()));
            contentValues.put("mp3Url", polyvQuestionVO.getMp3url());
            contentValues.put("wrongTime", Integer.valueOf(polyvQuestionVO.getWrongTime()));
            contentValues.put("wrongShow", Integer.valueOf(polyvQuestionVO.getWrongShow()));
            contentValues.put("status", Integer.valueOf(polyvQuestionVO.getStatus()));
            contentValues.put("createdTime", Long.valueOf(polyvQuestionVO.getCreatedTime()));
            contentValues.put("isFromDownload", Boolean.valueOf(polyvQuestionVO.isFromDownload()));
            contentValues.put("save_date", com.easefun.polyvsdk.database.a.m.format(date));
            long l2 = sQLiteDatabase.replace("question_table", null, contentValues);
            arrayList.add(l2);
        }
        return arrayList;
    }

    public int deleteQuestionByVid(@NonNull String vid) {
        SQLiteDatabase sQLiteDatabase = this.questionOpenHelper.getWritableDatabase();
        String string = "vid = ?";
        String[] stringArray = new String[]{vid};
        return sQLiteDatabase.delete("question_table", string, stringArray);
    }

    public int deleteOverdueQuestion(int month, int day, int hour) {
        SQLiteDatabase sQLiteDatabase = this.questionOpenHelper.getWritableDatabase();
        String string = String.format("%s < datetime(?) and %s == 0", "save_date", "isFromDownload");
        Calendar calendar = Calendar.getInstance();
        calendar.set(2, calendar.get(2) - month);
        calendar.set(5, calendar.get(5) - day);
        calendar.set(11, calendar.get(11) - hour);
        String string2 = com.easefun.polyvsdk.database.a.m.format(calendar.getTime());
        String[] stringArray = new String[]{string2};
        return sQLiteDatabase.delete("question_table", string, stringArray);
    }

    private String choicesListToString(List<QuestionVO.ChoicesVO> choicesList) {
        StringBuilder stringBuilder = new StringBuilder();
        QuestionVO.ChoicesVO choicesVO = null;
        int n2 = choicesList.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            choicesVO = choicesList.get(i2);
            String string = choicesVO.getAnswer().replaceAll(separator2, separator2_EScape).replaceAll(separator1, separator1_EScape);
            stringBuilder.append(string).append(separator1).append(choicesVO.getRightAnswer());
            if (i2 == n2 - 1) continue;
            stringBuilder.append(separator2);
        }
        return stringBuilder.toString();
    }

    private List<QuestionVO.ChoicesVO> stringToChoicesList(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return new ArrayList<QuestionVO.ChoicesVO>(0);
        }
        String[] stringArray = str.split(separator2);
        ArrayList<QuestionVO.ChoicesVO> arrayList = new ArrayList<QuestionVO.ChoicesVO>(stringArray.length);
        String[] stringArray2 = null;
        QuestionVO.ChoicesVO choicesVO = null;
        for (String string : stringArray) {
            stringArray2 = string.split(separator1);
            String string2 = stringArray2[0];
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                string2 = string2.replaceAll(separator2_EScape, separator2).replaceAll(separator1_EScape, separator1);
            }
            choicesVO = new QuestionVO.ChoicesVO(string2, Integer.parseInt(stringArray2[1]));
            arrayList.add(choicesVO);
        }
        return arrayList;
    }
}

