/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Binder;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.easefun.polyvsdk.PolyvBitRate;
import com.easefun.polyvsdk.PolyvSDKClient;
import com.easefun.polyvsdk.RestVO;
import com.easefun.polyvsdk.Video;
import com.easefun.polyvsdk.database.video.VideoDatabaseService;
import com.easefun.polyvsdk.vo.PolyvRestVO;
import com.easefun.polyvsdk.vo.PolyvVideoJSONVO;
import com.easefun.polyvsdk.vo.PolyvVideoVO;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PolyvSDKUtil {
    private static final String TAG = PolyvSDKUtil.class.getSimpleName();
    public static final int CONNECT_TIMEOUT = 10000;
    public static final int READ_TIMEOUT = 10000;
    private static StringBuilder mFormatBuilder = new StringBuilder();
    private static Formatter mFormatter = new Formatter(mFormatBuilder, Locale.getDefault());
    public static final String UTF8 = "UTF-8";
    @Deprecated
    public static final String encode_head = "polyv";

    public static String MD5(String md5) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray = messageDigest.digest(md5.getBytes());
            StringBuilder stringBuilder = new StringBuilder();
            for (byte by : byArray) {
                stringBuilder.append(Integer.toHexString(by & 0xFF | 0x100).substring(1, 3));
            }
            return stringBuilder.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "";
        }
    }

    @Deprecated
    public static JSONObject loadUserJson(String userid) {
        String string = PolyvSDKUtil.getUrl2String("http://v.polyv.net/userjson/" + userid + ".js");
        try {
            return new JSONObject(string);
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            return null;
        }
    }

    @Deprecated
    public static String getVpidFromTsUrl(String tsurl) {
        int n2 = tsurl.lastIndexOf("/");
        int n3 = tsurl.indexOf("_", n2);
        return tsurl.substring(n2 + 1, n3 + 2);
    }

    public static String getPid() {
        Random random = new Random();
        long l2 = System.currentTimeMillis();
        long l3 = random.nextInt(1000000) + 1000000;
        return l2 + "X" + l3;
    }

    @Nullable
    public static Video loadVideoJSON2Video(@NonNull String vid) throws IllegalArgumentException, JSONException {
        return PolyvSDKUtil.loadVideoJSON2Video(vid, null);
    }

    @Nullable
    public static Video loadVideoJSON2Video(@NonNull String vid, List<String> exceptionList) throws IllegalArgumentException, JSONException {
        return PolyvSDKUtil.loadVideoJSON2Video(vid, exceptionList, null);
    }

    @Nullable
    public static Video loadVideoJSON2Video(@NonNull String vid, List<String> exceptionList, List<String> logList) throws IllegalArgumentException, JSONException {
        if (TextUtils.isEmpty((CharSequence)vid)) {
            throw new IllegalArgumentException("vid\u4e0d\u80fd\u4e3a\u7a7a");
        }
        VideoDatabaseService videoDatabaseService = PolyvSDKClient.getInstance().getVideoDBService();
        videoDatabaseService.deleteOverdueVideo(0, 4);
        PolyvVideoVO polyvVideoVO = videoDatabaseService.getVideo(vid);
        if (polyvVideoVO == null) {
            PolyvVideoJSONVO polyvVideoJSONVO = PolyvSDKUtil.getVideoJSONVO(vid, exceptionList, logList);
            if (polyvVideoJSONVO == null) {
                if (logList != null) {
                    logList.add("loadVideoJSON2Video\u4e2dvideoJSONVO is null");
                }
                return null;
            }
            polyvVideoVO = polyvVideoJSONVO.getVideoVO();
            if (polyvVideoVO.getStatus() >= 60 && !polyvVideoVO.isOutflow() && !polyvVideoVO.isTimeoutFlow() && logList != null) {
                logList.add("\u4fdd\u5b58\u5230\u6570\u636e\u5e93");
            }
        }
        return PolyvVideoVO.copyToVideo(polyvVideoVO);
    }

    @Nullable
    static PolyvVideoJSONVO getVideoJSONVO(String vid, List<String> exceptionList, List<String> logList) {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add(String.format("https://player.polyv.net/videojson/%s.json", vid));
        arrayList.add(String.format("http://v3.polyv.net/videojson/%s.json", vid));
        for (String string : arrayList) {
            for (int i2 = 0; i2 < 3; ++i2) {
                JSONObject jSONObject;
                JSONObject jSONObject2;
                String string2 = PolyvSDKUtil.getUrl2String(string, 10000, 10000, exceptionList, logList);
                if (TextUtils.isEmpty((CharSequence)string2)) {
                    if (logList == null) continue;
                    logList.add("body[" + string2 + "] is empty");
                    continue;
                }
                try {
                    jSONObject2 = new JSONObject(string2);
                }
                catch (JSONException jSONException) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(jSONException, -1));
                    if (exceptionList == null) continue;
                    exceptionList.add(PolyvSDKUtil.getExceptionFullMessage(jSONException, -1));
                    continue;
                }
                int n2 = jSONObject2.optInt("code", 0);
                if (n2 != 200) {
                    if (logList == null) continue;
                    logList.add("code[" + n2 + "] is error");
                    continue;
                }
                String string3 = jSONObject2.optString("body", "");
                if (TextUtils.isEmpty((CharSequence)string3)) {
                    if (logList == null) continue;
                    logList.add("body[" + n2 + "] is empty in json");
                    continue;
                }
                String string4 = PolyvSDKClient.getInstance().getDataToString(vid, string3);
                try {
                    jSONObject = new JSONObject(string4);
                }
                catch (JSONException jSONException) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(jSONException, -1));
                    if (exceptionList == null) continue;
                    exceptionList.add(PolyvSDKUtil.getExceptionFullMessage(jSONException, -1));
                    continue;
                }
                PolyvVideoVO polyvVideoVO = PolyvVideoVO.fromJSONObject(vid, jSONObject);
                if (logList != null) {
                    logList.add("body[" + string2 + "],json[" + jSONObject2.toString() + "]");
                }
                return new PolyvVideoJSONVO(polyvVideoVO, string2);
            }
        }
        return null;
    }

    public static List<RestVO> convertJsonToRestVOList(String jsonBody) throws JSONException {
        ArrayList<RestVO> arrayList = new ArrayList<RestVO>();
        if (TextUtils.isEmpty((CharSequence)jsonBody)) {
            return arrayList;
        }
        JSONObject jSONObject = new JSONObject(jsonBody);
        JSONArray jSONArray = jSONObject.optJSONArray("data");
        if (jSONArray == null) {
            return arrayList;
        }
        int n2 = jSONArray.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            JSONObject jSONObject2 = jSONArray.optJSONObject(i2);
            if (jSONObject2 == null) continue;
            arrayList.add(PolyvRestVO.formatJSONObject(jSONObject2));
        }
        return arrayList;
    }

    public static String sha1(String str) {
        String string = "";
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            messageDigest.reset();
            messageDigest.update(str.getBytes(UTF8));
            string = PolyvSDKUtil.byteToHex(messageDigest.digest());
        }
        catch (UnsupportedEncodingException | NoSuchAlgorithmException exception) {
            Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
        }
        return string;
    }

    private static String byteToHex(byte[] hash) {
        Formatter formatter = new Formatter();
        for (byte by : hash) {
            formatter.format("%02x", by);
        }
        String string = formatter.toString();
        formatter.close();
        return string;
    }

    public static int getErrorCodeFromJson(String jsonbody) throws JSONException {
        if (TextUtils.isEmpty((CharSequence)jsonbody)) {
            return -9999;
        }
        JSONObject jSONObject = new JSONObject(jsonbody);
        return jSONObject.getInt("error");
    }

    public static int formatToSecond(int hour, int minute, int second) {
        int n2 = hour * 3600;
        n2 += minute * 60;
        return n2 += second;
    }

    public static String getVideoDisplayTime(long timeMs) {
        int n2 = (int)timeMs / 1000;
        int n3 = n2 % 60;
        int n4 = n2 / 60 % 60;
        int n5 = n2 / 3600;
        mFormatBuilder.setLength(0);
        if (n5 > 0) {
            return mFormatter.format("%02d:%02d:%02d", n5, n4, n3).toString();
        }
        return mFormatter.format("%02d:%02d:%02d", n5, n4, n3).toString();
    }

    public static boolean isOpenNetwork(Context context) {
        NetworkInfo networkInfo;
        if (context == null) {
            return true;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        return connectivityManager != null && (networkInfo = connectivityManager.getActiveNetworkInfo()) != null && networkInfo.isConnected() && networkInfo.getState() == NetworkInfo.State.CONNECTED;
    }

    public static boolean validateVideoId(String videoId) {
        if (TextUtils.isEmpty((CharSequence)videoId)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[[a-z]|[0-9]]{32}_[[a-z]|[0-9]]$");
        Matcher matcher = pattern.matcher(videoId);
        return matcher.matches();
    }

    public static boolean validateVideoPoolBitrateId(String vpbid) {
        if (TextUtils.isEmpty((CharSequence)vpbid)) {
            return false;
        }
        Pattern pattern = Pattern.compile("^[[a-z]|[0-9]]{32}_[" + PolyvBitRate.getMinBitRate().getNum() + "-" + PolyvBitRate.getMaxBitRate().getNum() + "]$");
        Matcher matcher = pattern.matcher(vpbid);
        return matcher.matches();
    }

    public static String getUrl2String(String urlStr) {
        return PolyvSDKUtil.getUrl2String(urlStr, true);
    }

    @Deprecated
    public static String getUrl2String(String urlStr, boolean useUserAgent) {
        return PolyvSDKUtil.getUrl2String(urlStr, useUserAgent, UTF8);
    }

    @Deprecated
    public static String getUrl2String(String urlStr, boolean useUserAgent, String charset) {
        return PolyvSDKUtil.getUrl2String(urlStr, useUserAgent, charset, 10000);
    }

    @Deprecated
    public static String getUrl2String(String urlStr, boolean useUserAgent, String charset, int connectTimeout) {
        return PolyvSDKUtil.getUrl2String(urlStr, useUserAgent, charset, connectTimeout, 10000);
    }

    @Deprecated
    public static String getUrl2String(String urlStr, boolean useUserAgent, String charset, int connectTimeout, int readTimeout) {
        return PolyvSDKUtil.getUrl2String(urlStr, useUserAgent, charset, connectTimeout, readTimeout, null);
    }

    @Deprecated
    public static String getUrl2String(String urlStr, boolean useUserAgent, String charset, int connectTimeout, int readTimeout, List<String> exceptionList) {
        return PolyvSDKUtil.getUrl2String(urlStr, useUserAgent, charset, connectTimeout, readTimeout, exceptionList, null);
    }

    @Deprecated
    public static String getUrl2String(String urlStr, boolean useUserAgent, String charset, int connectTimeout, int readTimeout, List<String> exceptionList, List<String> logList) {
        return PolyvSDKUtil.getUrl2String(urlStr, connectTimeout, readTimeout, exceptionList, logList);
    }

    @NonNull
    public static String getUrl2String(@NonNull String urlStr, int connectTimeout) {
        return PolyvSDKUtil.getUrl2String(urlStr, connectTimeout, 10000);
    }

    @NonNull
    public static String getUrl2String(@NonNull String urlStr, int connectTimeout, int readTimeout) {
        return PolyvSDKUtil.getUrl2String(urlStr, connectTimeout, readTimeout, null);
    }

    @NonNull
    public static String getUrl2String(@NonNull String urlStr, int connectTimeout, int readTimeout, @Nullable List<String> exceptionList) {
        return PolyvSDKUtil.getUrl2String(urlStr, connectTimeout, readTimeout, exceptionList, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static String getUrl2String(@NonNull String urlStr, int connectTimeout, int readTimeout, @Nullable List<String> exceptionList, @Nullable List<String> logList) {
        Object object;
        String string;
        InputStream inputStream = null;
        Channel channel = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        Channel channel2 = null;
        try {
            Object object2;
            URL uRL = new URL(urlStr);
            string = uRL.getProtocol();
            if ("https".equals(string)) {
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
                object2 = SSLContext.getInstance("TLS");
                ((SSLContext)object2).init(null, null, new SecureRandom());
                httpsURLConnection.setSSLSocketFactory(((SSLContext)object2).getSocketFactory());
                object = httpsURLConnection;
            } else {
                object = (HttpURLConnection)uRL.openConnection();
            }
            ((URLConnection)object).setConnectTimeout(connectTimeout);
            ((URLConnection)object).setReadTimeout(readTimeout);
            ((HttpURLConnection)object).setRequestMethod("GET");
            ((URLConnection)object).setDoInput(true);
            ((URLConnection)object).addRequestProperty("User-Agent", "polyv-android-sdk2.2.0-20171212");
            ((URLConnection)object).connect();
            int n2 = ((HttpURLConnection)object).getResponseCode();
            if (n2 != 200) {
                object2 = String.format(Locale.getDefault(), "%s response code %d", urlStr, n2);
                Log.e((String)TAG, (String)object2);
                if (exceptionList != null) {
                    exceptionList.add((String)object2);
                }
                String string2 = "";
                return string2;
            }
            inputStream = ((URLConnection)object).getInputStream();
            channel = Channels.newChannel(inputStream);
            byteArrayOutputStream = new ByteArrayOutputStream();
            channel2 = Channels.newChannel(byteArrayOutputStream);
            object2 = ByteBuffer.allocate(20244);
            while (true) {
                int n3;
                if ((n3 = channel.read((ByteBuffer)object2)) == -1) break;
                ((ByteBuffer)object2).flip();
                channel2.write((ByteBuffer)object2);
                ((ByteBuffer)object2).clear();
            }
            ((ByteBuffer)object2).clear();
            if (logList != null) {
                logList.add("\u8bf7\u6c42" + urlStr + "\u8bfb\u53d6\u6570\u636e\u5b8c\u6210,length=" + byteArrayOutputStream.toString().length() + ",body[" + byteArrayOutputStream.toString() + "]");
            }
            String string3 = byteArrayOutputStream.toString();
            return string3;
        }
        catch (Exception exception) {
            string = PolyvSDKUtil.getExceptionFullMessage(exception, -1);
            Log.e((String)TAG, (String)string);
            if (exceptionList != null) {
                exceptionList.add(string);
            }
            object = "";
            return object;
        }
        finally {
            if (channel2 != null) {
                try {
                    channel2.close();
                }
                catch (IOException iOException) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
                }
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
                }
            }
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
                }
            }
        }
    }

    @Deprecated
    @NonNull
    public static String postUrl2String(@NonNull String urlStr, @Nullable String param, String charset, int connectTimeout, int readTimeout, @Nullable ArrayList<String> exceptionList) {
        return PolyvSDKUtil.postUrl2String(urlStr, param, connectTimeout, readTimeout, exceptionList, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static String postUrl2String(@NonNull String urlStr, @Nullable String param, int connectTimeout, int readTimeout, @Nullable ArrayList<String> exceptionList, @Nullable ArrayList<String> logList) {
        String string;
        OutputStreamWriter outputStreamWriter = null;
        InputStream inputStream = null;
        Channel channel = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        Channel channel2 = null;
        try {
            HttpURLConnection httpURLConnection;
            Object object;
            URL uRL = new URL(urlStr);
            string = uRL.getProtocol();
            if ("https".equals(string)) {
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRL.openConnection();
                object = SSLContext.getInstance("TLS");
                ((SSLContext)object).init(null, null, new SecureRandom());
                httpsURLConnection.setSSLSocketFactory(((SSLContext)object).getSocketFactory());
                httpURLConnection = httpsURLConnection;
            } else {
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
            }
            httpURLConnection.setConnectTimeout(connectTimeout);
            httpURLConnection.setReadTimeout(readTimeout);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            httpURLConnection.addRequestProperty("User-Agent", "polyv-android-sdk2.2.0-20171212");
            httpURLConnection.connect();
            outputStreamWriter = new OutputStreamWriter(httpURLConnection.getOutputStream(), UTF8);
            if (!TextUtils.isEmpty((CharSequence)param)) {
                outputStreamWriter.write(param);
            }
            outputStreamWriter.flush();
            int n2 = httpURLConnection.getResponseCode();
            if (n2 == 200) {
                inputStream = httpURLConnection.getInputStream();
                channel = Channels.newChannel(inputStream);
                byteArrayOutputStream = new ByteArrayOutputStream();
                channel2 = Channels.newChannel(byteArrayOutputStream);
                object = ByteBuffer.allocate(1024);
                while (true) {
                    int n3;
                    if ((n3 = channel.read((ByteBuffer)object)) == -1) break;
                    ((ByteBuffer)object).flip();
                    channel2.write((ByteBuffer)object);
                    ((ByteBuffer)object).clear();
                }
                ((ByteBuffer)object).clear();
                if (logList != null) {
                    logList.add("\u8bf7\u6c42" + urlStr + "\u8bfb\u53d6\u6570\u636e\u5b8c\u6210,length=" + byteArrayOutputStream.toString().length() + ",body[" + byteArrayOutputStream.toString() + "]");
                }
                String string2 = byteArrayOutputStream.toString();
                return string2;
            }
            object = "response code error " + n2;
            Log.e((String)TAG, (String)object);
            if (exceptionList != null) {
                exceptionList.add((String)object);
            }
            Log.d((String)TAG, (String)String.valueOf(n2));
        }
        catch (Exception exception) {
            string = PolyvSDKUtil.getExceptionFullMessage(exception, -1);
            Log.e((String)TAG, (String)string);
            if (exceptionList != null) {
                exceptionList.add(string);
            }
        }
        finally {
            if (outputStreamWriter != null) {
                try {
                    outputStreamWriter.close();
                }
                catch (IOException iOException) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
                }
            }
            if (channel2 != null) {
                try {
                    channel2.close();
                }
                catch (IOException iOException) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
                }
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
                }
            }
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
                }
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
                }
            }
        }
        return "";
    }

    public static String getFile2String(String filePath) {
        return PolyvSDKUtil.getFile2String(filePath, UTF8);
    }

    public static String getFile2String(String filePath, String charset) {
        return PolyvSDKUtil.getFile2String(new File(filePath), charset);
    }

    public static String getFile2String(File file) {
        return PolyvSDKUtil.getFile2String(file, UTF8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFile2String(File file, String charset) {
        if (!file.exists()) {
            return "";
        }
        FileInputStream fileInputStream = null;
        FileChannel fileChannel = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        Channel channel = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileChannel = fileInputStream.getChannel();
            byteArrayOutputStream = new ByteArrayOutputStream();
            channel = Channels.newChannel(byteArrayOutputStream);
            ByteBuffer byteBuffer = ByteBuffer.allocate(1024);
            while (true) {
                int n2;
                if ((n2 = fileChannel.read(byteBuffer)) == -1) break;
                byteBuffer.flip();
                channel.write(byteBuffer);
                byteBuffer.clear();
            }
            byteBuffer.clear();
            String string = byteArrayOutputStream.toString();
            return string;
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
            String string = "";
            return string;
        }
        finally {
            if (channel != null) {
                try {
                    channel.close();
                }
                catch (IOException iOException) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
                }
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
                }
            }
            if (fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException iOException) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeFile(@NonNull File file, String context) {
        if (!file.exists()) {
            return false;
        }
        if (context == null) {
            context = "";
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(context.getBytes());
        }
        catch (IOException iOException) {
            Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
            boolean bl = false;
            return bl;
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
                }
            }
        }
        return true;
    }

    public static Map<String, String> getHttpResponseHeader(HttpURLConnection http) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        String string = "";
        String string2 = "";
        int n2 = 0;
        while ((string2 = http.getHeaderField(n2)) != null) {
            string = http.getHeaderFieldKey(n2);
            if (!TextUtils.isEmpty((CharSequence)string)) {
                linkedHashMap.put(string, string2);
            }
            ++n2;
        }
        return linkedHashMap;
    }

    public static String getExceptionFullMessage(Throwable ex) {
        return PolyvSDKUtil.getExceptionFullMessage(ex, 500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getExceptionFullMessage(Throwable ex, int readLength) {
        if (ex == null) {
            return "";
        }
        StringWriter stringWriter = null;
        PrintWriter printWriter = null;
        try {
            stringWriter = new StringWriter();
            printWriter = new PrintWriter(stringWriter);
            ex.printStackTrace(printWriter);
            String string = stringWriter.toString();
            if (TextUtils.isEmpty((CharSequence)string)) {
                String string2 = "";
                return string2;
            }
            string = string.replaceAll("\n", "");
            if (readLength == -1) {
                readLength = string.length();
            } else if (string.length() < readLength) {
                readLength = string.length();
            }
            String string3 = string.substring(0, readLength);
            return string3;
        }
        catch (Exception exception) {
            String string = "";
            return string;
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
            if (stringWriter != null) {
                try {
                    stringWriter.close();
                }
                catch (IOException iOException) {
                    Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(iOException, -1));
                }
            }
        }
    }

    public static String getIpAddressString() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (!(inetAddress instanceof Inet4Address) || inetAddress.isLoopbackAddress()) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (Exception exception) {
            Log.e((String)TAG, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
        }
        return "";
    }

    public static boolean isVideoUrl(String url) {
        return url.endsWith(".flv") || url.endsWith(".mp4") || url.endsWith(".FLV") || url.endsWith(".MP4");
    }

    public static boolean isImageUrl(String url) {
        return url.endsWith(".jpg") || url.endsWith(".png") || url.endsWith(".gif") || url.endsWith(".JPG") || url.endsWith(".PNG") || url.endsWith(".GIF");
    }

    public static boolean checkOpWriteExternalStorage(Context context) {
        if (Build.VERSION.SDK_INT > 19) {
            Object object = context.getSystemService("appops");
            Class<?> clazz = object.getClass();
            try {
                Class[] classArray = new Class[]{Integer.TYPE, Integer.TYPE, String.class};
                Method method = clazz.getDeclaredMethod("checkOp", classArray);
                int n2 = (Integer)method.invoke(object, 60, Binder.getCallingUid(), context.getPackageName());
                return n2 != 1;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    public static boolean isIpAddr(String addr) {
        if (TextUtils.isEmpty((CharSequence)addr)) {
            return false;
        }
        Pattern pattern = Pattern.compile("[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}");
        Matcher matcher = pattern.matcher(addr);
        return matcher.find();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void saveVideo(String filePath, char c2) {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(filePath, "rw");
            if (randomAccessFile.length() < 1024L) {
                return;
            }
            byte[] byArray = new byte[1024];
            randomAccessFile.read(byArray, 0, byArray.length);
            int n2 = 0;
            while (n2 < byArray.length) {
                int n3 = n2++;
                byArray[n3] = (byte)(byArray[n3] ^ c2);
            }
            randomAccessFile.seek(0L);
            randomAccessFile.write(byArray, 0, byArray.length);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void decodeVideo(String filePath, char c2) {
        FileOutputStream fileOutputStream = null;
        try {
            File file = new File(PolyvSDKClient.getInstance().getDownloadDir(), "temp.mp4");
            File file2 = new File(filePath);
            if (file.exists()) {
                file.createNewFile();
            }
            RandomAccessFile randomAccessFile = new RandomAccessFile(filePath, "rw");
            byte[] byArray = encode_head.getBytes();
            byte[] byArray2 = new byte[byArray.length];
            randomAccessFile.read(byArray2, 0, byArray.length);
            if (!encode_head.equals(new String(byArray2))) {
                randomAccessFile.close();
                return;
            }
            if (randomAccessFile.length() < 1024L) {
                return;
            }
            randomAccessFile.seek(byArray.length);
            byte[] byArray3 = new byte[1024];
            randomAccessFile.read(byArray3, 0, byArray3.length);
            int n2 = 0;
            while (n2 < byArray3.length) {
                int n3 = n2++;
                byArray3[n3] = (byte)(byArray3[n3] ^ c2);
            }
            randomAccessFile.seek(byArray.length);
            randomAccessFile.write(byArray3, 0, byArray3.length);
            randomAccessFile.seek(byArray.length);
            fileOutputStream = new FileOutputStream(file);
            byte[] byArray4 = new byte[1024];
            int n4 = 0;
            while ((n4 = randomAccessFile.read(byArray4)) > 0) {
                fileOutputStream.write(byArray4);
            }
            PolyvSDKUtil.fileCopy(file, file2);
            file.delete();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void encodeVideo(String filePath, char c2) {
        RandomAccessFile randomAccessFile = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            randomAccessFile = new RandomAccessFile(filePath, "rw");
            byte[] byArray = encode_head.getBytes();
            byte[] byArray2 = new byte[byArray.length];
            randomAccessFile.read(byArray2, 0, byArray.length);
            if (encode_head.equals(new String(byArray2))) {
                randomAccessFile.close();
                return;
            }
            randomAccessFile.seek(0L);
            if (randomAccessFile.length() < 1024L) {
                return;
            }
            byte[] byArray3 = new byte[1024];
            randomAccessFile.read(byArray3, 0, byArray3.length);
            Log.i((String)"SDKUtil b4 encode", (String)(byArray3[0] + " " + byArray3[1]));
            int n2 = 0;
            while (n2 < byArray3.length) {
                Log.i((String)"SDKUtil into encode", (String)"\u5f02\u6216");
                int n3 = n2++;
                byArray3[n3] = (byte)(byArray3[n3] ^ c2);
            }
            Log.i((String)"SDKUtil after encode", (String)(byArray3[0] + " " + byArray3[1]));
            File file = File.createTempFile("tmp", null);
            file.deleteOnExit();
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file);
            randomAccessFile.seek(0L);
            byte[] byArray4 = new byte[1024];
            int n4 = 0;
            while ((n4 = randomAccessFile.read(byArray4)) > 0) {
                fileOutputStream.write(byArray4);
            }
            randomAccessFile.seek(0L);
            randomAccessFile.write(byArray);
            while ((n4 = fileInputStream.read(byArray4)) > 0) {
                randomAccessFile.write(byArray4, 0, n4);
            }
            randomAccessFile.seek(byArray.length);
            randomAccessFile.write(byArray3, 0, byArray3.length);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static void fileCopy(File sourceFile, File targetFile) {
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel = null;
        AbstractInterruptibleChannel abstractInterruptibleChannel2 = null;
        try {
            fileInputStream = new FileInputStream(sourceFile);
            fileOutputStream = new FileOutputStream(targetFile);
            abstractInterruptibleChannel = fileInputStream.getChannel();
            abstractInterruptibleChannel2 = fileOutputStream.getChannel();
            ((FileChannel)abstractInterruptibleChannel).transferTo(0L, ((FileChannel)abstractInterruptibleChannel).size(), (WritableByteChannel)((Object)abstractInterruptibleChannel2));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            try {
                fileInputStream.close();
                abstractInterruptibleChannel.close();
                fileOutputStream.close();
                abstractInterruptibleChannel2.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }
}

