/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk;

import android.content.Context;
import android.os.Environment;
import android.os.StatFs;
import android.os.storage.StorageManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.easefun.polyvsdk.PolyvSDKUtil;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class PolyvDevMountInfo {
    private static final String a = PolyvDevMountInfo.class.getSimpleName();
    private static final int b = -1;
    private static final String c = "android.os.storage.StorageVolume";
    private static final String d = "getVolumeList";
    private static final String e = "getVolumeState";
    private static final String f = "isRemovable";
    private static final String g = "getPath";
    private static final String h = "mounted";
    private static PolyvDevMountInfo i;
    private String j = null;
    private ConcurrentLinkedQueue<String> k = new ConcurrentLinkedQueue();
    private ConcurrentLinkedQueue<String> l = new ConcurrentLinkedQueue();
    private ExecutorService m = Executors.newSingleThreadExecutor();
    private Context n = null;

    private PolyvDevMountInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PolyvDevMountInfo getInstance() {
        Class<PolyvDevMountInfo> clazz = PolyvDevMountInfo.class;
        synchronized (PolyvDevMountInfo.class) {
            if (null == i) {
                i = new PolyvDevMountInfo();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        super.finalize();
        Class<PolyvDevMountInfo> clazz = PolyvDevMountInfo.class;
        synchronized (PolyvDevMountInfo.class) {
            this.k.clear();
            this.l.clear();
            this.m.shutdown();
            i = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public void init(Context context, final OnLoadCallback callback) {
        this.n = context.getApplicationContext();
        this.m.execute(new Runnable(){

            @Override
            public void run() {
                PolyvDevMountInfo.this.a(PolyvDevMountInfo.this.n, callback);
            }
        });
    }

    public boolean isSDCardAvaiable() {
        return !this.l.isEmpty() || !this.k.isEmpty();
    }

    @Nullable
    public String getSDCardPath() {
        return this.j;
    }

    public long getSDCardTotalSpace() {
        long l2 = 0L;
        if (!TextUtils.isEmpty((CharSequence)this.j)) {
            StatFs statFs = null;
            try {
                statFs = new StatFs(this.j);
            }
            catch (Exception exception) {
                Log.e((String)a, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
                return -1L;
            }
            long l3 = statFs.getBlockSize();
            long l4 = statFs.getBlockCount();
            l2 = l4 * l3 / 1024L;
        }
        return l2;
    }

    public long getSDCardAvailSpace() {
        long l2 = 0L;
        if (!TextUtils.isEmpty((CharSequence)this.j)) {
            StatFs statFs = null;
            try {
                statFs = new StatFs(this.j);
            }
            catch (Exception exception) {
                Log.e((String)a, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
                return -1L;
            }
            long l3 = statFs.getBlockSize();
            long l4 = statFs.getAvailableBlocks();
            l2 = l4 * l3 / 1024L;
        }
        return l2;
    }

    @Nullable
    public String getInternalSDCardPath() {
        return this.k.peek();
    }

    @Nullable
    public String getExternalSDCardPath() {
        return this.l.peek();
    }

    /*
     * Unable to fully structure code
     */
    private void a(Context var1_1, OnLoadCallback var2_2) {
        var3_3 = (StorageManager)var1_1.getSystemService("storage");
        if (var3_3 != null) {
            try {
                var4_4 = Class.forName("android.os.storage.StorageVolume");
                var5_5 = var3_3.getClass().getMethod("getVolumeList", new Class[0]);
                var6_6 = var3_3.getClass().getMethod("getVolumeState", new Class[]{String.class});
                var8_7 = var4_4.getMethod("isRemovable", new Class[0]);
                var7_8 = var4_4.getMethod("getPath", new Class[0]);
                var9_9 = (Object[])var5_5.invoke((Object)var3_3, new Object[0]);
                var10_10 = false;
                if (var9_9 == null || var9_9.length <= 0) ** GOTO lbl61
                var11_16 = var9_9.length;
                Log.i((String)PolyvDevMountInfo.a, (String)("init() === > StorageVolume Count = " + var11_16));
                this.k.clear();
                this.l.clear();
                for (Object var15_20 : var9_9) {
                    var16_21 = (String)var7_8.invoke(var15_20, new Object[0]);
                    var10_10 = (Boolean)var8_7.invoke(var15_20, new Object[0]);
                    if (TextUtils.isEmpty((CharSequence)var16_21) || (var17_22 = (String)var6_6.invoke((Object)var3_3, new Object[]{var16_21})) == null || !var17_22.equals("mounted")) continue;
                    if (var10_10) {
                        Log.i((String)PolyvDevMountInfo.a, (String)("init() === > external storage path = (" + var16_21 + ")"));
                        this.l.add(var16_21);
                        continue;
                    }
                    Log.i((String)PolyvDevMountInfo.a, (String)("init() === > internal storage path = (" + var16_21 + ")"));
                    this.k.add(var16_21);
                }
            }
            catch (ClassNotFoundException var10_11) {
                this.a();
                Log.e((String)PolyvDevMountInfo.a, (String)"init() === > Exception:ClassNotFoundException");
            }
            catch (NoSuchMethodException var10_12) {
                this.a();
                Log.e((String)PolyvDevMountInfo.a, (String)"init() === > Exception:NoSuchMethodException");
            }
            catch (IllegalArgumentException var10_13) {
                this.a();
                Log.e((String)PolyvDevMountInfo.a, (String)"init() === > Exception:IllegalArgumentException");
            }
            catch (IllegalAccessException var10_14) {
                this.a();
                Log.e((String)PolyvDevMountInfo.a, (String)"init() === > Exception:IllegalAccessException");
            }
            catch (InvocationTargetException var10_15) {
                this.a();
                Log.e((String)PolyvDevMountInfo.a, (String)"init() === > Exception:InvocationTargetException");
            }
        } else {
            this.a();
            Log.e((String)PolyvDevMountInfo.a, (String)"init() === > can't get storage manager");
        }
lbl61:
        // 8 sources

        this.b();
        if (var2_2 != null) {
            var2_2.callback();
        }
    }

    private void a() {
        this.k.add(Environment.getExternalStorageDirectory().getPath());
    }

    private void b() {
        this.j = !this.l.isEmpty() ? this.l.peek() : (!this.k.isEmpty() ? this.k.peek() : Environment.getExternalStorageDirectory().getPath());
        Log.i((String)a, (String)("initSDCardPath() === > SDCARD PATH = (" + this.j + ")"));
    }

    public static boolean externalMemoryAvailable() {
        return Environment.getExternalStorageState().equals(h);
    }

    public int getExternalPathListSize() {
        return this.l.size();
    }

    public static long getAvailableInternalMemorySize() {
        File file = Environment.getDataDirectory();
        StatFs statFs = null;
        try {
            statFs = new StatFs(file.getPath());
        }
        catch (Exception exception) {
            Log.e((String)a, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
            return -1L;
        }
        long l2 = statFs.getBlockSize();
        long l3 = statFs.getAvailableBlocks();
        return l3 * l2;
    }

    public static long getTotalInternalMemorySize() {
        File file = Environment.getDataDirectory();
        StatFs statFs = null;
        try {
            statFs = new StatFs(file.getPath());
        }
        catch (Exception exception) {
            Log.e((String)a, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
            return -1L;
        }
        long l2 = statFs.getBlockSize();
        long l3 = statFs.getBlockCount();
        return l3 * l2;
    }

    public static long getAvailableInternalSystemMemorySize() {
        File file = Environment.getRootDirectory();
        StatFs statFs = null;
        try {
            statFs = new StatFs(file.getPath());
        }
        catch (Exception exception) {
            Log.e((String)a, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
            return -1L;
        }
        long l2 = statFs.getBlockSize();
        long l3 = statFs.getAvailableBlocks();
        return l3 * l2;
    }

    public static long getTotalInternalSystemMemorySize() {
        File file = Environment.getRootDirectory();
        StatFs statFs = null;
        try {
            statFs = new StatFs(file.getPath());
        }
        catch (Exception exception) {
            Log.e((String)a, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
            return -1L;
        }
        long l2 = statFs.getBlockSize();
        long l3 = statFs.getBlockCount();
        return l3 * l2;
    }

    public static long getAvailableExternalMemorySize() {
        if (PolyvDevMountInfo.externalMemoryAvailable()) {
            File file = Environment.getExternalStorageDirectory();
            StatFs statFs = null;
            try {
                statFs = new StatFs(file.getPath());
            }
            catch (Exception exception) {
                Log.e((String)a, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
                return -1L;
            }
            long l2 = statFs.getBlockSize();
            long l3 = statFs.getAvailableBlocks();
            return l3 * l2;
        }
        return -1L;
    }

    public static long getTotalExternalMemorySize() {
        if (PolyvDevMountInfo.externalMemoryAvailable()) {
            File file = Environment.getExternalStorageDirectory();
            StatFs statFs = null;
            try {
                statFs = new StatFs(file.getPath());
            }
            catch (Exception exception) {
                Log.e((String)a, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
                return -1L;
            }
            long l2 = statFs.getBlockSize();
            long l3 = statFs.getBlockCount();
            return l3 * l2;
        }
        return -1L;
    }

    public static long getAvailableMemorySize(String path) {
        if (null == path) {
            return 0L;
        }
        StatFs statFs = null;
        try {
            statFs = new StatFs(path);
        }
        catch (Exception exception) {
            Log.e((String)a, (String)PolyvSDKUtil.getExceptionFullMessage(exception, -1));
            return -1L;
        }
        long l2 = statFs.getBlockSize();
        long l3 = statFs.getAvailableBlocks();
        return l3 * l2;
    }

    public boolean mkdirs(@NonNull File dir) throws IllegalArgumentException {
        if (!dir.exists()) {
            for (int i2 = 3; i2 > 0; --i2) {
                boolean bl = this.a(dir);
                if (bl) {
                    return true;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(300L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    Log.e((String)a, (String)PolyvSDKUtil.getExceptionFullMessage(interruptedException, -1));
                }
            }
        } else {
            return true;
        }
        return false;
    }

    private boolean a(File file) {
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!file.exists() && this.n != null) {
            this.n.getExternalFilesDir(null);
            file.mkdirs();
        }
        return file.exists();
    }

    public static interface OnLoadCallback {
        public void callback();
    }
}

