/*
 * Decompiled with CFR 0.152.
 */
package com.easefun.polyvsdk;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.SparseArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum PolyvBitRate {
    ziDong(0){

        @Override
        public String getName() {
            return ziDongName;
        }

        @Override
        public int getIndexByVideoUrlList() {
            return 0;
        }
    }
    ,
    liuChang(1){

        @Override
        public String getName() {
            return liuChangName;
        }

        @Override
        public int getIndexByVideoUrlList() {
            return 0;
        }
    }
    ,
    gaoQing(2){

        @Override
        public String getName() {
            return gaoQingName;
        }

        @Override
        public int getIndexByVideoUrlList() {
            return 1;
        }
    }
    ,
    chaoQing(3){

        @Override
        public String getName() {
            return chaoQingName;
        }

        @Override
        public int getIndexByVideoUrlList() {
            return 2;
        }
    };

    private final int num;
    public static String ziDongName;
    public static String liuChangName;
    public static String gaoQingName;
    public static String chaoQingName;
    private static final SparseArray<String[]> nameArray;
    private static final SparseArray<List<PolyvBitRate>> bitRateArray;
    private static final PolyvBitRate minBitRate;
    private static final PolyvBitRate maxBitRate;
    private static final List<PolyvBitRate> descBitRateList;

    private PolyvBitRate(int num) {
        this.num = num;
    }

    public int getNum() {
        return this.num;
    }

    public abstract String getName();

    public abstract int getIndexByVideoUrlList();

    public static PolyvBitRate getMinBitRate() {
        return minBitRate;
    }

    public static PolyvBitRate getMinBitRateFromAll() {
        return ziDong;
    }

    public static PolyvBitRate getMaxBitRate() {
        return maxBitRate;
    }

    public static PolyvBitRate getMaxBitRate(int dfNum) {
        List list = (List)bitRateArray.get(dfNum);
        return (PolyvBitRate)((Object)list.get(list.size() - 1));
    }

    public static String[] getBitRateNameArray(int dfNum) {
        return (String[])nameArray.get(dfNum);
    }

    public static List<PolyvBitRate> getBitRateList(int dfNum) {
        return (List)bitRateArray.get(dfNum);
    }

    @Nullable
    public static PolyvBitRate getBitRate(int bitRate) {
        return PolyvBitRate.getBitRate(bitRate, null);
    }

    public static PolyvBitRate getBitRate(int bitRate, PolyvBitRate defaultBitRate) {
        PolyvBitRate[] polyvBitRateArray;
        for (PolyvBitRate polyvBitRate : polyvBitRateArray = PolyvBitRate.values()) {
            if (polyvBitRate.getNum() != bitRate) continue;
            return polyvBitRate;
        }
        return defaultBitRate;
    }

    @Nullable
    public static String getBitRateName(int bitRate) {
        PolyvBitRate polyvBitRate = PolyvBitRate.getBitRate(bitRate);
        if (polyvBitRate == null) {
            return "";
        }
        return polyvBitRate.getName();
    }

    @NonNull
    public static List<PolyvBitRate> getDescBitRateList() {
        return PolyvBitRate.getDescBitRateList(true);
    }

    @NonNull
    public static List<PolyvBitRate> getDescBitRateList(boolean isIncludeZiDong) {
        if (isIncludeZiDong) {
            return descBitRateList;
        }
        ArrayList<PolyvBitRate> arrayList = new ArrayList<PolyvBitRate>();
        for (PolyvBitRate polyvBitRate : descBitRateList) {
            if (polyvBitRate == ziDong) continue;
            arrayList.add(polyvBitRate);
        }
        return arrayList;
    }

    static {
        ziDongName = "\u81ea\u52a8";
        liuChangName = "\u6d41\u7545";
        gaoQingName = "\u9ad8\u6e05";
        chaoQingName = "\u8d85\u6e05";
        nameArray = new SparseArray();
        bitRateArray = new SparseArray();
        PolyvBitRate[] polyvBitRateArray = PolyvBitRate.values();
        polyvBitRateArray = Arrays.copyOfRange(polyvBitRateArray, 1, polyvBitRateArray.length);
        List<PolyvBitRate> list = Arrays.asList(polyvBitRateArray);
        String[] stringArray = null;
        ArrayList<PolyvBitRate> arrayList = null;
        int n2 = list.size();
        PolyvBitRate polyvBitRate = null;
        for (int i2 = 1; i2 <= n2; ++i2) {
            stringArray = new String[i2];
            arrayList = new ArrayList<PolyvBitRate>(i2);
            for (int i3 = 0; i3 < i2; ++i3) {
                polyvBitRate = list.get(i3);
                stringArray[i3] = polyvBitRate.getName();
                arrayList.add(polyvBitRate);
            }
            nameArray.append(i2, (Object)stringArray);
            bitRateArray.append(i2, arrayList);
        }
        minBitRate = list.get(0);
        maxBitRate = list.get(n2 - 1);
        Collections.reverse(list);
        descBitRateList = list;
    }
}

