package com.easefun.polyvsdk.video;

import android.support.annotation.IntDef;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

/**
 * 验证本地m3u8返回类型
 * @version 2.0
 * @author TanQu 2015-9-23
 */
public class PolyvValidateM3U8VideoReturnType {
	/** m3u8视频正确 */
	public static final int M3U8_CORRECT = 1;
	/** m3u8文件未找到(没有下载视频) */
	public static final int M3U8_FILE_NOT_FOUND = 2;
	/** m3u8文件内容为空(下载了视频，但视频数据错误) */
	public static final int M3U8_FILE_CONTENT_EMPTY = 3;
	/** ts列表为空(下载了视频，但视频数据错误) */
	public static final int M3U8_TS_LIST_EMPTY = 4;
	/** ts文件未找到(下载了视频，但视频数据错误) */
	public static final int M3U8_TS_FILE_NOT_FOUND = 5;
	/** key文件未找到(下载了视频，但视频数据错误) */
	public static final int M3U8_KEY_FILE_NOT_FOUND = 6;

	/** @hide */
	@IntDef({
			M3U8_CORRECT,
			M3U8_FILE_NOT_FOUND,
			M3U8_FILE_CONTENT_EMPTY,
			M3U8_TS_LIST_EMPTY,
			M3U8_TS_FILE_NOT_FOUND,
			M3U8_KEY_FILE_NOT_FOUND
	})
	@Retention(RetentionPolicy.SOURCE)
	public @interface ValidateM3U8VideoReturnType {}
}
