package com.easefun.polyvsdk.video;

import android.app.Activity;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;

import com.easefun.polyvsdk.Video;
import com.easefun.polyvsdk.ijk.PolyvPlayerScreenRatio;
import com.easefun.polyvsdk.live.chat.IPolyvPPTView;
import com.easefun.polyvsdk.marquee.PolyvMarqueeItem;
import com.easefun.polyvsdk.marquee.PolyvMarqueeView;
import com.easefun.polyvsdk.video.auxiliary.PolyvAuxiliaryVideoView;
import com.easefun.polyvsdk.vo.PolyvVideoVO;

import java.util.List;

/**
 * Polyv视频播放，媒体播放控制接口<br/>
 * 广告默认不开启<br/>
 * 片头默认不开启<br/>
 * 字幕默认不开启<br/>
 * 问答默认不开启<br/>
 * 自动续播默认不开启<br/>
 * 预加载默认不开启<br/>
 * @version 2.0
 * @author Lion 2015-11-13
 */
//实现PolyvBaseMediaController.MediaPlayerControl接口是为了兼容SDK1.0版本，SDK1.0版本中PolyvVideoView是实现的PolyvBaseMediaController.MediaPlayerControl接口
@SuppressWarnings("unused")
public interface IPolyvVideoView extends PolyvBaseMediaController.MediaPlayerControl {
	/**
	 * 设置视频id播放视频，如果本地存在视频id的文件，并且是完整的，就播放本地视频。搜索本地视频是从设置的下载目录中，从高码率（清晰度）到低码率（清晰度）搜索。<br/>
	 * 如果没有本地视频文件就播放网络视频。<br/>
     * 视频加载成功自动播放<br/>
	 * 播放网络视频的码率（清晰度）匹配规则如下：<br/>
	 * 1.如果设置过播放的码率（清晰度），比如调用过{@link #setVid(String, int)}，就拿上次设置的码率（清晰度）。<br/>
	 * 2.如果没有设置过播放的码率（清晰度），就拿<a href="http://www.polyv.net/">Polyv后台</a>设置的首选播放。
	 * @param videoId 视频id
	 */
	void setVid(@NonNull String videoId);
	
	/**
	 * 设置视频id播放视频，如果本地存在视频id的文件，并且是完整的，就播放本地视频。搜索本地视频是从设置的下载目录中，从高码率（清晰度）到低码率（清晰度）搜索。<br/>
	 * 如果没有本地视频文件就播放网络视频。<br/>
     * 视频加载成功自动播放<br/>
	 * 播放网络视频的码率（清晰度）匹配规则如下：<br/>
	 * 1.如果设置过播放的码率（清晰度），比如调用过{@link #setVid(String, int)}，就拿上次设置的码率（清晰度）。<br/>
	 * 2.如果没有设置过播放的码率（清晰度），就拿<a href="http://www.polyv.net/">Polyv后台</a>设置的首选播放。
	 * @param videoId 视频id
	 * @param isMustFromLocal 是否必须从本地播放，本地没有视频文件则回调错误，不去播放网络视频
	 */
	void setVid(@NonNull String videoId, boolean isMustFromLocal);

	/**
	 * 设置视频id播放视频，如果本地存在视频id的文件，并且是完整的，就播放本地视频。搜索本地视频是从设置的下载目录中，从高码率（清晰度）到低码率（清晰度）搜索。<br/>
	 * 如果没有本地视频文件就播放网络视频。<br/>
     * 视频加载成功自动播放<br/>
	 * 播放网络视频的码率（清晰度）匹配规则如下：<br/>
	 * 1.如果设置过播放的码率（清晰度），比如调用过{@link #setVid(String, int)}，就拿上次设置的码率（清晰度）。<br/>
	 * 2.如果没有设置过播放的码率（清晰度），就拿<a href="http://www.polyv.net/">Polyv后台</a>设置的首选播放。<br/>
	 * @param videoId 视频id
	 * @param isMustFromLocal 是否必须从本地播放，本地没有视频文件则回调错误，不去播放网络视频
	 * @param hlsSpeedType 播放速度类型 {@link Video.HlsSpeedType}，非加密视频设置此参数没有效果，默认值{@code Video.HlsSpeedType.SPEED_1X}。<b>请使用{@code setSpeed(float)}设置播放速度</b>
	 */
	@Deprecated
	void setVid(@NonNull String videoId, boolean isMustFromLocal, @NonNull Video.HlsSpeedType hlsSpeedType);

	/**
	 * 设置视频id播放视频，如果本地存在视频id的文件，并且是完整的，就播放本地视频。搜索本地视频是从设置的下载目录中，从高码率（清晰度）到低码率（清晰度）搜索。<br/>
	 * 如果没有本地视频文件就播放网络视频<br/>
     * 视频加载成功自动播放
	 * @param videoId 视频id
	 * @param bitRate 码率（清晰度）
	 */
	void setVid(@NonNull String videoId, int bitRate);
	
	/**
	 * 设置视频id播放视频，如果本地存在视频id的文件，并且是完整的，就播放本地视频。搜索本地视频是从设置的下载目录中，从高码率（清晰度）到低码率（清晰度）搜索。<br/>
	 * 如果没有本地视频文件就播放网络视频<br/>
     * 视频加载成功自动播放
	 * @param videoId 视频id
	 * @param bitRate 码率（清晰度）
	 * @param isMustFromLocal 是否必须从本地播放，本地没有视频文件则回调错误，不去播放网络视频
	 */
	void setVid(@NonNull String videoId, int bitRate, boolean isMustFromLocal);

	/**
	 * 设置视频id播放视频，如果本地存在视频id的文件，并且是完整的，就播放本地视频。搜索本地视频是从设置的下载目录中，从高码率（清晰度）到低码率（清晰度）搜索。<br/>
	 * 如果没有本地视频文件就播放网络视频<br/>
     * 视频加载成功自动播放
	 * @param videoId 视频id
	 * @param bitRate 码率（清晰度）
	 * @param isMustFromLocal 是否必须从本地播放，本地没有视频文件则回调错误，不去播放网络视频
	 * @param hlsSpeedType 播放速度类型 {@link Video.HlsSpeedType}，非加密视频设置此参数没有效果，默认值{@code Video.HlsSpeedType.SPEED_1X}。<b>请使用{@code setSpeed(float)}设置播放速度</b>
	 */
	@Deprecated
	void setVid(@NonNull String videoId, int bitRate, boolean isMustFromLocal, @NonNull Video.HlsSpeedType hlsSpeedType);

	/**
	 * 设置ppt回放视频id播放视频，如果本地存在视频id的文件，并且是完整的，就播放本地视频。搜索本地视频是从设置的下载目录中，从高码率（清晰度）到低码率（清晰度）搜索。<br/>
	 * 如果没有本地视频文件就播放网络视频
	 * @param videoId 视频id
	 * @param bitRate 码率（清晰度）
	 * @param isMustFromLocal 是否必须从本地播放，本地没有视频文件则回调错误，不去播放网络视频
	 */
	public void setPPTVid(@NonNull String videoId, int bitRate, boolean isMustFromLocal);

	/**
	 *设置ppt回放视频uri播放视频
	 * @param uri ppt回放视频的uri
	 */
	public void setPPTVideoURI(@NonNull Uri uri);

	/**
	 * ppt回放界面的布局发生变化时，可以调用该方法把播放器放到右上角
	 */
	public void PPTLiveLayoutChange();

	/**
	 * ppt回放界面的布局恢复到原来时，可以调用该方法把播放器放回到原来的位置
	 */
	public void PPTLiveLayoutResume();

	/**
	 * 传递手势事件，仅ppt回放使用。
	 * 当ppt回放时，使用外界传递过来手势事件，自身只使用点击移动手势
	 * @param event
	 * @param width
	 * @return
	 */
	public boolean onPPTLiveTranTouchEvent(MotionEvent event, int width);

	/**
	 * 设置ppt绘制控件
	 * @param pptView
	 * @param isLifeBeControlledByVideoView ppt绘制控件的生命周期是否由播放器决定，此时外部无需处理
	 */
	public void setPPTLiveDrawView(IPolyvPPTView pptView, boolean isLifeBeControlledByVideoView);

	/**
	 * ppt是否处于resume状态
	 * @return
     */
	public boolean isPPTResume();

	/**
	 * 设置ppt的状态
	 * @param isPPTResume
     */
	public void setPPTStatus(boolean isPPTResume);

	/**
	 * 设置跑马灯控件，及item
	 * @param marqueeView
	 * @param marqueeItem
     */
	public void setMarqueeView(PolyvMarqueeView marqueeView, PolyvMarqueeItem marqueeItem);

	/**
	 * 是否开启跑马灯
	 * @param isOpenMarquee
     */
	public void setOpenMarquee(boolean isOpenMarquee);

	/**
	 * 清除手势信息
	 */
	public void clearGestureInfo();

	/**
	 * 播ppt回放时的控制栏是否应该显示
	 * @return
     */
	public boolean canShowControllerToPPTPlayback();

	/**
	 * 取得当前视频Id
	 * @return vid
	 */
	@Nullable
	String getCurrentVid();
	
	/**
	 * 取得当前视频id
	 * @return vid
	 */
	@Nullable
	String getCurrentVideoId();
	
	/**
	 * 取得当前播放的视频码率
	 * @return 码率（清晰度）
	 */
	int getBitRate();
	
	/**
	 * 获取倍速类型，请使用{@code setSpeed(float)}设置播放速度
	 */
	@Deprecated
	Video.HlsSpeedType getHlsSpeedType();
	
	/**
	 * 取得当前播放的视频Video
	 * @return
	 */
	@Nullable
	PolyvVideoVO getVideo();
	
	/**
	 * 获取码率数量
	 */
	int getLevel();
	
	/**
	 * 取得观看时长，只有在播放中才会计数
	 * @return 秒
	 */
	int getWatchTimeDuration();
	
	/**
	 * 取得停留时长
	 * @return 秒
	 */
	int getStayTimeDuration();
	
	/**
	 * 是否本地播放
	 * @return {@code true}:是<br/>{@code false}:否
	 */
	boolean isLocalPlay();
	
	/**
	 * 是否是播放主视频阶段
	 * @return 返回true
	 */
	@Deprecated
	boolean isPlayStageMain();
	
	/**
	 * 切换码率
	 * 内部调用switchLevel方法
	 * @param bitRate - 码率
     * @return 执行成功返回true，返回值不一定准确，最准确的做法是在{@code setOnPreparedListener}设置的回调监听中，调用{@link #getBitRate()}获取码率（清晰度）
	 */
    boolean changeBitRate(int bitRate);
	
	/**
	 * 切换码率
	 * 内部调用switchLevel方法
	 * @param bitRate 码率
	 * @param isMustFromLocal 是否必须从本地播放，本地没有视频文件则回调错误，不去播放网络视频
     * @return 执行成功返回true，返回值不一定准确，最准确的做法是在{@code setOnPreparedListener}设置的回调监听中，调用{@link #getBitRate()}获取码率（清晰度）
	 */
    boolean changeBitRate(int bitRate, boolean isMustFromLocal);
	
	/**
	 * 切换码率
	 * @param birRate 码率
     * @return 执行成功返回true，返回值不一定准确，最准确的做法是在{@code setOnPreparedListener}设置的回调监听中，调用{@link #getBitRate()}获取码率（清晰度）
	 */
    boolean switchLevel(int birRate);
	
	/**
	 * 切换码率
	 * @param bitRate 码率
	 * @param isMustFromLocal 是否必须从本地播放，本地没有视频文件则回调错误，不去播放网络视频
	 * @return 执行成功返回true，返回值不一定准确，最准确的做法是在{@code setOnPreparedListener}设置的回调监听中，调用{@link #getBitRate()}获取码率（清晰度）
	 */
	boolean switchLevel(int bitRate, boolean isMustFromLocal);
	
	/**
	 * 切换播放速度，请使用{@code setSpeed(float)}设置播放速度
	 * @param hlsSpeedType 播放速度类型 {@link Video.HlsSpeedType}，非加密视频设置此参数没有效果
	 */
	@Deprecated
	void changeHlsSpeedType(Video.HlsSpeedType hlsSpeedType);
	
	/**
	 * 切换播放速度，请使用{@code setSpeed(float)}设置播放速度
	 * @param hlsSpeedType 播放速度类型 {@link Video.HlsSpeedType}，非加密视频设置此参数没有效果
	 * @param isMustFromLocal 是否必须从本地播放，本地没有视频文件则回调错误，不去播放网络视频
	 */
	@Deprecated
	void changeHlsSpeedType(Video.HlsSpeedType hlsSpeedType, boolean isMustFromLocal);

	/**
	 * 当前是否在准备中
	 * @return {@code true}:是<br/>{@code false}:否
	 */
	boolean isPreparedState();
	
	/**
	 * 当前是否在播放中（不包括缓冲状态）
	 * @return {@code true}:是<br/>{@code false}:否
	 */
	boolean isPlayState();

	/**
	 * 当前是否在播放中
	 * @param isAndBuffer 是否包括缓冲状态，默认为false
	 * @return {@code true}:是<br/>{@code false}:否
	 */
	boolean isPlayState(boolean isAndBuffer);

	/**
	 * 是否在播放状态，包括准备好，播放，缓冲，暂停，播放完成
	 * @return {@code true}:是<br/>{@code false}:否
	 */
	boolean isInPlaybackState();

	/**
	 * 等同于 {@link #isPauseState()}
	 * @return {@code true}:是<br/>{@code false}:否
     * @see #isPauseState()
	 */
	@Deprecated
	boolean isPausState();

	/**
	 * 当前是否在暂停中
	 * @return {@code true}:是<br/>{@code false}:否
	 */
	boolean isPauseState();
	
	/**
	 * 当前是否在缓冲中
	 * @return {@code true}:是<br/>{@code false}:否
	 */
	boolean isBufferState();

	/**
	 * 当前是否播放完成
	 * @return {@code true}:是<br/>{@code false}:否
     */
	boolean isCompletedState();

	/**
	 * 当{@code Activity}触发{@code onResume()}时调用，用于恢复播放，与{@code onActivityStop()}方法对应<br/>
	 * 会包括{@link com.easefun.polyvsdk.video.auxiliary.PolyvAuxiliaryVideoView} 的控制
	 */
	void onActivityResume();

	/**
	 * 当{@code Activity}触发{@code onStop()}时调用，用于暂停播放，与{@code onAcitiviyResume()}方法对应<br/>
	 * 会包括{@link com.easefun.polyvsdk.video.auxiliary.PolyvAuxiliaryVideoView} 的控制
	 * @return 在播放中返回true，否则返回false
	 */
	boolean onActivityStop();

    /**
     * 取得观众id
     * @return 观众id字符串
     */
    String getViewerId();

	/**
	 * 设置观众id，发送统计日志自动带上此参数
	 * @param viewerId 观众id字符串
	 */
	void setViewerId(String viewerId);

	/**
	 * 取得观众名称
	 * @return 观众名称字符串
	 */
	String getViewerName();

	/**
	 * 设置观众名称
	 * @param viewerName 观众名称字符串
	 */
	void setViewerName(String viewerName);

	String getViewerParam();

	/**
	 * 设置观众额外参数
	 * @param viewerParam 观众额外参数字符串
	 */
	void setViewerParam(String viewerParam);

    String getViewLogParam1();

    /**
     * 设置view log 的param1
     * @param viewLogParam1 参数字符串
     */
    void setViewLogParam1(String viewLogParam1);

    String getViewLogParam2();

    /**
     * 设置view log 的param2
     * @param viewLogParam2 参数字符串
     */
    void setViewLogParam2(String viewLogParam2);

    String getViewLogParam3();

    /**
     * 设置view log 的param3
     * @param viewLogParam3 参数字符串
     */
    void setViewLogParam3(String viewLogParam3);

    String getViewLogParam4();

    /**
     * 设置view log 的param4
     * @param viewLogParam4 参数字符串
     */
    void setViewLogParam4(String viewLogParam4);

    String getViewLogParam5();

    /**
     * 设置view log 的param5
     * @param viewLogParam5 参数字符串
     */
    void setViewLogParam5(String viewLogParam5);

	/**
	 * 是否开启声音
	 * @return {@code true}:开启<br/>{@code false}:关闭
	 */
	boolean isOpenSound();
	
	/**
	 * 开启声音
	 */
	void openSound();
	
	/**
	 * 关闭声音
	 */
	void closeSound();
	
	/**
	 * 设置音量
	 * @param volume - 音量，0 到 100 闭区间的数
	 */
	void setVolume(int volume);
	
	/**
	 * 取得音量
	 * @return 0 到 100 之间的值
	 */
	int getVolume();
	
	/**
	 * 设置系统亮度，需android.permission.WRITE_SETTINGS权限
	 * @param brightness - 亮度，0 到 100 闭区间的数
	 * @return 是否设置成功，有些手机不支持设置亮度
	 */
	boolean setBrightness(int brightness);

	/**
	 * 设置当前窗口亮度
	 * @param brightness - 亮度，-1 到 100 闭区间的数，如果为-1，那么设置为系统亮度
	 */
	void setBrightness(Activity activity, int brightness);
	
	/**
	 * 取得系统亮度
	 * @return 0 到 100 之间的值
	 */
	int getBrightness();

	/**
	 * 取得当前窗口亮度
	 * @return 0 到 100 之间的值
	 */
	int getBrightness(Activity activity);
	
	/**
	 * 是否可以开始
	 * @return {@code true}:可以<br/>{@code false}:不可以
	 */
	boolean canStart();
	
	/**
	 * 设置银幕比率
	 * @param screen 银幕大小
	 * @return 设置成功返回true，失败返回false
	 */
	boolean setAspectRatio(@PolyvPlayerScreenRatio.RenderScreenRatio int screen);
	
	/**
	 * 取得银幕比率
	 * @return {@link com.easefun.polyvsdk.ijk.PolyvPlayerScreenRatio}的常量
	 * @see PolyvPlayerScreenRatio
	 */
	int getAspectRatio();

	/**
	 * 设置播放器缓冲视图
	 * @param view 缓存视图
	 */
	void setPlayerBufferingIndicator(@NonNull View view);
	
	/**
	 * 等同于 {@link #setPlayerBufferingIndicator(View)}
	 * @param view 缓存视图
	 */
	@Deprecated
	void setMediaBufferingIndicator(@NonNull View view);
	
	/**
	 * 设置辅助视频播放视图
	 * @param auxiliaryVideoView
	 */
	void setAuxiliaryVideoView(PolyvAuxiliaryVideoView auxiliaryVideoView);
	
	/**
	 * 获取辅助视频播放视图
	 * @return
	 */
	PolyvAuxiliaryVideoView getAuxiliaryVideoView();
	
	/**
	 * 设置播放器控制栏
	 * @param MediaController
	 */
	void setMediaController(PolyvBaseMediaController MediaController);
	
	/**
	 * 取得播放器控制栏
	 * @return
	 */
	PolyvBaseMediaController getMediaController();
	
	/**
	 * 设置是否开启片头
	 * @param isOpenTeaser true为开启
	 */
	void setOpenTeaser(boolean isOpenTeaser);
	
	/**
	 * 设置是否开启广告
	 * @param isOpenAd true为开启
	 */
	void setOpenAd(boolean isOpenAd);
	
	/**
	 * 设置是否开启问答
	 * @param isOpenQuestion true为开启
	 */
	void setOpenQuestion(boolean isOpenQuestion);
	
	/**
	 * 设置是否开启字幕
	 * @param isOpenSRT true为开启
	 */
	void setOpenSRT(boolean isOpenSRT);
	
	/**
	 * 设置是否自动续播
	 * @param isAutoContinue true为开启
	 */
	void setAutoContinue(boolean isAutoContinue);

	/**
	 * 是否开启预加载
	 * @return 开启返回true，未开启返回false
	 */
	boolean isOpenPreload();

	/**
	 * 设置是否开启预加载
	 * @param isOpenPreload true为开启
	 */
	void setOpenPreload(boolean isOpenPreload);

	/**
	 * 设置是否开启预加载
	 * @param isOpenPreload true为开启
	 * @param preloadSecond 预加载倒计时临界值（秒），默认值1
	 */
	void setOpenPreload(boolean isOpenPreload, int preloadSecond);
	
	/**
	 * 设置问答问题过期时间，默认是1天，问题会被缓存在数据库中，都设置为0表示不保存到数据库中
	 * @param month 月
	 * @param day 日
	 * @param hour 时
	 */
	void setQuestionOverdueTime(int month, int day, int hour);
	
	/**
	 * 设置问答回答过期时间，默认是7天，回答会被缓存在数据库中，都设置为0表示不保存到数据库中
	 * @param month 月
	 * @param day 日
	 * @param hour 时
	 */
	void setQuestionAnswerOverdueTime(int month, int day, int hour);

	/**
	 * 释放
	 */
	void release();

	/**
	 * 销毁，在最后不使用播放器时调用
	 */
	void destroy();
	
	/**
	 * 切换字幕
	 * @param key
	 * @return 是否设置字幕成功
	 */
	boolean changeSRT(@NonNull String key);
	
	/**
	 * 取得当前字幕的key
	 * @return
	 */
	@Nullable
	String getCurrSRTKey();

	/**
	 * 回答问题
	 */
	void answerQuestion();

	/**
	 * 回答问题
	 * @param indexList 选中的下标列表，0开始
	 */
	void answerQuestion(@NonNull List<Integer> indexList);
	
	/**
	 * 回答问题错误
	 */
	void answerQuestionFault();
	
	/**
	 * 跳过问题
	 */
	void skipQuestion();
	
	/**
	 * 获取GestureDetector
	 * @return
	 */
	GestureDetector getGestureDetector();
	
	/**
	 * 取得是否需要手势
	 * @return
	 */
	boolean getNeedGestureDetector();
	
	/**
	 * 设置是否需要手势
	 * @param need
	 */
	void setNeedGestureDetector(boolean need);

	/**
	 * Nothing to do，因为倒计时由SDK内部控制了，所以外部不需要再调用方法继续
	 */
	@Deprecated
	void playNext();

    /**
     * Nothing to do
     */
    @Deprecated
    void setUserAgent(String ua);

    /**
     * @param layout
	 * @see #setAspectRatio(int)
     */
	@Deprecated
	void setVideoLayout(int layout);

	/**
	 * Nothing to do
	 * @param controller
	 * @see #setMediaController(PolyvBaseMediaController)
	 */
	@Deprecated
	void setMediaController(com.easefun.polyvsdk.ijk.widget.media.IMediaController controller);
}
