package com.easefun.polyvsdk.video;

import android.net.Uri;
import android.view.SurfaceHolder;

import com.easefun.polyvsdk.ijk.PolyvPlayerScreenRatio;
import com.easefun.polyvsdk.ijk.widget.media.IMediaController;
import com.easefun.polyvsdk.ijk.widget.media.IRenderView;

import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.misc.ITrackInfo;

/**
 * IjkVideoView 的方法
 * @version 2.0
 * @author Lion 2016-5-20
 */
public interface IPolyvIjkVideoView extends IPolyvMediaPlayerControl {
	void setRenderView(IRenderView renderView);
	void setRender(int render);
	/**
	 * 设置视频路径
	 * @param path 视频地址
	 */
	void setVideoPath(String path);
	/**
	 * 设置视频URI
	 * @param uri 视频地址
	 */
	void setVideoURI(Uri uri);
	/**
	 * 停止播放
	 */
	void stopPlayback();
	void setMediaController(IMediaController controller);
	void setOnPreparedListener(IMediaPlayer.OnPreparedListener l);
	void setOnCompletionListener(IMediaPlayer.OnCompletionListener l);
	void setOnErrorListener(IMediaPlayer.OnErrorListener l);
	void setOnInfoListener(IMediaPlayer.OnInfoListener l);
	void releaseWithoutStop();
	void release(boolean cleartargetstate);
	void suspend();
	void resume();
	int toggleAspectRatio();
	int toggleRender();
	int togglePlayer();
	IMediaPlayer createPlayer(int playerType);
	ITrackInfo[] getTrackInfo();
	void selectTrack(int stream);
	void deselectTrack(int stream);
	int getSelectedTrack(int trackType);
	// --------------------------- polyv ----------------------------------
	boolean isInPlaybackStateForwarding();
	IRenderView getRenderView();
	@PolyvPlayerScreenRatio.RenderScreenRatio
	int getCurrentAspectRatio();
	void setCurrentAspectRatio(int aspectRatio);
	int getVideoWidth();
	int getVideoHeight();
	IMediaPlayer getMediaPlayer();
	SurfaceHolder getSurfaceHolder();
	/**
	 * 设置播放速度
	 * @param speed 播放速度，最好不要超过2
     */
	void setSpeed(float speed);
	/**
	 * 获取播放速度
	 * @return 播放速度
     */
	float getSpeed();
	int getStateIdleCode();
	int getStatePreparingCode();
	int getStatePreparedCode();
	int getStatePauseCode();
	int getStatePlaybackCompletedCode();
	int getCurrentState();
	void setOptionParameters(Object[][] mOptionParameters);
	void clearOptionParameters();
	void clearCanvasInStart(boolean isClearCanvasInStart);
}
